/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.api.J2SEProjectPlatform;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.Parameters;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class J2SEProjectPlatformImpl
implements J2SEProjectPlatform,
PropertyChangeListener {
    private static final String SE_PLATFORM = "j2se";
    private final J2SEProject project;
    private final PropertyChangeSupport support;
    private final PropertyEvaluator eval;

    J2SEProjectPlatformImpl(@NonNull J2SEProject project) {
        assert (project != null);
        this.support = new PropertyChangeSupport(this);
        this.project = project;
        this.eval = project.evaluator();
        this.eval.addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    @CheckForNull
    public JavaPlatform getProjectPlatform() {
        return (JavaPlatform)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<JavaPlatform>(){

            public JavaPlatform run() {
                return CommonProjectUtils.getActivePlatform((String)J2SEProjectPlatformImpl.this.project.evaluator().getProperty("platform.active"));
            }
        });
    }

    @Override
    public void setProjectPlatform(final @NonNull JavaPlatform platform) throws IOException {
        Parameters.notNull((CharSequence)"platform", (Object)platform);
        if (!SE_PLATFORM.equals(platform.getSpecification().getName())) {
            throw new IllegalArgumentException(String.format("Not J2SE Platform: %s (%s)", platform.getDisplayName(), platform.getSpecification().getName()));
        }
        if (platform.getInstallFolders().isEmpty()) {
            throw new IllegalArgumentException(String.format("Broken Platform %s", platform.getDisplayName()));
        }
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    String platformId = (String)platform.getProperties().get("platform.ant.name");
                    UpdateHelper uh = J2SEProjectPlatformImpl.this.project.getUpdateHelper();
                    EditableProperties props = uh.getProperties("nbproject/project.properties");
                    props.setProperty("platform.active", platformId);
                    uh.putProperties("nbproject/project.properties", props);
                    J2SEProjectPlatformImpl.updateProjectXml(platform, uh);
                    ProjectManager.getDefault().saveProject((Project)J2SEProjectPlatformImpl.this.project);
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getCause();
        }
    }

    @Override
    public void addPropertyChangeListener(@NonNull PropertyChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(@NonNull PropertyChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    public void propertyChange(@NonNull PropertyChangeEvent event) {
        String propName = event.getPropertyName();
        if (propName == null || "platform.active".equals(propName)) {
            this.support.firePropertyChange("projectPlatform", null, null);
        }
    }

    static boolean updateProjectXml(@NonNull JavaPlatform platform, @NonNull UpdateHelper helper) {
        assert (ProjectManager.mutex().isWriteAccess());
        boolean remove = platform.equals(JavaPlatformManager.getDefault().getDefaultPlatform());
        Element root = helper.getPrimaryConfigurationData(true);
        boolean changed = false;
        if (remove) {
            Element platformElement = XMLUtil.findElement((Element)root, (String)"explicit-platform", (String)"http://www.netbeans.org/ns/j2se-project/3");
            if (platformElement != null) {
                root.removeChild(platformElement);
                changed = true;
            }
        } else {
            Node insertBefore = null;
            for (Element e : XMLUtil.findSubElements((Element)root)) {
                String name = e.getNodeName();
                if ("name".equals(name) || "minimum-ant-version".equals(name)) continue;
                insertBefore = e;
                break;
            }
            Element platformNode = insertBefore.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/j2se-project/3", "explicit-platform");
            platformNode.setAttribute("explicit-source-supported", platform.getSpecification().getVersion().compareTo((Object)new SpecificationVersion("1.3")) > 0 ? "true" : "false");
            root.insertBefore(platformNode, insertBefore);
            changed = true;
        }
        if (changed) {
            helper.putPrimaryConfigurationData(root, true);
        }
        return changed;
    }
}

