/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.progress.FileListener;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.Cancellable;

public class AddCommand
extends GitCommand {
    public static final boolean KIT = false;
    private final VCSFileProxy[] roots;
    private final ProgressMonitor monitor;
    private final FileListener listener;

    public AddCommand(JGitRepository repository, GitClassFactory gitFactory, VCSFileProxy[] roots, ProgressMonitor monitor, FileListener listener) {
        super(repository, gitFactory, monitor);
        this.roots = roots;
        this.monitor = monitor;
        this.listener = listener;
    }

    @Override
    protected void prepare() throws GitException {
        super.prepare();
        this.addArgument(0, "add");
        this.addArgument(0, "-v");
        this.addArgument(0, "--");
        if (this.roots.length == 0) {
            this.addArgument(0, ".");
        } else {
            this.addExistingFiles(0, this.roots);
        }
    }

    @Override
    protected void run() throws GitException {
        block4: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                        AddCommand.this.parseAddVerboseOutput(output);
                    }

                    @Override
                    protected void errorParser(String error) throws GitException {
                        AddCommand.this.parseAddError(error);
                    }
                }.runCLI();
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block4;
                throw new GitException(t);
            }
        }
    }

    private void parseAddVerboseOutput(String output) {
        for (String line : output.split("\n")) {
            String s;
            if (!line.startsWith("add") || !(s = line.substring(3).trim()).startsWith("'") || !s.endsWith("'")) continue;
            String file = s.substring(1, s.length() - 1);
            this.listener.notifyFile(VCSFileProxy.createFileProxy((VCSFileProxy)this.getRepository().getLocation(), (String)file), file);
        }
    }

    private void parseAddError(String error) {
        this.processMessages(error);
    }
}

