/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitRevisionInfo;
import org.netbeans.modules.git.remote.cli.GitUser;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.Utils;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.Cancellable;

public class CommitCommand
extends GitCommand {
    public static final boolean KIT = false;
    private final VCSFileProxy[] roots;
    private final ProgressMonitor monitor;
    private final String message;
    private final GitUser author;
    private final GitUser commiter;
    public GitRevisionInfo revision;
    private final boolean amend;

    public CommitCommand(JGitRepository repository, GitClassFactory gitFactory, VCSFileProxy[] roots, String message, GitUser author, GitUser commiter, boolean amend, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.roots = roots;
        this.message = message;
        this.monitor = monitor;
        this.author = author;
        this.commiter = commiter;
        this.amend = amend;
    }

    @Override
    protected void prepare() throws GitException {
        this.setCommandsNumber(2);
        super.prepare();
        this.addArgument(0, "commit");
        this.addArgument(0, "--status");
        this.addArgument(0, "--allow-empty");
        this.addArgument(0, "-m");
        this.addArgument(0, this.message);
        if (this.amend) {
            this.addArgument(0, "--amend");
        }
        if (this.author != null) {
            this.addArgument(0, "--author=" + this.author.toString());
        }
        if (this.commiter != null) {
            // empty if block
        }
        this.addArgument(0, "--");
        this.addExistingFilesExceptRoot(0, this.roots);
        this.addArgument(1, "log");
        this.addArgument(1, "--raw");
        this.addArgument(1, "--pretty=raw");
        this.addArgument(1, "-1");
    }

    private void addExistingFilesExceptRoot(int command, VCSFileProxy ... files) {
        for (VCSFileProxy root : files) {
            String relativePath;
            if (!root.exists() || (relativePath = Utils.getRelativePath(this.getRepository().getLocation(), root)).isEmpty()) continue;
            this.addArgument(0, relativePath);
        }
    }

    @Override
    protected void run() throws GitException {
        block7: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                final GitRevisionInfo.GitRevCommit status = new GitRevisionInfo.GitRevCommit();
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                        CommitCommand.this.parseCommit(output, status);
                    }

                    @Override
                    protected void errorParser(String error) throws GitException {
                        super.errorParser(error);
                    }
                }.runCLI();
                if (status.revisionCode != null) {
                    this.addArgument(1, status.revisionCode);
                } else {
                    this.addArgument(1, "HEAD");
                }
                new GitCommand.Runner(canceled, 1){

                    @Override
                    public void outputParser(String output) throws GitException {
                        CommitCommand.parseLog(output, status);
                    }
                }.runCLI();
                if (canceled.canceled()) {
                    return;
                }
                this.revision = this.getClassFactory().createRevisionInfo(status, this.getRepository());
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block7;
                throw new GitException(t);
            }
        }
    }

    private void parseCommit(String output, GitRevisionInfo.GitRevCommit status) {
        for (String line : output.split("\n")) {
            String[] s;
            if ((line = line.trim()).startsWith("[")) {
                int j;
                int i = line.indexOf(32);
                if (i > 0) {
                    status.branch = line.substring(1, i);
                }
                if ((j = line.indexOf(93)) > 0) {
                    String[] s2 = line.substring(i, j).split(" ");
                    status.revisionCode = s2[s2.length - 1];
                }
                status.message = line.substring(j + 1).trim();
                continue;
            }
            if (line.startsWith("Committer:")) {
                status.autorAndMail = line.substring(10).trim();
                continue;
            }
            if (line.startsWith("create mode")) {
                String[] s3 = line.substring(11).trim().split(" ");
                if (s3.length != 2) continue;
                status.commitedFiles.put(s3[1], GitRevisionInfo.GitFileInfo.Status.ADDED);
                continue;
            }
            if (!line.startsWith("delete mode") || (s = line.substring(11).trim().split(" ")).length != 2) continue;
            status.commitedFiles.put(s[1], GitRevisionInfo.GitFileInfo.Status.REMOVED);
        }
    }

    static void parseLog(String output, GitRevisionInfo.GitRevCommit status) {
        status.commitedFiles.clear();
        StringBuilder buf = new StringBuilder();
        for (String line : output.split("\n")) {
            Object s;
            if (line.startsWith("committer")) {
                s = line.substring(9).trim();
                int i = s.indexOf(62);
                if (i <= 0) continue;
                status.commiterAndMail = s.substring(0, i + 1);
                status.commiterTime = s.substring(i + 1).trim();
                continue;
            }
            if (line.startsWith("commit")) {
                status.revisionCode = line.substring(6).trim();
                continue;
            }
            if (line.startsWith("tree")) {
                status.treeCode = line.substring(4).trim();
                continue;
            }
            if (line.startsWith("parent")) {
                status.parents.add(line.substring(6).trim());
                continue;
            }
            if (line.startsWith("author")) {
                s = line.substring(6).trim();
                int i = s.indexOf(62);
                if (i <= 0) continue;
                status.autorAndMail = s.substring(0, i + 1);
                status.autorTime = s.substring(i + 1).trim();
                continue;
            }
            if (line.startsWith(" ")) {
                buf.append(line.trim());
                buf.append('\n');
                continue;
            }
            if (!line.startsWith(":") || ((String[])(s = line.split("\\s"))).length <= 2) continue;
            String file = s[((String[])s).length - 1];
            String st = s[((String[])s).length - 2];
            GitRevisionInfo.GitFileInfo.Status gitSt = GitRevisionInfo.GitFileInfo.Status.UNKNOWN;
            if ("A".equals(st)) {
                gitSt = GitRevisionInfo.GitFileInfo.Status.ADDED;
            } else if ("M".equals(st)) {
                gitSt = GitRevisionInfo.GitFileInfo.Status.MODIFIED;
            } else if ("R".equals(st)) {
                gitSt = GitRevisionInfo.GitFileInfo.Status.RENAMED;
            } else if ("C".equals(st)) {
                gitSt = GitRevisionInfo.GitFileInfo.Status.COPIED;
            } else if ("D".equals(st)) {
                gitSt = GitRevisionInfo.GitFileInfo.Status.REMOVED;
            }
            status.commitedFiles.put(file, gitSt);
        }
        status.message = buf.toString();
    }
}

