/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.IgnoreRule;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.Utils;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.progress.FileListener;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;

public abstract class IgnoreUnignoreCommand
extends GitCommand {
    public static final String DOT_GIT_IGNORE = ".gitignore";
    public static final Charset CHARSET = Charset.forName("UTF-8");
    protected final VCSFileProxy[] files;
    private final ProgressMonitor monitor;
    private final Set<VCSFileProxy> ignoreFiles;
    private final FileListener listener;
    protected static final Logger LOG = Logger.getLogger(IgnoreUnignoreCommand.class.getName());

    public IgnoreUnignoreCommand(JGitRepository repository, GitClassFactory gitFactory, VCSFileProxy[] files, ProgressMonitor monitor, FileListener listener) {
        super(repository, gitFactory, monitor);
        this.files = files;
        this.monitor = monitor;
        this.ignoreFiles = new LinkedHashSet<VCSFileProxy>();
        this.listener = listener;
    }

    @Override
    protected boolean prepareCommand() throws GitException {
        boolean retval = super.prepareCommand();
        if (retval) {
            String message = null;
            if (this.files.length == 0) {
                message = "Files to ignore must not be empty.";
            } else if (Arrays.asList(this.files).contains(this.getRepository().getLocation())) {
                message = "Cannot ignore working tree root.";
            }
            if (message != null) {
                this.monitor.preparationsFailed(message);
                throw new GitException(message);
            }
        }
        return retval;
    }

    @Override
    protected void run() {
        VCSFileProxy workTree = this.getRepository().getLocation();
        for (int i = 0; i < this.files.length && !this.monitor.isCanceled(); ++i) {
            VCSFileProxy f = this.files[i];
            try {
                this.changeIgnoreStatus(f);
                this.listener.notifyFile(f, Utils.getRelativePath(workTree, f));
                continue;
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, ex.getLocalizedMessage(), ex);
                this.monitor.notifyError(ex.getLocalizedMessage());
            }
        }
    }

    private void changeIgnoreStatus(VCSFileProxy f) throws IOException {
        VCSFileProxy parent = f;
        boolean isDirectory = f.isDirectory();
        StringBuilder sb = new StringBuilder(47);
        if (isDirectory) {
            sb.append('/');
        }
        boolean cont = true;
        while (cont) {
            sb.insert(0, parent.getName()).insert(0, '/');
            parent = parent.getParentFile();
            String path = sb.toString();
            if (parent.equals((Object)this.getRepository().getLocation())) {
                if (this.addStatement(VCSFileProxy.createFileProxy((VCSFileProxy)parent, (String)DOT_GIT_IGNORE), path, isDirectory, false) && this.handleAdditionalIgnores(path, isDirectory)) {
                    this.addStatement(VCSFileProxy.createFileProxy((VCSFileProxy)parent, (String)DOT_GIT_IGNORE), path, isDirectory, true);
                }
                cont = false;
                continue;
            }
            cont = this.addStatement(VCSFileProxy.createFileProxy((VCSFileProxy)parent, (String)DOT_GIT_IGNORE), path, isDirectory, false);
        }
    }

    private boolean addStatement(VCSFileProxy gitIgnore, String path, boolean isDirectory, boolean forceWrite) throws IOException {
        List<IgnoreRule> ignoreRules = this.parse(gitIgnore);
        return this.addStatement(ignoreRules, gitIgnore, path, isDirectory, forceWrite, true) == MatchResult.CHECK_PARENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void save(VCSFileProxy gitIgnore, List<IgnoreRule> ignoreRules) throws IOException {
        BufferedWriter bw = null;
        VCSFileProxy tmpFile = VCSFileProxySupport.generateTemporaryFile((VCSFileProxy)gitIgnore.getParentFile(), (String)".gitignoretmp");
        try {
            bw = new BufferedWriter(new OutputStreamWriter(VCSFileProxySupport.getOutputStream((VCSFileProxy)tmpFile), CHARSET));
            ListIterator<IgnoreRule> it = ignoreRules.listIterator();
            while (it.hasNext()) {
                String s = it.next().getPattern(false);
                bw.write(s, 0, s.length());
                if (!it.hasNext()) continue;
                bw.newLine();
            }
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException ex) {}
            }
            if (!VCSFileProxySupport.renameTo((VCSFileProxy)tmpFile, (VCSFileProxy)gitIgnore)) {
                VCSFileProxy tmpCopy = this.generateTempFile(DOT_GIT_IGNORE, gitIgnore.getParentFile());
                boolean success = false;
                if (VCSFileProxySupport.renameTo((VCSFileProxy)gitIgnore, (VCSFileProxy)tmpCopy)) {
                    success = VCSFileProxySupport.renameTo((VCSFileProxy)tmpFile, (VCSFileProxy)gitIgnore);
                    if (!success) {
                        VCSFileProxySupport.renameTo((VCSFileProxy)tmpCopy, (VCSFileProxy)gitIgnore);
                    }
                    VCSFileProxySupport.delete((VCSFileProxy)tmpCopy);
                }
                if (!success) {
                    VCSFileProxySupport.delete((VCSFileProxy)tmpFile);
                    throw new IOException("Cannot write to " + gitIgnore.getPath());
                }
            }
        }
        this.ignoreFiles.add(gitIgnore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IgnoreRule> parse(VCSFileProxy gitIgnore) throws IOException {
        LinkedList<IgnoreRule> rules = new LinkedList<IgnoreRule>();
        if (gitIgnore.exists()) {
            BufferedReader br = null;
            try {
                String txt;
                br = new BufferedReader(new InputStreamReader(gitIgnore.getInputStream(false), CHARSET));
                while ((txt = br.readLine()) != null) {
                    rules.add(new IgnoreRule(txt));
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        return rules;
    }

    public VCSFileProxy[] getModifiedIgnoreFiles() {
        return this.ignoreFiles.toArray(new VCSFileProxy[this.ignoreFiles.size()]);
    }

    protected abstract MatchResult addStatement(List<IgnoreRule> var1, VCSFileProxy var2, String var3, boolean var4, boolean var5, boolean var6) throws IOException;

    protected static String escapeChars(String path) {
        return path.replace("[", "[[]").replace("*", "[*]").replace("?", "[?]");
    }

    protected final MatchResult checkExcludeFile(String path, boolean isDirectory) throws IOException {
        VCSFileProxy excludeFile = VCSFileProxy.createFileProxy((VCSFileProxy)this.getRepository().getMetadataLocation(), (String)"info/exclude");
        List<IgnoreRule> ignoreRules = this.parse(excludeFile);
        return this.addStatement(ignoreRules, excludeFile, path, isDirectory, false, true);
    }

    protected final MatchResult checkGlobalExcludeFile(String path, boolean directory) throws IOException {
        VCSFileProxy excludeFile = null;
        if (excludeFile != null && VCSFileProxySupport.canRead(excludeFile)) {
            List<IgnoreRule> ignoreRules = this.parse(excludeFile);
            return this.addStatement(ignoreRules, excludeFile, path, directory, false, false);
        }
        return MatchResult.NOT_IGNORED;
    }

    private VCSFileProxy generateTempFile(String basename, VCSFileProxy parent) {
        VCSFileProxy tempFile = VCSFileProxy.createFileProxy((VCSFileProxy)parent, (String)basename);
        while (tempFile.exists()) {
            tempFile = VCSFileProxy.createFileProxy((VCSFileProxy)parent, (String)(basename + Long.toString(System.currentTimeMillis())));
        }
        return tempFile;
    }

    protected abstract boolean handleAdditionalIgnores(String var1, boolean var2) throws IOException;

    public static enum MatchResult {
        NOT_IGNORED,
        IGNORED,
        CHECK_PARENT;

    }
}

