/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.util.Collection;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitConfig;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;

public class RemoveRemoteCommand
extends GitCommand {
    private final String remote;

    public RemoveRemoteCommand(JGitRepository repository, GitClassFactory gitFactory, String remote, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.remote = remote;
    }

    @Override
    protected void run() throws GitException {
        JGitConfig config = this.getRepository().getConfig();
        config.load();
        config.unsetSection("remote", this.remote);
        Collection<String> subSections = config.getSubsections("branch");
        for (String subSection : subSections) {
            if (!this.remote.equals(config.getString("branch", subSection, "remote"))) continue;
            config.unset("branch", subSection, "remote");
            config.unset("branch", subSection, "merge");
        }
        config.save();
    }

    @Override
    protected void prepare() throws GitException {
        super.prepare();
        this.addArgument(0, "remote");
        this.addArgument(0, "rm");
        this.addArgument(0, this.remote);
    }
}

