/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitRevertResult;
import org.netbeans.modules.git.remote.cli.GitRevisionInfo;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.Cancellable;

public class RevertCommand
extends GitCommand {
    private final ProgressMonitor monitor;
    private final String revisionStr;
    private GitRevertResult result;
    private final String message;
    private final boolean commit;

    public RevertCommand(JGitRepository repository, GitClassFactory gitFactory, String revision, String message, boolean commit, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.monitor = monitor;
        this.revisionStr = revision;
        this.message = message;
        this.commit = commit;
    }

    public GitRevertResult getResult() {
        return this.result;
    }

    @Override
    protected void prepare() throws GitException {
        super.prepare();
        this.addArgument(0, "revert");
        if (!this.commit) {
            this.addArgument(0, "-n");
        }
        this.addArgument(0, this.revisionStr);
    }

    @Override
    protected void run() throws GitException {
        block4: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                final ResultContainer status = new ResultContainer();
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                        RevertCommand.this.parseRevertOutput(output, status);
                    }

                    @Override
                    protected void outputErrorParser(String output, String error, int exitCode) throws GitException {
                        RevertCommand.this.parseRevertOutputError(output, error, status);
                    }

                    @Override
                    protected void errorParser(String error) throws GitException {
                        RevertCommand.this.parseRevertError(error, status);
                    }
                }.runCLI();
                GitRevisionInfo rev = this.getClassFactory().createRevisionInfo(status.revertCommit, this.getRepository());
                this.result = this.getClassFactory().createRevertResult(status.status, rev, status.conflicts, status.failures);
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block4;
                throw new GitException(t);
            }
        }
    }

    private void parseRevertOutput(String output, ResultContainer status) {
        for (String line : output.split("\n")) {
            if (!line.startsWith("[") || line.indexOf(93) <= 0) continue;
            if (line.contains("] Revert")) {
                status.status = GitRevertResult.Status.REVERTED;
            }
            String[] s = line.substring(1, line.indexOf(93)).trim().split(" ");
            ((ResultContainer)status).revertCommit.revisionCode = s[s.length - 1];
        }
    }

    private void parseRevertOutputError(String output, String error, ResultContainer status) {
        if (output.contains("nothing to commit")) {
            status.status = GitRevertResult.Status.NO_CHANGE;
        }
    }

    private void parseRevertError(String error, ResultContainer status) {
        for (String line : error.split("\n")) {
            if (line.startsWith("error: could not revert")) {
                status.status = GitRevertResult.Status.CONFLICTING;
                continue;
            }
            if (line.startsWith("Aborting")) {
                status.status = GitRevertResult.Status.FAILED;
                continue;
            }
            if (!(line = line.replace('\t', ' ')).startsWith(" ")) continue;
            String file = line.trim();
            status.failures.add(VCSFileProxy.createFileProxy((VCSFileProxy)this.getRepository().getLocation(), (String)file));
        }
    }

    private static final class ResultContainer {
        private GitRevertResult.Status status;
        private GitRevisionInfo.GitRevCommit revertCommit = new GitRevisionInfo.GitRevCommit();
        private List<VCSFileProxy> conflicts = new ArrayList<VCSFileProxy>();
        private List<VCSFileProxy> failures = new ArrayList<VCSFileProxy>();

        private ResultContainer() {
        }
    }
}

