/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.tree.TreeNode;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUCCTProvider;
import org.netbeans.lib.profiler.results.cpu.CPUResultsDiff;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JExtendedSplitPane;
import org.netbeans.lib.profiler.ui.cpu.CPUTableView;
import org.netbeans.lib.profiler.ui.cpu.CPUTreeTableView;
import org.netbeans.lib.profiler.ui.cpu.CPUView;
import org.netbeans.lib.profiler.ui.cpu.ThreadsSelector;
import org.netbeans.lib.profiler.ui.memory.LiveMemoryView;
import org.netbeans.lib.profiler.ui.results.DataView;
import org.netbeans.lib.profiler.ui.swing.FilterUtils;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTable;
import org.netbeans.lib.profiler.ui.swing.SearchUtils;
import org.openide.util.Lookup;

public abstract class LiveCPUView
extends JPanel {
    private static final int MIN_UPDATE_DIFF = 900;
    private static final int MAX_UPDATE_DIFF = 1400;
    private final ResultsMonitor rm;
    private CPUResultsSnapshot snapshot;
    private CPUResultsSnapshot refSnapshot;
    private boolean sampled;
    private boolean mergedThreads;
    private Collection<Integer> selectedThreads;
    private DataView lastFocused;
    private CPUTableView hotSpotsView;
    private CPUTreeTableView forwardCallsView;
    private CPUTreeTableView reverseCallsView;
    private ThreadsSelector threadsSelector;
    private long lastupdate;
    private volatile boolean paused;
    private volatile boolean forceRefresh;
    private volatile boolean refreshIsRunning;

    public LiveCPUView(Set<ClientUtils.SourceCodeSelection> selection) {
        this.initUI(selection);
        this.registerActions();
        this.rm = (ResultsMonitor)Lookup.getDefault().lookup(ResultsMonitor.class);
        this.rm.view = this;
    }

    public void setView(boolean forwardCalls, boolean hotSpots, boolean reverseCalls) {
        this.forwardCallsView.setVisible(forwardCalls);
        this.hotSpotsView.setVisible(hotSpots);
        this.reverseCallsView.setVisible(reverseCalls);
    }

    public ThreadsSelector createThreadSelector() {
        this.threadsSelector = new ThreadsSelector(){

            @Override
            protected CPUResultsSnapshot getSnapshot() {
                return LiveCPUView.this.snapshot;
            }

            @Override
            protected void selectionChanged(Collection<Integer> selected, boolean mergeThreads) {
                LiveCPUView.this.mergedThreads = mergeThreads;
                LiveCPUView.this.selectedThreads = selected;
                LiveCPUView.this.setData();
            }

            @Override
            void reset() {
                super.reset();
                LiveCPUView.this.mergedThreads = false;
                LiveCPUView.this.selectedThreads = null;
            }
        };
        return this.threadsSelector;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public void setForceRefresh(boolean forceRefresh) {
        this.forceRefresh = forceRefresh;
    }

    private void refreshData(RuntimeCCTNode appRootNode) throws ClientUtils.TargetAppOrVMTerminated {
        if ((this.lastupdate + 900L > System.currentTimeMillis() || this.paused) && !this.forceRefresh) {
            return;
        }
        if (this.refreshIsRunning) {
            return;
        }
        this.refreshIsRunning = true;
        try {
            CPUResultsSnapshot snapshotData;
            ProfilerClient client = this.getProfilerClient();
            this.snapshot = snapshotData = client.getStatus().getInstrMethodClasses() == null ? null : client.getCPUProfilingResultsSnapshot(false);
            this.sampled = snapshotData == null ? true : client.getCurrentInstrType() == 2;
            this.setData();
            this.lastupdate = System.currentTimeMillis();
            this.forceRefresh = false;
        }
        catch (CPUResultsSnapshot.NoDataAvailableException e) {
            this.refreshIsRunning = false;
        }
        catch (Throwable t) {
            this.refreshIsRunning = false;
            if (t instanceof ClientUtils.TargetAppOrVMTerminated) {
                throw (ClientUtils.TargetAppOrVMTerminated)t;
            }
            Logger.getLogger(LiveCPUView.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    private void setData() {
        if (this.snapshot == null) {
            this.resetData();
            this.refreshIsRunning = false;
        } else {
            final CPUResultsSnapshot _snapshot = this.refSnapshot == null ? this.snapshot : this.refSnapshot.createDiff(this.snapshot);
            final FlatProfileContainer flatData = _snapshot.getFlatProfile(this.selectedThreads, 0);
            final Map idMap = _snapshot.getMethodIDMap(0);
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        boolean diff = _snapshot instanceof CPUResultsDiff;
                        LiveCPUView.this.forwardCallsView.setData(_snapshot, idMap, 0, LiveCPUView.this.selectedThreads, LiveCPUView.this.mergedThreads, LiveCPUView.this.sampled, diff);
                        LiveCPUView.this.hotSpotsView.setData(flatData, idMap, LiveCPUView.this.sampled, diff);
                        LiveCPUView.this.reverseCallsView.setData(_snapshot, idMap, 0, LiveCPUView.this.selectedThreads, LiveCPUView.this.mergedThreads, LiveCPUView.this.sampled, diff);
                    }
                    finally {
                        LiveCPUView.this.refreshIsRunning = false;
                    }
                }
            });
        }
    }

    public boolean setDiffView(boolean diff) {
        if (this.snapshot == null) {
            return false;
        }
        this.refSnapshot = diff ? this.snapshot : null;
        this.setData();
        return true;
    }

    public void refreshData() throws ClientUtils.TargetAppOrVMTerminated {
        if (this.lastupdate + 1400L < System.currentTimeMillis() && !this.paused || this.forceRefresh) {
            this.getProfilerClient().forceObtainedResultsDump(true);
        }
    }

    public void resetData() {
        this.forwardCallsView.resetData();
        this.hotSpotsView.resetData();
        this.reverseCallsView.resetData();
        this.snapshot = null;
        this.refSnapshot = null;
        this.sampled = true;
        if (this.threadsSelector != null) {
            this.threadsSelector.reset();
        }
    }

    public void showSelectionColumn() {
        this.forwardCallsView.showSelectionColumn();
        this.hotSpotsView.showSelectionColumn();
        this.reverseCallsView.showSelectionColumn();
    }

    public void refreshSelection() {
        this.forwardCallsView.refreshSelection();
        this.hotSpotsView.refreshSelection();
        this.reverseCallsView.refreshSelection();
    }

    public void cleanup() {
        if (this.rm.view == this) {
            this.rm.view = null;
        }
    }

    protected abstract ProfilerClient getProfilerClient();

    protected boolean profileMethodSupported() {
        return true;
    }

    protected abstract boolean showSourceSupported();

    protected abstract void showSource(ClientUtils.SourceCodeSelection var1);

    protected abstract void selectForProfiling(ClientUtils.SourceCodeSelection var1);

    protected void popupShowing() {
    }

    protected void popupHidden() {
    }

    protected void foundInForwardCalls() {
    }

    protected void foundInHotSpots() {
    }

    protected void foundInReverseCalls() {
    }

    private void profileMethod(ClientUtils.SourceCodeSelection value) {
        this.selectForProfiling(value);
    }

    private void profileClass(ClientUtils.SourceCodeSelection value) {
        this.selectForProfiling(new ClientUtils.SourceCodeSelection(value.getClassName(), "*", null));
    }

    private void initUI(Set<ClientUtils.SourceCodeSelection> selection) {
        this.setLayout(new BorderLayout(0, 0));
        this.forwardCallsView = new CPUTreeTableView(selection, false){

            @Override
            protected void performDefaultAction(ClientUtils.SourceCodeSelection userValue) {
                if (LiveCPUView.this.showSourceSupported()) {
                    LiveCPUView.this.showSource(userValue);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                LiveCPUView.this.populatePopup(LiveCPUView.this.forwardCallsView, popup, value, userValue);
            }

            @Override
            protected void popupShowing() {
                LiveCPUView.this.popupShowing();
            }

            @Override
            protected void popupHidden() {
                LiveCPUView.this.popupHidden();
            }

            @Override
            protected boolean hasBottomFilterFindMargin() {
                return true;
            }
        };
        this.forwardCallsView.notifyOnFocus(new Runnable(){

            @Override
            public void run() {
                LiveCPUView.this.lastFocused = LiveCPUView.this.forwardCallsView;
            }
        });
        this.hotSpotsView = new CPUTableView(selection){

            @Override
            protected void performDefaultAction(ClientUtils.SourceCodeSelection userValue) {
                if (LiveCPUView.this.showSourceSupported()) {
                    LiveCPUView.this.showSource(userValue);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                LiveCPUView.this.populatePopup(LiveCPUView.this.hotSpotsView, popup, value, userValue);
            }

            @Override
            protected void popupShowing() {
                LiveCPUView.this.popupShowing();
            }

            @Override
            protected void popupHidden() {
                LiveCPUView.this.popupHidden();
            }

            @Override
            protected boolean hasBottomFilterFindMargin() {
                return true;
            }
        };
        this.hotSpotsView.notifyOnFocus(new Runnable(){

            @Override
            public void run() {
                LiveCPUView.this.lastFocused = LiveCPUView.this.hotSpotsView;
            }
        });
        this.reverseCallsView = new CPUTreeTableView(selection, true){

            @Override
            protected void performDefaultAction(ClientUtils.SourceCodeSelection userValue) {
                if (LiveCPUView.this.showSourceSupported()) {
                    LiveCPUView.this.showSource(userValue);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                LiveCPUView.this.populatePopup(LiveCPUView.this.reverseCallsView, popup, value, userValue);
            }

            @Override
            protected void popupShowing() {
                LiveCPUView.this.popupShowing();
            }

            @Override
            protected void popupHidden() {
                LiveCPUView.this.popupHidden();
            }

            @Override
            protected boolean hasBottomFilterFindMargin() {
                return true;
            }
        };
        this.reverseCallsView.notifyOnFocus(new Runnable(){

            @Override
            public void run() {
                LiveCPUView.this.lastFocused = LiveCPUView.this.reverseCallsView;
            }
        });
        JExtendedSplitPane upperSplit = new JExtendedSplitPane(0){
            {
                BasicSplitPaneDivider divider;
                super(x0);
                this.setBorder(null);
                this.setDividerSize(5);
                if (this.getUI() instanceof BasicSplitPaneUI && (divider = ((BasicSplitPaneUI)this.getUI()).getDivider()) != null) {
                    Color c = UIUtils.isNimbus() || UIUtils.isAquaLookAndFeel() ? UIUtils.getDisabledLineColor() : new JSeparator().getForeground();
                    divider.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, c));
                }
            }
        };
        upperSplit.setBorder(BorderFactory.createEmptyBorder());
        ((JSplitPane)upperSplit).setTopComponent(this.forwardCallsView);
        ((JSplitPane)upperSplit).setBottomComponent(this.hotSpotsView);
        upperSplit.setDividerLocation(0.5);
        upperSplit.setResizeWeight(0.5);
        JExtendedSplitPane lowerSplit = new JExtendedSplitPane(0){
            {
                BasicSplitPaneDivider divider;
                super(x0);
                this.setBorder(null);
                this.setDividerSize(5);
                if (this.getUI() instanceof BasicSplitPaneUI && (divider = ((BasicSplitPaneUI)this.getUI()).getDivider()) != null) {
                    Color c = UIUtils.isNimbus() || UIUtils.isAquaLookAndFeel() ? UIUtils.getDisabledLineColor() : new JSeparator().getForeground();
                    divider.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, c));
                }
            }
        };
        lowerSplit.setBorder(BorderFactory.createEmptyBorder());
        ((JSplitPane)lowerSplit).setTopComponent(upperSplit);
        ((JSplitPane)lowerSplit).setBottomComponent(this.reverseCallsView);
        lowerSplit.setDividerLocation(0.66);
        lowerSplit.setResizeWeight(0.66);
        this.add((Component)lowerSplit, "Center");
    }

    private void registerActions() {
        ActionMap map = this.getActionMap();
        map.put("filter-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataView active = LiveCPUView.this.getLastFocused();
                if (active != null) {
                    active.activateFilter();
                }
            }
        });
        map.put("find-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataView active = LiveCPUView.this.getLastFocused();
                if (active != null) {
                    active.activateSearch();
                }
            }
        });
    }

    private DataView getLastFocused() {
        if (this.lastFocused != null && !this.lastFocused.isShowing()) {
            this.lastFocused = null;
        }
        if (this.lastFocused == null) {
            if (this.forwardCallsView.isShowing()) {
                this.lastFocused = this.forwardCallsView;
            } else if (this.hotSpotsView.isShowing()) {
                this.lastFocused = this.hotSpotsView;
            } else if (this.reverseCallsView.isShowing()) {
                this.lastFocused = this.reverseCallsView;
            }
        }
        return this.lastFocused;
    }

    private void populatePopup(final DataView invoker, JPopupMenu popup, Object value, final ClientUtils.SourceCodeSelection userValue) {
        if (this.showSourceSupported()) {
            popup.add(new JMenuItem(CPUView.ACTION_GOTOSOURCE){
                {
                    super(x0);
                    this.setEnabled(userValue != null);
                    this.setFont(this.getFont().deriveFont(1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    LiveCPUView.this.showSource(userValue);
                }
            });
            popup.addSeparator();
        }
        popup.add(new JMenuItem(CPUView.ACTION_PROFILE_METHOD){
            {
                super(x0);
                this.setEnabled(LiveCPUView.this.profileMethodSupported() && userValue != null && CPUTableView.isSelectable(userValue));
            }

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                LiveCPUView.this.profileMethod(userValue);
            }
        });
        popup.add(new JMenuItem(CPUView.ACTION_PROFILE_CLASS){
            {
                super(x0);
                this.setEnabled(userValue != null);
            }

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                LiveCPUView.this.profileClass(userValue);
            }
        });
        popup.addSeparator();
        if (invoker == this.forwardCallsView) {
            ProfilerTreeTable ttable = (ProfilerTreeTable)this.forwardCallsView.getResultsComponent();
            int column = ttable.convertColumnIndexToView(ttable.getMainColumn());
            final String searchString = ttable.getStringValue((TreeNode)value, column);
            popup.add(new JMenuItem(CPUView.FIND_IN_HOTSPOTS){
                {
                    super(x0);
                    this.setEnabled(userValue != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ProfilerTable table = LiveCPUView.this.hotSpotsView.getResultsComponent();
                    if (SearchUtils.findString(table, searchString)) {
                        LiveCPUView.this.hotSpotsView.setVisible(true);
                        LiveCPUView.this.foundInHotSpots();
                        table.requestFocusInWindow();
                    }
                }
            });
            popup.add(new JMenuItem(CPUView.FIND_IN_REVERSECALLS){
                {
                    super(x0);
                    this.setEnabled(userValue != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ProfilerTable table = LiveCPUView.this.reverseCallsView.getResultsComponent();
                    if (SearchUtils.findString(table, searchString)) {
                        LiveCPUView.this.reverseCallsView.setVisible(true);
                        LiveCPUView.this.foundInReverseCalls();
                        table.requestFocusInWindow();
                    }
                }
            });
        } else if (invoker == this.hotSpotsView) {
            final String searchString = value.toString().replace("(", " (");
            popup.add(new JMenuItem(CPUView.FIND_IN_FORWARDCALLS){
                {
                    super(x0);
                    this.setEnabled(userValue != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ProfilerTable table = LiveCPUView.this.forwardCallsView.getResultsComponent();
                    if (SearchUtils.findString(table, searchString)) {
                        LiveCPUView.this.forwardCallsView.setVisible(true);
                        LiveCPUView.this.foundInForwardCalls();
                        table.requestFocusInWindow();
                    }
                }
            });
            popup.add(new JMenuItem(CPUView.FIND_IN_REVERSECALLS){
                {
                    super(x0);
                    this.setEnabled(userValue != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ProfilerTable table = LiveCPUView.this.reverseCallsView.getResultsComponent();
                    if (SearchUtils.findString(table, searchString)) {
                        LiveCPUView.this.reverseCallsView.setVisible(true);
                        LiveCPUView.this.foundInReverseCalls();
                        table.requestFocusInWindow();
                    }
                }
            });
        } else if (invoker == this.reverseCallsView) {
            ProfilerTreeTable ttable = (ProfilerTreeTable)this.reverseCallsView.getResultsComponent();
            int column = ttable.convertColumnIndexToView(ttable.getMainColumn());
            final String searchString = ttable.getStringValue((TreeNode)value, column);
            popup.add(new JMenuItem(CPUView.FIND_IN_FORWARDCALLS){
                {
                    super(x0);
                    this.setEnabled(userValue != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ProfilerTable table = LiveCPUView.this.forwardCallsView.getResultsComponent();
                    if (SearchUtils.findString(table, searchString)) {
                        LiveCPUView.this.forwardCallsView.setVisible(true);
                        LiveCPUView.this.foundInForwardCalls();
                        table.requestFocusInWindow();
                    }
                }
            });
            popup.add(new JMenuItem(CPUView.FIND_IN_HOTSPOTS){
                {
                    super(x0);
                    this.setEnabled(userValue != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ProfilerTable table = LiveCPUView.this.hotSpotsView.getResultsComponent();
                    if (SearchUtils.findString(table, searchString)) {
                        LiveCPUView.this.hotSpotsView.setVisible(true);
                        LiveCPUView.this.foundInHotSpots();
                        table.requestFocusInWindow();
                    }
                }
            });
        }
        popup.addSeparator();
        popup.add(invoker.createCopyMenuItem());
        popup.addSeparator();
        popup.add(new JMenuItem(FilterUtils.ACTION_FILTER){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                invoker.activateFilter();
            }
        });
        popup.add(new JMenuItem(SearchUtils.ACTION_FIND){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                invoker.activateSearch();
            }
        });
    }

    public static final class ResultsMonitor
    implements CPUCCTProvider.Listener {
        private LiveCPUView view;

        public void cctEstablished(RuntimeCCTNode appRootNode, boolean empty) {
            if (this.view != null && !empty) {
                try {
                    this.view.refreshData(appRootNode);
                }
                catch (ClientUtils.TargetAppOrVMTerminated ex) {
                    Logger.getLogger(LiveMemoryView.class.getName()).log(Level.FINE, null, ex);
                }
            }
        }

        public void cctReset() {
            if (this.view != null) {
                this.view.resetData();
            }
        }
    }
}

