/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.locks;

import javax.swing.Icon;
import org.netbeans.lib.profiler.results.locks.LockCCTNode;
import org.netbeans.lib.profiler.ui.swing.renderer.NormalBoldGrayRenderer;
import org.netbeans.modules.profiler.api.icons.Icons;

public class LockContentionRenderer
extends NormalBoldGrayRenderer {
    private static final Icon THREAD_ICON = Icons.getIcon((String)"ProfilerIcons.Thread");
    private static final Icon LOCK_ICON = Icons.getIcon((String)"ProfilerIcons.WindowLocks");

    @Override
    public void setValue(Object value, int row) {
        LockCCTNode node = (LockCCTNode)value;
        boolean lockNode = node.isThreadLockNode();
        boolean monitorNode = node.isMonitorNode();
        String nodeName = node.getNodeName();
        int bracketIndex = nodeName.indexOf(40);
        int dotIndex = nodeName.lastIndexOf(46);
        String normalValue = this.getNormalValue(node, nodeName, bracketIndex, dotIndex, lockNode);
        String boldValue = this.getBoldValue(node, nodeName, bracketIndex, dotIndex, lockNode);
        String grayValue = this.getGrayValue(node, nodeName, bracketIndex, dotIndex, lockNode);
        this.setNormalValue(normalValue);
        this.setBoldValue(boldValue);
        this.setGrayValue(grayValue);
        Icon icon = null;
        if (lockNode) {
            icon = THREAD_ICON;
        } else if (monitorNode) {
            icon = LOCK_ICON;
        }
        this.setIcon(icon);
    }

    private String getNormalValue(LockCCTNode node, String nodeName, int bracketIndex, int dotIndex, boolean lockNode) {
        if (lockNode) {
            return node.getParent().getParent() == null ? "" : nodeName;
        }
        if (dotIndex == -1 && bracketIndex == -1) {
            return nodeName;
        }
        if (bracketIndex != -1) {
            nodeName = nodeName.substring(0, bracketIndex);
        }
        return nodeName.substring(0, dotIndex + 1);
    }

    private String getBoldValue(LockCCTNode node, String nodeName, int bracketIndex, int dotIndex, boolean lockNode) {
        if (lockNode) {
            return node.getParent().getParent() == null ? nodeName : "";
        }
        if (dotIndex == -1 && bracketIndex == -1) {
            return "";
        }
        if (bracketIndex != -1) {
            nodeName = nodeName.substring(0, bracketIndex);
        }
        return nodeName.substring(dotIndex + 1);
    }

    private String getGrayValue(LockCCTNode node, String nodeName, int bracketIndex, int dotIndex, boolean lockNode) {
        if (lockNode) {
            return "";
        }
        return bracketIndex != -1 ? " " + nodeName.substring(bracketIndex) : "";
    }
}

