/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform;

import java.io.File;
import java.io.IOException;
import java.lang.constant.Constable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.Profile;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.mobility.cldcplatform.PlatformConvertor;
import org.netbeans.modules.mobility.cldcplatform.UEIEmulatorConfiguratorImpl;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class J2MEPlatform
extends JavaPlatform {
    public static final String SPECIFICATION_NAME = "j2me";
    private static final String URL_SEPARATOR = ",";
    private static final String PATH_SEPARATOR = ":";
    public static final String PLATFORM_STRING_PREFIX = "${platform.home}/";
    private ClassPath bootstrapLibs;
    private ClassPath standardLibs;
    private Specification spec;
    private String name;
    private final String type;
    private String preverifyCmd;
    private String runCmd;
    private String debugCmd;
    private Device[] devices;
    private final File homeFile;
    private FileObject home;
    private String displayName;
    private List<URL> javadocs;
    private ClassPath sources;
    private boolean me3Platform;

    public J2MEPlatform(String name, String home, String type, String displayName, String srcPath, String docPath, String preverifyCmd, String runCmd, String debugCmd, Device[] devices) {
        assert (name != null);
        this.name = name;
        assert (home != null);
        this.homeFile = FileUtil.normalizeFile((File)new File(home));
        this.home = FileUtil.toFileObject((File)this.homeFile);
        assert (type != null);
        this.type = type;
        this.displayName = displayName == null ? name : displayName;
        this.preverifyCmd = preverifyCmd;
        this.runCmd = runCmd;
        this.debugCmd = debugCmd;
        assert (devices != null);
        assert (devices.length > 0);
        this.devices = devices;
        this.sources = ClassPathSupport.createClassPath((FileObject[])this.resolveRelativePathToFileObjects(srcPath).toArray(new FileObject[0]));
        this.javadocs = this.resolveRelativePathToURLs(docPath);
        this.me3Platform = J2MEPlatform.isJavaME3Platform(this.home);
    }

    public Device[] getDevices() {
        return this.devices == null ? null : (Device[])this.devices.clone();
    }

    public synchronized void setDevices(Device[] devices) {
        this.devices = devices;
        this.spec = null;
        this.bootstrapLibs = ClassPathSupport.createClassPath((FileObject[])this.getAllLibraries());
        this.firePropertyChange("devices", null, null);
        this.firePropertyChange("bootstrapLibraries", null, null);
    }

    private List<URL> resolveRelativePathToURLs(String path) {
        ArrayList<URL> array = new ArrayList<URL>();
        if (path == null) {
            return array;
        }
        StringTokenizer stk = new StringTokenizer(path, URL_SEPARATOR);
        while (stk.hasMoreTokens()) {
            URL url = this.resolveRelativePathToURL(stk.nextToken().trim());
            if (url == null) continue;
            array.add(url);
        }
        return array;
    }

    private URL getURL(String fragment) throws MalformedURLException {
        try {
            URL url = new URL(fragment);
            if (fragment.equals(url.toExternalForm())) {
                return url;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return Utilities.toURI((File)(fragment.startsWith(PLATFORM_STRING_PREFIX) ? new File(this.homeFile, fragment.substring(PLATFORM_STRING_PREFIX.length())) : new File(fragment))).toURL();
    }

    public URL resolveRelativePathToURL(String path) {
        if (path == null || path.length() <= 0) {
            return null;
        }
        try {
            URL url = this.getURL(path);
            if (!FileUtil.isArchiveFile((URL)url)) {
                String s = url.toExternalForm();
                if (s.endsWith("/")) {
                    return url;
                }
                return new URL(s + '/');
            }
            return FileUtil.getArchiveRoot((URL)url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static URL localfilepath2url(String path) {
        try {
            return Utilities.toURI((File)new File(path)).toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static URL localfilepath2url(File file) {
        try {
            return Utilities.toURI((File)file).toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<FileObject> resolveRelativePathToFileObjects(String path) {
        ArrayList<FileObject> res = new ArrayList<FileObject>();
        if (path == null) {
            return new ArrayList<FileObject>();
        }
        String[] paths = PropertyUtils.tokenizePath((String)path);
        for (int a = 0; a < paths.length; ++a) {
            FileObject fo = this.resolveRelativePathToFileObject(paths[a].trim());
            if (fo == null) continue;
            res.add(fo);
        }
        return res;
    }

    public FileObject resolveRelativePathToFileObject(String path) {
        if (path == null || path.length() <= 0) {
            return null;
        }
        File f = path.startsWith(PLATFORM_STRING_PREFIX) ? new File(this.homeFile, path.substring(PLATFORM_STRING_PREFIX.length())) : new File(path);
        FileObject fo = FileUtil.toFileObject((File)(f = FileUtil.normalizeFile((File)f)));
        if (fo == null || !FileUtil.isArchiveFile((FileObject)fo)) {
            return fo;
        }
        return FileUtil.getArchiveRoot((FileObject)fo);
    }

    public static String getFilePath(FileObject fo) {
        File file;
        if (fo == null) {
            return null;
        }
        FileObject ff = FileUtil.getArchiveFile((FileObject)fo);
        if (ff == null) {
            ff = fo;
        }
        return (file = FileUtil.toFile((FileObject)ff)) != null ? file.getAbsolutePath() : null;
    }

    public String getAllLibrariesString() {
        FileObject[] files = this.getAllLibraries();
        if (files == null || files.length <= 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (int a = 0; a < files.length; ++a) {
            String value = J2MEPlatform.getFilePath(files[a]);
            if (value == null) continue;
            if (first) {
                first = false;
            } else {
                sb.append(':');
            }
            sb.append(value);
        }
        return sb.toString();
    }

    public ClassPath getStandardLibraries() {
        if (this.standardLibs == null) {
            this.standardLibs = ClassPathSupport.createClassPath(new ArrayList());
        }
        return this.standardLibs;
    }

    public ClassPath getBootstrapLibraries() {
        if (this.bootstrapLibs == null) {
            this.bootstrapLibs = ClassPathSupport.createClassPath((FileObject[])this.getAllLibraries());
        }
        return this.bootstrapLibs;
    }

    private FileObject[] getAllLibraries() {
        HashSet<FileObject> fobs = new HashSet<FileObject>();
        for (int i = 0; i < this.devices.length; ++i) {
            J2MEProfile[] profiles = this.devices[i].getProfiles();
            for (int j = 0; j < profiles.length; ++j) {
                fobs.addAll(this.resolveRelativePathToFileObjects(profiles[j].getClassPath()));
            }
        }
        return fobs.toArray(new FileObject[fobs.size()]);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getVendor() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getPreverifyCmd() {
        return this.preverifyCmd;
    }

    public String getRunCmd() {
        return this.runCmd;
    }

    public String getDebugCmd() {
        return this.debugCmd;
    }

    public String getHomePath() {
        return this.homeFile.getAbsolutePath();
    }

    public boolean isMe3Platform() {
        return this.me3Platform;
    }

    private boolean hasEssentialTools(Collection<FileObject> folders) {
        if (this.me3Platform) {
            return J2MEPlatform.findTool("emulator", folders) != null && J2MEPlatform.findTool("preverify", folders) != null;
        }
        return J2MEPlatform.findTool("emulator", folders) != null;
    }

    public Collection<FileObject> getInstallFolders() {
        if (this.home == null) {
            this.home = FileUtil.toFileObject((File)this.homeFile);
        }
        if (this.home != null && this.home.isValid() && this.home.isFolder()) {
            Set folders = Collections.singleton(this.home);
            return this.hasEssentialTools(folders) ? folders : Collections.EMPTY_SET;
        }
        return Collections.EMPTY_SET;
    }

    public List<URL> getJavadocFolders() {
        return Collections.unmodifiableList(this.javadocs);
    }

    public void setJavadocFolders(List<URL> javadocs) {
        this.javadocs = new ArrayList<URL>(javadocs);
        this.firePropertyChange("javadocFolders", null, null);
    }

    private String toRelativePaths(List<? extends Object> path) {
        StringBuffer sb = new StringBuffer();
        String homePath = this.homeFile.getAbsolutePath();
        if (Utilities.isWindows()) {
            homePath = "/" + homePath.toLowerCase().replace('\\', '/');
        }
        for (Object object : path) {
            if (object instanceof FileObject) {
                FileObject fo = FileUtil.getArchiveFile((FileObject)((FileObject)object));
                if (fo == null) {
                    fo = (FileObject)object;
                }
                if (this.home != null && FileUtil.isParentOf((FileObject)this.home, (FileObject)fo)) {
                    String tmp = FileUtil.getRelativePath((FileObject)this.home, (FileObject)fo);
                    if (tmp == null) continue;
                    if (tmp.startsWith("\\") || tmp.startsWith("/")) {
                        tmp = tmp.substring(1);
                    }
                    sb.append(PLATFORM_STRING_PREFIX).append(tmp).append(PATH_SEPARATOR);
                    continue;
                }
                File f = FileUtil.toFile((FileObject)fo);
                if (f == null) continue;
                sb.append(f.getAbsolutePath()).append(PATH_SEPARATOR);
                continue;
            }
            if (!(object instanceof URL)) continue;
            URL url = (URL)object;
            try {
                FileObject fo = URLMapper.findFileObject((URL)url);
                if (fo != null && this.home != null && FileUtil.isParentOf((FileObject)this.home, (FileObject)fo)) {
                    String tmp = FileUtil.getRelativePath((FileObject)this.home, (FileObject)fo);
                    if (tmp == null) continue;
                    if (tmp.startsWith("\\") || tmp.startsWith("/")) {
                        tmp = tmp.substring(1);
                    }
                    sb.append(PLATFORM_STRING_PREFIX).append(tmp).append(URL_SEPARATOR);
                    continue;
                }
                sb.append(url.toString()).append(URL_SEPARATOR);
            }
            catch (Exception e) {}
        }
        return sb.toString();
    }

    public String getJavadocPath() {
        return this.toRelativePaths(this.javadocs);
    }

    public ClassPath getSourceFolders() {
        return this.sources;
    }

    public void setSourceFolders(List<FileObject> sources) {
        this.sources = ClassPathSupport.createClassPath((FileObject[])sources.toArray(new FileObject[sources.size()]));
        this.firePropertyChange("sourceFolders", null, null);
    }

    public String getSourcePath() {
        return this.toRelativePaths(Arrays.asList(this.sources.getRoots()));
    }

    public Map<String, String> getProperties() {
        return Collections.singletonMap("platform.ant.name", this.getName());
    }

    public synchronized Specification getSpecification() {
        if (this.spec == null) {
            HashSet<J2MEProfile> profs = new HashSet<J2MEProfile>();
            for (int i = 0; i < this.devices.length; ++i) {
                J2MEProfile[] profiles = this.devices[i].getProfiles();
                profs.addAll(Arrays.asList(profiles));
            }
            SpecificationVersion sv = new SpecificationVersion("8.0");
            if (this.isMe3Platform()) {
                sv = new SpecificationVersion("3.0");
            }
            this.spec = new Specification(SPECIFICATION_NAME, sv, NbBundle.getMessage(J2MEPlatform.class, (String)"TXT_J2MEDisplayName"), profs.toArray(new Profile[profs.size()]));
        }
        return this.spec;
    }

    public boolean isValid() {
        if (this.getInstallFolders().isEmpty() || this.devices == null) {
            return false;
        }
        for (int i = 0; i < this.devices.length; ++i) {
            if (!this.devices[i].isValid()) continue;
            return true;
        }
        return false;
    }

    public static boolean isJavaME3Platform(FileObject dir) {
        return J2MEPlatform.findTool("emulator", Collections.singletonList(dir)) != null && J2MEPlatform.findTool("preverify", Collections.singletonList(dir)) != null;
    }

    public static boolean isJavaME8Platform(FileObject dir) {
        return J2MEPlatform.findTool("emulator", Collections.singletonList(dir)) != null && J2MEPlatform.findTool("preverify", Collections.singletonList(dir)) == null;
    }

    public static FileObject getSubFileObject(FileObject folder, String name) {
        if (folder == null || name == null) {
            return null;
        }
        if (Utilities.isWindows()) {
            name = name + ".exe";
            FileObject[] fos = folder.getChildren();
            if (fos != null) {
                for (int a = 0; a < fos.length; ++a) {
                    if (!name.equalsIgnoreCase(fos[a].getNameExt())) continue;
                    return fos[a];
                }
            }
            return null;
        }
        return folder.getFileObject(name);
    }

    public static FileObject findTool(String toolName, Collection<FileObject> installFolders) {
        assert (toolName != null);
        for (FileObject root : installFolders) {
            FileObject tool;
            FileObject bin;
            if (root == null || (bin = root.getFileObject("bin")) == null || (tool = J2MEPlatform.getSubFileObject(bin, toolName)) == null) continue;
            return tool;
        }
        return null;
    }

    public FileObject findTool(String toolName) {
        return J2MEPlatform.findTool(toolName, this.getInstallFolders());
    }

    public static DataObject createPlatform(String platformPath) throws IOException {
        J2MEPlatform p = new UEIEmulatorConfiguratorImpl(platformPath).getPlatform();
        return p == null ? null : J2MEPlatform.createPlatform(p);
    }

    public static DataObject createPlatform(J2MEPlatform platform) throws IOException {
        String name = platform.getName();
        FileObject platformsFolder = FileUtil.getConfigFile((String)"Services/Platforms/org-netbeans-api-java-Platform");
        if (platformsFolder.getFileObject(name, "xml") != null) {
            return null;
        }
        return PlatformConvertor.create(platform, DataFolder.findFolder((FileObject)platformsFolder), name);
    }

    public static String computeUniqueName(String platformName) {
        StringBuffer antname = new StringBuffer();
        for (int a = 0; a < platformName.length(); ++a) {
            char c = platformName.charAt(a);
            if (Character.isJavaIdentifierPart(c)) {
                antname.append(c);
                continue;
            }
            antname.append('_');
        }
        return antname.toString();
    }

    public void setRunCmd(String runCmd) {
        String old = this.runCmd;
        this.runCmd = runCmd;
        this.firePropertyChange("runCmd", old, runCmd);
    }

    public void setPreverifyCmd(String preverifyCmd) {
        String old = this.preverifyCmd;
        this.preverifyCmd = preverifyCmd;
        this.firePropertyChange("preverifyCmd", old, preverifyCmd);
    }

    public void setDebugCmd(String debugCmd) {
        String old = this.debugCmd;
        this.debugCmd = debugCmd;
        this.firePropertyChange("debugCmd", old, debugCmd);
    }

    public static final class J2MEProfile
    extends Profile
    implements Comparable {
        public static final String TYPE_CONFIGURATION = "configuration";
        public static final String TYPE_PROFILE = "profile";
        public static final String TYPE_OPTIONAL = "optional";
        private static final MessageFormat DISPLAY_NAME_WITH_VERSION_FORMAT = new MessageFormat(NbBundle.getMessage(J2MEPlatform.class, (String)"FMT_J2MEPlatform_J2MEProfile_DisplayNameWithVersion"));
        private final String displayName;
        private final String displayNameWithVersion;
        private final String type;
        private final String dependencies;
        private final String classPath;
        private final boolean def;
        boolean realyOptional;

        public J2MEProfile(String name, String version, String displayName, String type, String dependencies, String classPath, boolean def) {
            this(name, new SpecificationVersion(version), displayName, type, dependencies, classPath, def);
        }

        J2MEProfile(String name, SpecificationVersion version, String displayName, String type, String dependencies, String classPath, boolean def) {
            super(name, version);
            assert (name != null);
            assert (version != null);
            this.displayName = displayName == null ? name : displayName;
            this.displayNameWithVersion = "IMP-NG".equalsIgnoreCase(this.getName()) ? this.getDisplayName() : DISPLAY_NAME_WITH_VERSION_FORMAT.format(new Object[]{this.getDisplayName(), this.getVersion().toString()}, new StringBuffer(), (FieldPosition)null).toString();
            assert (type != null);
            this.type = type;
            this.dependencies = dependencies != null ? dependencies : "";
            this.classPath = classPath == null ? "" : classPath;
            this.def = def;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDisplayNameWithVersion() {
            return this.displayNameWithVersion;
        }

        public String getType() {
            return this.type;
        }

        public String getDependencies() {
            return this.dependencies;
        }

        public String getClassPath() {
            assert (this.classPath != null);
            return this.classPath;
        }

        public boolean isDefault() {
            return this.def;
        }

        public boolean isRealyOptional() {
            return this.realyOptional;
        }

        public boolean isNameIsJarFileName() {
            return this.classPath.equals(J2MEPlatform.PLATFORM_STRING_PREFIX + this.displayName);
        }

        public String toString() {
            return this.isNameIsJarFileName() || "IMP-NG".equalsIgnoreCase(this.getName()) ? this.getName() : this.getName() + '-' + this.getVersion().toString();
        }

        public int compareTo(Object o) {
            Profile p = (Profile)o;
            int r = this.getName().compareTo(p.getName());
            if (r != 0) {
                return r;
            }
            if (this.getVersion() == null) {
                return p.getVersion() == null ? 0 : -1;
            }
            return p.getVersion() == null ? 1 : this.getVersion().compareTo((Object)p.getVersion());
        }
    }

    public static final class Screen {
        private final Integer width;
        private final Integer height;
        private final Integer bitDepth;
        private final Boolean color;
        private final Boolean touch;

        public Screen(String width, String height, String bitDepth, String color, String touch) {
            Constable o;
            try {
                o = new Integer(width);
            }
            catch (NumberFormatException e) {
                o = null;
            }
            this.width = o;
            try {
                o = new Integer(height);
            }
            catch (NumberFormatException e) {
                o = null;
            }
            this.height = o;
            try {
                o = new Integer(bitDepth);
            }
            catch (NumberFormatException e) {
                o = null;
            }
            this.bitDepth = o;
            try {
                o = Boolean.valueOf(color);
            }
            catch (NumberFormatException e) {
                o = null;
            }
            this.color = (Boolean)o;
            try {
                o = Boolean.valueOf(touch);
            }
            catch (NumberFormatException e) {
                o = null;
            }
            this.touch = (Boolean)o;
        }

        public Integer getBitDepth() {
            return this.bitDepth;
        }

        public Boolean getColor() {
            return this.color;
        }

        public Integer getHeight() {
            return this.height;
        }

        public Boolean getTouch() {
            return this.touch;
        }

        public Integer getWidth() {
            return this.width;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Screen) {
                Integer width = ((Screen)obj).getWidth();
                Integer height = ((Screen)obj).getHeight();
                Integer bitDepth = ((Screen)obj).getBitDepth();
                Boolean color = ((Screen)obj).getColor();
                Boolean touch = ((Screen)obj).getTouch();
                boolean ret = true;
                ret &= width != null ? width.equals(this.width) : false;
                ret &= height != null ? height.equals(this.height) : false;
                ret &= bitDepth != null ? bitDepth.equals(this.bitDepth) : false;
                ret &= color != null ? color.equals(this.color) : false;
                return ret &= touch != null ? touch.equals(this.touch) : false;
            }
            return false;
        }

        public int hashCode() {
            int hash = 3;
            hash = 71 * hash + (this.width != null ? this.width.hashCode() : 0);
            hash = 71 * hash + (this.height != null ? this.height.hashCode() : 0);
            hash = 71 * hash + (this.bitDepth != null ? this.bitDepth.hashCode() : 0);
            hash = 71 * hash + (this.color != null ? this.color.hashCode() : 0);
            hash = 71 * hash + (this.touch != null ? this.touch.hashCode() : 0);
            return hash;
        }
    }

    public static final class Device {
        private final String name;
        private final String description;
        private final String[] securityDomains;
        private final J2MEProfile[] profiles;
        private final Screen screen;
        private final String[] pathOrder;

        public Device(String name, String description, String[] securityDomains, J2MEProfile[] profiles, Screen screen) {
            int i;
            this.screen = screen;
            assert (name != null);
            this.name = name;
            this.description = description == null ? name : description;
            this.securityDomains = securityDomains;
            assert (profiles != null);
            this.profiles = profiles;
            Set[] paths = new Set[profiles.length];
            HashMap<String, HashMap<String, SpecificationVersion>> allPaths = new HashMap<String, HashMap<String, SpecificationVersion>>();
            HashSet<String> doubledPaths = new HashSet<String>();
            for (i = 0; i < paths.length; ++i) {
                paths[i] = new HashSet();
                String[] s = PropertyUtils.tokenizePath((String)profiles[i].getClassPath());
                for (int j = 0; j < s.length; ++j) {
                    paths[i].add(s[j]);
                    HashMap<String, Object> apis = allPaths.get(s[j]);
                    if (apis == null) {
                        apis = new HashMap();
                        allPaths.put(s[j], apis);
                    } else {
                        doubledPaths.add(s[j]);
                    }
                    apis.put(profiles[i].getName(), profiles[i].getVersion());
                }
            }
            for (i = 0; i < paths.length; ++i) {
                profiles[i].realyOptional = paths[i].retainAll(doubledPaths);
            }
            this.pathOrder = new String[allPaths.size()];
            for (i = 0; i < this.pathOrder.length; ++i) {
                String first;
                this.pathOrder[i] = first = this.findFirst(allPaths);
                allPaths.remove(first);
            }
        }

        public String sortClasspath(String classpath) {
            HashSet<String> path = new HashSet<String>(Arrays.asList(PropertyUtils.tokenizePath((String)classpath)));
            StringBuffer newPath = new StringBuffer();
            for (int i = 0; i < this.pathOrder.length; ++i) {
                if (!path.remove(this.pathOrder[i])) continue;
                if (newPath.length() > 0) {
                    newPath.append(':');
                }
                newPath.append(this.pathOrder[i]);
            }
            for (String str : path) {
                if (newPath.length() > 0) {
                    newPath.append(':');
                }
                newPath.append(str);
            }
            return newPath.toString();
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }

        public String getDescription() {
            return this.description;
        }

        public String[] getSecurityDomains() {
            return this.securityDomains == null ? null : (String[])this.securityDomains.clone();
        }

        public J2MEProfile[] getProfiles() {
            return this.profiles == null ? null : (J2MEProfile[])this.profiles.clone();
        }

        public Screen getScreen() {
            return this.screen;
        }

        public boolean isValid() {
            if (this.profiles == null) {
                return false;
            }
            boolean cfg = false;
            boolean prof = false;
            for (int i = 0; i < this.profiles.length; ++i) {
                cfg = cfg || this.profiles[i].getType().equals("configuration");
                prof = prof || this.profiles[i].getType().equals("profile");
            }
            return cfg && prof;
        }

        private String findFirst(HashMap<String, HashMap<String, SpecificationVersion>> allPaths) {
            Map.Entry<String, HashMap<String, SpecificationVersion>> last = null;
            for (Map.Entry<String, HashMap<String, SpecificationVersion>> me : allPaths.entrySet()) {
                Map apis = me.getValue();
                if (!apis.containsKey("CLDC") && !apis.containsKey("MIDP") && this.canBeFirst(apis, allPaths)) {
                    return me.getKey();
                }
                last = me;
            }
            for (Map.Entry<String, HashMap<String, SpecificationVersion>> me : allPaths.entrySet()) {
                if (this.canBeFirst((Map<String, SpecificationVersion>)me.getValue(), allPaths)) {
                    return me.getKey();
                }
                last = me;
            }
            return (String)last.getKey();
        }

        private boolean canBeFirst(Map<String, SpecificationVersion> map, HashMap<String, HashMap<String, SpecificationVersion>> allPaths) {
            for (HashMap<String, SpecificationVersion> svmap : allPaths.values()) {
                if (this.isValidOrder(map, svmap)) continue;
                return false;
            }
            return true;
        }

        private boolean isValidOrder(Map<String, SpecificationVersion> firstAPImap, HashMap<String, SpecificationVersion> secondAPImap) {
            HashSet<String> hs = new HashSet<String>(firstAPImap.keySet());
            hs.retainAll(secondAPImap.keySet());
            if (hs.isEmpty()) {
                return true;
            }
            for (String api : hs) {
                if (firstAPImap.get(api).compareTo((Object)secondAPImap.get(api)) < 0) continue;
                return true;
            }
            return false;
        }
    }
}

