/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.visual;

import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.visual.JavaComponentInfo;

public class ComponentsFieldFinder {
    static void findFieldsForComponents(JavaComponentInfo ci) {
        int n = ComponentsFieldFinder.countComponents(ci);
        long[] uids = new long[n];
        JavaComponentInfo[] components = new JavaComponentInfo[n];
        ComponentsFieldFinder.fillComponents(ci, components, 0);
        Arrays.sort(components, new JavaComponentInfoUIDComparator());
        for (int i = 0; i < n; ++i) {
            uids[i] = components[i].uid;
        }
        for (JavaComponentInfo jci : components) {
            if (!jci.isCustomType() || jci.getSubComponents().length <= 0) continue;
            ObjectReference c = jci.getComponent();
            try {
                Map fieldValues = ObjectReferenceWrapper.getValues((ObjectReference)c, (List)ReferenceTypeWrapper.fields((ReferenceType)ObjectReferenceWrapper.referenceType((ObjectReference)c)));
                for (Map.Entry fv : fieldValues.entrySet()) {
                    long uid;
                    int index;
                    Value value = (Value)fv.getValue();
                    if (!(value instanceof ObjectReference) || (index = Arrays.binarySearch(uids, uid = ObjectReferenceWrapper.uniqueID((ObjectReference)((ObjectReference)value)))) < 0) continue;
                    components[index].setFieldInfo(new JavaComponentInfo.FieldInfo((Field)fv.getKey(), jci));
                }
            }
            catch (ClassNotPreparedExceptionWrapper cnpex) {
            }
            catch (InternalExceptionWrapper iex) {
            }
            catch (ObjectCollectedExceptionWrapper ocex) {
            }
            catch (VMDisconnectedExceptionWrapper vmdex) {
                return;
            }
        }
    }

    private static int countComponents(JavaComponentInfo ci) {
        int n = 1;
        for (JavaComponentInfo jci : ci.getSubComponents()) {
            n += ComponentsFieldFinder.countComponents(jci);
        }
        return n;
    }

    private static int fillComponents(JavaComponentInfo ci, JavaComponentInfo[] components, int pos) {
        components[pos] = ci;
        ++pos;
        for (JavaComponentInfo jci : ci.getSubComponents()) {
            pos = ComponentsFieldFinder.fillComponents(jci, components, pos);
        }
        return pos;
    }

    private static class JavaComponentInfoUIDComparator
    implements Comparator<JavaComponentInfo> {
        @Override
        public int compare(JavaComponentInfo o1, JavaComponentInfo o2) {
            if (o1.uid == o2.uid) {
                return 0;
            }
            if (o1.uid < o2.uid) {
                return -1;
            }
            return 1;
        }
    }
}

