/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.visual.breakpoints;

import com.sun.jdi.ObjectReference;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.netbeans.modules.debugger.jpda.visual.RemoteAWTScreenshot;
import org.netbeans.modules.debugger.jpda.visual.breakpoints.AWTComponentBreakpointImpl;
import org.netbeans.modules.debugger.jpda.visual.breakpoints.BaseComponentBreakpointImpl;
import org.netbeans.modules.debugger.jpda.visual.breakpoints.ComponentBreakpoint;
import org.netbeans.modules.debugger.jpda.visual.breakpoints.ComponentBreakpointImpl;
import org.netbeans.modules.debugger.jpda.visual.breakpoints.FXComponentBreakpointImpl;
import org.netbeans.spi.debugger.ContextProvider;

public class BreakpointsEngineListener
extends LazyActionsManagerListener
implements PropertyChangeListener,
DebuggerManagerListener {
    private static final Logger logger = Logger.getLogger(BreakpointsEngineListener.class.getName());
    private JPDADebuggerImpl debugger;
    private SourcePath engineContext;
    private boolean started = false;
    private Session session;
    private final Map<Breakpoint, ComponentBreakpointImpl> breakpointToImpl = new IdentityHashMap<Breakpoint, ComponentBreakpointImpl>();
    private final ComponentBreakpointImpl preliminaryBreakpointImpl = new PreliminaryBreakpointImpl();

    public BreakpointsEngineListener(ContextProvider lookupProvider) {
        this.debugger = (JPDADebuggerImpl)lookupProvider.lookupFirst(null, JPDADebugger.class);
        this.engineContext = (SourcePath)lookupProvider.lookupFirst(null, SourcePath.class);
        this.session = (Session)lookupProvider.lookupFirst(null, Session.class);
        this.debugger.addPropertyChangeListener("state", (PropertyChangeListener)this);
    }

    protected void destroy() {
        this.debugger.removePropertyChangeListener("state", (PropertyChangeListener)this);
        DebuggerManager.getDebuggerManager().removeDebuggerListener("breakpoints", (DebuggerManagerListener)this);
        this.removeBreakpointImpls();
    }

    public String[] getProperties() {
        return new String[]{"asd"};
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.debugger.getState() == 2) {
            if (this.started) {
                return;
            }
            this.started = true;
            this.createBreakpointImpls();
            DebuggerManager.getDebuggerManager().addDebuggerListener("breakpoints", (DebuggerManagerListener)this);
        }
        if (this.debugger.getState() == 4) {
            this.removeBreakpointImpls();
            this.started = false;
            DebuggerManager.getDebuggerManager().removeDebuggerListener("breakpoints", (DebuggerManagerListener)this);
        }
    }

    public void actionPerformed(Object action) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void breakpointAdded(final Breakpoint breakpoint) {
        final boolean[] started = new boolean[]{false};
        if (!EventQueue.isDispatchThread() && this.debugger.accessLock.readLock().tryLock()) {
            try {
                this.createBreakpointImpl(breakpoint);
                return;
            }
            finally {
                this.debugger.accessLock.readLock().unlock();
            }
        }
        this.debugger.getRequestProcessor().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ((BreakpointsEngineListener)BreakpointsEngineListener.this).debugger.accessLock.readLock().lock();
                try {
                    boolean[] blArray = started;
                    synchronized (started) {
                        started[0] = true;
                        started.notify();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        BreakpointsEngineListener.this.createBreakpointImpl(breakpoint);
                    }
                }
                finally {
                    ((BreakpointsEngineListener)BreakpointsEngineListener.this).debugger.accessLock.readLock().unlock();
                }
                {
                    return;
                }
            }
        });
        if (EventQueue.isDispatchThread()) return;
        boolean[] blArray = started;
        synchronized (started) {
            if (started[0]) return;
            try {
                started.wait();
            }
            catch (InterruptedException iex) {
                // empty catch block
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void breakpointRemoved(final Breakpoint breakpoint) {
        final boolean[] started = new boolean[]{false};
        if (!EventQueue.isDispatchThread() && this.debugger.accessLock.readLock().tryLock()) {
            try {
                this.removeBreakpointImpl(breakpoint);
                return;
            }
            finally {
                this.debugger.accessLock.readLock().unlock();
            }
        }
        this.debugger.getRequestProcessor().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ((BreakpointsEngineListener)BreakpointsEngineListener.this).debugger.accessLock.readLock().lock();
                try {
                    boolean[] blArray = started;
                    synchronized (started) {
                        started[0] = true;
                        started.notify();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        BreakpointsEngineListener.this.removeBreakpointImpl(breakpoint);
                    }
                }
                finally {
                    ((BreakpointsEngineListener)BreakpointsEngineListener.this).debugger.accessLock.readLock().unlock();
                }
                {
                    return;
                }
            }
        });
        if (EventQueue.isDispatchThread()) return;
        boolean[] blArray = started;
        synchronized (started) {
            if (started[0]) return;
            try {
                started.wait();
            }
            catch (InterruptedException iex) {
                // empty catch block
            }
            return;
        }
    }

    public Breakpoint[] initBreakpoints() {
        return new Breakpoint[0];
    }

    public void initWatches() {
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void engineAdded(DebuggerEngine engine) {
    }

    public void engineRemoved(DebuggerEngine engine) {
    }

    private void createBreakpointImpls() {
        Breakpoint[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
        int k = bs.length;
        for (int i = 0; i < k; ++i) {
            this.createBreakpointImpl(bs[i]);
        }
    }

    private void removeBreakpointImpls() {
        Breakpoint[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
        int k = bs.length;
        for (int i = 0; i < k; ++i) {
            boolean removed = this.removeBreakpointImpl(bs[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBreakpointImpl(Breakpoint b) {
        if (!(b instanceof ComponentBreakpoint)) {
            return;
        }
        ComponentBreakpoint ab = (ComponentBreakpoint)b;
        Map<Breakpoint, ComponentBreakpointImpl> map = this.breakpointToImpl;
        synchronized (map) {
            if (this.breakpointToImpl.containsKey(b)) {
                return;
            }
            ObjectReference component = ab.getComponent().getComponent((JPDADebugger)this.debugger);
            if (component == null) {
                return;
            }
            this.breakpointToImpl.put(b, this.preliminaryBreakpointImpl);
        }
        BaseComponentBreakpointImpl bpi = ab.getComponent().getComponentInfo() instanceof RemoteAWTScreenshot.AWTComponentInfo ? new AWTComponentBreakpointImpl(ab, (JPDADebugger)this.debugger) : new FXComponentBreakpointImpl(ab, (JPDADebugger)this.debugger);
        BaseComponentBreakpointImpl bpiToRemove = null;
        Map<Breakpoint, ComponentBreakpointImpl> map2 = this.breakpointToImpl;
        synchronized (map2) {
            if (bpi == null) {
                this.breakpointToImpl.remove(b);
            } else if (!this.breakpointToImpl.containsKey(b)) {
                bpiToRemove = bpi;
            } else {
                this.breakpointToImpl.put(b, bpi);
            }
        }
        logger.finer("BreakpointsEngineListener: created impl " + bpi + " for " + b);
        if (bpiToRemove != null) {
            bpiToRemove.notifyRemoved();
            logger.finer("BreakpointsEngineListener: removed impl " + bpiToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeBreakpointImpl(Breakpoint b) {
        ComponentBreakpointImpl impl;
        Map<Breakpoint, ComponentBreakpointImpl> map = this.breakpointToImpl;
        synchronized (map) {
            impl = this.breakpointToImpl.remove(b);
            if (impl == null) {
                return false;
            }
        }
        logger.finer("BreakpointsEngineListener: removed impl " + impl + " for " + b);
        impl.notifyRemoved();
        return true;
    }

    private static final class PreliminaryBreakpointImpl
    extends ComponentBreakpointImpl {
    }
}

