/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.client.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.remotefs.versioning.api.RemoteVcsSupport;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.SvnModuleConfig;
import org.netbeans.modules.subversion.remote.api.Annotations;
import org.netbeans.modules.subversion.remote.api.Depth;
import org.netbeans.modules.subversion.remote.api.ISVNAnnotations;
import org.netbeans.modules.subversion.remote.api.ISVNDirEntry;
import org.netbeans.modules.subversion.remote.api.ISVNDirEntryWithLock;
import org.netbeans.modules.subversion.remote.api.ISVNInfo;
import org.netbeans.modules.subversion.remote.api.ISVNLogMessage;
import org.netbeans.modules.subversion.remote.api.ISVNNotifyListener;
import org.netbeans.modules.subversion.remote.api.ISVNProperty;
import org.netbeans.modules.subversion.remote.api.ISVNStatus;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.api.SVNDiffSummary;
import org.netbeans.modules.subversion.remote.api.SVNNotificationHandler;
import org.netbeans.modules.subversion.remote.api.SVNRevision;
import org.netbeans.modules.subversion.remote.api.SVNScheduleKind;
import org.netbeans.modules.subversion.remote.api.SVNStatusKind;
import org.netbeans.modules.subversion.remote.api.SVNStatusUnversioned;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.SvnClient;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.client.SvnClientFactory;
import org.netbeans.modules.subversion.remote.client.cli.Bundle;
import org.netbeans.modules.subversion.remote.client.cli.CLIStatus;
import org.netbeans.modules.subversion.remote.client.cli.Commandline;
import org.netbeans.modules.subversion.remote.client.cli.SvnCommand;
import org.netbeans.modules.subversion.remote.client.cli.commands.AddCommand;
import org.netbeans.modules.subversion.remote.client.cli.commands.BlameCommand;
import org.netbeans.modules.subversion.remote.client.cli.commands.CatCommand;
import org.netbeans.modules.subversion.remote.client.cli.commands.CheckoutCommand;
import org.netbeans.modules.subversion.remote.client.cli.commands.CleanupCommand;
import org.netbeans.modules.subversion.remote.client.cli.commands.CommitCommand;
import org.netbeans.modules.subversion.remote.client.cli.commands.CopyCommand;
import org.netbeans.modules.subversion.remote.client.cli.commands.ExportCommand;
import org.netbeans.modules.subversion.remote.client.cli.commands.ImportCommand;
import org.netbeans.modules.subversion.remote.client.cli.commands.InfoCommand;
import org.netbeans.modules.subversion.remote.client.cli.commands.ListCommand;
import org.netbeans.modules.subversion.remote.client.cli.commands.ListPropertiesCommand;
import org.netbeans.modules.subversion.remote.client.cli.commands.LockCommand;
import org.netbeans.modules.subversion.remote.client.cli.commands.LogCommand;
import org.netbeans.modules.subversion.remote.client.cli.commands.MergeCommand;
import org.netbeans.modules.subversion.remote.client.cli.commands.MkdirCommand;
import org.netbeans.modules.subversion.remote.client.cli.commands.MoveCommand;
import org.netbeans.modules.subversion.remote.client.cli.commands.PropertyDelCommand;
import org.netbeans.modules.subversion.remote.client.cli.commands.PropertyGetCommand;
import org.netbeans.modules.subversion.remote.client.cli.commands.PropertySetCommand;
import org.netbeans.modules.subversion.remote.client.cli.commands.RelocateCommand;
import org.netbeans.modules.subversion.remote.client.cli.commands.RemoveCommand;
import org.netbeans.modules.subversion.remote.client.cli.commands.ResolvedCommand;
import org.netbeans.modules.subversion.remote.client.cli.commands.RevertCommand;
import org.netbeans.modules.subversion.remote.client.cli.commands.StatusCommand;
import org.netbeans.modules.subversion.remote.client.cli.commands.SwitchToCommand;
import org.netbeans.modules.subversion.remote.client.cli.commands.UnlockCommand;
import org.netbeans.modules.subversion.remote.client.cli.commands.UpdateCommand;
import org.netbeans.modules.subversion.remote.client.cli.commands.UpgradeCommand;
import org.netbeans.modules.subversion.remote.client.cli.commands.VersionCommand;
import org.netbeans.modules.subversion.remote.client.parser.LocalSubversionException;
import org.netbeans.modules.subversion.remote.client.parser.ParserSvnStatus;
import org.netbeans.modules.subversion.remote.client.parser.SvnWcParser;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

public class CommandlineClient
implements SvnClient {
    private String user;
    private String psswd;
    private VCSFileProxy configDir;
    private final NotificationHandler notificationHandler = new NotificationHandler();
    private final SvnWcParser wcParser = new SvnWcParser();
    private final Commandline cli;
    private final FileSystem fileSystem;
    public static final String ERR_CLI_NOT_AVALABLE = "commandline is not available";

    public CommandlineClient(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
        this.cli = new Commandline(fileSystem);
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public boolean checkSupportedVersion() throws SVNClientException {
        VersionCommand cmd = new VersionCommand(this.fileSystem);
        try {
            this.config(cmd);
            this.cli.exec(cmd);
            this.checkErrors(cmd);
            if (!cmd.checkForErrors()) {
                if (cmd.isUnsupportedVersion()) {
                    Subversion.LOG.log(Level.WARNING, "Unsupported svn version. You need >= 1.5");
                }
                throw new SVNClientException("commandline is not available\n" + cmd.getOutput());
            }
            return cmd.isMetadataFormatSupported();
        }
        catch (IOException ex) {
            if (Subversion.LOG.isLoggable(Level.FINE)) {
                Subversion.LOG.log(Level.FINE, null, ex);
            }
            throw new SVNClientException(ERR_CLI_NOT_AVALABLE);
        }
    }

    @Override
    public String getVersion() throws SVNClientException {
        VersionCommand cmd = new VersionCommand(this.fileSystem);
        try {
            this.config(cmd);
            this.cli.exec(cmd);
            this.checkErrors(cmd);
            return cmd.getOutput();
        }
        catch (IOException ex) {
            if (Subversion.LOG.isLoggable(Level.FINE)) {
                Subversion.LOG.log(Level.FINE, null, ex);
            }
            throw new SVNClientException(ex);
        }
    }

    @Override
    public void addNotifyListener(ISVNNotifyListener l) {
        this.notificationHandler.add(l);
    }

    @Override
    public void removeNotifyListener(ISVNNotifyListener l) {
        this.notificationHandler.remove(l);
    }

    @Override
    public void setUsername(String user) {
        this.user = user;
    }

    @Override
    public void setPassword(String psswd) {
        this.psswd = psswd;
    }

    @Override
    public void setConfigDirectory(VCSFileProxy file) throws SVNClientException {
        this.configDir = file;
    }

    @Override
    public SVNNotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    @Override
    public void addFile(VCSFileProxy file) throws SVNClientException {
        AddCommand cmd = new AddCommand(this.fileSystem, new VCSFileProxy[]{file}, false, false);
        this.exec(cmd);
    }

    @Override
    public void addDirectory(VCSFileProxy dir, boolean recursive) throws SVNClientException {
        AddCommand cmd = new AddCommand(this.fileSystem, new VCSFileProxy[]{dir}, recursive, false);
        this.exec(cmd);
    }

    @Override
    public void checkout(SVNUrl url, VCSFileProxy file, SVNRevision revision, boolean recurse) throws SVNClientException {
        CheckoutCommand cmd = new CheckoutCommand(this.fileSystem, url, file, revision, recurse);
        this.exec(cmd);
        this.refresh(file);
    }

    @Override
    public void doExport(SVNUrl url, VCSFileProxy destination, SVNRevision revision, boolean force) throws SVNClientException {
        ExportCommand cmd = new ExportCommand(this.fileSystem, url, destination, revision, force);
        this.exec(cmd);
        this.refresh(destination);
    }

    @Override
    public void doExport(VCSFileProxy fileFrom, VCSFileProxy fileTo, boolean force) throws SVNClientException {
        ExportCommand cmd = new ExportCommand(this.fileSystem, fileFrom, fileTo, force);
        this.exec(cmd);
        this.refresh(fileTo);
    }

    @Override
    public long commit(VCSFileProxy[] files, String message, boolean recurse) throws SVNClientException {
        return this.commit(files, message, false, recurse);
    }

    @Override
    public long commit(VCSFileProxy[] files, String message, boolean keep, boolean recursive) throws SVNClientException {
        int retry = 0;
        CommitCommand cmd = null;
        while (true) {
            try {
                cmd = new CommitCommand(this.fileSystem, files, keep, recursive, message);
                this.exec(cmd);
            }
            catch (SVNClientException e) {
                if (e.getMessage().startsWith("svn: Attempted to lock an already-locked dir")) {
                    if (Subversion.LOG.isLoggable(Level.FINE)) {
                        Subversion.LOG.fine("ComandlineClient.comit() : " + e.getMessage());
                    }
                    try {
                        if (++retry > 14) {
                            throw e;
                        }
                        Thread.sleep(retry * 50);
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                    continue;
                }
                throw e;
            }
            break;
        }
        this.refresh(files);
        return cmd.getRevision();
    }

    @Override
    public ISVNDirEntry[] getList(SVNUrl url, SVNRevision revision, boolean recursivelly) throws SVNClientException {
        ListCommand cmd = new ListCommand(this.fileSystem, url, revision, recursivelly);
        this.exec(cmd);
        return cmd.getEntries();
    }

    @Override
    public ISVNInfo getInfo(Context context, SVNUrl url) throws SVNClientException {
        return this.getInfo(context, url, SVNRevision.HEAD, SVNRevision.HEAD);
    }

    @Override
    public ISVNInfo getInfo(VCSFileProxy file) throws SVNClientException {
        return this.getInfoFromWorkingCopy(file);
    }

    @Override
    public String getPostCommitError() {
        return null;
    }

    private ISVNInfo[] getInfo(VCSFileProxy[] files, SVNRevision revision, SVNRevision pegging) throws SVNClientException, SVNClientException {
        if (files == null || files.length == 0) {
            return new ISVNInfo[0];
        }
        InfoCommand infoCmd = new InfoCommand(this.fileSystem, files, revision, pegging);
        this.exec(infoCmd);
        ISVNInfo[] infos = infoCmd.getInfo();
        return infos;
    }

    @Override
    public ISVNInfo getInfo(Context context, SVNUrl url, SVNRevision revision, SVNRevision pegging) throws SVNClientException {
        InfoCommand cmd = new InfoCommand(this.fileSystem, context, url, revision, pegging);
        this.exec(cmd);
        ISVNInfo[] infos = cmd.getInfo();
        ISVNInfo info = null;
        if (infos.length > 0) {
            info = infos[0];
        }
        return info;
    }

    @Override
    public void copy(VCSFileProxy fileFrom, VCSFileProxy fileTo) throws SVNClientException {
        CopyCommand cmd = new CopyCommand(this.fileSystem, fileFrom, fileTo);
        this.exec(cmd);
        this.refresh(fileTo);
    }

    @Override
    public void copy(VCSFileProxy file, SVNUrl url, String msg) throws SVNClientException {
        CopyCommand cmd = new CopyCommand(this.fileSystem, file, url, msg);
        this.exec(cmd);
    }

    @Override
    public void copy(SVNUrl url, VCSFileProxy file, SVNRevision rev) throws SVNClientException {
        CopyCommand cmd = new CopyCommand(this.fileSystem, url, file, rev);
        this.exec(cmd);
        this.refresh(file);
    }

    @Override
    public void copy(SVNUrl fromUrl, SVNUrl toUrl, String msg, SVNRevision rev) throws SVNClientException {
        this.copy(fromUrl, toUrl, msg, rev, false);
    }

    @Override
    public void remove(VCSFileProxy[] files, boolean force) throws SVNClientException {
        RemoveCommand cmd = new RemoveCommand(this.fileSystem, files, force);
        this.exec(cmd);
        this.refreshParents(files);
    }

    @Override
    public void doImport(VCSFileProxy File2, SVNUrl url, String msg, boolean recursivelly) throws SVNClientException {
        ImportCommand cmd = new ImportCommand(this.fileSystem, File2, url, recursivelly, msg);
        this.exec(cmd);
    }

    @Override
    public void mkdir(SVNUrl url, String msg) throws SVNClientException {
        MkdirCommand cmd = new MkdirCommand(this.fileSystem, url, msg);
        this.exec(cmd);
    }

    @Override
    public void mkdir(VCSFileProxy file) throws SVNClientException {
        MkdirCommand cmd = new MkdirCommand(this.fileSystem, file);
        this.exec(cmd);
    }

    @Override
    public void move(VCSFileProxy fromFile, VCSFileProxy toFile, boolean force) throws SVNClientException {
        MoveCommand cmd = new MoveCommand(this.fileSystem, fromFile, toFile, force);
        this.exec(cmd);
        this.refreshParents(fromFile, toFile);
    }

    @Override
    public long update(VCSFileProxy file, SVNRevision rev, boolean recursivelly) throws SVNClientException {
        UpdateCommand cmd = new UpdateCommand(this.fileSystem, new VCSFileProxy[]{file}, rev, recursivelly, false);
        this.exec(cmd);
        this.refresh(file);
        return cmd.getRevision();
    }

    @Override
    public void revert(VCSFileProxy file, boolean recursivelly) throws SVNClientException {
        this.revert(new VCSFileProxy[]{file}, recursivelly);
    }

    @Override
    public void revert(VCSFileProxy[] files, boolean recursivelly) throws SVNClientException {
        if (files == null || files.length == 0) {
            return;
        }
        RevertCommand cmd = new RevertCommand(this.fileSystem, files, recursivelly);
        this.exec(cmd);
        this.refresh(files);
    }

    @Override
    public ISVNStatus[] getStatus(VCSFileProxy[] files) throws SVNClientException {
        HashMap<VCSFileProxy, SVNStatusUnversioned> unversionedMap = new HashMap<VCSFileProxy, SVNStatusUnversioned>();
        ArrayList<VCSFileProxy> filesForStatus = new ArrayList<VCSFileProxy>();
        ArrayList<VCSFileProxy> filesForInfo = new ArrayList<VCSFileProxy>();
        for (VCSFileProxy f : files) {
            if (!this.isManaged(f)) {
                unversionedMap.put(f, new SVNStatusUnversioned(f));
                continue;
            }
            filesForStatus.add(f);
        }
        StatusCommand.Status[] statusValues = new StatusCommand.Status[]{};
        if (!filesForStatus.isEmpty()) {
            StatusCommand statusCmd = new StatusCommand(this.fileSystem, filesForStatus.toArray(new VCSFileProxy[filesForStatus.size()]), true, false, false, false);
            this.exec(statusCmd);
            statusValues = statusCmd.getStatusValues();
        }
        for (StatusCommand.Status status : statusValues) {
            if (!this.isManaged(status.getWcStatus())) continue;
            filesForInfo.add(status.getPath());
        }
        HashMap<VCSFileProxy, ISVNInfo> infoMap = new HashMap<VCSFileProxy, ISVNInfo>();
        if (!filesForInfo.isEmpty()) {
            ISVNInfo[] infos;
            ISVNInfo[] arr$ = infos = this.getInfo(filesForInfo.toArray(new VCSFileProxy[filesForInfo.size()]), null, null);
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                ISVNInfo info = arr$[i$];
                infoMap.put(info.getFile(), info);
            }
        }
        HashMap<VCSFileProxy, ISVNStatus> statusMap = new HashMap<VCSFileProxy, ISVNStatus>();
        for (StatusCommand.Status status : statusValues) {
            VCSFileProxy file = status.getPath();
            if (status == null || !this.isManaged(status.getWcStatus())) {
                if (!SVNStatusKind.UNVERSIONED.equals((Object)status.getRepoStatus())) {
                    statusMap.put(file, new CLIStatus(status));
                    continue;
                }
                statusMap.put(file, new SVNStatusUnversioned(file, SVNStatusKind.IGNORED.equals((Object)status.getWcStatus())));
                continue;
            }
            ISVNInfo info = (ISVNInfo)infoMap.get(file);
            if (info == null) continue;
            statusMap.put(file, new CLIStatus(status, info));
        }
        ArrayList<ISVNStatus> ret = new ArrayList<ISVNStatus>();
        for (VCSFileProxy f : files) {
            ISVNStatus s = (ISVNStatus)statusMap.get(f);
            if (s == null) {
                s = (ISVNStatus)unversionedMap.get(f);
            }
            if (s == null) continue;
            ret.add(s);
        }
        return ret.toArray(new ISVNStatus[ret.size()]);
    }

    @Override
    public ISVNStatus[] getStatus(VCSFileProxy file, boolean descend, boolean getAll, boolean contactServer) throws SVNClientException {
        return this.getStatus(file, descend, getAll, contactServer, false);
    }

    @Override
    public ISVNStatus[] getStatus(VCSFileProxy file, boolean descend, boolean getAll, boolean contactServer, boolean ignoreExternals) throws SVNClientException {
        StatusCommand.Status[] statusValues = null;
        try {
            if (!this.isManaged(file)) {
                return new ISVNStatus[]{new SVNStatusUnversioned(file)};
            }
            StatusCommand statusCmd = new StatusCommand(this.fileSystem, new VCSFileProxy[]{file}, getAll, descend, contactServer, ignoreExternals);
            this.exec(statusCmd);
            statusValues = statusCmd.getStatusValues();
        }
        catch (SVNClientException e) {
            if (SvnClientExceptionHandler.isUnversionedResource(e.getMessage())) {
                return new ISVNStatus[]{new SVNStatusUnversioned(file)};
            }
            throw e;
        }
        ArrayList<VCSFileProxy> filesForInfo = new ArrayList<VCSFileProxy>();
        for (StatusCommand.Status status : statusValues) {
            if (!this.isManaged(status.getWcStatus())) continue;
            filesForInfo.add(status.getPath());
        }
        ISVNInfo[] infos = this.getInfo(filesForInfo.toArray(new VCSFileProxy[filesForInfo.size()]), null, null);
        HashMap<VCSFileProxy, ISVNInfo> infoMap = new HashMap<VCSFileProxy, ISVNInfo>();
        for (ISVNInfo info : infos) {
            infoMap.put(info.getFile(), info);
        }
        HashMap<VCSFileProxy, ISVNStatus> statusMap = new HashMap<VCSFileProxy, ISVNStatus>();
        for (StatusCommand.Status status : statusValues) {
            VCSFileProxy f = status.getPath();
            if (status == null || !this.isManaged(status.getWcStatus())) {
                if (!SVNStatusKind.UNVERSIONED.equals((Object)status.getRepoStatus())) {
                    statusMap.put(f, new CLIStatus(status));
                    continue;
                }
                statusMap.put(f, new SVNStatusUnversioned(f, SVNStatusKind.IGNORED.equals((Object)status.getWcStatus())));
                continue;
            }
            ISVNInfo info = (ISVNInfo)infoMap.get(f);
            if (info == null) continue;
            statusMap.put(f, new CLIStatus(status, info));
        }
        ArrayList<ISVNStatus> ret = new ArrayList<ISVNStatus>();
        for (StatusCommand.Status status : statusValues) {
            VCSFileProxy f = status.getPath();
            ISVNStatus s = (ISVNStatus)statusMap.get(f);
            if (s == null) {
                s = new SVNStatusUnversioned(f);
            }
            ret.add(s);
        }
        return ret.toArray(new ISVNStatus[ret.size()]);
    }

    @Override
    public ISVNLogMessage[] getLogMessages(SVNUrl url, SVNRevision revStart, SVNRevision revEnd) throws SVNClientException {
        return this.getLogMessages(url, revStart, revEnd, false);
    }

    @Override
    public ISVNLogMessage[] getLogMessages(SVNUrl url, SVNRevision revStart, SVNRevision revEnd, boolean fetchChangePath) throws SVNClientException {
        return this.getLogMessages(url, null, revStart, revEnd, false, fetchChangePath);
    }

    @Override
    public ISVNLogMessage[] getLogMessages(SVNUrl url, String[] paths, SVNRevision revStart, SVNRevision revEnd, boolean stopOnCopy, boolean fetchChangePath) throws SVNClientException {
        LogCommand cmd = new LogCommand(this.fileSystem, url, paths, revStart, revEnd, SVNRevision.HEAD, stopOnCopy, fetchChangePath, 0L);
        return this.getLog(cmd);
    }

    @Override
    public ISVNLogMessage[] getLogMessages(SVNUrl url, SVNRevision revPeg, SVNRevision revStart, SVNRevision revEnd, boolean stopOnCopy, boolean fetchChangePath, long limit) throws SVNClientException {
        LogCommand cmd = new LogCommand(this.fileSystem, url, null, revStart, revEnd, revPeg, stopOnCopy, fetchChangePath, limit);
        return this.getLog(cmd);
    }

    @Override
    public ISVNLogMessage[] getLogMessages(VCSFileProxy file, SVNRevision revStart, SVNRevision revEnd) throws SVNClientException {
        return this.getLogMessages(file, revStart, revEnd, false);
    }

    @Override
    public ISVNLogMessage[] getLogMessages(VCSFileProxy file, SVNRevision revStart, SVNRevision revEnd, boolean fetchChangePath) throws SVNClientException {
        return this.getLogMessages(file, revStart, revEnd, false, fetchChangePath);
    }

    @Override
    public ISVNLogMessage[] getLogMessages(VCSFileProxy file, SVNRevision revStart, SVNRevision revEnd, boolean stopOnCopy, boolean fetchChangePath) throws SVNClientException {
        return this.getLogMessages(file, revStart, revEnd, stopOnCopy, fetchChangePath, 0L);
    }

    @Override
    public ISVNLogMessage[] getLogMessages(VCSFileProxy file, SVNRevision revStart, SVNRevision revEnd, boolean stopOnCopy, boolean fetchChangePath, long limit) throws SVNClientException {
        return this.getLogMessages(file, SVNRevision.HEAD, revStart, revEnd, stopOnCopy, fetchChangePath, limit, false);
    }

    @Override
    public ISVNLogMessage[] getLogMessages(VCSFileProxy file, SVNRevision pegRevision, SVNRevision revStart, SVNRevision revEnd, boolean stopOnCopy, boolean fetchChangePath, long limit, boolean includeMergedRevisions) throws SVNClientException {
        ISVNInfo info = this.getInfoFromWorkingCopy(file);
        LogCommand logCmd = info.getSchedule().equals((Object)SVNScheduleKind.ADD) && info.getCopyUrl() != null ? new LogCommand(this.fileSystem, info.getCopyUrl(), null, revStart, revEnd, pegRevision, stopOnCopy, fetchChangePath, limit) : new LogCommand(this.fileSystem, file, revStart, revEnd, pegRevision, stopOnCopy, fetchChangePath, limit);
        return this.getLog(logCmd);
    }

    private ISVNLogMessage[] getLog(LogCommand cmd) throws SVNClientException {
        this.exec(cmd);
        return cmd.getLogMessages();
    }

    @Override
    public InputStream getContent(SVNUrl url, SVNRevision rev) throws SVNClientException {
        return this.getContent(url, rev, null);
    }

    @Override
    public InputStream getContent(VCSFileProxy file, SVNRevision rev) throws SVNClientException {
        CatCommand cmd = new CatCommand(this.fileSystem, file, rev);
        this.exec(cmd);
        return cmd.getOutput();
    }

    @Override
    public void propertySet(VCSFileProxy file, String name, String value, boolean rec) throws SVNClientException {
        ISVNStatus[] oldStatus = this.getStatus(file, rec, true);
        PropertySetCommand cmd = new PropertySetCommand(this.fileSystem, name, value, file, rec);
        this.exec(cmd);
        this.notifyChangedStatus(file, rec, oldStatus);
    }

    @Override
    public void propertySet(VCSFileProxy file, String name, VCSFileProxy propFile, boolean rec) throws SVNClientException, IOException {
        ISVNStatus[] oldStatus = this.getStatus(file, rec, true);
        PropertySetCommand cmd = new PropertySetCommand(this.fileSystem, name, propFile, file, rec);
        this.exec(cmd);
        this.notifyChangedStatus(file, rec, oldStatus);
    }

    @Override
    public void propertyDel(VCSFileProxy file, String name, boolean rec) throws SVNClientException {
        ISVNStatus[] oldStatus = this.getStatus(file, rec, true);
        PropertyDelCommand cmd = new PropertyDelCommand(this.fileSystem, file, name, rec);
        this.exec(cmd);
        this.notifyChangedStatus(file, rec, oldStatus);
    }

    @Override
    public ISVNProperty propertyGet(VCSFileProxy file, String name) throws SVNClientException {
        return this.propertyGet(new PropertyGetCommand(this.fileSystem, file, name), name, null, file);
    }

    @Override
    public ISVNProperty propertyGet(SVNUrl url, String name) throws SVNClientException {
        return this.propertyGet(url, SVNRevision.HEAD, SVNRevision.HEAD, name);
    }

    @Override
    public ISVNProperty propertyGet(SVNUrl url, SVNRevision rev, SVNRevision peg, String name) throws SVNClientException {
        return this.propertyGet(new PropertyGetCommand(this.fileSystem, url, rev, peg, name), name, url, null);
    }

    ISVNProperty propertyGet(PropertyGetCommand cmd, final String name, final SVNUrl url, final VCSFileProxy file) throws SVNClientException {
        this.exec(cmd);
        final byte[] bytes = cmd.getOutput();
        if (bytes.length == 0) {
            return null;
        }
        return new ISVNProperty(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            @SuppressWarnings(value={"Dm"})
            public String getValue() {
                try {
                    return new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    return new String(bytes);
                }
            }

            @Override
            public VCSFileProxy getFile() {
                return file;
            }

            @Override
            public SVNUrl getUrl() {
                return url;
            }

            @Override
            public byte[] getData() {
                return bytes;
            }
        };
    }

    @Override
    public List<String> getIgnoredPatterns(VCSFileProxy file) throws SVNClientException {
        if (!file.isDirectory()) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>();
        for (ISVNProperty property : this.getProperties(file)) {
            if (!"svn:ignore".equals(property.getName())) continue;
            String value = property.getValue();
            for (String s : value.split("\n")) {
                if (s.isEmpty()) continue;
                res.add(s);
            }
        }
        return res;
    }

    @Override
    public void addToIgnoredPatterns(VCSFileProxy file, String value) throws SVNClientException {
        List<String> ignoredPatterns = this.getIgnoredPatterns(file);
        if (ignoredPatterns == null) {
            return;
        }
        if (!ignoredPatterns.contains(value)) {
            ignoredPatterns.add(value);
            this.setIgnoredPatterns(file, ignoredPatterns);
        }
    }

    @Override
    public void setIgnoredPatterns(VCSFileProxy file, List<String> l) throws SVNClientException {
        if (!file.isDirectory()) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        for (String s : l) {
            buf.append(s);
            buf.append('\n');
        }
        this.propertySet(file, "svn:ignore", buf.toString(), false);
    }

    @Override
    public ISVNAnnotations annotate(VCSFileProxy file, SVNRevision revStart, SVNRevision revEnd) throws SVNClientException {
        ISVNInfo info = this.getInfoFromWorkingCopy(file);
        BlameCommand blameCommand = info.getSchedule().equals((Object)SVNScheduleKind.ADD) && info.getCopyUrl() != null ? new BlameCommand(this.fileSystem, info.getCopyUrl(), revStart, revEnd) : new BlameCommand(this.fileSystem, file, revStart, revEnd);
        return this.annotate(file, blameCommand, new CatCommand(this.fileSystem, file, revEnd));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISVNAnnotations annotate(VCSFileProxy file, BlameCommand blameCmd, CatCommand catCmd) throws SVNClientException {
        this.exec(blameCmd);
        Annotations.Annotation[] annotations = blameCmd.getAnnotation();
        this.exec(catCmd);
        InputStream is = catCmd.getOutput();
        FileObject fo = file.toFileObject();
        Charset encoding = null;
        if (fo != null) {
            encoding = FileEncodingQuery.getEncoding((FileObject)fo);
        }
        if (encoding == null) {
            encoding = FileEncodingQuery.getDefaultEncoding();
        }
        Annotations ret = new Annotations();
        BufferedReader r = new BufferedReader(new InputStreamReader(is, encoding));
        try {
            for (Annotations.Annotation annotation : annotations) {
                String line = null;
                try {
                    line = r.readLine();
                }
                catch (IOException ex) {
                    Subversion.LOG.log(Level.INFO, ex.getMessage(), ex);
                }
                annotation.setLine(line);
                ret.addAnnotation(annotation);
            }
        }
        finally {
            try {
                r.close();
            }
            catch (IOException e) {}
        }
        return ret;
    }

    @Override
    public ISVNProperty[] getProperties(final VCSFileProxy file) throws SVNClientException {
        ListPropertiesCommand cmd = new ListPropertiesCommand(this.fileSystem, file, false);
        this.exec(cmd);
        List<String> names = cmd.getPropertyNames();
        ArrayList<ISVNProperty> props = new ArrayList<ISVNProperty>(names.size());
        for (final String name : names) {
            ISVNProperty prop = this.propertyGet(file, name);
            if (prop == null) {
                props.add(new ISVNProperty(){

                    @Override
                    public String getName() {
                        return name;
                    }

                    @Override
                    public String getValue() {
                        return "";
                    }

                    @Override
                    public VCSFileProxy getFile() {
                        return file;
                    }

                    @Override
                    public SVNUrl getUrl() {
                        return null;
                    }

                    @Override
                    public byte[] getData() {
                        return new byte[0];
                    }
                });
                continue;
            }
            props.add(prop);
        }
        return props.toArray(new ISVNProperty[props.size()]);
    }

    @Override
    public ISVNProperty[] getProperties(SVNUrl url) throws SVNClientException {
        ListPropertiesCommand cmd = new ListPropertiesCommand(this.fileSystem, url, false);
        this.exec(cmd);
        List<String> names = cmd.getPropertyNames();
        ArrayList<ISVNProperty> props = new ArrayList<ISVNProperty>(names.size());
        for (String name : names) {
            ISVNProperty prop = this.propertyGet(url, name);
            if (prop == null) continue;
            props.add(prop);
        }
        return props.toArray(new ISVNProperty[props.size()]);
    }

    @Override
    public void resolved(VCSFileProxy file) throws SVNClientException {
        ResolvedCommand cmd = new ResolvedCommand(this.fileSystem, file, false);
        this.exec(cmd);
    }

    @Override
    public void cancelOperation() throws SVNClientException {
        this.cli.interrupt();
    }

    @Override
    public void switchToUrl(VCSFileProxy file, SVNUrl url, SVNRevision rev, boolean rec) throws SVNClientException {
        SwitchToCommand cmd = new SwitchToCommand(this.fileSystem, file, url, rev, rec);
        this.exec(cmd);
    }

    @Override
    public void merge(SVNUrl startUrl, SVNRevision startRev, SVNUrl endUrl, SVNRevision endRev, VCSFileProxy file, boolean force, boolean recurse) throws SVNClientException {
        this.merge(startUrl, startRev, endUrl, endRev, file, force, recurse, false);
    }

    @Override
    public void merge(SVNUrl startUrl, SVNRevision startRev, SVNUrl endUrl, SVNRevision endRev, VCSFileProxy file, boolean force, boolean recurse, boolean dryRun) throws SVNClientException {
        this.merge(startUrl, startRev, endUrl, endRev, file, force, recurse, dryRun, false);
    }

    @Override
    public void merge(SVNUrl startUrl, SVNRevision startRev, SVNUrl endUrl, SVNRevision endRev, VCSFileProxy file, boolean force, boolean recurse, boolean dryRun, boolean ignoreAncestry) throws SVNClientException {
        MergeCommand cmd = new MergeCommand(this.fileSystem, startUrl, endUrl, startRev, endRev, file, recurse, force, ignoreAncestry, dryRun);
        this.exec(cmd);
        this.refresh(file);
    }

    @Override
    public void relocate(Context context, String from, String to, String path, boolean rec) throws SVNClientException {
        RelocateCommand cmd = new RelocateCommand(this.fileSystem, null, from, to, path, rec);
        this.exec(cmd);
    }

    @Override
    public ISVNStatus getSingleStatus(VCSFileProxy file) throws SVNClientException {
        block6: {
            if (SvnClientFactory.getInstance(new Context(file)).isCLIOldFormat()) {
                try {
                    return this.wcParser.getSingleStatus(file);
                }
                catch (LocalSubversionException ex) {
                    if (ex.getCause() != null && "WC1_7Format".equals(ex.getCause().getMessage())) break block6;
                    throw new SVNClientException(ex);
                }
            }
        }
        try {
            ISVNStatus[] statuses = this.getStatus(new VCSFileProxy[]{file});
            return statuses.length > 0 ? statuses[0] : new ParserSvnStatus(file, null, 0L, "unknown", SVNStatusKind.UNVERSIONED, SVNStatusKind.UNVERSIONED, null, 0L, null, false, null, null, null, null, null, null, null, false, null);
        }
        catch (SVNClientException ex) {
            if (SvnClientExceptionHandler.isUnversionedResource(ex.getMessage()) || SvnClientExceptionHandler.isNodeNotFound(ex.getMessage())) {
                return new SVNStatusUnversioned(file);
            }
            throw ex;
        }
    }

    @Override
    public ISVNStatus[] getStatus(VCSFileProxy file, boolean descend, boolean getAll) throws SVNClientException {
        block3: {
            if (SvnClientFactory.getInstance(new Context(file)).isCLIOldFormat()) {
                try {
                    return this.wcParser.getStatus(file, descend, getAll);
                }
                catch (LocalSubversionException ex) {
                    if (ex.getCause() != null && "WC1_7Format".equals(ex.getCause().getMessage())) break block3;
                    throw new SVNClientException(ex);
                }
            }
        }
        return this.getStatus(file, descend, getAll, false, true);
    }

    @Override
    public ISVNInfo getInfoFromWorkingCopy(VCSFileProxy file) throws SVNClientException {
        block6: {
            if (SvnClientFactory.getInstance(new Context(file)).isCLIOldFormat()) {
                try {
                    return this.wcParser.getInfoFromWorkingCopy(file);
                }
                catch (LocalSubversionException ex) {
                    if (ex.getCause() != null && "WC1_7Format".equals(ex.getCause().getMessage())) break block6;
                    throw new SVNClientException(ex);
                }
            }
        }
        try {
            ISVNInfo[] infos = this.getInfo(new VCSFileProxy[]{file}, null, null);
            return infos.length > 0 ? infos[0] : null;
        }
        catch (SVNClientException ex) {
            if (SvnClientExceptionHandler.isNodeNotFound(ex.getMessage())) {
                return this.wcParser.getUnknownInfo(file);
            }
            throw ex;
        }
    }

    private void exec(SvnCommand cmd) throws SVNClientException {
        try {
            this.config(cmd);
            this.cli.exec(cmd);
        }
        catch (IOException ex) {
            if (Subversion.LOG.isLoggable(Level.FINE)) {
                Subversion.LOG.log(Level.FINE, null, ex);
            }
            throw new SVNClientException(ex);
        }
        this.checkErrors(cmd);
    }

    private void config(SvnCommand cmd) {
        cmd.setNotificationHandler(this.notificationHandler);
        cmd.setConfigDir(this.configDir);
        cmd.setUsername(this.user);
        cmd.setPassword(this.psswd);
    }

    private void checkErrors(SvnCommand cmd) throws SVNClientException {
        List<String> errors = cmd.getCmdError();
        if (errors == null || errors.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < errors.size(); ++i) {
            sb.append(errors.get(i));
            if (i >= errors.size() - 1) continue;
            sb.append('\n');
        }
        throw new SVNClientException(sb.toString());
    }

    private boolean isManaged(SVNStatusKind s) {
        return !s.equals((Object)SVNStatusKind.UNVERSIONED) && !s.equals((Object)SVNStatusKind.NONE) && !s.equals((Object)SVNStatusKind.IGNORED) && !s.equals((Object)SVNStatusKind.EXTERNAL);
    }

    private boolean hasMetadata(VCSFileProxy file) {
        return SvnUtils.hasMetadata(file);
    }

    private boolean isManaged(VCSFileProxy file) {
        boolean managed = true;
        if (SvnClientFactory.getInstance(new Context(file)).isCLIOldFormat()) {
            managed = this.hasMetadata(file.getParentFile()) || this.hasMetadata(file);
        }
        return managed;
    }

    @Override
    public void cleanup(VCSFileProxy file) throws SVNClientException {
        CleanupCommand cmd = new CleanupCommand(this.fileSystem, file);
        this.exec(cmd);
        this.refresh(file);
    }

    private void notifyChangedStatus(VCSFileProxy file, boolean rec, ISVNStatus[] oldStatuses) throws SVNClientException {
        ISVNStatus[] newStatuses;
        HashMap<VCSFileProxy, ISVNStatus> oldStatusMap = new HashMap<VCSFileProxy, ISVNStatus>();
        for (ISVNStatus s : oldStatuses) {
            oldStatusMap.put(s.getFile(), s);
        }
        for (ISVNStatus newStatus : newStatuses = this.getStatus(file, rec, true)) {
            ISVNStatus oldStatus = (ISVNStatus)oldStatusMap.get(newStatus.getFile());
            if ((oldStatus != null || newStatus == null) && oldStatus.getTextStatus() == newStatus.getTextStatus() && oldStatus.getPropStatus() == newStatus.getPropStatus()) continue;
            this.notificationHandler.notifyListenersOfChange(newStatus.getFile());
        }
    }

    @Override
    public ISVNDirEntryWithLock[] getListWithLocks(SVNUrl svnurl, SVNRevision svnr, SVNRevision svnr1, boolean bln) throws SVNClientException {
        return new ISVNDirEntryWithLock[0];
    }

    @Override
    public ISVNProperty[] getProperties(SVNUrl url, SVNRevision revision, SVNRevision pegRevision) throws SVNClientException {
        return this.getProperties(url, revision, pegRevision, false);
    }

    @Override
    public ISVNProperty[] getProperties(SVNUrl url, SVNRevision revision, SVNRevision pegRevision, boolean recursive) throws SVNClientException {
        ListPropertiesCommand cmd = new ListPropertiesCommand(this.fileSystem, url, revision.toString(), recursive);
        this.exec(cmd);
        List<String> names = cmd.getPropertyNames();
        ArrayList<ISVNProperty> props = new ArrayList<ISVNProperty>(names.size());
        for (String name : names) {
            ISVNProperty prop = this.propertyGet(url, name);
            if (prop == null) continue;
            props.add(prop);
        }
        return props.toArray(new ISVNProperty[props.size()]);
    }

    @Override
    public void upgrade(VCSFileProxy wcRoot) throws SVNClientException {
        UpgradeCommand cmd = new UpgradeCommand(this.fileSystem, wcRoot);
        this.exec(cmd);
    }

    @Override
    public void unlock(VCSFileProxy[] vcsFileProxy, boolean b) throws SVNClientException {
        UnlockCommand cmd = new UnlockCommand(this.fileSystem, vcsFileProxy);
        this.exec(cmd);
    }

    @Override
    public void lock(VCSFileProxy[] vcsFileProxy, String string, boolean b) throws SVNClientException {
        LockCommand cmd = new LockCommand(this.fileSystem, vcsFileProxy);
        this.exec(cmd);
    }

    public boolean cancel() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SVNUrl getSvnUrl() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copy(VCSFileProxy[] files, SVNUrl targetUrl, String message, boolean addAsChild, boolean makeParents) throws SVNClientException {
        for (VCSFileProxy file : files) {
            CopyCommand cmd = new CopyCommand(this.fileSystem, file, targetUrl, message, makeParents);
            this.exec(cmd);
        }
    }

    @Override
    public void copy(SVNUrl fromUrl, SVNUrl toUrl, String msg, SVNRevision rev, boolean makeParents) throws SVNClientException {
        CopyCommand cmd = new CopyCommand(this.fileSystem, fromUrl, toUrl, msg, rev, makeParents);
        this.exec(cmd);
    }

    @Override
    public InputStream getContent(SVNUrl url, SVNRevision rev, SVNRevision pegRevision) throws SVNClientException {
        CatCommand cmd = new CatCommand(this.fileSystem, url, rev, pegRevision);
        this.exec(cmd);
        return cmd.getOutput();
    }

    @Override
    public void mergeReintegrate(SVNUrl arg0, SVNRevision arg1, VCSFileProxy arg2, boolean arg3, boolean arg4) throws SVNClientException {
        throw new SVNClientException(SvnModuleConfig.getDefault(this.fileSystem).isForcedCommandlineClient() ? Bundle.MSG_Error_reintegrateBranchWithCLI_CLIforced() : Bundle.MSG_Error_reintegrateBranchWithCLI());
    }

    @Override
    public SVNDiffSummary[] diffSummarize(SVNUrl arg0, SVNRevision arg1, SVNUrl arg2, SVNRevision arg3, Depth arg4, boolean arg5) throws SVNClientException {
        throw new SVNClientException(SvnModuleConfig.getDefault(this.fileSystem).isForcedCommandlineClient() ? Bundle.MSG_Error_diffSummaryWithCLI_CLIforced() : Bundle.MSG_Error_diffSummaryWithCLI());
    }

    @Override
    public void dispose() {
    }

    private void refresh(VCSFileProxy ... files) {
        try {
            RemoteVcsSupport.refreshFor((VCSFileProxy[])files);
        }
        catch (IOException ex) {
            Subversion.LOG.log(Level.INFO, "error when refreshing: {0}", ex.getLocalizedMessage());
        }
    }

    private void refreshParents(VCSFileProxy ... files) {
        VCSFileProxy[] parents = new VCSFileProxy[files.length];
        for (int i = 0; i < files.length; ++i) {
            parents[i] = files[i].getParentFile();
            if (parents[i] != null) continue;
            parents[i] = files[i];
        }
        this.refresh(parents);
    }

    static class NotificationHandler
    extends SVNNotificationHandler {
        NotificationHandler() {
        }
    }
}

