/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.config;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ini4j.Config;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.SvnModuleConfig;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.ui.repository.RepositoryConnection;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.util.KeyringSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.NetworkSettings;

public class SvnConfigFiles {
    public static final boolean USE_LOCAL_PROXY_SETTINGS = "true".equals(System.getProperty("remote.subversion.manage.proxy", "false"));
    public static final boolean COPY_CONFIG_FILES = "true".equals(System.getProperty("remote.subversion.manage.config", "false"));
    private static final Map<FileSystem, SvnConfigFiles> instances = new HashMap<FileSystem, SvnConfigFiles>();
    private Ini svnServers = null;
    private Ini config = null;
    private static final String UNIX_CONFIG_DIR = ".subversion/";
    private static final String GROUPS_SECTION = "groups";
    private static final String GLOBAL_SECTION = "global";
    private static final List<String> DEFAULT_GLOBAL_IGNORES = SvnConfigFiles.parseGlobalIgnores("*.o *.lo *.la #*# .*.rej *.rej .*~ *~ .#* .DS_Store");
    private static final boolean DO_NOT_SAVE_PASSPHRASE = Boolean.getBoolean("versioning.subversion.noPassphraseInConfig");
    private String recentUrl;
    private final FileSystem fileSystem;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SvnConfigFiles(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(Subversion.class.getClassLoader());
        try {
            Config.getGlobal().setEscape(false);
            this.config = this.copyConfigFileToIDEConfigDir("config", new ConfigIniFilePatcher());
            this.svnServers = this.loadSystemIniFile("servers");
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public static synchronized SvnConfigFiles getInstance(FileSystem fileSystem) {
        SvnConfigFiles res;
        String t9yUserConfigPath = System.getProperty("netbeans.t9y.svn.user.config.path");
        if (t9yUserConfigPath != null && t9yUserConfigPath.length() > 0) {
            instances.clear();
        }
        if ((res = instances.get(fileSystem)) == null) {
            res = new SvnConfigFiles(fileSystem);
            instances.put(fileSystem, res);
        }
        return res;
    }

    public void reset() {
        this.recentUrl = null;
    }

    public VCSFileProxy storeSvnServersSettings(SVNUrl url) {
        assert (url != null) : "can't do anything for a null host";
        VCSFileProxy sensitiveConfigFile = null;
        if (!(url.getProtocol().startsWith("http") || url.getProtocol().startsWith("https") || url.getProtocol().startsWith("svn+"))) {
            return sensitiveConfigFile;
        }
        if (!COPY_CONFIG_FILES) {
            return null;
        }
        boolean changes = false;
        Ini nbServers = new Ini();
        Profile.Section nbGlobalSection = nbServers.add(GLOBAL_SECTION);
        String repositoryUrl = url.toString();
        boolean bl = changes = !repositoryUrl.equals(this.recentUrl);
        if (changes) {
            RepositoryConnection rc = SvnModuleConfig.getDefault(this.fileSystem).getRepositoryConnection(repositoryUrl);
            if (rc != null && url.getProtocol().startsWith("svn+")) {
                this.setExternalCommand(SvnUtils.getTunnelName(url.getProtocol()), rc.getExternalCommand());
            }
            boolean hasPassphrase = false;
            if (url.getProtocol().startsWith("https")) {
                hasPassphrase = this.setSSLCert(rc, nbGlobalSection);
            }
            hasPassphrase = this.setProxy(url, nbGlobalSection) | hasPassphrase;
            VCSFileProxy configFile = this.storeIni(nbServers, "servers");
            this.recentUrl = url.toString();
            if (hasPassphrase) {
                sensitiveConfigFile = configFile;
                this.recentUrl = null;
            }
        }
        return sensitiveConfigFile;
    }

    private boolean setSSLCert(RepositoryConnection rc, Profile.Section nbGlobalSection) {
        String certPassword;
        if (rc == null) {
            return false;
        }
        String certFile = rc.getCertFile();
        if (certFile.isEmpty()) {
            return false;
        }
        char[] certPasswordChars = rc.getCertPassword();
        String string = certPassword = certPasswordChars == null ? "" : new String(certPasswordChars);
        if (certPassword.equals("")) {
            return false;
        }
        nbGlobalSection.put((Object)"ssl-client-cert-file", (Object)certFile);
        if (!DO_NOT_SAVE_PASSPHRASE) {
            nbGlobalSection.put((Object)"ssl-client-cert-password", (Object)certPassword);
            return true;
        }
        return false;
    }

    private boolean setProxy(SVNUrl url, Profile.Section nbGlobalSection) {
        String host = SvnUtils.ripUserFromHost(url.getHost());
        Profile.Section svnGlobalSection = (Profile.Section)this.svnServers.get((Object)GLOBAL_SECTION);
        URI uri = null;
        boolean passwordAdded = false;
        try {
            uri = new URI(url.toString());
        }
        catch (URISyntaxException ex) {
            Subversion.LOG.log(Level.INFO, null, ex);
            return passwordAdded;
        }
        if (USE_LOCAL_PROXY_SETTINGS) {
            String proxyHost = NetworkSettings.getProxyHost((URI)uri);
            if (proxyHost != null && proxyHost.length() > 0) {
                String proxyPort = NetworkSettings.getProxyPort((URI)uri);
                assert (proxyPort != null);
                nbGlobalSection.put((Object)"http-proxy-host", (Object)proxyHost);
                nbGlobalSection.put((Object)"http-proxy-port", (Object)proxyPort);
                String username = NetworkSettings.getAuthenticationUsername((URI)uri);
                if (username != null) {
                    String password = this.getProxyPassword(NetworkSettings.getKeyForAuthenticationPassword((URI)uri));
                    nbGlobalSection.put((Object)"http-proxy-username", (Object)username);
                    nbGlobalSection.put((Object)"http-proxy-password", (Object)password);
                    passwordAdded = true;
                }
            }
            this.mergeNonProxyKeys(host, svnGlobalSection, nbGlobalSection);
        } else {
            this.mergeAllKeys(host, svnGlobalSection, nbGlobalSection);
        }
        return passwordAdded;
    }

    private void mergeNonProxyKeys(String host, Profile.Section svnGlobalSection, Profile.Section nbGlobalSection) {
        Profile.Section svnHostGroup;
        if (svnGlobalSection != null) {
            this.mergeNonProxyKeys(svnGlobalSection, nbGlobalSection);
        }
        if ((svnHostGroup = this.getServerGroup(host)) != null) {
            this.mergeNonProxyKeys(svnHostGroup, nbGlobalSection);
        }
    }

    private void mergeNonProxyKeys(Profile.Section source, Profile.Section target) {
        for (String key : source.keySet()) {
            if (this.isProxyConfigurationKey(key)) continue;
            target.put((Object)key, source.get((Object)key));
        }
    }

    private void mergeAllKeys(String host, Profile.Section svnGlobalSection, Profile.Section nbGlobalSection) {
        Profile.Section svnHostGroup;
        if (svnGlobalSection != null) {
            this.mergeAllKeys(svnGlobalSection, nbGlobalSection);
        }
        if ((svnHostGroup = this.getServerGroup(host)) != null) {
            this.mergeAllKeys(svnHostGroup, nbGlobalSection);
        }
    }

    private void mergeAllKeys(Profile.Section source, Profile.Section target) {
        for (String key : source.keySet()) {
            target.put((Object)key, source.get((Object)key));
        }
    }

    public void setExternalCommand(String tunnelName, String command) {
        if (command == null) {
            return;
        }
        if (COPY_CONFIG_FILES) {
            Profile.Section tunnels = this.getSection(this.config, "tunnels", true);
            tunnels.put((Object)tunnelName, (Object)command);
            this.storeIni(this.config, "config");
        }
    }

    public String getExternalCommand(String tunnelName) {
        Profile.Section tunnels = this.getSection(this.config, "tunnels", true);
        String cmd = (String)tunnels.get((Object)tunnelName);
        return cmd != null ? cmd : "";
    }

    private Profile.Section getSection(Ini ini, String key, boolean create) {
        Profile.Section section = (Profile.Section)ini.get((Object)key);
        if (section == null) {
            return ini.add(key);
        }
        return section;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VCSFileProxy storeIni(Ini ini, String iniFile) {
        if (!COPY_CONFIG_FILES) {
            return null;
        }
        FilterOutputStream bos = null;
        VCSFileProxy file = null;
        try {
            file = VCSFileProxy.createFileProxy((VCSFileProxy)SvnConfigFiles.getNBConfigPath(this.fileSystem), (String)iniFile);
            FileObject fo = file.toFileObject();
            if (fo == null) {
                VCSFileProxySupport.mkdirs((VCSFileProxy)file.getParentFile());
                fo = file.getParentFile().toFileObject().createData(file.getName());
            }
            bos = new BufferedOutputStream(fo.getOutputStream());
            ini.store((OutputStream)bos);
        }
        catch (IOException ex) {
            Subversion.LOG.log(Level.INFO, null, ex);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException ex) {
                    Subversion.LOG.log(Level.INFO, null, ex);
                }
            }
        }
        return file;
    }

    public List<String> getGlobalIgnores() {
        String ignores;
        Profile.Section miscellany = (Profile.Section)this.config.get((Object)"miscellany");
        if (miscellany != null && (ignores = (String)miscellany.get((Object)"global-ignores")) != null && ignores.trim().length() > 0) {
            return SvnConfigFiles.parseGlobalIgnores(ignores);
        }
        return DEFAULT_GLOBAL_IGNORES;
    }

    public String getClientCertFile(String host) {
        return this.getMergeValue("ssl-client-cert-file", host);
    }

    public String getClientCertPassword(String host) {
        return this.getMergeValue("ssl-client-cert-password", host);
    }

    private String getMergeValue(String key, String host) {
        Profile.Section group = this.getServerGroup(host);
        if (group != null) {
            return (String)group.get((Object)key);
        }
        group = (Profile.Section)this.svnServers.get((Object)GLOBAL_SECTION);
        if (group != null) {
            return (String)group.get((Object)key);
        }
        return null;
    }

    private static List<String> parseGlobalIgnores(String ignores) {
        StringTokenizer st = new StringTokenizer(ignores, " ");
        ArrayList<String> ret = new ArrayList<String>(10);
        while (st.hasMoreTokens()) {
            String entry = st.nextToken();
            if (entry.equals("")) continue;
            ret.add(entry);
        }
        return ret;
    }

    public static VCSFileProxy getUserConfigPath(FileSystem fileSystem) {
        VCSFileProxy root = VCSFileProxy.createFileProxy((FileObject)fileSystem.getRoot());
        String t9yUserConfigPath = System.getProperty("netbeans.t9y.svn.user.config.path");
        if (t9yUserConfigPath != null && t9yUserConfigPath.length() > 0) {
            return VCSFileProxySupport.getResource((FileSystem)fileSystem, (String)t9yUserConfigPath);
        }
        VCSFileProxy home = VCSFileProxySupport.getHome((VCSFileProxy)root);
        return VCSFileProxy.createFileProxy((VCSFileProxy)home, (String)UNIX_CONFIG_DIR);
    }

    public static VCSFileProxy getNBConfigPath(FileSystem fileSystem) throws IOException {
        if (!COPY_CONFIG_FILES) {
            return null;
        }
        String t9yNbConfigPath = System.getProperty("netbeans.t9y.svn.nb.config.path");
        if (t9yNbConfigPath != null && t9yNbConfigPath.length() > 0) {
            return VCSFileProxySupport.getResource((FileSystem)fileSystem, (String)t9yNbConfigPath);
        }
        return VCSFileProxySupport.getRemotePeristenceFolder((FileSystem)fileSystem);
    }

    private Profile.Section getServerGroup(String host) {
        if (host == null || host.equals("")) {
            return null;
        }
        Profile.Section groups = (Profile.Section)this.svnServers.get((Object)GROUPS_SECTION);
        if (groups != null) {
            for (String key : groups.keySet()) {
                String value = (String)groups.get((Object)key);
                if (value == null || !this.match(value = value.trim(), host)) continue;
                return (Profile.Section)this.svnServers.get((Object)key);
            }
        }
        return null;
    }

    private boolean match(String value, String host) {
        String[] values = value.split(",");
        for (int i = 0; i < values.length; ++i) {
            value = values[i].trim();
            if (value.equals("*") || value.equals(host)) {
                return true;
            }
            int idx = value.indexOf(42);
            if (idx <= -1 || !this.matchSegments(value, host)) continue;
            return true;
        }
        return false;
    }

    private boolean matchSegments(String value, String host) {
        value = value.replace(".", "\\.");
        value = value.replace("*", ".*");
        Matcher m = Pattern.compile(value).matcher(host);
        return m.matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Ini copyConfigFileToIDEConfigDir(String fileName, IniFilePatcher patcher) {
        Ini systemIniFile = this.loadSystemIniFile(fileName);
        if (COPY_CONFIG_FILES) {
            patcher.patch(systemIniFile);
            FilterOutputStream bos = null;
            try {
                VCSFileProxy file = VCSFileProxy.createFileProxy((VCSFileProxy)SvnConfigFiles.getNBConfigPath(this.fileSystem), (String)fileName);
                VCSFileProxySupport.mkdirs((VCSFileProxy)file.getParentFile());
                FileObject fo = file.toFileObject();
                if (fo == null || !fo.isValid()) {
                    fo = file.getParentFile().toFileObject().createData(file.getName());
                }
                bos = new BufferedOutputStream(fo.getOutputStream());
                systemIniFile.store((OutputStream)bos);
            }
            catch (IOException ex) {
                Subversion.LOG.log(Level.INFO, null, ex);
            }
            finally {
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException ex) {
                        Subversion.LOG.log(Level.INFO, null, ex);
                    }
                }
            }
        }
        return systemIniFile;
    }

    private Ini loadSystemIniFile(String fileName) {
        VCSFileProxy file = VCSFileProxy.createFileProxy((VCSFileProxy)SvnConfigFiles.getUserConfigPath(this.fileSystem), (String)fileName);
        file = file.normalizeFile();
        Ini system = null;
        try {
            system = new Ini((Reader)new InputStreamReader(file.getInputStream(false), "UTF-8"));
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException ex) {
            Subversion.LOG.log(Level.INFO, null, ex);
        }
        catch (Exception ex) {
            Subversion.LOG.log(Level.INFO, "exception in Ini4j, system file not loaded: " + file.getPath(), ex);
        }
        if (system == null) {
            system = new Ini();
            Subversion.LOG.warning("Could not load the file " + file.getPath() + ". Falling back on svn defaults.");
        }
        file = VCSFileProxy.createFileProxy((VCSFileProxy)SvnConfigFiles.getGlobalConfigPath(this.fileSystem), (String)fileName);
        Ini global = null;
        try {
            global = new Ini((Reader)new InputStreamReader(file.getInputStream(false), "UTF-8"));
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException ex) {
            Subversion.LOG.log(Level.INFO, null, ex);
        }
        catch (Exception ex) {
            Subversion.LOG.log(Level.INFO, "exception in Ini4j, global file not loaded: " + file.getPath(), ex);
        }
        if (global != null) {
            this.merge(global, system);
        }
        return system;
    }

    private void merge(Ini source, Ini target) {
        for (String sectionName : source.keySet()) {
            Profile.Section sourceSection = (Profile.Section)source.get((Object)sectionName);
            Profile.Section targetSection = (Profile.Section)target.get((Object)sectionName);
            if (targetSection == null) {
                targetSection = target.add(sectionName);
            }
            for (String key : sourceSection.keySet()) {
                if (targetSection.containsKey((Object)key)) continue;
                targetSection.put((Object)key, sourceSection.get((Object)key));
            }
        }
    }

    private boolean isProxyConfigurationKey(String key) {
        return key.equals("http-proxy-host") || key.equals("http-proxy-port") || key.equals("http-proxy-username") || key.equals("http-proxy-password") || key.equals("http-proxy-exceptions");
    }

    private static VCSFileProxy getGlobalConfigPath(FileSystem fileSystem) {
        return VCSFileProxySupport.getResource((FileSystem)fileSystem, (String)"/etc/subversion");
    }

    private String getProxyPassword(String key) {
        char[] pwd = KeyringSupport.read((String)"", (String)key);
        return pwd == null ? "" : new String(pwd);
    }

    private static class ConfigIniFilePatcher
    implements IniFilePatcher {
        private ConfigIniFilePatcher() {
        }

        @Override
        public void patch(Ini file) {
            if (COPY_CONFIG_FILES) {
                Profile.Section auth = (Profile.Section)file.get((Object)"auth");
                if (auth == null) {
                    auth = file.add("auth");
                }
                auth.put((Object)"store-auth-creds", (Object)"yes");
                auth.put((Object)"store-passwords", (Object)"no");
                auth.put((Object)"password-stores", (Object)"");
            }
        }
    }

    private static interface IniFilePatcher {
        public void patch(Ini var1);
    }
}

