/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.options;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.Annotator;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.SvnModuleConfig;
import org.netbeans.modules.subversion.remote.client.SvnProgressSupport;
import org.netbeans.modules.subversion.remote.options.AnnotationSettings;
import org.netbeans.modules.subversion.remote.options.LabelsPanel;
import org.netbeans.modules.subversion.remote.options.SvnOptionsPanel;
import org.netbeans.modules.subversion.remote.ui.repository.Repository;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.util.VCSOptionsKeywordsProvider;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class SvnOptionsController
extends OptionsPanelController
implements ItemListener,
ActionListener,
VCSOptionsKeywordsProvider {
    private final SvnOptionsPanel panel;
    private Repository repository;
    private final AnnotationSettings annotationSettings;
    private static final HashSet<String> allowedExecutables = new HashSet<String>(Arrays.asList("svn"));
    private FileSystem fileSystem;

    public SvnOptionsController() {
        FileSystem[] fileSystems = VCSFileProxySupport.getConnectedFileSystems();
        if (fileSystems.length > 0) {
            this.fileSystem = fileSystems[0];
        }
        this.annotationSettings = new AnnotationSettings(this.fileSystem);
        this.panel = new SvnOptionsPanel();
        this.panel.browseButton.addActionListener(this);
        this.panel.manageConnSettingsButton.addActionListener(this);
        this.panel.manageLabelsButton.addActionListener(this);
        String tooltip = NbBundle.getMessage(AnnotationSettings.class, (String)"AnnotationSettingsPanel.annotationTextField.toolTipText", (Object[])Annotator.LABELS.toArray(new String[Annotator.LABELS.size()]));
        this.panel.annotationTextField.setToolTipText(tooltip);
        this.panel.addButton.addActionListener(this);
        this.panel.cbBuildHost.addItemListener(this);
        this.panel.cbBuildHost.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof FileSystem) {
                    value = ((FileSystem)value).getDisplayName();
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        this.panel.cbBuildHost.setModel(new DefaultComboBoxModel<FileSystem>(fileSystems));
        this.panel.fileSystemChanged(this.fileSystem);
        this.panel.textPaneClient.addHyperlinkListener(new HyperlinkListener(){

            @Override
            @SuppressWarnings(value={"RCN"})
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                URL url = e.getURL();
                assert (url != null);
                HtmlBrowser.URLDisplayer displayer = HtmlBrowser.URLDisplayer.getDefault();
                assert (displayer != null) : "HtmlBrowser.URLDisplayer found.";
                if (displayer != null) {
                    displayer.showURL(url);
                } else {
                    Subversion.LOG.info("No URLDisplayer found.");
                }
            }
        });
    }

    public boolean acceptKeywords(List<String> keywords) {
        HashSet<String> allKeywords = new HashSet<String>(this.panel.getKeywords());
        allKeywords.retainAll(keywords);
        return !allKeywords.isEmpty();
    }

    private void createRepository() throws MissingResourceException {
        int repositoryModeMask = 20;
        String title = NbBundle.getMessage(SvnOptionsController.class, (String)"CTL_Repository_Location");
        this.repository = new Repository(this.fileSystem, repositoryModeMask, title);
    }

    public void update() {
        FileSystem[] fileSystems = VCSFileProxySupport.getConnectedFileSystems();
        this.fileSystem = fileSystems.length > 0 ? fileSystems[0] : null;
        this.panel.cbBuildHost.setModel(new DefaultComboBoxModel<FileSystem>(fileSystems));
        this.annotationSettings.update();
        if (this.fileSystem == null) {
            return;
        }
        this.panel.executablePathTextField.setText(SvnModuleConfig.getDefault(this.fileSystem).getExecutableBinaryPath());
        this.panel.annotationTextField.setText(SvnModuleConfig.getDefault(this.fileSystem).getAnnotationFormat());
        this.panel.cbOpenOutputWindow.setSelected(SvnModuleConfig.getDefault(this.fileSystem).getAutoOpenOutput());
        this.panel.cbGetRemoteLocks.setSelected(SvnModuleConfig.getDefault(this.fileSystem).isGetRemoteLocks());
        this.panel.cbAutoLockFiles.setSelected(SvnModuleConfig.getDefault(this.fileSystem).isAutoLock());
        if (this.repository != null) {
            this.repository.refreshUrlHistory();
        }
        this.panel.excludeNewFiles.setSelected(SvnModuleConfig.getDefault(this.fileSystem).getExludeNewFiles());
        this.panel.prefixRepositoryPath.setSelected(SvnModuleConfig.getDefault(this.fileSystem).isRepositoryPathPrefixed());
        this.panel.cbDetermineBranches.setSelected(SvnModuleConfig.getDefault(this.fileSystem).isDetermineBranchesEnabled());
    }

    public void applyChanges() {
        SvnModuleConfig.getDefault(this.fileSystem).setExecutableBinaryPath(this.panel.executablePathTextField.getText());
        SvnModuleConfig.getDefault(this.fileSystem).setPreferredFactoryType("commandline");
        SvnModuleConfig.getDefault(this.fileSystem).setAnnotationFormat(this.panel.annotationTextField.getText());
        SvnModuleConfig.getDefault(this.fileSystem).setAutoOpenOutputo(this.panel.cbOpenOutputWindow.isSelected());
        SvnModuleConfig.getDefault(this.fileSystem).setGetRemoteLocks(this.panel.cbGetRemoteLocks.isSelected());
        SvnModuleConfig.getDefault(this.fileSystem).setAutoLock(this.panel.cbAutoLockFiles.isSelected());
        SvnModuleConfig.getDefault(this.fileSystem).setExcludeNewFiles(this.panel.excludeNewFiles.isSelected());
        SvnModuleConfig.getDefault(this.fileSystem).setRepositoryPathPrefixed(this.panel.prefixRepositoryPath.isSelected());
        SvnModuleConfig.getDefault(this.fileSystem).setDetermineBranchesEnabled(this.panel.cbDetermineBranches.isSelected());
        this.annotationSettings.applyChanges();
        Subversion.getInstance().getAnnotator().refresh();
        Subversion.getInstance().refreshAllAnnotations();
        Subversion.getInstance().getStatusCache().getLabelsCache().flushFileLabels(null);
    }

    public void cancel() {
        if (this.repository != null) {
            this.repository.refreshUrlHistory();
        }
    }

    public boolean isValid() {
        return true;
    }

    public boolean isChanged() {
        return !this.panel.executablePathTextField.getText().equals(SvnModuleConfig.getDefault(this.fileSystem).getExecutableBinaryPath()) || !this.panel.annotationTextField.getText().equals(SvnModuleConfig.getDefault(this.fileSystem).getAnnotationFormat()) || this.panel.cbGetRemoteLocks.isSelected() != SvnModuleConfig.getDefault(this.fileSystem).isGetRemoteLocks() || this.repository != null && this.repository.isChanged() || this.annotationSettings.isChanged() || SvnModuleConfig.getDefault(this.fileSystem).getAutoOpenOutput() != this.panel.cbOpenOutputWindow.isSelected() || SvnModuleConfig.getDefault(this.fileSystem).isAutoLock() != this.panel.cbAutoLockFiles.isSelected() || SvnModuleConfig.getDefault(this.fileSystem).getExludeNewFiles() != this.panel.excludeNewFiles.isSelected() || SvnModuleConfig.getDefault(this.fileSystem).isDetermineBranchesEnabled() != this.panel.cbDetermineBranches.isSelected() || SvnModuleConfig.getDefault(this.fileSystem).isRepositoryPathPrefixed() != this.panel.prefixRepositoryPath.isSelected();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getClass());
    }

    public JComponent getComponent(Lookup masterLookup) {
        return this.panel;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
    }

    @Override
    public void itemStateChanged(ItemEvent ev) {
        Object item;
        if (ev.getStateChange() == 1 && (item = ev.getItem()) instanceof FileSystem) {
            this.fileSystem = (FileSystem)item;
            this.panel.fileSystemChanged(this.fileSystem);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.panel.browseButton) {
            this.onBrowseClick();
        } else if (evt.getSource() == this.panel.manageConnSettingsButton) {
            this.onManageConnClick();
        } else if (evt.getSource() == this.panel.manageLabelsButton) {
            this.onManageLabelsClick();
        } else if (evt.getSource() == this.panel.addButton) {
            this.onAddClick();
        }
    }

    private VCSFileProxy getExecutableFile() {
        if (this.fileSystem == null) {
            return null;
        }
        String execPath = this.panel.executablePathTextField.getText();
        if (execPath.isEmpty()) {
            return VCSFileProxy.createFileProxy((FileObject)this.fileSystem.getRoot());
        }
        return VCSFileProxySupport.getResource((FileSystem)this.fileSystem, (String)execPath);
    }

    private void onBrowseClick() {
        VCSFileProxy oldFile = this.getExecutableFile();
        this.onBrowse(oldFile, allowedExecutables, this.panel.executablePathTextField, NbBundle.getMessage(SvnOptionsController.class, (String)"ACSD_BrowseFolder"), NbBundle.getMessage(SvnOptionsController.class, (String)"Browse_title"), NbBundle.getMessage(SvnOptionsController.class, (String)"FileChooser.SvnExecutables.desc"));
    }

    private void onBrowse(VCSFileProxy oldFile, final Set<String> allowedFileNames, JTextField textField, String acsd, String browseTitle, final String fileTypeDesc) {
        VCSFileProxy f;
        if (oldFile == null) {
            return;
        }
        JFileChooser fileChooser = VCSFileProxySupport.createFileChooser((VCSFileProxy)oldFile);
        fileChooser.setDialogTitle(browseTitle);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileSelectionMode(2);
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || allowedFileNames.contains(f.getName());
            }

            @Override
            public String getDescription() {
                return fileTypeDesc;
            }
        });
        int showDialog = fileChooser.showDialog(this.panel, NbBundle.getMessage(SvnOptionsController.class, (String)"OK_Button"));
        if (showDialog == 0 && (f = VCSFileProxySupport.getSelectedFile((JFileChooser)fileChooser)) != null) {
            VCSFileProxy parent;
            while ((!f.exists() || f.isFile()) && (parent = f.getParentFile()) != null) {
                f = parent;
            }
            textField.setText(f.getPath());
        }
    }

    private void onManageConnClick() {
        this.fileSystem = (FileSystem)this.panel.cbBuildHost.getSelectedItem();
        if (this.fileSystem == null) {
            return;
        }
        if (this.repository == null) {
            this.panel.manageConnSettingsButton.setEnabled(false);
            new SvnProgressSupport(this.fileSystem){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void perform() {
                    try {
                        SvnOptionsController.this.createRepository();
                    }
                    catch (Throwable throwable) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((SvnOptionsController)SvnOptionsController.this).panel.manageConnSettingsButton.setEnabled(true);
                                if (SvnOptionsController.this.repository != null) {
                                    SvnOptionsController.this.onManageConnClick();
                                }
                            }
                        });
                        throw throwable;
                    }
                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            }.start(Subversion.getInstance().getParallelRequestProcessor(), null, NbBundle.getMessage(SvnOptionsController.class, (String)"MSG_ManageConnections.initializing"));
        } else {
            boolean ok = this.repository.show(NbBundle.getMessage(SvnOptionsController.class, (String)"CTL_ManageConnections"), new HelpCtx(Repository.class), true);
            if (ok) {
                this.repository.storeRecentUrls();
            } else {
                this.repository.refreshUrlHistory();
            }
        }
    }

    private void onManageLabelsClick() {
        String labelFormat = this.panel.annotationTextField.getText().replaceAll(" ", "");
        this.annotationSettings.show(labelFormat.indexOf("{folder}") > -1);
    }

    private void onAddClick() {
        LabelsPanel labelsPanel = new LabelsPanel();
        ArrayList<LabelVariable> variables = new ArrayList<LabelVariable>(Annotator.LABELS.size());
        for (int i = 0; i < Annotator.LABELS.size(); ++i) {
            LabelVariable variable = new LabelVariable(Annotator.LABELS.get(i), "{" + Annotator.LABELS.get(i) + "} - " + NbBundle.getMessage(AnnotationSettings.class, (String)("AnnotationSettings.label." + Annotator.LABELS.get(i))));
            variables.add(variable);
        }
        labelsPanel.labelsList.setListData(variables.toArray(new LabelVariable[variables.size()]));
        String title = NbBundle.getMessage(AnnotationSettings.class, (String)"AnnotationSettings.labelVariables.title");
        String acsd = NbBundle.getMessage(AnnotationSettings.class, (String)"AnnotationSettings.labelVariables.acsd");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)labelsPanel, title);
        dialogDescriptor.setModal(true);
        dialogDescriptor.setValid(true);
        final Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(acsd);
        labelsPanel.labelsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    dialog.setVisible(false);
                }
            }
        });
        dialog.setVisible(true);
        if (DialogDescriptor.OK_OPTION.equals(dialogDescriptor.getValue())) {
            Object[] selection = labelsPanel.labelsList.getSelectedValues();
            String variable = "";
            for (int i = 0; i < selection.length; ++i) {
                variable = variable + "{" + ((LabelVariable)selection[i]).getVariable() + "}";
            }
            String annotation = this.panel.annotationTextField.getText();
            int pos = this.panel.annotationTextField.getCaretPosition();
            if (pos < 0) {
                pos = annotation.length();
            }
            StringBuilder sb = new StringBuilder(annotation.length() + variable.length());
            sb.append(annotation.substring(0, pos));
            sb.append(variable);
            if (pos < annotation.length()) {
                sb.append(annotation.substring(pos, annotation.length()));
            }
            this.panel.annotationTextField.setText(sb.toString());
            this.panel.annotationTextField.requestFocus();
            this.panel.annotationTextField.setCaretPosition(pos + variable.length());
        }
    }

    private static class LabelVariable {
        private String description;
        private String variable;

        public LabelVariable(String variable, String description) {
            this.description = description;
            this.variable = variable;
        }

        public String toString() {
            return this.description;
        }

        public String getDescription() {
            return this.description;
        }

        public String getVariable() {
            return this.variable;
        }
    }
}

