/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.copy;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.subversion.remote.RepositoryFile;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.api.ISVNDirEntry;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.api.SVNRevision;
import org.netbeans.modules.subversion.remote.client.PanelProgressSupport;
import org.netbeans.modules.subversion.remote.client.SvnClient;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.client.SvnProgressSupport;
import org.netbeans.modules.subversion.remote.ui.copy.BranchPickerPanel;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

class BranchPicker {
    private final BranchPickerPanel panel;
    private final RepositoryFile repositoryFile;
    private String selectedPath;
    private static final String ITEM_BRANCHES = NbBundle.getMessage(BranchPicker.class, (String)"BranchPickerPanel.item.branches");
    private static final String ITEM_TAGS = NbBundle.getMessage(BranchPicker.class, (String)"BranchPickerPanel.item.tags");
    private static final String ITEM_LOADING = NbBundle.getMessage(BranchPicker.class, (String)"BranchPickerPanel.item.loading");
    private static final String ITEM_SEP = "   ";
    private static final Set<Object> FORBIDDEN_SELECTION = new HashSet<Object>(Arrays.asList(null, ITEM_BRANCHES, ITEM_TAGS, ITEM_LOADING, "   "));
    private static final String PREFIX_BRANCHES = "branches";
    private static final String PREFIX_TAGS = "tags";
    private SvnProgressSupport loadingSupport;
    private final String branchesFolderPrefix;
    private final FileSystem fileSystem;

    public BranchPicker(FileSystem fileSystem, RepositoryFile repositoryFile, String branchesFolderPrefix) {
        this.repositoryFile = repositoryFile;
        this.branchesFolderPrefix = branchesFolderPrefix;
        this.fileSystem = fileSystem;
        this.panel = new BranchPickerPanel();
        this.panel.lstBranches.setCellRenderer(new Renderer(branchesFolderPrefix));
    }

    boolean openDialog() {
        final JButton okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)okButton, (String)NbBundle.getMessage(BranchPicker.class, (String)"LBL_BranchPicker.okButton.text"));
        DialogDescriptor dd = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(BranchPicker.class, (String)"LBL_BranchPicker.title"), true, new Object[]{okButton, DialogDescriptor.CANCEL_OPTION}, (Object)okButton, 0, new HelpCtx(BranchPicker.class), null);
        okButton.setEnabled(false);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        ListSelectionListener list = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    String selected = (String)((BranchPicker)BranchPicker.this).panel.lstBranches.getSelectedValue();
                    BranchPicker.this.selectedPath = null;
                    if (!FORBIDDEN_SELECTION.contains(selected)) {
                        BranchPicker.this.selectedPath = selected;
                    }
                    okButton.setEnabled(BranchPicker.this.selectedPath != null);
                }
            }
        };
        this.panel.lstBranches.addListSelectionListener(list);
        this.initializeItems();
        dialog.setVisible(true);
        SvnProgressSupport supp = this.loadingSupport;
        if (supp != null) {
            supp.cancel();
        }
        this.panel.lstBranches.removeListSelectionListener(list);
        return dd.getValue() == okButton;
    }

    String getSelectedPath() {
        return this.selectedPath;
    }

    private void initializeItems() {
        DefaultListModel<String> model = new DefaultListModel<String>();
        model.addElement(ITEM_BRANCHES);
        model.addElement(ITEM_LOADING);
        model.addElement(ITEM_SEP);
        model.addElement(ITEM_TAGS);
        model.addElement(ITEM_LOADING);
        this.panel.lstBranches.setModel(model);
        PanelProgressSupport supp = new PanelProgressSupport(this.fileSystem, this.panel.pnlProgress){

            @Override
            protected void perform() {
                try {
                    Context context = new Context(VCSFileProxy.createFileProxy((FileObject)BranchPicker.this.fileSystem.getRoot()));
                    SvnClient client = Subversion.getInstance().getClient(context, BranchPicker.this.repositoryFile.getRepositoryUrl());
                    final HashMap<String, ISVNDirEntry[]> entries = new HashMap<String, ISVNDirEntry[]>(2);
                    for (String pathName : new String[]{BranchPicker.PREFIX_BRANCHES, BranchPicker.PREFIX_TAGS}) {
                        if (this.isCanceled()) {
                            return;
                        }
                        try {
                            entries.put(pathName, client.getList(BranchPicker.this.repositoryFile.getRepositoryUrl().appendPath(BranchPicker.this.branchesFolderPrefix + pathName), SVNRevision.HEAD, false));
                        }
                        catch (SVNClientException ex) {
                            if (SvnClientExceptionHandler.isWrongURLInRevision(ex.getMessage())) {
                                entries.put(pathName, new ISVNDirEntry[0]);
                                continue;
                            }
                            throw ex;
                        }
                    }
                    if (!this.isCanceled()) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DefaultListModel<String> model = new DefaultListModel<String>();
                                model.addElement(ITEM_BRANCHES);
                                for (ISVNDirEntry e : (ISVNDirEntry[])entries.get(BranchPicker.PREFIX_BRANCHES)) {
                                    model.addElement(BranchPicker.this.branchesFolderPrefix + BranchPicker.PREFIX_BRANCHES + "/" + e.getPath());
                                }
                                model.addElement(BranchPicker.ITEM_SEP);
                                model.addElement(ITEM_TAGS);
                                for (ISVNDirEntry e : (ISVNDirEntry[])entries.get(BranchPicker.PREFIX_TAGS)) {
                                    model.addElement(BranchPicker.this.branchesFolderPrefix + BranchPicker.PREFIX_TAGS + "/" + e.getPath());
                                }
                                ((BranchPicker)BranchPicker.this).panel.lstBranches.setModel(model);
                            }
                        });
                    }
                }
                catch (SVNClientException ex) {
                    SvnClientExceptionHandler.notifyException(null, ex, true, false);
                }
            }
        };
        supp.start(Subversion.getInstance().getRequestProcessor(this.repositoryFile.getRepositoryUrl()), null, NbBundle.getMessage(BranchPicker.class, (String)"BranchPickerPanel.loading.progress"));
        this.loadingSupport = supp;
    }

    private static class Renderer
    extends DefaultListCellRenderer {
        private final String branchesFolderPrefix;

        public Renderer(String branchesFolderPrefix) {
            this.branchesFolderPrefix = branchesFolderPrefix;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == ITEM_BRANCHES || value == ITEM_TAGS) {
                value = "<html><strong>" + value + "</strong></html>";
            } else {
                String sValue = (String)value;
                for (String pref : new String[]{this.branchesFolderPrefix + BranchPicker.PREFIX_BRANCHES + "/", this.branchesFolderPrefix + BranchPicker.PREFIX_TAGS + "/"}) {
                    if (!sValue.startsWith(pref)) continue;
                    value = "<html>" + pref + "<strong>" + sValue.substring(pref.length()) + "</strong></html>";
                }
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

