/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.copy;

import java.awt.EventQueue;
import java.util.concurrent.Callable;
import org.netbeans.modules.subversion.remote.RepositoryFile;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.api.ISVNInfo;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.api.SVNRevision;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.SvnClient;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.client.SvnProgressSupport;
import org.netbeans.modules.subversion.remote.ui.actions.ContextAction;
import org.netbeans.modules.subversion.remote.ui.copy.CreateCopy;
import org.netbeans.modules.subversion.remote.ui.copy.SwitchToAction;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CreateCopyAction
extends ContextAction {
    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_MenuItem_Copy";
    }

    @Override
    protected int getFileEnabledStatus() {
        return -8;
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    @Override
    protected boolean enable(Node[] nodes) {
        return nodes != null && nodes.length == 1 && this.isCacheReady() && this.getCachedContext(nodes).getRoots().size() > 0;
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        SVNUrl fileUrl;
        SVNUrl repositoryUrl;
        Context ctx = this.getContext(nodes);
        if (!Subversion.getInstance().checkClientAvailable(ctx)) {
            return;
        }
        VCSFileProxy[] roots = SvnUtils.getActionRoots(ctx);
        if (roots == null || roots.length == 0) {
            return;
        }
        VCSFileProxy[] files = Subversion.getInstance().getStatusCache().listFiles(ctx, 88532);
        VCSFileProxy interestingFile = roots.length == 1 ? roots[0] : SvnUtils.getPrimaryFile(roots[0]);
        try {
            repositoryUrl = ContextAction.getSvnUrl(ctx);
            fileUrl = SvnUtils.getRepositoryUrl(interestingFile);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException(ctx, ex, true, true);
            return;
        }
        RepositoryFile repositoryFile = new RepositoryFile(ctx.getFileSystem(), repositoryUrl, fileUrl, SVNRevision.HEAD);
        RequestProcessor rp = this.createRequestProcessor(ctx);
        boolean hasChanges = files.length > 0;
        CreateCopy createCopy = new CreateCopy(repositoryFile, interestingFile, hasChanges);
        this.performCopy(createCopy, rp, nodes, roots);
    }

    private void performCopy(final CreateCopy createCopy, final RequestProcessor rp, final Node[] nodes, final VCSFileProxy[] roots) {
        if (!createCopy.showDialog()) {
            return;
        }
        rp.post(new Runnable(){

            @Override
            public void run() {
                String errorText = CreateCopyAction.this.validateTargetPath(createCopy, roots);
                if (errorText == null) {
                    ContextAction.ProgressSupport support = new ContextAction.ProgressSupport(CreateCopyAction.this, nodes, CreateCopyAction.this.getCachedContext(nodes)){

                        @Override
                        public void perform() {
                            CreateCopyAction.this.performCopy(createCopy, this, roots);
                        }
                    };
                    support.start(rp);
                } else {
                    SvnClientExceptionHandler.annotate(errorText);
                    createCopy.setErrorText(errorText);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CreateCopyAction.this.performCopy(createCopy, rp, nodes, roots);
                        }
                    });
                }
            }
        });
    }

    private String validateTargetPath(CreateCopy createCopy, VCSFileProxy[] roots) {
        String errorText = null;
        try {
            ISVNInfo info;
            block5: {
                RepositoryFile toRepositoryFile = createCopy.getToRepositoryFile();
                Context context = new Context(roots);
                SvnClient client = Subversion.getInstance().getClient(context, toRepositoryFile.getRepositoryUrl());
                info = null;
                try {
                    info = client.getInfo(context, toRepositoryFile.getFileUrl());
                }
                catch (SVNClientException e) {
                    if (SvnClientExceptionHandler.isWrongUrl(e.getMessage())) break block5;
                    throw e;
                }
            }
            if (info != null) {
                errorText = NbBundle.getMessage(CreateCopyAction.class, (String)"MSG_CreateCopy_Target_Exists");
            }
        }
        catch (SVNClientException ex) {
            errorText = null;
        }
        return errorText;
    }

    private void performCopy(final CreateCopy createCopy, final SvnProgressSupport support, final VCSFileProxy[] roots) {
        if (roots == null) {
            return;
        }
        final RepositoryFile toRepositoryFile = createCopy.getToRepositoryFile();
        try {
            SvnClient client;
            Context context = new Context(roots);
            try {
                client = Subversion.getInstance().getClient(context, toRepositoryFile.getRepositoryUrl());
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException(context, ex, true, true);
                return;
            }
            if (support.isCanceled()) {
                return;
            }
            if (createCopy.isLocal()) {
                if (roots.length == 1) {
                    client.copy(new VCSFileProxy[]{createCopy.getLocalFile()}, toRepositoryFile.getFileUrl(), createCopy.getMessage(), true, true);
                } else {
                    for (VCSFileProxy root : roots) {
                        SVNUrl toUrl = this.getToRepositoryFile(toRepositoryFile, root).getFileUrl();
                        client.copy(new VCSFileProxy[]{root}, toUrl, createCopy.getMessage(), true, true);
                    }
                }
            } else if (roots.length == 1) {
                RepositoryFile fromRepositoryFile = createCopy.getFromRepositoryFile();
                client.copy(fromRepositoryFile.getFileUrl(), toRepositoryFile.getFileUrl(), createCopy.getMessage(), fromRepositoryFile.getRevision(), true);
            } else {
                for (VCSFileProxy root : roots) {
                    SVNUrl fromUrl = SvnUtils.getRepositoryRootUrl(root).appendPath(SvnUtils.getRepositoryPath(root));
                    SVNUrl toUrl = this.getToRepositoryFile(toRepositoryFile, root).getFileUrl();
                    client.copy(fromUrl, toUrl, createCopy.getMessage(), SVNRevision.HEAD, true);
                }
            }
            if (support.isCanceled()) {
                return;
            }
            if (createCopy.switchTo()) {
                VCSFileProxy[] vCSFileProxyArray;
                boolean rootsPresent;
                boolean bl = rootsPresent = roots.length > 1;
                if (rootsPresent) {
                    vCSFileProxyArray = roots;
                } else {
                    VCSFileProxy[] vCSFileProxyArray2 = new VCSFileProxy[1];
                    vCSFileProxyArray = vCSFileProxyArray2;
                    vCSFileProxyArray2[0] = createCopy.getLocalFile();
                }
                VCSFileProxy[] indexingRoots = vCSFileProxyArray;
                SvnUtils.runWithoutIndexing(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        if (rootsPresent) {
                            for (VCSFileProxy file : roots) {
                                SwitchToAction.performSwitch(CreateCopyAction.this.getToRepositoryFile(toRepositoryFile, file), file, support);
                            }
                        } else {
                            SwitchToAction.performSwitch(toRepositoryFile, createCopy.getLocalFile(), support);
                        }
                        return null;
                    }
                }, indexingRoots);
            }
        }
        catch (SVNClientException ex) {
            support.annotate(ex);
        }
    }

    private RepositoryFile getToRepositoryFile(RepositoryFile toRepositoryFile, VCSFileProxy file) {
        return toRepositoryFile.replaceLastSegment(file.getName(), 0);
    }
}

