/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.properties;

import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.api.ISVNProperty;
import org.netbeans.modules.subversion.remote.api.ISVNStatus;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.api.SVNStatusKind;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.SvnClient;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.client.SvnProgressSupport;
import org.netbeans.modules.subversion.remote.ui.actions.ContextAction;
import org.netbeans.modules.subversion.remote.ui.properties.Bundle;
import org.netbeans.modules.subversion.remote.ui.properties.PropertiesPanel;
import org.netbeans.modules.subversion.remote.ui.properties.PropertiesTable;
import org.netbeans.modules.subversion.remote.ui.properties.SvnPropertiesNode;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class SvnProperties
implements ActionListener {
    private static final HashSet<String> DIR_ONLY_PROPERTIES = new HashSet<String>(Arrays.asList("svn:ignore", "svn:externals"));
    private static final HashSet<String> FILE_ONLY_PROPERTIES = new HashSet<String>(Arrays.asList("svn:eol-style", "svn:executable", "svn:keywords", "svn:needs-lock", "svn:mime-type"));
    private static final HashSet<String> MIXED_PROPERTIES = new HashSet(DIR_ONLY_PROPERTIES.size() + FILE_ONLY_PROPERTIES.size());
    private PropertiesPanel panel;
    private final VCSFileProxy[] roots;
    private final PropertiesTable propTable;
    private SvnProgressSupport support;
    private boolean loadedFromFile;
    private VCSFileProxy loadedValueFile;
    private final Set<VCSFileProxy> folders = new HashSet<VCSFileProxy>();
    private final Set<VCSFileProxy> files = new HashSet<VCSFileProxy>();
    private final Map<String, Set<VCSFileProxy>> filesPerProperty = new HashMap<String, Set<VCSFileProxy>>();

    public SvnProperties(PropertiesPanel panel, PropertiesTable propTable, VCSFileProxy[] files) {
        this.panel = panel;
        this.propTable = propTable;
        this.roots = files;
        propTable.getTable().addMouseListener(new TableMouseListener());
        panel.btnRefresh.addActionListener(this);
        panel.btnAdd.addActionListener(this);
        panel.btnRemove.addActionListener(this);
        panel.btnBrowse.addActionListener(this);
        panel.comboName.setEditable(true);
        for (VCSFileProxy f : files) {
            if (f.isDirectory()) {
                this.folders.add(f);
                continue;
            }
            this.files.add(f);
        }
        panel.setForDirectory(!this.folders.isEmpty());
        if (this.folders.isEmpty()) {
            panel.setIllegalPropertyNames(DIR_ONLY_PROPERTIES.toArray(new String[DIR_ONLY_PROPERTIES.size()]), "PropertiesPanel.errInvalidPropertyForFile");
        } else {
            panel.setRecursiveProperties(FILE_ONLY_PROPERTIES);
        }
        this.setLoadedValueFile(null);
        this.initPropertyNameCbx();
        this.setLoadedFromFile(false);
        this.refreshProperties();
        panel.initInteraction();
    }

    public PropertiesPanel getPropertiesPanel() {
        return this.panel;
    }

    public void setPropertiesPanel(PropertiesPanel panel) {
        this.panel = panel;
    }

    public VCSFileProxy[] getFiles() {
        return this.roots;
    }

    private void setLoadedValueFile(VCSFileProxy file) {
        this.loadedValueFile = file;
    }

    private VCSFileProxy getLoadedValueFile() {
        return this.loadedValueFile;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source.equals(this.panel.btnRefresh)) {
            this.refreshProperties();
        }
        if (source.equals(this.panel.btnAdd)) {
            this.setProperties();
        }
        if (source.equals(this.panel.btnRemove)) {
            this.removeProperties();
        }
        if (source.equals(this.panel.btnBrowse)) {
            this.loadFromFile();
        }
    }

    protected void initPropertyNameCbx() {
        if (this.panel.comboName.isEditable()) {
            this.panel.setPredefinedPropertyNames(this.folders.isEmpty() ? FILE_ONLY_PROPERTIES.toArray(new String[FILE_ONLY_PROPERTIES.size()]) : MIXED_PROPERTIES.toArray(new String[MIXED_PROPERTIES.size()]));
        }
    }

    protected String getPropertyValue() {
        return SvnUtils.fixLineEndings(this.panel.getPropertyValue());
    }

    protected String getPropertyName() {
        return this.panel.getPropertyName();
    }

    public boolean isLoadedFromFile() {
        return this.loadedFromFile;
    }

    public void setLoadedFromFile(boolean value) {
        this.loadedFromFile = value;
        if (this.loadedFromFile) {
            this.panel.setPropertyValueChangeListener(this);
        }
    }

    public void handleBinaryFile(VCSFileProxy source) {
        this.setLoadedValueFile(source);
        StringBuilder txtValue = new StringBuilder();
        txtValue.append(NbBundle.getMessage(SvnProperties.class, (String)"Binary_Content"));
        txtValue.append("\n");
        try {
            txtValue.append(VCSFileProxySupport.getCanonicalPath((VCSFileProxy)source));
        }
        catch (IOException ex) {
            Subversion.LOG.log(Level.SEVERE, null, ex);
        }
        this.panel.txtAreaValue.setText(txtValue.toString());
        this.setLoadedFromFile(true);
    }

    public void loadFromFile() {
        final JFileChooser chooser = VCSFileProxySupport.createFileChooser((VCSFileProxy)this.roots[0].getParentFile());
        chooser.setDialogTitle(NbBundle.getMessage(SvnProperties.class, (String)"CTL_Load_Value_Title"));
        chooser.setMultiSelectionEnabled(false);
        FileFilter[] fileFilters = chooser.getChoosableFileFilters();
        for (int i = 0; i < fileFilters.length; ++i) {
            FileFilter fileFilter = fileFilters[i];
            chooser.removeChoosableFileFilter(fileFilter);
        }
        chooser.setDialogType(0);
        chooser.setApproveButtonMnemonic(NbBundle.getMessage(SvnProperties.class, (String)"MNE_LoadValue").charAt(0));
        chooser.setApproveButtonText(NbBundle.getMessage(SvnProperties.class, (String)"CTL_LoadValue"));
        DialogDescriptor dd = new DialogDescriptor((Object)chooser, NbBundle.getMessage(SvnProperties.class, (String)"CTL_Load_Value_Title"));
        dd.setOptions(new Object[0]);
        final Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        chooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String state = e.getActionCommand();
                if (state.equals("ApproveSelection")) {
                    VCSFileProxy source = VCSFileProxySupport.getSelectedFile((JFileChooser)chooser);
                    if (VCSFileProxySupport.isFileContentText((VCSFileProxy)source)) {
                        if (VCSFileProxySupport.canRead((VCSFileProxy)source)) {
                            StringWriter sw = new StringWriter();
                            try {
                                Utils.copyStreamsCloseAll((Writer)sw, (Reader)new InputStreamReader(source.getInputStream(false), "UTF-8"));
                                ((SvnProperties)SvnProperties.this).panel.txtAreaValue.setText(sw.toString());
                            }
                            catch (IOException ex) {
                                Subversion.LOG.log(Level.SEVERE, null, ex);
                            }
                        }
                    } else {
                        SvnProperties.this.handleBinaryFile(source);
                    }
                }
                dialog.dispose();
            }
        });
        dialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperties() {
        SVNUrl repositoryUrl;
        Context context = new Context(this.roots);
        try {
            repositoryUrl = ContextAction.getSvnUrl(context);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException(context, ex, true, true);
            return;
        }
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor(repositoryUrl);
        try {
            this.support = new SvnProgressSupport(context.getFileSystem()){
                HashMap<String, String> properties;

                @Override
                protected void perform() {
                    Context context = new Context(SvnProperties.this.roots);
                    try {
                        SvnClient client = Subversion.getInstance().getClient(false, context);
                        this.properties = new HashMap();
                        for (VCSFileProxy f : SvnProperties.this.roots) {
                            ISVNStatus status = SvnUtils.getSingleStatus(client, f);
                            if (status.getTextStatus().equals((Object)SVNStatusKind.UNVERSIONED)) continue;
                            this.addProperties(f, client.getProperties(f));
                        }
                    }
                    catch (SVNClientException ex) {
                        SvnClientExceptionHandler.notifyException(context, ex, true, true);
                        return;
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String[] propNames = new String[properties.size()];
                            SvnPropertiesNode[] svnProps = new SvnPropertiesNode[properties.size()];
                            int i = 0;
                            for (Map.Entry<String, String> e : properties.entrySet()) {
                                String name;
                                propNames[i] = name = e.getKey();
                                String value = e.getValue();
                                svnProps[i] = new SvnPropertiesNode(name, value);
                                ++i;
                            }
                            SvnProperties.this.propTable.setNodes(svnProps);
                            SvnProperties.this.panel.setExistingPropertyNames(propNames);
                        }
                    });
                }

                private void addProperties(VCSFileProxy file, ISVNProperty[] toAddProps) {
                    for (ISVNProperty prop : toAddProps) {
                        String tmp;
                        String propName = prop.getName();
                        String propValue = SvnUtils.isBinary(prop.getData()) ? NbBundle.getMessage(SvnProperties.class, (String)"Binary_Content") : ((tmp = prop.getValue()) != null ? tmp : "");
                        String existingValue = this.properties.get(propName);
                        if (existingValue != null && !existingValue.equals(propValue)) {
                            propValue = NbBundle.getMessage(SvnProperties.class, (String)"SvnProperties.VariousValues");
                        }
                        this.properties.put(propName, propValue);
                        HashSet<VCSFileProxy> filesPerProp = (HashSet<VCSFileProxy>)SvnProperties.this.filesPerProperty.get(propName);
                        if (filesPerProp == null) {
                            filesPerProp = new HashSet<VCSFileProxy>();
                            SvnProperties.this.filesPerProperty.put(propName, filesPerProp);
                        }
                        filesPerProp.add(file);
                    }
                }
            };
            this.support.start(rp, repositoryUrl, NbBundle.getMessage(SvnProperties.class, (String)"LBL_Properties_Progress"));
        }
        finally {
            this.support = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProperties() {
        SVNUrl repositoryUrl;
        Context context = new Context(this.roots);
        try {
            repositoryUrl = ContextAction.getSvnUrl(context);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException(context, ex, true, true);
            return;
        }
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor(repositoryUrl);
        try {
            this.support = new SvnProgressSupport(context.getFileSystem()){
                ISVNProperty[] isvnProps;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void perform() {
                    SvnClient client;
                    Context context = new Context(SvnProperties.this.roots);
                    try {
                        client = Subversion.getInstance().getClient(false, context);
                    }
                    catch (SVNClientException ex) {
                        SvnClientExceptionHandler.notifyException(context, ex, true, true);
                        return;
                    }
                    boolean recursively = ((SvnProperties)SvnProperties.this).panel.cbxRecursively.isSelected();
                    HashSet<VCSFileProxy> toRefresh = new HashSet<VCSFileProxy>();
                    try {
                        String propName = SvnProperties.this.getPropertyName();
                        for (VCSFileProxy root : SvnProperties.this.getAllowedFiles(propName, recursively)) {
                            SvnProperties.this.addFile(client, root, recursively);
                            if (SvnProperties.this.isLoadedFromFile()) {
                                try {
                                    client.propertySet(root, propName, SvnProperties.this.getLoadedValueFile(), recursively);
                                    toRefresh.add(root);
                                    continue;
                                }
                                catch (IOException ex) {
                                    Subversion.LOG.log(Level.SEVERE, null, ex);
                                    Subversion.getInstance().getStatusCache().refreshAsync(recursively, toRefresh.toArray(new VCSFileProxy[toRefresh.size()]));
                                    return;
                                }
                            }
                            client.propertySet(root, propName, SvnProperties.this.getPropertyValue(), recursively);
                            toRefresh.add(root);
                        }
                    }
                    catch (SVNClientException ex) {
                        SvnClientExceptionHandler.notifyException(context, ex, true, true);
                        return;
                    }
                    finally {
                        Subversion.getInstance().getStatusCache().refreshAsync(recursively, toRefresh.toArray(new VCSFileProxy[toRefresh.size()]));
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((SvnProperties)SvnProperties.this).panel.comboName.getEditor().setItem("");
                            ((SvnProperties)SvnProperties.this).panel.txtAreaValue.setText("");
                        }
                    });
                }
            };
            this.support.start(rp, repositoryUrl, NbBundle.getMessage(SvnProperties.class, (String)"LBL_Properties_Progress"));
        }
        finally {
            this.support = null;
        }
        this.refreshProperties();
    }

    private VCSFileProxy[] getAllowedFiles(String propertyName, boolean recursively) {
        LinkedList<VCSFileProxy> fileList = new LinkedList<VCSFileProxy>();
        for (VCSFileProxy root : this.roots) {
            boolean isFile = this.files.contains(root);
            if (isFile && DIR_ONLY_PROPERTIES.contains(propertyName) || !isFile && !recursively && FILE_ONLY_PROPERTIES.contains(propertyName)) continue;
            fileList.add(root);
        }
        return fileList.toArray(new VCSFileProxy[fileList.size()]);
    }

    private VCSFileProxy[] getFilesWithProperty(String propertyName) {
        Set<VCSFileProxy> filesWithProperty = this.filesPerProperty.get(propertyName);
        HashSet<VCSFileProxy> fileList = new HashSet<VCSFileProxy>();
        if (filesWithProperty != null) {
            fileList.addAll(filesWithProperty);
        }
        return fileList.toArray(new VCSFileProxy[fileList.size()]);
    }

    private void addFile(SvnClient client, VCSFileProxy file, boolean recursively) throws SVNClientException {
        if (SvnUtils.isPartOfSubversionMetadata(file)) {
            return;
        }
        ISVNStatus status = SvnUtils.getSingleStatus(client, file);
        if (status.getTextStatus().equals((Object)SVNStatusKind.UNVERSIONED)) {
            boolean isDir = file.isDirectory();
            if (isDir) {
                client.addDirectory(file, false);
            } else {
                client.addFile(file);
            }
            if (recursively && isDir) {
                VCSFileProxy[] files = file.listFiles();
                if (files == null) {
                    return;
                }
                for (VCSFileProxy f : files) {
                    this.addFile(client, f, recursively);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProperties() {
        SVNUrl repositoryUrl;
        final Context context = new Context(this.roots);
        try {
            repositoryUrl = ContextAction.getSvnUrl(context);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException(context, ex, true, true);
            return;
        }
        final int[] rows = this.propTable.getSelectedItems();
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor(repositoryUrl);
        try {
            this.support = new SvnProgressSupport(context.getFileSystem()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void perform() {
                    SvnClient client;
                    try {
                        client = Subversion.getInstance().getClient(false, context);
                    }
                    catch (SVNClientException ex) {
                        SvnClientExceptionHandler.notifyException(context, ex, true, true);
                        return;
                    }
                    boolean recursively = ((SvnProperties)SvnProperties.this).panel.cbxRecursively.isSelected();
                    HashSet<VCSFileProxy> toRefresh = new HashSet<VCSFileProxy>();
                    try {
                        SvnPropertiesNode[] svnPropertiesNodes = SvnProperties.this.propTable.getNodes();
                        List<SvnPropertiesNode> lstSvnPropertiesNodes = Arrays.asList(svnPropertiesNodes);
                        if (recursively && rows.length == 0) {
                            this.removePropertyRecursively(client, toRefresh);
                        }
                        for (int i = rows.length - 1; i >= 0; --i) {
                            String svnPropertyName = svnPropertiesNodes[SvnProperties.this.propTable.getModelIndex(rows[i])].getName();
                            for (VCSFileProxy root : SvnProperties.this.getFilesWithProperty(svnPropertyName)) {
                                client.propertyDel(root, svnPropertyName, recursively);
                                toRefresh.add(root);
                            }
                            try {
                                lstSvnPropertiesNodes.remove(svnPropertiesNodes[SvnProperties.this.propTable.getModelIndex(rows[i])]);
                                continue;
                            }
                            catch (UnsupportedOperationException e) {
                                // empty catch block
                            }
                        }
                        final SvnPropertiesNode[] remainingNodes = (SvnPropertiesNode[])lstSvnPropertiesNodes.toArray();
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SvnProperties.this.propTable.setNodes(remainingNodes);
                                if (remainingNodes.length == 0) {
                                    SvnProperties.this.panel.setExistingPropertyNames(new String[0]);
                                } else {
                                    String[] propNames = new String[remainingNodes.length];
                                    for (int i = 0; i < propNames.length; ++i) {
                                        propNames[i] = remainingNodes[i].getName();
                                    }
                                    SvnProperties.this.panel.setExistingPropertyNames(propNames);
                                }
                            }
                        });
                    }
                    catch (SVNClientException ex) {
                        SvnClientExceptionHandler.notifyException(context, ex, true, true);
                    }
                    finally {
                        Subversion.getInstance().getStatusCache().refreshAsync(recursively, toRefresh.toArray(new VCSFileProxy[toRefresh.size()]));
                    }
                }

                private void removePropertyRecursively(SvnClient client, Set<VCSFileProxy> toRefresh) throws SVNClientException {
                    String propName = SvnProperties.this.getPropertyName();
                    if (!propName.trim().isEmpty() && JOptionPane.showConfirmDialog(SvnProperties.this.panel, Bundle.MSG_SvnProperties_RecursiveDelete_question(propName), Bundle.LBL_SvnProperties_RecursiveDelete_title(), 0, 3) == 0) {
                        for (VCSFileProxy root : SvnProperties.this.roots) {
                            client.propertyDel(root, propName, true);
                            toRefresh.add(root);
                        }
                    }
                }
            };
            this.support.start(rp, repositoryUrl, NbBundle.getMessage(SvnProperties.class, (String)"LBL_Properties_Progress"));
        }
        finally {
            this.support = null;
        }
        this.refreshProperties();
    }

    public void propertyValueChanged() {
        assert (this.isLoadedFromFile());
        this.panel.removePropertyValueChangeListener();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((SvnProperties)SvnProperties.this).panel.txtAreaValue.setText("");
            }
        });
        this.setLoadedFromFile(false);
    }

    static {
        MIXED_PROPERTIES.addAll(DIR_ONLY_PROPERTIES);
        MIXED_PROPERTIES.addAll(FILE_ONLY_PROPERTIES);
    }

    public class TableMouseListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.getClickCount() == 2) {
                int[] rows = SvnProperties.this.propTable.getSelectedItems();
                SvnPropertiesNode[] svnPropertiesNodes = SvnProperties.this.propTable.getNodes();
                if (svnPropertiesNodes == null) {
                    return;
                }
                final String svnPropertyName = svnPropertiesNodes[SvnProperties.this.propTable.getModelIndex(rows[0])].getName();
                final String svnPropertyValue = svnPropertiesNodes[SvnProperties.this.propTable.getModelIndex(rows[0])].getValue();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((SvnProperties)SvnProperties.this).panel.comboName.getEditor().setItem(svnPropertyName);
                        ((SvnProperties)SvnProperties.this).panel.txtAreaValue.setText(svnPropertyValue);
                    }
                });
            }
        }
    }
}

