/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.relocate;

import java.awt.Dialog;
import java.net.MalformedURLException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.subversion.remote.FileInformation;
import org.netbeans.modules.subversion.remote.FileStatusCache;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.SvnClient;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.client.SvnProgressSupport;
import org.netbeans.modules.subversion.remote.ui.actions.ContextAction;
import org.netbeans.modules.subversion.remote.ui.relocate.RelocatePanel;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RelocateAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        if (nodes.length != 1) {
            return false;
        }
        if (this.isCacheReady()) {
            Context ctx = this.getCachedContext(nodes);
            VCSFileProxy[] roots = ctx.getRootFiles();
            if (roots == null || roots.length < 1) {
                return false;
            }
            for (VCSFileProxy file : roots) {
                if (!file.isDirectory()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    public void validate(RelocatePanel panel, JButton btnOk) {
        try {
            new SVNUrl(panel.getNewURL().getText());
            btnOk.setEnabled(true);
        }
        catch (MalformedURLException e) {
            btnOk.setEnabled(false);
        }
    }

    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_Relocate_Title";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        ResourceBundle loc = NbBundle.getBundle(RelocateAction.class);
        final Context ctx = this.getContext(nodes);
        VCSFileProxy[] roots = ctx.getRootFiles();
        if (roots == null) {
            return;
        }
        final RelocatePanel panel = new RelocatePanel();
        roots = SvnUtils.getActionRoots(ctx);
        if (roots == null || roots.length == 0) {
            return;
        }
        final VCSFileProxy root = roots[0];
        SVNUrl repositoryUrl = null;
        try {
            repositoryUrl = ContextAction.getSvnUrl(ctx);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException(ctx, ex, true, true);
            return;
        }
        if (repositoryUrl == null) {
            Subversion.LOG.log(Level.WARNING, "Could not retrieve repository root for context file {0}", new Object[]{root});
            return;
        }
        final String wc = root.getPath();
        panel.getCurrentURL().setText(repositoryUrl.toString());
        panel.getWorkingCopy().setText(wc);
        final JButton btnRelocate = new JButton(loc.getString("CTL_Relocate_Action_Name"));
        btnRelocate.setEnabled(false);
        btnRelocate.setToolTipText(loc.getString("TT_Relocate_Action"));
        panel.getNewURL().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent event) {
                RelocateAction.this.validate(panel, btnRelocate);
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                RelocateAction.this.validate(panel, btnRelocate);
            }

            @Override
            public void changedUpdate(DocumentEvent event) {
                RelocateAction.this.validate(panel, btnRelocate);
            }
        });
        JButton btnCancel = new JButton(loc.getString("CTL_Relocate_Action_Cancel"));
        btnCancel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RelocateAction.class, (String)"ACSD_Relocate_Action_Cancel"));
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, loc.getString("CTL_Relocate_Dialog_Title"), true, new Object[]{btnRelocate, btnCancel}, (Object)btnRelocate, 0, null, null);
        descriptor.setClosingOptions(null);
        descriptor.setHelpCtx(new HelpCtx(RelocateAction.class));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.getAccessibleContext().setAccessibleDescription(loc.getString("ACSD_Relocate"));
        dialog.setVisible(true);
        if (descriptor.getValue() != btnRelocate) {
            return;
        }
        final String newUrl = panel.getNewURL().getText();
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor(repositoryUrl);
        final SVNUrl url = repositoryUrl;
        SvnProgressSupport support = new SvnProgressSupport(ctx.getFileSystem()){
            SvnClient client;
            {
                super(x0);
                this.client = null;
            }

            @Override
            protected void perform() {
                try {
                    this.client = Subversion.getInstance().getClient(ctx, url);
                    this.client.relocate(ctx, url.toString(), newUrl, wc, true);
                    this.patchCache();
                }
                catch (SVNClientException ex) {
                    this.annotate(ex);
                }
            }

            private void patchCache() {
                VCSFileProxy[] files;
                FileStatusCache cache = Subversion.getInstance().getStatusCache();
                for (VCSFileProxy f : files = cache.listFiles(new VCSFileProxy[]{root}, -2)) {
                    FileInformation fi = cache.getCachedStatus(f);
                    if (fi == null || fi.getEntry(null) == null) continue;
                    cache.refresh(f, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
                }
            }
        };
        support.start(rp, repositoryUrl, loc.getString("LBL_Relocate_Progress"));
    }
}

