/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.update;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.FileInformation;
import org.netbeans.modules.subversion.remote.FileStatusCache;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.api.ISVNInfo;
import org.netbeans.modules.subversion.remote.api.ISVNNotifyListener;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.api.SVNNodeKind;
import org.netbeans.modules.subversion.remote.api.SVNRevision;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.SvnClient;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.client.SvnProgressSupport;
import org.netbeans.modules.subversion.remote.ui.actions.ActionUtils;
import org.netbeans.modules.subversion.remote.ui.actions.ContextAction;
import org.netbeans.modules.subversion.remote.ui.update.FileUpdateInfo;
import org.netbeans.modules.subversion.remote.ui.update.UpdateResults;
import org.netbeans.modules.subversion.remote.util.ClientCheckSupport;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VersioningOutputManager;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class UpdateAction
extends ContextAction {
    private static final String ICON_RESOURCE = "org/netbeans/modules/subversion/remote/resources/icons/update.png";
    private static final int STATUS_RECURSIVELY_TRAVERSIBLE = -4;

    public UpdateAction() {
        this(ICON_RESOURCE);
    }

    protected UpdateAction(String iconResource) {
        super(iconResource);
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_Update";
    }

    @Override
    protected int getFileEnabledStatus() {
        return 90108;
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected void performContextAction(final Node[] nodes) {
        ClientCheckSupport.getInstance().runInAWTIfAvailable(nodes, ActionUtils.cutAmpersand(this.getRunningName(nodes)), new Runnable(){

            @Override
            public void run() {
                UpdateAction.this.performUpdate(nodes);
            }
        });
    }

    void performUpdate(final Node[] nodes) {
        final Context ctx = this.getContext(nodes);
        if (ctx.getRootFiles().length == 0) {
            Subversion.LOG.info("UpdateAction.performUpdate: context is empty, some files may be unversioned.");
            return;
        }
        final SVNRevision revision = this.getRevision(ctx);
        if (revision == null) {
            return;
        }
        final ContextAction.ProgressSupport support = new ContextAction.ProgressSupport(this, nodes, ctx){

            @Override
            public void perform() {
                UpdateAction.update(ctx, this, UpdateAction.this.getContextDisplayName(nodes), revision);
            }
        };
        Utils.post((Runnable)new Runnable(){

            @Override
            public void run() {
                support.start(UpdateAction.this.createRequestProcessor(ctx));
            }
        });
    }

    protected SVNRevision getRevision(Context ctx) {
        return SVNRevision.HEAD;
    }

    private static void update(Context ctx, SvnProgressSupport progress, String contextDisplayName, SVNRevision revision) {
        VCSFileProxy[] roots = ctx.getRootFiles();
        SVNUrl repositoryUrl = null;
        try {
            VCSFileProxy root;
            VCSFileProxy[] arr$ = roots;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (repositoryUrl = SvnUtils.getRepositoryRootUrl(root = arr$[i$])) == null; ++i$) {
                Subversion.LOG.log(Level.WARNING, "Could not retrieve repository root for context file {0}", new Object[]{root});
            }
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException(ctx, ex, true, true);
            return;
        }
        if (repositoryUrl == null) {
            return;
        }
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        cache.refreshCached(ctx);
        UpdateAction.update(roots, progress, contextDisplayName, repositoryUrl, revision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void update(VCSFileProxy[] roots, final SvnProgressSupport progress, String contextDisplayName, SVNUrl repositoryUrl, final SVNRevision revision) {
        SvnClient client;
        int i;
        VCSFileProxy[][] split = VCSFileProxySupport.splitFlatOthers((VCSFileProxy[])roots);
        final ArrayList<VCSFileProxy> recursiveFiles = new ArrayList<VCSFileProxy>();
        final ArrayList<VCSFileProxy> flatFiles = new ArrayList<VCSFileProxy>();
        for (i = 0; i < split[1].length; ++i) {
            recursiveFiles.add(split[1][i]);
        }
        for (i = 0; i < split[0].length; ++i) {
            flatFiles.add(split[0][i]);
        }
        Context context = new Context(roots);
        UpdateOutputListener listener = new UpdateOutputListener(context);
        try {
            client = Subversion.getInstance().getClient(context, repositoryUrl);
            client.removeNotifyListener(Subversion.getInstance().getRefreshHandler());
            client.addNotifyListener(listener);
            client.addNotifyListener(progress);
            progress.setCancellableDelegate(client);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException(context, ex, true, true);
            return;
        }
        try {
            UpdateNotifyListener l = new UpdateNotifyListener(context);
            client.addNotifyListener(l);
            try {
                SvnUtils.runWithoutIndexing(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        UpdateAction.updateRoots(recursiveFiles, progress, client, true, revision);
                        if (progress.isCanceled()) {
                            return null;
                        }
                        UpdateAction.updateRoots(flatFiles, progress, client, false, revision);
                        return null;
                    }
                }, roots);
                if (progress.isCanceled()) {
                    return;
                }
            }
            finally {
                client.removeNotifyListener(l);
                client.removeNotifyListener(progress);
            }
            if (!l.existedFiles.isEmpty() || !l.conflictedFiles.isEmpty()) {
                HashSet<VCSFileProxy> filesToRefresh = new HashSet<VCSFileProxy>(l.existedFiles);
                filesToRefresh.addAll(l.conflictedFiles);
                Subversion.getInstance().getStatusCache().refreshAsync(filesToRefresh.toArray(new VCSFileProxy[filesToRefresh.size()]));
            }
            if (!l.conflictedFiles.isEmpty()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(UpdateAction.class, (String)"MSG_UpdateCausedConflicts_Prompt"), 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    }
                });
            } else {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(UpdateAction.class, (String)"MSG_Update_Completed"));
            }
        }
        catch (SVNClientException e1) {
            progress.annotate(e1);
        }
        finally {
            UpdateAction.openResults(listener.getResults(), repositoryUrl, contextDisplayName);
        }
    }

    private static void openResults(final List<FileUpdateInfo> resultsList, final SVNUrl url, final String contextDisplayName) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UpdateResults results = new UpdateResults(resultsList, url, contextDisplayName);
                VersioningOutputManager vom = VersioningOutputManager.getInstance();
                vom.addComponent(SvnUtils.decodeToString(url) + "-UpdateExecutor", (JComponent)results);
            }
        });
    }

    private static void updateRoots(List<VCSFileProxy> roots, SvnProgressSupport support, SvnClient client, boolean recursive, SVNRevision revision) throws SVNClientException {
        for (VCSFileProxy root : roots) {
            if (support.isCanceled()) break;
            long rev = client.update(root, revision == null ? SVNRevision.HEAD : revision, recursive);
            UpdateAction.revisionUpdateWorkaround(recursive, root.normalizeFile(), client, rev);
        }
    }

    private static void revisionUpdateWorkaround(final boolean recursive, final VCSFileProxy root, final SvnClient client, final long revision) throws SVNClientException {
        Utils.post((Runnable)new Runnable(){

            @Override
            public void run() {
                VCSFileProxy[] fileArray;
                List filesToRefresh;
                SVNRevision.Number svnRevision = null;
                if (revision < -1L) {
                    ISVNInfo info = null;
                    try {
                        info = SvnUtils.getInfoFromWorkingCopy(client, root);
                        svnRevision = info.getRevision();
                        if (svnRevision == null) {
                            info = client.getInfo(root);
                            svnRevision = info.getRevision();
                        }
                    }
                    catch (SVNClientException ex) {
                        SvnClientExceptionHandler.notifyException(new Context(root), ex, true, true);
                    }
                } else {
                    svnRevision = new SVNRevision.Number(revision);
                }
                if (recursive) {
                    Subversion.getInstance().getStatusCache().patchRevision(new VCSFileProxy[]{root}, svnRevision);
                    int maxItems = 5;
                    filesToRefresh = UpdateAction.patchFilesRecursively(root, svnRevision, maxItems);
                    fileArray = filesToRefresh.size() >= maxItems ? null : filesToRefresh.toArray(new VCSFileProxy[filesToRefresh.size()]);
                } else {
                    filesToRefresh = new ArrayList<VCSFileProxy>();
                    filesToRefresh.add(root);
                    VCSFileProxy[] files = root.listFiles();
                    if (files != null) {
                        filesToRefresh.addAll(Arrays.asList(files));
                    }
                    fileArray = filesToRefresh.toArray(new VCSFileProxy[filesToRefresh.size()]);
                    Subversion.getInstance().getStatusCache().patchRevision(fileArray, svnRevision);
                }
                Subversion.getInstance().getStatusCache().getLabelsCache().flushFileLabels(fileArray);
                Subversion.getInstance().refreshAnnotationsAndSidebars(fileArray);
            }
        });
    }

    public static void performUpdate(final Context context, final String contextDisplayName) {
        SVNUrl repository;
        if (context == null || context.getRoots().size() == 0) {
            return;
        }
        if (!Subversion.getInstance().checkClientAvailable(context)) {
            return;
        }
        try {
            repository = ContextAction.getSvnUrl(context);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException(context, ex, true, true);
            return;
        }
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor(repository);
        SvnProgressSupport support = new SvnProgressSupport(context.getFileSystem()){

            @Override
            public void perform() {
                UpdateAction.update(context, this, contextDisplayName, null);
            }
        };
        support.start(rp, repository, NbBundle.getMessage(UpdateAction.class, (String)"MSG_Update_Progress"));
    }

    public static void performUpdate(final VCSFileProxy file) {
        SVNUrl repository;
        if (file == null) {
            return;
        }
        Context context = new Context(file);
        if (!Subversion.getInstance().checkClientAvailable(context)) {
            return;
        }
        try {
            repository = ContextAction.getSvnUrl(context);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException(context, ex, true, true);
            return;
        }
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor(repository);
        SvnProgressSupport support = new SvnProgressSupport(context.getFileSystem()){

            @Override
            public void perform() {
                UpdateAction.update(new VCSFileProxy[]{file}, this, file.getPath(), repository, null);
            }
        };
        support.start(rp, repository, NbBundle.getMessage(UpdateAction.class, (String)"MSG_Update_Progress"));
    }

    private static List<VCSFileProxy> patchFilesRecursively(VCSFileProxy root, SVNRevision.Number revision, int maxReturnFiles) {
        VCSFileProxy[] files;
        ArrayList<VCSFileProxy> ret = new ArrayList<VCSFileProxy>();
        if (root == null) {
            return ret;
        }
        if (maxReturnFiles > 0) {
            ret.add(root);
        }
        if ((files = root.listFiles()) != null) {
            FileStatusCache cache = Subversion.getInstance().getStatusCache();
            cache.patchRevision(files, revision);
            for (VCSFileProxy file : files) {
                FileInformation info = cache.getCachedStatus(file);
                if (SvnUtils.isPartOfSubversionMetadata(file) || SvnUtils.isAdministrative(file) || info != null && (info.getStatus() & 0xFFFFFFFC) == 0) continue;
                if (file.isDirectory()) {
                    ret.addAll(UpdateAction.patchFilesRecursively(file, revision, maxReturnFiles - ret.size()));
                    continue;
                }
                if (maxReturnFiles - ret.size() <= 0) continue;
                ret.add(file);
            }
        }
        return ret;
    }

    private static class UpdateNotifyListener
    implements ISVNNotifyListener {
        private static final Pattern conflictFilePattern = Pattern.compile("(C...|.C..|..C.|...C) ?(.+)");
        private static final Pattern existedFilePattern = Pattern.compile("E    ?(.+)");
        HashSet<VCSFileProxy> conflictedFiles = new HashSet();
        HashSet<VCSFileProxy> existedFiles = new HashSet();
        private final VCSFileProxy root;

        private UpdateNotifyListener(Context context) {
            this.root = context.getRootFiles()[0];
        }

        @Override
        public void logMessage(String msg) {
            this.catchMessage(msg);
        }

        @Override
        public void logError(String msg) {
            if (msg == null) {
                return;
            }
            this.catchMessage(msg);
        }

        @Override
        public void setCommand(ISVNNotifyListener.Command arg0) {
        }

        @Override
        public void logCommandLine(String arg0) {
        }

        @Override
        public void logRevision(long arg0, String arg1) {
        }

        @Override
        public void logCompleted(String arg0) {
        }

        @Override
        public void onNotify(VCSFileProxy arg0, SVNNodeKind arg1) {
        }

        private void catchMessage(String message) {
            Matcher m = conflictFilePattern.matcher(message);
            if (m.matches() && m.groupCount() > 1) {
                String filePath = m.group(2);
                this.conflictedFiles.add(VCSFileProxySupport.getResource((VCSFileProxy)this.root, (String)filePath).normalizeFile());
            } else {
                m = existedFilePattern.matcher(message);
                if (m.matches() && m.groupCount() > 0) {
                    String filePath = m.group(1);
                    this.existedFiles.add(VCSFileProxySupport.getResource((VCSFileProxy)this.root, (String)filePath).normalizeFile());
                }
            }
        }
    }

    private static class UpdateOutputListener
    implements ISVNNotifyListener {
        private List<FileUpdateInfo> results;
        private final VCSFileProxy root;

        private UpdateOutputListener(Context context) {
            this.root = context.getRootFiles()[0];
        }

        @Override
        public void setCommand(ISVNNotifyListener.Command command) {
        }

        @Override
        public void logCommandLine(String str) {
        }

        @Override
        public void logMessage(String logMsg) {
            this.catchMessage(logMsg);
        }

        @Override
        public void logError(String str) {
            if (str == null) {
                return;
            }
            this.catchMessage(str);
        }

        @Override
        public void logRevision(long rev, String str) {
        }

        @Override
        public void logCompleted(String str) {
        }

        @Override
        public void onNotify(VCSFileProxy file, SVNNodeKind kind) {
        }

        List<FileUpdateInfo> getResults() {
            if (this.results == null) {
                this.results = new ArrayList<FileUpdateInfo>();
            }
            return this.results;
        }

        private void catchMessage(String logMsg) {
            FileUpdateInfo[] fuis = FileUpdateInfo.createFromLogMsg(this.root, logMsg);
            if (fuis != null) {
                for (FileUpdateInfo fui : fuis) {
                    if (fui == null) continue;
                    this.getResults().add(fui);
                }
            }
        }
    }
}

