/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.versioning.util;

import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public abstract class VCSNotificationDisplayer {
    private static final String NOTIFICATION_ICON_PATH = "org/netbeans/modules/subversion/remote/resources/icons/info.png";

    protected abstract void setupPane(JTextPane var1, VCSFileProxy[] var2, VCSFileProxy var3, String var4, String var5);

    protected String trim(String str) {
        if (str.startsWith("/")) {
            str = str.substring(1, str.length());
        }
        if (str.endsWith("/")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    protected String getFileNames(VCSFileProxy[] files) {
        StringBuffer filesSb = new StringBuffer();
        for (int i = 0; i < files.length; ++i) {
            if (i == 5) {
                filesSb.append("...");
                break;
            }
            VCSFileProxy file = files[i];
            filesSb.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            filesSb.append(file.getName());
            filesSb.append("<br>");
        }
        filesSb.append("<br>");
        return filesSb.toString();
    }

    protected void notifyFileChange(VCSFileProxy[] files, VCSFileProxy projectDir, String url, String revision) {
        JTextPane ballonDetails = this.getPane(files, projectDir, url, revision);
        JTextPane popupDetails = this.getPane(files, projectDir, url, revision);
        NotificationDisplayer.getDefault().notify(NbBundle.getMessage(VCSNotificationDisplayer.class, (String)"MSG_NotificationBubble_Title"), (Icon)ImageUtilities.loadImageIcon((String)NOTIFICATION_ICON_PATH, (boolean)false), (JComponent)ballonDetails, (JComponent)popupDetails, NotificationDisplayer.Priority.NORMAL);
    }

    private JTextPane getPane(VCSFileProxy[] files, VCSFileProxy projectDir, String url, String revision) {
        JTextPane bubble = new JTextPane();
        bubble.setOpaque(false);
        bubble.setEditable(false);
        if (UIManager.getLookAndFeel().getID().equals("Nimbus")) {
            bubble.setBackground(new Color(0, 0, 0, 0));
        }
        bubble.setContentType("text/html");
        this.setupPane(bubble, files, projectDir, url, revision);
        return bubble;
    }
}

