/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.actions;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.core.jaxws.actions.ConvertToRestCookie;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsNode;
import org.netbeans.modules.websvc.core.jaxws.saas.RestResourceGenerator;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.openide.ErrorManager;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class ConvertToRestCookieImpl
implements ConvertToRestCookie {
    private JaxWsNode node;

    public ConvertToRestCookieImpl(JaxWsNode node) {
        this.node = node;
    }

    @Override
    public void convertToRest() {
        FileObject fo = (FileObject)this.node.getLookup().lookup(FileObject.class);
        JAXWSSupport support = JAXWSSupport.getJAXWSSupport((FileObject)fo);
        Service service = (Service)this.node.getLookup().lookup(Service.class);
        String packageName = this.getPackageName(service.getImplementationClass());
        String wsdlFileName = service.getLocalWsdlFile();
        URI wsdlURL = null;
        if (wsdlFileName != null) {
            FileObject fileObject = support.getLocalWsdlFolderForService(service.getName(), false);
            File dir = FileUtil.toFile((FileObject)fileObject);
            File urlFile = new File(dir, wsdlFileName);
            wsdlURL = urlFile.toURI();
        } else {
            try {
                wsdlURL = new URI(this.node.getWsdlURL());
            }
            catch (URISyntaxException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        RestResourceGenerator generator = new RestResourceGenerator(fo.getParent(), wsdlURL, packageName);
        generator.generate();
    }

    private String getPackageName(String implementationClass) {
        int index = implementationClass.lastIndexOf(".");
        return implementationClass.substring(0, index);
    }

    private void invokeWsGen(String serviceName, Project project) {
        FileObject buildImplFo = project.getProjectDirectory().getFileObject("build.xml");
        try {
            ExecutorTask wsgentTask = ActionUtils.runTarget((FileObject)buildImplFo, (String[])new String[]{"wsgen-" + serviceName}, null);
            wsgentTask.waitFinished();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

