/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.projects;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.javaee.specs.support.api.JaxWs;
import org.netbeans.modules.javaee.specs.support.api.JaxWsStackSupport;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.WebServiceNotifier;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileObject;

public class ProjectWebServiceNotifier
implements WebServiceNotifier {
    private static final String J2EE_SERVER_INSTANCE = "j2ee.server.instance";
    private Project proj;

    public ProjectWebServiceNotifier(Project proj) {
        this.proj = proj;
    }

    public void serviceAdded(String serviceName, String implementationClass) {
        JAXWSSupport jaxWsSupport = JAXWSSupport.getJAXWSSupport((FileObject)this.proj.getProjectDirectory());
        if (jaxWsSupport != null) {
            jaxWsSupport.addService(serviceName, implementationClass, this.isJsr109Supported());
        }
    }

    public void serviceRemoved(String serviceName) {
        JAXWSSupport jaxWsSupport = JAXWSSupport.getJAXWSSupport((FileObject)this.proj.getProjectDirectory());
        if (jaxWsSupport != null) {
            jaxWsSupport.serviceFromJavaRemoved(serviceName);
        }
    }

    private boolean isJsr109Supported() {
        String serverInstance;
        JaxWsModel jaxWsModel = (JaxWsModel)this.proj.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null && jaxWsModel.getJsr109() != null) {
            return jaxWsModel.getJsr109();
        }
        EditableProperties projectProperties = null;
        try {
            projectProperties = WSUtils.getEditableProperties((Project)this.proj, (String)"nbproject/private/private.properties");
        }
        catch (IOException ex) {
            // empty catch block
        }
        boolean jsr109Supported = false;
        if (projectProperties != null && (serverInstance = projectProperties.getProperty(J2EE_SERVER_INSTANCE)) != null) {
            try {
                J2eePlatform j2eePlatform = Deployment.getDefault().getServerInstance(serverInstance).getJ2eePlatform();
                WSStack wsStack = JaxWsStackSupport.getJaxWsStack((J2eePlatform)j2eePlatform);
                if (wsStack != null) {
                    jsr109Supported = wsStack.isFeatureSupported((WSStack.Feature)JaxWs.Feature.JSR109);
                }
            }
            catch (InstanceRemovedException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Failed to find J2eePlatform", ex);
            }
        }
        if (!jsr109Supported) {
            jsr109Supported = jaxWsModel != null ? JaxWsUtils.askForSunJaxWsConfig(jaxWsModel) : true;
        }
        return jsr109Supported;
    }
}

