/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.saas;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlOperation;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlParameter;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlPort;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.saas.codegen.java.support.JavaSourceHelper;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.openide.filesystems.FileObject;

public class RestWrapperForSoapGenerator {
    private FileObject targetFile;
    private WsdlService service;
    private WsdlPort port;
    private WsdlOperation operation;
    private Project project;
    private Map<String, Class> primitiveTypes;
    private static final Modifier[] PUBLIC = new Modifier[]{Modifier.PUBLIC};
    public static final String INDENT = "        ";
    public static final String INDENT_2 = "             ";
    public static final String APP_XML_MIME = "application/xml";
    public static final String TEXT_PLAIN_MIME = "text/plain";
    public static final String APP_JSON_MIMI = "application/json";
    private String[] ANNOTATIONS_GET = new String[]{"javax.ws.rs.GET", "javax.ws.rs.Produces", "javax.ws.rs.Consumes", "javax.ws.rs.Path"};
    private String[] ANNOTATIONS_POST = new String[]{"javax.ws.rs.POST", "javax.ws.rs.Produces", "javax.ws.rs.Consumes", "javax.ws.rs.Path"};
    private String[] ANNOTATIONS_PUT = new String[]{"javax.ws.rs.PUT", "javax.ws.rs.Consumes", "javax.ws.rs.Path"};
    static final String JAVA_TRY = "\ntry '{' // Call Web Service Operation\n";
    static final String JAVA_SERVICE_DEF = "   {0} {5} = new {0}();\n";
    static final String JAVA_PORT_DEF = "   {1} p = {5}.{2}();\n";
    static final String JAVA_RESULT = "   {3} result = port.{4}({6});\n";
    static final String JAVA_VOID = "   port.{4}({6});\n";
    static final String JAVA_CATCH = "'}' catch (Exception ex) '{'\n   // TODO handle custom exceptions here\n'}'\n";
    static final String IF_PORT_NOT_NULL = "\nif(port != null)'{'\n";
    static final String RESPONSE_BLOCK = "class {8}_1 extends {7}.{8} '{'\n    {8}_1({3} _return) '{'\n        this._return = _return;\n    '}'\n'}'\n{7}.{8} response = new {8}_1(result);\nreturn new {7}.ObjectFactory().create{8}(response);\n";
    static final String CLOSE_IF_PORT = "\n'}'\n";

    public RestWrapperForSoapGenerator(WsdlService service, WsdlPort port, WsdlOperation operation, Project project, FileObject targetFile, String wsdlUrl) {
        this.service = service;
        this.port = port;
        this.operation = operation;
        this.targetFile = targetFile;
        this.project = project;
    }

    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public Set<FileObject> generate() throws IOException {
        JavaSource targetSource = JavaSource.forFileObject((FileObject)this.targetFile);
        final String returnType = this.operation.getReturnTypeName();
        CancellableTask<WorkingCopy> task = new CancellableTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ClassTree javaClass = SourceUtils.getPublicTopLevelTree((CompilationController)workingCopy);
                TypeElement classElement = SourceUtils.getPublicTopLevelElement((CompilationController)workingCopy);
                List<? extends AnnotationMirror> anns = classElement.getAnnotationMirrors();
                String pathValue = javaClass.getSimpleName().toString().toLowerCase();
                AnnotationMirror pathAnn = JavaSourceHelper.findAnnotation(anns, (String)("javax.ws.rs.Path(\"" + pathValue + "\")"));
                if (pathAnn == null) {
                    RestWrapperForSoapGenerator.this.addPathAnnotation(workingCopy, new String[]{javaClass.getSimpleName().toString().toLowerCase()});
                }
                if (!returnType.equals("void") && RestWrapperForSoapGenerator.this.getPrimitiveType(returnType) == null) {
                    RestWrapperForSoapGenerator.this.addQNameImport(workingCopy);
                }
                ClassTree finalJavaClass = RestWrapperForSoapGenerator.this.addHttpMethod(returnType, workingCopy, javaClass);
                workingCopy.rewrite((Tree)javaClass, (Tree)finalJavaClass);
            }

            public void cancel() {
            }
        };
        targetSource.runModificationTask((Task)task).commit();
        return new HashSet<FileObject>(Collections.EMPTY_LIST);
    }

    private void addQNameImport(WorkingCopy copy) {
        JavaSourceHelper.addImports((WorkingCopy)copy, (String[])new String[]{"javax.xml.namespace.QName"});
    }

    public List<WsdlParameter> getOutputParameters() {
        ArrayList<WsdlParameter> params = new ArrayList<WsdlParameter>();
        for (WsdlParameter p : this.operation.getParameters()) {
            if (!p.isHolder()) continue;
            params.add(p);
        }
        return params;
    }

    private void addPathAnnotation(WorkingCopy copy, String[] path) {
        JavaSourceHelper.addClassAnnotation((WorkingCopy)copy, (String[])new String[]{"Path"}, (Object[])path);
    }

    private String wrapInJaxbElement(String type) {
        return "javax.xml.bind.JAXBElement<" + type + ">";
    }

    private ClassTree addHttpMethod(String returnType, WorkingCopy copy, ClassTree tree) throws IOException {
        Modifier[] modifiers = PUBLIC;
        String retType = returnType;
        if (retType.equals("void")) {
            List<WsdlParameter> parms = this.getOutputParameters();
            for (WsdlParameter parm : parms) {
                if (!parm.isHolder()) continue;
                String holderType = parm.getTypeName();
                int leftbracket = holderType.indexOf("<");
                int rightbracket = holderType.lastIndexOf(">");
                retType = holderType.substring(leftbracket + 1, rightbracket);
                break;
            }
        } else {
            retType = this.isList(retType) ? this.wrapInJaxbElement(this.getPackageFromJava(this.port.getJavaName()) + "." + this.getResponseType(this.operation.getName())) : (this.getPrimitiveType(retType) != null ? "java.lang.String" : this.wrapInJaxbElement(retType));
        }
        List queryParams = this.operation.getParameters();
        String[] parameters = this.getHttpParamNames(queryParams);
        Object[] paramTypes = this.getHttpParamTypes(queryParams);
        String[][] paramAnnotations = this.getHttpParamAnnotations((String[])paramTypes);
        Object[][] paramAnnotationAttrs = this.getHttpParamAnnotationAttrs(queryParams, (String[])paramTypes);
        String[] methodAnnotations = this.getOperationAnnotations(retType, (String[])paramTypes);
        Object[] methodAnnotationAttrs = this.getOperationAnnotationAttrs(this.operation.getName(), retType, (String[])paramTypes);
        String bodyText = this.getSOAPClientInvocation(retType);
        StringBuilder comment = new StringBuilder("Invokes the SOAP method ");
        comment.append(this.operation.getName());
        comment.append('\n');
        for (String param : parameters) {
            comment.append("@param ");
            comment.append(param);
            comment.append(" resource URI parameter\n");
        }
        if (!retType.equals("void")) {
            comment.append("@return an instance of ");
            comment.append(retType);
        }
        int index = methodAnnotations[0].lastIndexOf(".");
        String methodPrefix = methodAnnotations[0].substring(index + 1).toLowerCase();
        return JavaSourceHelper.addMethod((WorkingCopy)copy, (ClassTree)tree, (Modifier[])modifiers, (String[])methodAnnotations, (Object[])methodAnnotationAttrs, (String)this.getMethodName(methodPrefix), (Object)retType, (String[])parameters, (Object[])paramTypes, (Object[])paramAnnotations, (Object[])paramAnnotationAttrs, (String)bodyText, (String)comment.toString());
    }

    private String[] getHttpParamTypes(List<WsdlParameter> queryParams) {
        ArrayList<String> types = new ArrayList<String>();
        for (WsdlParameter queryParam : queryParams) {
            String paramTypeName = queryParam.getTypeName();
            if (queryParam.isHolder()) continue;
            if (this.getPrimitiveType(paramTypeName) == null) {
                types.add(this.wrapInJaxbElement(paramTypeName));
                continue;
            }
            types.add(paramTypeName);
        }
        return types.toArray(new String[types.size()]);
    }

    private String[] getHttpParamNames(List<WsdlParameter> queryParams) {
        ArrayList<String> names = new ArrayList<String>();
        for (WsdlParameter queryParam : queryParams) {
            if (queryParam.isHolder()) continue;
            names.add(queryParam.getName());
        }
        return names.toArray(new String[names.size()]);
    }

    private Object generateDefaultValue(Class type) {
        if (type == Integer.class || type == Short.class || type == Long.class || type == Float.class || type == Double.class) {
            try {
                return type.getConstructor(String.class).newInstance("0");
            }
            catch (Exception ex) {
                return null;
            }
        }
        if (type == Boolean.class) {
            return Boolean.FALSE;
        }
        if (type == Character.class) {
            return Character.valueOf('\u0000');
        }
        return null;
    }

    private String[][] getHttpParamAnnotations(String[] paramTypeNames) {
        ArrayList<String[]> annos = new ArrayList<String[]>();
        String[] annotations = null;
        if (!this.hasComplexTypes(paramTypeNames)) {
            for (int i = 0; i < paramTypeNames.length; ++i) {
                Class type = this.getType(this.project, paramTypeNames[i]);
                annotations = this.generateDefaultValue(type) != null ? new String[]{"javax.ws.rs.QueryParam", "javax.ws.rs.DefaultValue"} : new String[]{"javax.ws.rs.QueryParam"};
                annos.add(annotations);
            }
        }
        return (String[][])annos.toArray((T[])new String[annos.size()][]);
    }

    public Class getGenericRawType(String typeName, ClassLoader loader) {
        int i = typeName.indexOf(60);
        if (i < 1) {
            return null;
        }
        String raw = typeName.substring(0, i);
        try {
            return loader.loadClass(raw);
        }
        catch (ClassNotFoundException ex) {
            Logger.global.log(Level.INFO, "", ex);
            return null;
        }
    }

    public Class getType(Project project, String typeName) {
        List<ClassPath> classPaths = RestWrapperForSoapGenerator.getClassPath(project);
        for (ClassPath cp : classPaths) {
            try {
                Class ret = this.getPrimitiveType(typeName);
                if (ret != null) {
                    return ret;
                }
                ClassLoader cl = cp.getClassLoader(true);
                ret = this.getGenericRawType(typeName, cl);
                if (ret != null) {
                    return ret;
                }
                if (cl == null) continue;
                return cl.loadClass(typeName);
            }
            catch (ClassNotFoundException ex) {
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class[] getInputParameterTypes() {
        ArrayList<Class> types = new ArrayList<Class>();
        for (WsdlParameter p : this.operation.getParameters()) {
            if (p.isHolder()) continue;
            Class type = null;
            RestWrapperForSoapGenerator restWrapperForSoapGenerator = this;
            synchronized (restWrapperForSoapGenerator) {
                try {
                    for (int repeatCount = 0; repeatCount < 60 && (type = this.getType(this.project, p.getTypeName())) == null; ++repeatCount) {
                        this.wait(2000L);
                    }
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            if (type == null) {
                type = Object.class;
            }
            types.add(type);
        }
        return types.toArray(new Class[types.size()]);
    }

    private Object[][] getHttpParamAnnotationAttrs(List<WsdlParameter> queryParams, String[] typeNames) {
        ArrayList<Object[]> attrs = new ArrayList<Object[]>();
        Object[] annotationAttrs = null;
        if (!this.hasComplexTypes(typeNames)) {
            for (WsdlParameter param : queryParams) {
                Class type = this.getType(this.project, param.getTypeName());
                Object defaultValue = this.generateDefaultValue(type);
                annotationAttrs = this.generateDefaultValue(type) != null ? new Object[]{param.getName(), defaultValue.toString()} : new Object[]{param.getName()};
                attrs.add(annotationAttrs);
            }
        }
        return (Object[][])attrs.toArray((T[])new Object[attrs.size()][]);
    }

    private String getMethodName(String prefix) {
        String methodName = this.camelize(this.operation.getName(), true);
        if (methodName.startsWith(prefix)) {
            return methodName;
        }
        return prefix + this.camelize(methodName, false);
    }

    private String getSOAPClientInvocation(String typeName) throws IOException {
        String code = "{\n";
        code = code + this.getCustomMethodBody() + "\n";
        if (!typeName.equals("void")) {
            code = code + "return null;\n";
        }
        code = code + "}\n";
        return code;
    }

    private String getReturnTypeQName(String returnTypeName) {
        int index = returnTypeName.lastIndexOf(".");
        String packageName = returnTypeName.substring(0, index);
        StringTokenizer tokenizer = new StringTokenizer(packageName, ".");
        int tokens = tokenizer.countTokens();
        String[] inverted = new String[tokens];
        while (tokenizer.hasMoreTokens()) {
            inverted[--tokens] = tokenizer.nextToken();
        }
        StringBuffer namespace = new StringBuffer();
        for (int i = 0; i < inverted.length; ++i) {
            namespace.append(inverted[i]);
            if (i >= inverted.length - 1) continue;
            namespace.append(".");
        }
        String ns = "http//" + namespace.toString() + "/";
        String localpart = returnTypeName.substring(index + 1).toLowerCase();
        return "new QName(\"" + ns + "\",\"" + localpart + "\")";
    }

    private String getReturnStatement(WsdlOperation operation) {
        String statement = "return result";
        String returnTypeName = operation.getReturnTypeName();
        Class c = this.getPrimitiveType(returnTypeName);
        if (c != null && !returnTypeName.equals("java.lang.String") && !returnTypeName.equals("String")) {
            statement = "return new " + c.getName() + "(result).toString();";
        } else if (c == null) {
            statement = "return new JAXBElement<" + returnTypeName + ">(" + this.getReturnTypeQName(returnTypeName) + "," + returnTypeName + ".class, result);";
        }
        return statement;
    }

    private String getCustomMethodBody() throws IOException {
        String methodBody = INDENT;
        methodBody = methodBody + this.getWSInvocationCode(this.targetFile, this.service, this.port, this.operation);
        return methodBody;
    }

    public String getWSInvocationCode(FileObject target, WsdlService service, WsdlPort port, WsdlOperation operation) {
        String serviceFieldName = "service";
        String operationJavaName = operation.getJavaName();
        String portJavaName = port.getJavaName();
        String portGetterMethod = port.getPortGetter();
        List arguments = operation.getParameters();
        String returnTypeName = operation.getReturnTypeName();
        StringBuffer argumentBuffer = new StringBuffer();
        int i = 0;
        for (WsdlParameter argument : arguments) {
            String argumentTypeName = argument.getTypeName();
            String argumentName = argument.getName();
            if (this.getPrimitiveType(argumentTypeName) == null) {
                argumentName = argumentName + ".getValue()";
            }
            argumentBuffer.append(i > 0 ? ", " + argumentName : argumentName);
            ++i;
        }
        String argumentDeclarationPart = argumentBuffer.toString();
        String javaInvocationBody = this.getJavaInvocationWithReturnBody(operation, portJavaName, portGetterMethod, returnTypeName, operationJavaName, serviceFieldName, argumentDeclarationPart);
        return javaInvocationBody;
    }

    public String getJavaInvocationWithReturnBody(WsdlOperation operation, String portJavaName, String portGetterMethod, String returnTypeName, String operationJavaName, String serviceFName, String argumentDeclarationPart) {
        String serviceJavaName = this.service.getJavaName();
        String invocationBody = "";
        Object[] args = new Object[]{serviceJavaName, portJavaName, portGetterMethod, returnTypeName, operationJavaName, serviceFName, argumentDeclarationPart, this.getPackageFromJava(portJavaName), this.getResponseType(operationJavaName)};
        if ("void".equals(returnTypeName)) {
            String body = "\ntry '{' // Call Web Service Operation\n\nif(port != null)'{'\n   port.{4}({6});\n\n'}'\n'}' catch (Exception ex) '{'\n   // TODO handle custom exceptions here\n'}'\n";
            invocationBody = MessageFormat.format(body, args);
        } else {
            String body = "\ntry '{' // Call Web Service Operation\n\nif(port != null)'{'\n   {3} result = port.{4}({6});\n" + (this.isList(returnTypeName) ? RESPONSE_BLOCK : this.getReturnStatement(operation)) + CLOSE_IF_PORT + JAVA_CATCH;
            invocationBody = MessageFormat.format(body, args);
        }
        return invocationBody;
    }

    private Class getPrimitiveType(String typeName) {
        if (this.primitiveTypes == null) {
            this.primitiveTypes = new HashMap<String, Class>();
            this.primitiveTypes.put("int", Integer.class);
            this.primitiveTypes.put("int[]", Integer[].class);
            this.primitiveTypes.put("boolean", Boolean.class);
            this.primitiveTypes.put("boolean[]", Boolean[].class);
            this.primitiveTypes.put("byte", Byte.class);
            this.primitiveTypes.put("byte[]", Byte[].class);
            this.primitiveTypes.put("char", Character.class);
            this.primitiveTypes.put("char[]", Character[].class);
            this.primitiveTypes.put("double", Double.class);
            this.primitiveTypes.put("double[]", Double[].class);
            this.primitiveTypes.put("float", Float.class);
            this.primitiveTypes.put("float[]", Float[].class);
            this.primitiveTypes.put("long", Long.class);
            this.primitiveTypes.put("long[]", Long[].class);
            this.primitiveTypes.put("short", Short.class);
            this.primitiveTypes.put("short[]", Short[].class);
            this.primitiveTypes.put("java.lang.String", String.class);
            this.primitiveTypes.put("String", String.class);
        }
        return this.primitiveTypes.get(typeName);
    }

    private boolean isList(String typeName) {
        return typeName.startsWith("java.util.List");
    }

    public static List<ClassPath> getClassPath(Project project) {
        ArrayList<ClassPath> paths = new ArrayList<ClassPath>();
        ArrayList<SourceGroup> groups = new ArrayList<SourceGroup>();
        groups.addAll(Arrays.asList(ProjectUtils.getSources((Project)project).getSourceGroups("java")));
        ClassPathProvider cpp = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
        for (SourceGroup group : groups) {
            ClassPath cp = cpp.findClassPath(group.getRootFolder(), "classpath/compile");
            if (cp != null) {
                paths.add(cp);
            }
            if ((cp = cpp.findClassPath(group.getRootFolder(), "classpath/source")) == null) continue;
            paths.add(cp);
        }
        return paths;
    }

    public String camelize(String word, boolean flag) {
        if (word.length() == 0) {
            return word;
        }
        StringBuffer sb = new StringBuffer(word.length());
        if (flag) {
            sb.append(Character.toLowerCase(word.charAt(0)));
        } else {
            sb.append(Character.toUpperCase(word.charAt(0)));
        }
        boolean capitalize = false;
        for (int i = 1; i < word.length(); ++i) {
            char ch = word.charAt(i);
            if (capitalize) {
                sb.append(Character.toUpperCase(ch));
                capitalize = false;
                continue;
            }
            if (ch == '_') {
                capitalize = true;
                continue;
            }
            if (ch == '/') {
                capitalize = true;
                sb.append('.');
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private boolean hasComplexTypes(String[] types) {
        for (int i = 0; i < types.length; ++i) {
            if (this.getPrimitiveType(types[i]) != null) continue;
            return true;
        }
        return false;
    }

    private Object[] getOperationAnnotationAttrs(String operationName, String returnType, String[] parameterTypes) {
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add(null);
        if (!returnType.equals("void")) {
            if (this.getPrimitiveType(returnType) == null) {
                attributes.add(APP_XML_MIME);
            } else {
                attributes.add(TEXT_PLAIN_MIME);
            }
        }
        if (this.hasComplexTypes(parameterTypes)) {
            attributes.add(APP_XML_MIME);
        } else {
            attributes.add(TEXT_PLAIN_MIME);
        }
        attributes.add(operationName.toLowerCase() + "/");
        return attributes.toArray(new Object[attributes.size()]);
    }

    private String[] getOperationAnnotations(String returnType, String[] parameterTypes) {
        if (!returnType.equals("void")) {
            if (this.hasComplexTypes(parameterTypes)) {
                return this.ANNOTATIONS_POST;
            }
            return this.ANNOTATIONS_GET;
        }
        return this.ANNOTATIONS_PUT;
    }

    private String getResponseType(String operationName) {
        return operationName.substring(0, 1).toUpperCase() + operationName.substring(1) + "Response";
    }

    private String getPackageFromJava(String seiClass) {
        int index = seiClass.lastIndexOf(".");
        return index > 0 ? seiClass.substring(0, index) : "";
    }
}

