/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.compilers;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.toolchain.compilers.CCCCompiler;

public class SPICompilerAccesor {
    private final Tool compiler;

    public SPICompilerAccesor(Tool compiler) {
        this.compiler = compiler;
    }

    public List<List<String>> getSystemIncludesAndDefines() {
        if (this.compiler instanceof CCCCompiler) {
            CCCCompiler.Pair systemIncludesAndDefines = ((CCCCompiler)this.compiler).getFreshSystemIncludesAndDefines();
            ArrayList<List<String>> res = new ArrayList<List<String>>();
            res.add(systemIncludesAndDefines.systemIncludeDirectoriesList);
            res.add(systemIncludesAndDefines.systemPreprocessorSymbolsList);
            return res;
        }
        return null;
    }

    public void applySystemIncludesAndDefines(List<List<String>> pair) {
        if (this.compiler instanceof CCCCompiler) {
            List<Integer> user = this.merge(((CCCCompiler)this.compiler).getSystemIncludeDirectories(), pair.get(0));
            ((CCCCompiler)this.compiler).setSystemIncludeDirectories(pair.get(0));
            this.setUserAdded(user, ((CCCCompiler)this.compiler).getSystemIncludeDirectories());
            user = this.merge(((CCCCompiler)this.compiler).getSystemPreprocessorSymbols(), pair.get(1));
            ((CCCCompiler)this.compiler).setSystemPreprocessorSymbols(pair.get(1));
            this.setUserAdded(user, ((CCCCompiler)this.compiler).getSystemPreprocessorSymbols());
        }
    }

    private List<Integer> merge(List<String> old, List<String> newList) {
        ArrayList<Integer> user = new ArrayList<Integer>();
        if (old instanceof CCCCompiler.CompilerDefinition) {
            CCCCompiler.CompilerDefinition def = (CCCCompiler.CompilerDefinition)old;
            for (int i = 0; i < def.size(); ++i) {
                if (!def.isUserAdded(i)) continue;
                int j = newList.indexOf(def.get(i));
                if (j < 0) {
                    j = newList.size();
                    newList.add((String)def.get(i));
                }
                user.add(j);
            }
        }
        return user;
    }

    private void setUserAdded(List<Integer> user, List<String> newList) {
        if (newList instanceof CCCCompiler.CompilerDefinition) {
            CCCCompiler.CompilerDefinition def = (CCCCompiler.CompilerDefinition)newList;
            for (int i = 0; i < def.size(); ++i) {
                def.setUserAdded(false, i);
            }
            for (Integer i : user) {
                def.setUserAdded(true, i);
            }
        }
    }
}

