/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.compilerset;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.toolchain.compilerset.ToolchainManagerImpl;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.LinkSupport;
import org.netbeans.modules.nativeexecution.api.util.Path;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.WindowsRegistryIterator;
import org.openide.util.Utilities;

public final class ToolUtils {
    private static String cygwinBase;
    private static final WeakHashMap<String, String> commandCache;

    private ToolUtils() {
    }

    public static String getCygwinBase() {
        if (cygwinBase == null) {
            String cygwinBin;
            ToolchainManager.ToolchainDescriptor td = ToolchainManagerImpl.getImpl().getToolchain("Cygwin", 3);
            if (td != null && (cygwinBin = ToolUtils.getBaseFolder(td, 3)) != null) {
                cygwinBase = cygwinBin.substring(0, cygwinBin.length() - 4).replace("\\", "/");
            }
            if (cygwinBase == null) {
                for (String dir : Path.getPath()) {
                    if (!(dir = dir.toLowerCase().replace("\\", "/")).contains("cygwin")) continue;
                    if (dir.endsWith("/")) {
                        dir = dir.substring(0, dir.length() - 1);
                    }
                    if (dir.toLowerCase().endsWith("/usr/bin")) {
                        cygwinBase = dir.substring(0, dir.length() - 8);
                        break;
                    }
                    if (!dir.toLowerCase().endsWith("/bin")) continue;
                    cygwinBase = dir.substring(0, dir.length() - 4);
                    break;
                }
            }
        }
        return cygwinBase;
    }

    public static String getCommandFolder(CompilerSet cs) {
        if (!Utilities.isWindows()) {
            return null;
        }
        String res = ToolUtils.detectCommandFolder(cs);
        if (res != null) {
            return res;
        }
        return null;
    }

    public static String getCommandFolder() {
        if (!Utilities.isWindows()) {
            return null;
        }
        CompilerSetManager csm = CompilerSetManager.get(ExecutionEnvironmentFactory.getLocal());
        for (CompilerSet cs : csm.getCompilerSets()) {
            String res = cs.getCommandFolder();
            if (res == null) continue;
            return res;
        }
        ToolchainManagerImpl tcm = ToolchainManagerImpl.getImpl();
        for (ToolchainManager.ToolchainDescriptor td : tcm.getToolchains(3)) {
            String res;
            if (td == null || (res = ToolUtils.detectCommandFolder(td)) == null) continue;
            return res;
        }
        return ToolUtils.findMsysInPath();
    }

    public static String getPlatformName(int platform) {
        switch (platform) {
            case 2: {
                return "linux";
            }
            case 0: {
                return "sun_sparc";
            }
            case 1: {
                return "sun_intel";
            }
            case 3: {
                return "windows";
            }
            case 4: {
                return "mac";
            }
        }
        return "none";
    }

    public static boolean isPlatforSupported(int platform, ToolchainManager.ToolchainDescriptor d) {
        switch (platform) {
            case 0: {
                for (String p : d.getPlatforms()) {
                    if (!"sun_sparc".equals(p)) continue;
                    return true;
                }
                break;
            }
            case 1: {
                for (String p : d.getPlatforms()) {
                    if (!"sun_intel".equals(p)) continue;
                    return true;
                }
                break;
            }
            case 2: {
                for (String p : d.getPlatforms()) {
                    if (!"linux".equals(p)) continue;
                    return true;
                }
                break;
            }
            case 3: {
                for (String p : d.getPlatforms()) {
                    if (!"windows".equals(p)) continue;
                    return true;
                }
                break;
            }
            case 4: {
                for (String p : d.getPlatforms()) {
                    if (!"mac".equals(p)) continue;
                    return true;
                }
                break;
            }
            case 5: {
                for (String p : d.getPlatforms()) {
                    if (!"unix".equals(p)) continue;
                    return true;
                }
                break;
            }
            case 6: {
                for (String p : d.getPlatforms()) {
                    if (!"none".equals(p)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    public static int computeLocalPlatform() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("sunos")) {
            String os_arch = System.getProperty("os.arch", "");
            int platform_arch = 1;
            if (os_arch.toLowerCase().contains("sparc")) {
                platform_arch = 0;
            }
            return platform_arch;
        }
        if (os.contains("windows")) {
            return 3;
        }
        if (os.contains("linux")) {
            return 2;
        }
        if (os.contains("mac") || os.contains("darwin")) {
            return 4;
        }
        return 5;
    }

    public static String findCommand(CompilerSet cs, String name) {
        String dir;
        String path = Path.findCommand((String)name);
        if (path == null && (dir = cs.getCommandFolder()) != null) {
            path = ToolUtils.findCommand(name, dir);
        }
        return path;
    }

    public static String findCommand(String cmd, String dir) {
        String cmd2 = null;
        if (cmd.length() > 0) {
            File file2;
            File file;
            if (Utilities.isWindows() && !cmd.endsWith(".exe")) {
                cmd2 = cmd + ".exe";
            }
            if ((file = new File(dir, cmd)).exists()) {
                return file.getAbsolutePath();
            }
            if (Utilities.isWindows() && cmd.endsWith(".exe") && (file2 = new File(dir, cmd + ".lnk")).exists()) {
                return file.getAbsolutePath();
            }
            if (cmd2 != null) {
                file = new File(dir, cmd2);
                if (file.exists()) {
                    return file.getAbsolutePath();
                }
                file2 = new File(dir, cmd2 + ".lnk");
                if (file2.exists()) {
                    return file.getAbsolutePath();
                }
            }
        }
        return null;
    }

    public static String getBaseName(String path) {
        int sep = path.lastIndexOf(47);
        if (sep == -1) {
            sep = path.lastIndexOf(92);
        }
        if (sep != -1) {
            return path.substring(sep + 1);
        }
        return path;
    }

    public static boolean isPathAbsolute(String path) {
        if (path == null || path.length() == 0) {
            return false;
        }
        if (path.charAt(0) == '/') {
            return true;
        }
        if (path.charAt(0) == '\\') {
            return true;
        }
        return path.indexOf(58) > 0;
    }

    public static String replaceOddCharacters(String s, char replaceChar) {
        int n = s.length();
        StringBuilder ret = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c == ' ' || c == '\t' || c == ':' || c == '\'' || c == '*' || c == '\"' || c == '[' || c == ']' || c == '(' || c == ')') {
                ret.append(replaceChar);
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public static String getDirName(String path) {
        int sep = path.lastIndexOf(47);
        if (sep == -1) {
            sep = path.lastIndexOf(92);
        }
        if (sep != -1) {
            return path.substring(0, sep);
        }
        return null;
    }

    public String getPathName(ExecutionEnvironment executionEnvironment) {
        if (executionEnvironment.isLocal() && Utilities.isWindows()) {
            HostInfoProvider.getEnv((ExecutionEnvironment)executionEnvironment);
            for (String key : HostInfoProvider.getEnv((ExecutionEnvironment)executionEnvironment).keySet()) {
                if (!key.toLowerCase().equals("path")) continue;
                return key.substring(0, 4);
            }
        }
        return "PATH";
    }

    public static boolean isMyFolder(String path, ToolchainManager.ToolchainDescriptor d, int platform, boolean known, ToolKind tool) {
        boolean res = ToolUtils.isMyFolderImpl(path, d, platform, known, tool);
        if (ToolchainManagerImpl.TRACE && res) {
            System.err.println("Path [" + path + "] belongs to tool chain " + d.getName());
        }
        return res;
    }

    private static boolean isMyFolderImpl(String path, ToolchainManager.ToolchainDescriptor d, int platform, boolean known, ToolKind tool) {
        String command;
        String flag;
        File file;
        ToolchainManager.ToolDescriptor c = d.getC();
        if (tool == PredefinedToolKind.DebuggerTool) {
            c = d.getDebugger();
        }
        if (c == null || c.getNames().length == 0) {
            return false;
        }
        Pattern pattern = null;
        if (!known && c instanceof ToolchainManager.CompilerDescriptor) {
            ToolchainManager.CompilerDescriptor cd = (ToolchainManager.CompilerDescriptor)c;
            if (cd.getPathPattern() != null) {
                pattern = platform == 3 ? Pattern.compile(cd.getPathPattern(), 2) : Pattern.compile(cd.getPathPattern());
            }
            if (pattern != null && !pattern.matcher(path).find()) {
                String f = cd.getExistFolder();
                if (f == null) {
                    return false;
                }
                File folder = new File(path + "/" + f);
                if (!folder.exists() || !folder.isDirectory()) {
                    return false;
                }
            }
        }
        if (!((file = new File(path + "/" + c.getNames()[0])).exists() || (file = new File(path + "/" + c.getNames()[0] + ".exe")).exists() || (file = new File(path + "/" + c.getNames()[0] + ".exe.lnk")).exists())) {
            return false;
        }
        if (c.getVersionFlags() != null && c.getVersionPattern() != null) {
            flag = c.getVersionFlags();
            pattern = Pattern.compile(c.getVersionPattern());
            command = LinkSupport.resolveWindowsLink((String)file.getAbsolutePath());
            String s = ToolUtils.getCommandOutput(path, command, flag, true);
            boolean res = pattern.matcher(s).find();
            if (ToolchainManagerImpl.TRACE && !res) {
                System.err.println("No match for pattern [" + c.getVersionPattern() + "]:");
                System.err.println("Run " + path + "/" + c.getNames()[0] + " " + flag + "\n" + s);
            }
            return res;
        }
        if (c.getFingerPrintFlags() != null && c.getFingerPrintPattern() != null) {
            flag = c.getFingerPrintFlags();
            command = LinkSupport.resolveWindowsLink((String)file.getAbsolutePath());
            String s = ToolUtils.getCommandOutput(path, command, flag, false);
            pattern = Pattern.compile(c.getFingerPrintPattern());
            Matcher matcher = pattern.matcher(s);
            boolean res = matcher.find();
            if (ToolchainManagerImpl.TRACE && !res) {
                System.err.println("No match for pattern [" + c.getFingerPrintPattern() + "]:");
                System.err.println("Run " + path + "/" + c.getNames()[0] + " " + flag + "\n" + s);
            }
            return res;
        }
        return true;
    }

    public static String getBaseFolder(ToolchainManager.ToolchainDescriptor d, int platform) {
        if (platform != 3) {
            return null;
        }
        List<ToolchainManager.BaseFolder> list = d.getBaseFolders();
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (ToolchainManager.BaseFolder folder : list) {
            String base;
            String pattern = folder.getFolderPattern();
            String key = folder.getFolderKey();
            if (key == null || pattern == null || (base = ToolUtils.readRegistry(key, pattern)) == null) continue;
            if (folder.getFolderSuffix() != null) {
                base = base + "/" + folder.getFolderSuffix();
            }
            return base;
        }
        return null;
    }

    private static String detectCommandFolder(ToolchainManager.ToolchainDescriptor d) {
        String pattern;
        List<ToolchainManager.BaseFolder> list = d.getCommandFolders();
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (ToolchainManager.BaseFolder folder : list) {
            pattern = folder.getFolderPattern();
            String key = folder.getFolderKey();
            if (key == null || pattern == null) continue;
            String base = ToolUtils.readRegistry(key, pattern);
            if (base != null && folder.getFolderSuffix() != null) {
                base = base + "\\" + folder.getFolderSuffix();
            }
            if (base == null || !new File(base).exists()) continue;
            return base;
        }
        for (ToolchainManager.BaseFolder folder : list) {
            pattern = folder.getFolderPathPattern();
            if (pattern == null || pattern.length() <= 0) continue;
            Pattern p = Pattern.compile(pattern);
            for (String dir : Path.getPath()) {
                if (!p.matcher(dir).find() || !new File(dir).exists()) continue;
                return dir;
            }
        }
        return null;
    }

    public static String detectCommandFolder(CompilerSet cs) {
        ToolchainManager.ToolchainDescriptor d = cs.getCompilerFlavor().getToolchainDescriptor();
        String res = ToolUtils.detectCommandFolder(d);
        if (res != null) {
            return res;
        }
        List<ToolchainManager.BaseFolder> list = d.getCommandFolders();
        if (list != null) {
            for (ToolchainManager.BaseFolder folder : list) {
                String relPath = folder.getRelativePath();
                if (relPath == null || relPath.length() <= 0) continue;
                String dir = cs.getDirectory() + "/" + relPath;
                if (!new File(dir = CndFileUtils.normalizeAbsolutePath((String)dir)).exists()) continue;
                return dir;
            }
        }
        return ToolUtils.findMsysInPath();
    }

    private static String findMsysInPath() {
        for (String dir : Path.getPath()) {
            if (!(dir = dir.toLowerCase().replace("\\", "/")).contains("/msys/1.0") || !dir.contains("/bin") || !new File(dir).exists()) continue;
            return dir;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readRegistry(String key, String pattern) {
        block10: {
            cachedResult = ToolUtils.commandCache.get("reg " + key);
            if (cachedResult != null) {
                return cachedResult;
            }
            if (ToolchainManagerImpl.TRACE) {
                System.err.println("Read registry " + key);
            }
            base = null;
            p = Pattern.compile(pattern);
            regIterator = WindowsRegistryIterator.get((String)key, null, (boolean)true);
            try {
                while (regIterator.hasNext()) {
                    res = regIterator.next();
                    if (res == null) continue;
                    arr$ = res;
                    len$ = arr$.length;
                    i$ = 0;
lbl16:
                    // 2 sources

                    while (i$ < len$) {
                        line = arr$[i$];
                        if (ToolchainManagerImpl.TRACE) {
                            System.err.println("\t" + line);
                        }
                        if ((m = p.matcher(line.trim())).find() && m.groupCount() == 1) {
                            base = m.group(1).trim();
                            if (ToolchainManagerImpl.TRACE) {
                                System.err.println("\tFound " + base);
                            }
                            var12_12 = base;
                            ToolUtils.commandCache.put("reg " + key, base == null ? "" : base);
                            return var12_12;
                        }
                        ** GOTO lbl-1000
                    }
                }
                break block10;
            }
            catch (Throwable var13_13) {
                ToolUtils.commandCache.put("reg " + key, base == null ? "" : base);
                throw var13_13;
            }
lbl-1000:
            // 1 sources

            {
                ++i$;
                ** GOTO lbl16
            }
        }
        ToolUtils.commandCache.put("reg " + key, base == null ? "" : base);
        return null;
    }

    private static String getCommandOutput(String path, String command, String flags, boolean bothStreams) {
        String res = commandCache.get(command + " " + flags);
        if (res != null) {
            return res;
        }
        ArrayList<String> args = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(flags, " ");
        while (st.hasMoreTokens()) {
            args.add(st.nextToken());
        }
        if (path == null) {
            path = "";
        }
        ProcessUtils.ExitStatus status = ProcessUtils.executeInDir((String)path, (ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal(), (String)command, (String[])args.toArray(new String[args.size()]));
        StringBuilder buf = new StringBuilder();
        if (status.output != null) {
            buf.append(status.output);
        }
        buf.append('\n');
        if (bothStreams && status.error != null) {
            buf.append(status.error);
        }
        commandCache.put(command + " " + flags, buf.toString());
        return buf.toString();
    }

    static {
        commandCache = new WeakHashMap();
    }
}

