/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.compilerset;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.toolchain.compilerset.ToolUtils;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class ToolchainManagerImpl {
    private static final Logger LOG = Logger.getLogger(ToolchainManagerImpl.class.getName());
    public static final boolean TRACE = Boolean.getBoolean("cnd.toolchain.personality.trace");
    private static final boolean CREATE_SHADOW = Boolean.getBoolean("cnd.toolchain.personality.create_shadow");
    public static final String SHADOW_KEY = "toolchain_shadow";
    public static final String ROOT_FOLDER = "CND";
    public static final String SHADOW_FOLDER = "ToolChain";
    public static final String TOOLCHAIN_FOLDER = "ToolChains";
    public static final String TOOL_FOLDER = "Tool";
    private static final ToolchainManagerImpl manager = new ToolchainManagerImpl();
    private final List<ToolchainManager.ToolchainDescriptor> descriptors = new ArrayList<ToolchainManager.ToolchainDescriptor>();

    public static ToolchainManagerImpl getImpl() {
        return manager;
    }

    private ToolchainManagerImpl() {
        if (NbPreferences.forModule(ToolchainManagerImpl.class).getBoolean(SHADOW_KEY, false)) {
            this.initToolchainManager();
        } else {
            this.initToolchainManager2();
        }
    }

    private void initToolchainManager() {
        try {
            TreeMap<Integer, CompilerVendor> vendors = new TreeMap<Integer, CompilerVendor>();
            HashMap<String, String> cache = new HashMap<String, String>();
            FileObject folder = FileUtil.getConfigFile((String)"CND/ToolChain");
            int indefinedID = 0x3FFFFFFF;
            if (folder != null && folder.isFolder()) {
                FileObject[] files;
                for (FileObject file : files = folder.getChildren()) {
                    Integer position = (Integer)file.getAttribute("position");
                    if (position == null || vendors.containsKey(position)) {
                        position = indefinedID++;
                    }
                    String displayName = (String)file.getAttribute("displayName");
                    CompilerVendor v = new CompilerVendor(file.getNameExt(), position);
                    if (!this.read(file, files, v, new HashSet<FileObject>(), cache)) continue;
                    if (displayName != null && !displayName.isEmpty()) {
                        v.toolChainDisplay = displayName;
                    }
                    vendors.put(position, v);
                }
            }
            for (CompilerVendor v : vendors.values()) {
                this.descriptors.add(new ToolchainDescriptorImpl(v));
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
        if (CREATE_SHADOW && !NbPreferences.forModule(ToolchainManagerImpl.class).getBoolean(SHADOW_KEY, false)) {
            try {
                this.writeToolchains();
                NbPreferences.forModule(ToolchainManagerImpl.class).putBoolean(SHADOW_KEY, true);
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    private void initToolchainManager2() {
        try {
            TreeMap<Integer, CompilerVendor> vendors = new TreeMap<Integer, CompilerVendor>();
            HashMap<String, String> cache = new HashMap<String, String>();
            FileObject folder = FileUtil.getConfigFile((String)"CND/ToolChains");
            FileObject[] files = FileUtil.getConfigFile((String)"CND/Tool").getChildren();
            int indefinedID = 0x3FFFFFFF;
            if (folder != null && folder.isFolder()) {
                for (FileObject file : folder.getChildren()) {
                    CompilerVendor v;
                    Integer position = (Integer)file.getAttribute("position");
                    if (position == null || vendors.containsKey(position)) {
                        position = indefinedID++;
                    }
                    String displayName = null;
                    String bundleName = (String)file.getAttribute("SystemFileSystem.localizingBundle");
                    if (bundleName != null) {
                        try {
                            bundleName = Utilities.translate((String)bundleName);
                            ResourceBundle bundle = NbBundle.getBundle((String)bundleName);
                            if (bundle != null) {
                                displayName = bundle.getString(file.getPath());
                            }
                        }
                        catch (MissingResourceException ex) {
                            ex.printStackTrace(System.err);
                        }
                    }
                    if (!this.read2(file, files, v = new CompilerVendor(file.getNameExt() + ".xml", position), cache)) continue;
                    if (displayName != null && !displayName.isEmpty()) {
                        v.toolChainDisplay = displayName;
                    }
                    vendors.put(position, v);
                }
            }
            for (CompilerVendor v : vendors.values()) {
                this.descriptors.add(new ToolchainDescriptorImpl(v));
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
        if (CREATE_SHADOW && !NbPreferences.forModule(ToolchainManagerImpl.class).getBoolean(SHADOW_KEY, false)) {
            try {
                this.writeToolchains();
                NbPreferences.forModule(ToolchainManagerImpl.class).putBoolean(SHADOW_KEY, true);
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    public void reinitToolchainManager() {
        try {
            this.writeToolchains();
            NbPreferences.forModule(ToolchainManagerImpl.class).putBoolean(SHADOW_KEY, true);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        this.descriptors.clear();
        this.initToolchainManager();
    }

    public ToolchainManager.ToolchainDescriptor getToolchain(String name, int platform) {
        for (ToolchainManager.ToolchainDescriptor d : this.descriptors) {
            if (!name.equals(d.getName()) || !ToolUtils.isPlatforSupported(platform, d) && !ToolUtils.isPlatforSupported(6, d)) continue;
            return d;
        }
        for (ToolchainManager.ToolchainDescriptor d : this.descriptors) {
            if (!ToolUtils.isPlatforSupported(6, d)) continue;
            return d;
        }
        return null;
    }

    public List<ToolchainManager.ToolchainDescriptor> getAllToolchains() {
        return new ArrayList<ToolchainManager.ToolchainDescriptor>(this.descriptors);
    }

    public List<ToolchainManager.ToolchainDescriptor> getToolchains(int platform) {
        ArrayList<ToolchainManager.ToolchainDescriptor> res = new ArrayList<ToolchainManager.ToolchainDescriptor>();
        for (ToolchainManager.ToolchainDescriptor d : this.descriptors) {
            if (!ToolUtils.isPlatforSupported(platform, d)) continue;
            res.add(d);
        }
        return res;
    }

    private boolean read(FileObject file, FileObject[] files, CompilerVendor v, Set<FileObject> antiloop, Map<String, String> cache) {
        String baseName;
        if (antiloop.contains(file)) {
            LOG.log(Level.INFO, "Recursive inclusion of file {0}", file.getPath());
            return false;
        }
        antiloop.add(file);
        String originalFile = (String)file.getAttribute("originalFile");
        if (originalFile != null) {
            FileObject redirect = FileUtil.getConfigFile((String)originalFile);
            if (redirect != null) {
                file = redirect;
            } else {
                LOG.log(Level.INFO, "Not found original file {0} in file {1}", new Object[]{originalFile, file.getPath()});
            }
        }
        if ((baseName = (String)file.getAttribute("extends")) != null && baseName.length() > 0) {
            boolean find = false;
            for (FileObject base : files) {
                if (!baseName.equals(base.getNameExt())) continue;
                if (!this.read(base, files, v, antiloop, cache)) {
                    LOG.log(Level.INFO, "Cannot read base file {0}", file.getPath());
                    return false;
                }
                find = true;
            }
            if (!find) {
                LOG.log(Level.INFO, "Cannot find base file {0}", baseName);
            }
        }
        try {
            return this.read(file.getInputStream(), v, cache);
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Cannot read file {0}", file.getPath());
            ex.printStackTrace(System.err);
        }
        catch (SAXException ex) {
            LOG.log(Level.INFO, "Wrong content of file {0}", file.getPath());
            ex.printStackTrace(System.err);
        }
        catch (ParserConfigurationException ex) {
            LOG.log(Level.INFO, "Error in xml parser on parse file {0}", file.getPath());
            ex.printStackTrace(System.err);
        }
        return false;
    }

    private boolean read2(FileObject file, FileObject[] files, CompilerVendor v, Map<String, String> cache) {
        boolean res = true;
        for (FileObject fo : file.getChildren()) {
            res &= this.read(fo, files, v, new HashSet<FileObject>(), cache);
        }
        return res;
    }

    private boolean read(InputStream inputStream, CompilerVendor v, Map<String, String> cache) throws SAXException, ParserConfigurationException, IOException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setValidating(false);
        SAXParser saxParser = spf.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        SAXHandler handler = new SAXHandler(v, cache);
        xmlReader.setContentHandler(handler);
        InputSource source = new InputSource(inputStream);
        xmlReader.parse(source);
        return true;
    }

    private String unsplit(String[] array) {
        if (array == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (String s : array) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(s);
        }
        return buf.toString();
    }

    public void writeToolchains() throws IOException {
        FileObject folder = FileUtil.getConfigFile((String)ROOT_FOLDER);
        FileObject shadow = folder.getFileObject(SHADOW_FOLDER);
        if (shadow == null) {
            shadow = folder.createFolder(SHADOW_FOLDER);
        }
        if (shadow != null && shadow.isFolder()) {
            for (ToolchainManager.ToolchainDescriptor descriptor : this.descriptors) {
                String name = descriptor.getFileName();
                FileObject file = shadow.getFileObject(name);
                if (file == null) {
                    file = shadow.createData(name);
                }
                this.writeDescriptor(descriptor, file);
                ToolchainDescriptorImpl impl = (ToolchainDescriptorImpl)descriptor;
                file.setAttribute("position", (Object)impl.v.position);
                file.setAttribute("extends", (Object)"");
                file.setAttribute("displayName", (Object)impl.v.toolChainDisplay);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDescriptor(ToolchainManager.ToolchainDescriptor descriptor, FileObject file) throws DOMException {
        ToolchainManager.CMakeDescriptor cmake;
        ToolchainManager.QMakeDescriptor qmake;
        ToolchainManager.DebuggerDescriptor debugger;
        ToolchainManager.MakeDescriptor make;
        ToolchainManager.LinkerDescriptor linker;
        ToolchainManager.ScannerDescriptor scannerDescriptor;
        ToolchainManager.CompilerDescriptor compiler;
        Element p;
        Document doc = XMLUtil.createDocument((String)"toolchaindefinition", (String)"http://www.netbeans.org/ns/cnd-toolchain-definition/1", null, null);
        Element root = doc.getDocumentElement();
        Element element = doc.createElement("toolchain");
        element.setAttribute("name", descriptor.getName());
        element.setAttribute("display", descriptor.getDisplayName());
        element.setAttribute("family", this.unsplit(descriptor.getFamily()));
        if (descriptor.getQmakeSpec() != null) {
            element.setAttribute("qmakespec", descriptor.getQmakeSpec());
        }
        if (descriptor.isAbstract()) {
            element.setAttribute("abstract", "true");
        }
        if (!descriptor.isAutoDetected()) {
            element.setAttribute("auto_detected", "false");
        }
        if (descriptor.getAliases().length > 0) {
            element.setAttribute("aliases", this.unsplit(descriptor.getAliases()));
        }
        if (descriptor.getSubstitute() != null) {
            element.setAttribute("substitute", descriptor.getSubstitute());
        }
        root.appendChild(element);
        if (descriptor.getUpdateCenterUrl() != null && descriptor.getModuleID() != null) {
            element = doc.createElement("download");
            element.setAttribute("uc_url", descriptor.getUpdateCenterUrl());
            element.setAttribute("module_id", descriptor.getModuleID());
            element.setAttribute("uc_display", descriptor.getUpdateCenterDisplayName());
            element.setAttribute("upgrade_url", descriptor.getUpgradeUrl());
            root.appendChild(element);
        }
        element = doc.createElement("platforms");
        element.setAttribute("stringvalue", this.unsplit(descriptor.getPlatforms()));
        root.appendChild(element);
        if (descriptor.getDriveLetterPrefix() != null) {
            element = doc.createElement("drive_letter_prefix");
            element.setAttribute("stringvalue", descriptor.getDriveLetterPrefix());
            root.appendChild(element);
        }
        if (descriptor.getMakefileWriter() != null) {
            element = doc.createElement("makefile_writer");
            element.setAttribute("class", descriptor.getMakefileWriter());
            root.appendChild(element);
        }
        if (descriptor.getBaseFolders() != null) {
            element = doc.createElement("base_folders");
            root.appendChild(element);
            for (ToolchainManager.BaseFolder baseFolder : descriptor.getBaseFolders()) {
                p = doc.createElement("base_folder");
                if (baseFolder.getFolderKey() != null) {
                    p.setAttribute("regestry", baseFolder.getFolderKey());
                }
                if (baseFolder.getFolderPattern() != null) {
                    p.setAttribute("pattern", baseFolder.getFolderPattern());
                }
                if (baseFolder.getFolderPathPattern() != null) {
                    p.setAttribute("path_patern", baseFolder.getFolderPathPattern());
                }
                if (baseFolder.getFolderSuffix() != null) {
                    p.setAttribute("suffix", baseFolder.getFolderSuffix());
                }
                element.appendChild(p);
            }
        }
        if (descriptor.getCommandFolders() != null) {
            element = doc.createElement("command_folders");
            root.appendChild(element);
            for (ToolchainManager.BaseFolder baseFolder : descriptor.getCommandFolders()) {
                p = doc.createElement("command_folder");
                if (baseFolder.getFolderKey() != null) {
                    p.setAttribute("regestry", baseFolder.getFolderKey());
                }
                if (baseFolder.getFolderPattern() != null) {
                    p.setAttribute("pattern", baseFolder.getFolderPattern());
                }
                if (baseFolder.getFolderPathPattern() != null) {
                    p.setAttribute("path_patern", baseFolder.getFolderPathPattern());
                }
                if (baseFolder.getFolderSuffix() != null) {
                    p.setAttribute("suffix", baseFolder.getFolderSuffix());
                }
                if (baseFolder.getRelativePath() != null) {
                    p.setAttribute("relative_path", baseFolder.getRelativePath());
                }
                element.appendChild(p);
            }
        }
        if (descriptor.getDefaultLocations() != null) {
            element = doc.createElement("default_locations");
            root.appendChild(element);
            for (Map.Entry entry : descriptor.getDefaultLocations().entrySet()) {
                for (String st : (List)entry.getValue()) {
                    Element p2 = doc.createElement("platform");
                    p2.setAttribute("os", (String)entry.getKey());
                    p2.setAttribute("directory", st);
                    element.appendChild(p2);
                }
            }
        }
        if ((compiler = descriptor.getC()) != null) {
            element = doc.createElement("c");
            this.writeCompiler(doc, element, compiler);
            root.appendChild(element);
        }
        if ((compiler = descriptor.getCpp()) != null) {
            element = doc.createElement("cpp");
            this.writeCompiler(doc, element, compiler);
            root.appendChild(element);
        }
        if ((compiler = descriptor.getFortran()) != null) {
            element = doc.createElement("fortran");
            this.writeCompiler(doc, element, compiler);
            root.appendChild(element);
        }
        if ((compiler = descriptor.getAssembler()) != null) {
            element = doc.createElement("assembler");
            this.writeCompiler(doc, element, compiler);
            root.appendChild(element);
        }
        if ((scannerDescriptor = descriptor.getScanner()) != null) {
            element = doc.createElement("scanner");
            element.setAttribute("id", scannerDescriptor.getID());
            this.writeScanner(doc, element, scannerDescriptor);
            root.appendChild(element);
        }
        if ((linker = descriptor.getLinker()) != null) {
            element = doc.createElement("linker");
            this.writeLinker(doc, element, linker);
            root.appendChild(element);
        }
        if ((make = descriptor.getMake()) != null) {
            element = doc.createElement("make");
            this.writeMake(doc, element, make);
            root.appendChild(element);
        }
        if ((debugger = descriptor.getDebugger()) != null) {
            element = doc.createElement("debugger");
            element.setAttribute("id", debugger.getID());
            this.writeDebugger(doc, element, debugger);
            root.appendChild(element);
        }
        if ((qmake = descriptor.getQMake()) != null) {
            element = doc.createElement("qmake");
            this.writeQMake(doc, element, qmake);
            root.appendChild(element);
        }
        if ((cmake = descriptor.getCMake()) != null) {
            element = doc.createElement("cmake");
            this.writeCMake(doc, element, cmake);
            root.appendChild(element);
        }
        try {
            FileLock lock = file.lock();
            try {
                OutputStream os = file.getOutputStream(lock);
                try {
                    XMLUtil.write((Document)doc, (OutputStream)os, (String)"UTF-8");
                }
                finally {
                    os.close();
                }
            }
            finally {
                lock.releaseLock();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void writeCompiler(Document doc, Element element, ToolchainManager.CompilerDescriptor compiler) {
        Element e = doc.createElement("compiler");
        e.setAttribute("name", this.unsplit(compiler.getNames()));
        if (compiler.skipSearch()) {
            e.setAttribute("skip", "true");
        }
        element.appendChild(e);
        if (compiler.getPathPattern() != null || compiler.getExistFolder() != null) {
            e = doc.createElement("recognizer");
            if (compiler.getPathPattern() != null) {
                e.setAttribute("pattern", compiler.getPathPattern());
            }
            if (compiler.getExistFolder() != null) {
                e.setAttribute("or_exist_folder", compiler.getExistFolder());
            }
            element.appendChild(e);
        }
        if (compiler.getVersionFlags() != null || compiler.getVersionPattern() != null) {
            e = doc.createElement("version");
            if (compiler.getVersionFlags() != null) {
                e.setAttribute("flags", compiler.getVersionFlags());
            }
            if (compiler.getVersionPattern() != null) {
                e.setAttribute("pattern", compiler.getVersionPattern());
            }
            if (compiler.getFingerPrintFlags() != null) {
                e.setAttribute("fingerprint_flags", compiler.getFingerPrintFlags());
            }
            if (compiler.getFingerPrintPattern() != null) {
                e.setAttribute("fingerprint_pattern", compiler.getFingerPrintPattern());
            }
            element.appendChild(e);
        }
        this.writeAlternativePath(doc, element, compiler);
        if (compiler.getIncludeFlags() != null || compiler.getIncludeParser() != null || compiler.getRemoveIncludePathPrefix() != null || compiler.getRemoveIncludeOutputPrefix() != null) {
            e = doc.createElement("system_include_paths");
            if (compiler.getIncludeFlags() != null) {
                e.setAttribute("flags", compiler.getIncludeFlags());
            }
            if (compiler.getIncludeParser() != null) {
                e.setAttribute("parser", compiler.getIncludeParser());
            }
            if (compiler.getRemoveIncludePathPrefix() != null) {
                e.setAttribute("remove_in_path", compiler.getRemoveIncludePathPrefix());
            }
            if (compiler.getRemoveIncludeOutputPrefix() != null) {
                e.setAttribute("remove_in_output", compiler.getRemoveIncludeOutputPrefix());
            }
            element.appendChild(e);
        }
        if (compiler.getImportantFlags() != null) {
            e = doc.createElement("important_flags");
            e.setAttribute("flags", compiler.getImportantFlags());
            element.appendChild(e);
        }
        if (compiler.getMacroFlags() != null || compiler.getMacroParser() != null || compiler.getPredefinedMacros() != null) {
            e = doc.createElement("system_macros");
            if (compiler.getMacroFlags() != null) {
                e.setAttribute("flags", compiler.getMacroFlags());
            }
            if (compiler.getMacroParser() != null) {
                e.setAttribute("parser", compiler.getMacroParser());
            }
            element.appendChild(e);
            if (compiler.getPredefinedMacros() != null) {
                for (ToolchainManager.PredefinedMacro p : compiler.getPredefinedMacros()) {
                    Element ee = doc.createElement("macro");
                    ee.setAttribute("stringvalue", p.getMacro());
                    if (p.getFlags() != null) {
                        ee.setAttribute("flags", p.getFlags());
                    }
                    if (p.isHidden()) {
                        ee.setAttribute("hide", "true");
                    }
                    e.appendChild(ee);
                }
            }
        }
        if (compiler.getUserIncludeFlag() != null) {
            e = doc.createElement("user_include");
            e.setAttribute("flags", compiler.getUserIncludeFlag());
            element.appendChild(e);
        }
        if (compiler.getUserFileFlag() != null) {
            e = doc.createElement("user_file");
            e.setAttribute("flags", compiler.getUserFileFlag());
            element.appendChild(e);
        }
        if (compiler.getUserMacroFlag() != null) {
            e = doc.createElement("user_macro");
            e.setAttribute("flags", compiler.getUserMacroFlag());
            element.appendChild(e);
        }
        this.writeDevelopmentMode(doc, element, compiler);
        this.writeWarningLevel(doc, element, compiler);
        this.writeArchitecture(doc, element, compiler);
        if (compiler.getStripFlag() != null) {
            e = doc.createElement("strip");
            e.setAttribute("flags", compiler.getStripFlag());
            element.appendChild(e);
        }
        this.writeMultithreading(doc, element, compiler);
        this.writeStandard(doc, element, compiler);
        this.writeLanguageExtension(doc, element, compiler);
        this.writeCppStandard(doc, element, compiler);
        this.writeCStandard(doc, element, compiler);
        this.writeLibrary(doc, element, compiler);
        if (compiler.getOutputObjectFileFlags() != null) {
            e = doc.createElement("output_object_file");
            e.setAttribute("flags", compiler.getOutputObjectFileFlags());
            element.appendChild(e);
        }
        if (compiler.getDependencyGenerationFlags() != null) {
            e = doc.createElement("dependency_generation");
            e.setAttribute("flags", compiler.getDependencyGenerationFlags());
            element.appendChild(e);
        }
        if (compiler.getPrecompiledHeaderFlags() != null || compiler.getPrecompiledHeaderSuffix() != null) {
            e = doc.createElement("precompiled_header");
            if (compiler.getPrecompiledHeaderFlags() != null) {
                e.setAttribute("flags", compiler.getPrecompiledHeaderFlags());
            }
            if (compiler.getPrecompiledHeaderSuffix() != null) {
                e.setAttribute("suffix", compiler.getPrecompiledHeaderSuffix());
            }
            if (compiler.getPrecompiledHeaderSuffixAppend()) {
                e.setAttribute("append", "true");
            }
            element.appendChild(e);
        }
    }

    private void writeDevelopmentMode(Document doc, Element element, ToolchainManager.CompilerDescriptor compiler) {
        String[] flags = compiler.getDevelopmentModeFlags();
        if (flags == null) {
            return;
        }
        int def = 0;
        if (compiler instanceof CompilerDescriptorImpl) {
            def = ((Compiler)((CompilerDescriptorImpl)compiler).tool).developmentMode.default_selection;
        }
        Element e = doc.createElement("development_mode");
        element.appendChild(e);
        String[] names = new String[]{"fast_build", "debug", "performance_debug", "test_coverage", "diagnosable_release", "release", "performance_release"};
        for (int i = 0; i < flags.length; ++i) {
            Element c = doc.createElement(names[i]);
            c.setAttribute("flags", flags[i]);
            if (def == i) {
                c.setAttribute("default", "true");
            }
            e.appendChild(c);
        }
    }

    private void writeWarningLevel(Document doc, Element element, ToolchainManager.CompilerDescriptor compiler) {
        String[] flags = compiler.getWarningLevelFlags();
        if (flags == null) {
            return;
        }
        int def = 0;
        if (compiler instanceof CompilerDescriptorImpl) {
            def = ((Compiler)((CompilerDescriptorImpl)compiler).tool).warningLevel.default_selection;
        }
        Element e = doc.createElement("warning_level");
        element.appendChild(e);
        String[] names = new String[]{"no_warnings", "default", "more_warnings", "warning2error"};
        for (int i = 0; i < flags.length; ++i) {
            Element c = doc.createElement(names[i]);
            c.setAttribute("flags", flags[i]);
            if (def == i) {
                c.setAttribute("default", "true");
            }
            e.appendChild(c);
        }
    }

    private void writeArchitecture(Document doc, Element element, ToolchainManager.CompilerDescriptor compiler) {
        String[] flags = compiler.getArchitectureFlags();
        if (flags == null) {
            return;
        }
        int def = 0;
        if (compiler instanceof CompilerDescriptorImpl) {
            def = ((Compiler)((CompilerDescriptorImpl)compiler).tool).architecture.default_selection;
        }
        Element e = doc.createElement("architecture");
        element.appendChild(e);
        String[] names = new String[]{"default", "bits_32", "bits_64"};
        for (int i = 0; i < flags.length; ++i) {
            Element c = doc.createElement(names[i]);
            c.setAttribute("flags", flags[i]);
            if (def == i) {
                c.setAttribute("default", "true");
            }
            e.appendChild(c);
        }
    }

    private void writeMultithreading(Document doc, Element element, ToolchainManager.CompilerDescriptor compiler) {
        String[] flags = compiler.getMultithreadingFlags();
        if (flags == null) {
            return;
        }
        int def = 0;
        if (compiler instanceof CompilerDescriptorImpl) {
            def = ((Compiler)((CompilerDescriptorImpl)compiler).tool).multithreading.default_selection;
        }
        Element e = doc.createElement("multithreading");
        element.appendChild(e);
        String[] names = new String[]{"none", "safe", "automatic", "open_mp"};
        for (int i = 0; i < flags.length; ++i) {
            Element c = doc.createElement(names[i]);
            c.setAttribute("flags", flags[i]);
            if (def == i) {
                c.setAttribute("default", "true");
            }
            e.appendChild(c);
        }
    }

    private void writeStandard(Document doc, Element element, ToolchainManager.CompilerDescriptor compiler) {
        String[] flags = compiler.getStandardFlags();
        if (flags == null) {
            return;
        }
        int def = 0;
        if (compiler instanceof CompilerDescriptorImpl) {
            def = ((Compiler)((CompilerDescriptorImpl)compiler).tool).standard.default_selection;
        }
        Element e = doc.createElement("standard");
        element.appendChild(e);
        String[] names = new String[]{"old", "legacy", "default", "modern"};
        for (int i = 0; i < flags.length; ++i) {
            Element c = doc.createElement(names[i]);
            c.setAttribute("flags", flags[i]);
            if (def == i) {
                c.setAttribute("default", "true");
            }
            e.appendChild(c);
        }
    }

    private void writeLanguageExtension(Document doc, Element element, ToolchainManager.CompilerDescriptor compiler) {
        String[] flags = compiler.getLanguageExtensionFlags();
        if (flags == null) {
            return;
        }
        int def = 0;
        if (compiler instanceof CompilerDescriptorImpl) {
            def = ((Compiler)((CompilerDescriptorImpl)compiler).tool).languageExtension.default_selection;
        }
        Element e = doc.createElement("language_extension");
        element.appendChild(e);
        String[] names = new String[]{"none", "default", "all"};
        for (int i = 0; i < flags.length; ++i) {
            Element c = doc.createElement(names[i]);
            c.setAttribute("flags", flags[i]);
            if (def == i) {
                c.setAttribute("default", "true");
            }
            e.appendChild(c);
        }
    }

    private void writeCppStandard(Document doc, Element element, ToolchainManager.CompilerDescriptor compiler) {
        String[] flags = compiler.getCppStandardFlags();
        if (flags == null) {
            return;
        }
        int def = 0;
        if (compiler instanceof CompilerDescriptorImpl) {
            def = ((Compiler)((CompilerDescriptorImpl)compiler).tool).cppStandard.default_selection;
        }
        Element e = doc.createElement("cpp_standard");
        element.appendChild(e);
        String[] names = new String[]{"default", "cpp98", "cpp11", "cpp14"};
        for (int i = 0; i < flags.length; ++i) {
            Element c = doc.createElement(names[i]);
            c.setAttribute("flags", flags[i]);
            if (def == i) {
                c.setAttribute("default", "true");
            }
            e.appendChild(c);
        }
    }

    private void writeCStandard(Document doc, Element element, ToolchainManager.CompilerDescriptor compiler) {
        String[] flags = compiler.getCStandardFlags();
        if (flags == null) {
            return;
        }
        int def = 0;
        if (compiler instanceof CompilerDescriptorImpl) {
            def = ((Compiler)((CompilerDescriptorImpl)compiler).tool).cStandard.default_selection;
        }
        Element e = doc.createElement("c_standard");
        element.appendChild(e);
        String[] names = new String[]{"default", "c89", "c99", "c11"};
        for (int i = 0; i < flags.length; ++i) {
            Element c = doc.createElement(names[i]);
            c.setAttribute("flags", flags[i]);
            if (def == i) {
                c.setAttribute("default", "true");
            }
            e.appendChild(c);
        }
    }

    private void writeLibrary(Document doc, Element element, ToolchainManager.CompilerDescriptor compiler) {
        String[] flags = compiler.getLibraryFlags();
        if (flags == null) {
            return;
        }
        int def = 0;
        if (compiler instanceof CompilerDescriptorImpl) {
            def = ((Compiler)((CompilerDescriptorImpl)compiler).tool).library.default_selection;
        }
        Element e = doc.createElement("library");
        element.appendChild(e);
        String[] names = new String[]{"none", "runtime", "classic", "binary_standard", "conforming_standard"};
        for (int i = 0; i < flags.length; ++i) {
            Element c = doc.createElement(names[i]);
            c.setAttribute("flags", flags[i]);
            if (def == i) {
                c.setAttribute("default", "true");
            }
            e.appendChild(c);
        }
    }

    private void writeScanner(Document doc, Element element, ToolchainManager.ScannerDescriptor scanner) {
        Element c;
        for (ToolchainManager.ScannerPattern scannerPattern : scanner.getPatterns()) {
            c = doc.createElement("error");
            c.setAttribute("pattern", scannerPattern.getPattern());
            if (scannerPattern.getSeverity() != null) {
                c.setAttribute("severity", scannerPattern.getSeverity());
            }
            if (scannerPattern.getLanguage() != null) {
                c.setAttribute("language", scannerPattern.getLanguage());
            }
            element.appendChild(c);
        }
        for (String string : scanner.getStackHeaderPattern()) {
            c = doc.createElement("stack_header");
            c.setAttribute("pattern", string);
            element.appendChild(c);
        }
        for (String string : scanner.getStackNextPattern()) {
            c = doc.createElement("stack_next");
            c.setAttribute("pattern", string);
            element.appendChild(c);
        }
        if (scanner.getEnterDirectoryPattern() != null) {
            c = doc.createElement("enter_directory");
            c.setAttribute("pattern", scanner.getEnterDirectoryPattern());
            element.appendChild(c);
        }
        if (scanner.getChangeDirectoryPattern() != null) {
            c = doc.createElement("change_directory");
            c.setAttribute("pattern", scanner.getChangeDirectoryPattern());
            element.appendChild(c);
        }
        if (scanner.getMakeAllInDirectoryPattern() != null) {
            c = doc.createElement("making_all_in_directory");
            c.setAttribute("pattern", scanner.getMakeAllInDirectoryPattern());
            element.appendChild(c);
        }
        if (scanner.getLeaveDirectoryPattern() != null) {
            c = doc.createElement("leave_directory");
            c.setAttribute("pattern", scanner.getLeaveDirectoryPattern());
            element.appendChild(c);
        }
        for (String string : scanner.getFilterOutPatterns()) {
            c = doc.createElement("filter_out");
            c.setAttribute("pattern", string);
            element.appendChild(c);
        }
    }

    private void writeLinker(Document doc, Element element, ToolchainManager.LinkerDescriptor linker) {
        Element c;
        if (linker.getLibraryPrefix() != null) {
            c = doc.createElement("library_prefix");
            c.setAttribute("stringvalue", linker.getLibraryPrefix());
            element.appendChild(c);
        }
        if (linker.getLibrarySearchFlag() != null) {
            c = doc.createElement("library_search");
            c.setAttribute("flags", linker.getLibrarySearchFlag());
            element.appendChild(c);
        }
        if (linker.getDynamicLibrarySearchFlag() != null) {
            c = doc.createElement("dynamic_library_search");
            c.setAttribute("flags", linker.getDynamicLibrarySearchFlag());
            element.appendChild(c);
        }
        if (linker.getLibraryFlag() != null) {
            c = doc.createElement("library_flag");
            c.setAttribute("flags", linker.getLibraryFlag());
            element.appendChild(c);
        }
        if (linker.getPICFlag() != null) {
            c = doc.createElement("PIC");
            c.setAttribute("flags", linker.getPICFlag());
            element.appendChild(c);
        }
        if (linker.getStaticLibraryFlag() != null) {
            c = doc.createElement("static_library");
            c.setAttribute("flags", linker.getStaticLibraryFlag());
            element.appendChild(c);
        }
        if (linker.getDynamicLibraryFlag() != null) {
            c = doc.createElement("dynamic_library");
            c.setAttribute("flags", linker.getDynamicLibraryFlag());
            element.appendChild(c);
        }
        if (linker.getDynamicLibraryBasicFlag() != null) {
            c = doc.createElement("dynamic_library_basic");
            c.setAttribute("flags", linker.getDynamicLibraryBasicFlag());
            element.appendChild(c);
        }
        if (linker.getOutputFileFlag() != null) {
            c = doc.createElement("output_file");
            c.setAttribute("flags", linker.getOutputFileFlag());
            element.appendChild(c);
        }
        if (linker.getStripFlag() != null) {
            c = doc.createElement("strip_flag");
            c.setAttribute("flags", linker.getStripFlag());
            element.appendChild(c);
        }
        if (linker.getPreferredCompiler() != null) {
            c = doc.createElement("preferred_compiler");
            c.setAttribute("compiler", linker.getPreferredCompiler());
            element.appendChild(c);
        }
    }

    private void writeMake(Document doc, Element element, ToolchainManager.MakeDescriptor make) {
        Element c = doc.createElement("tool");
        c.setAttribute("name", this.unsplit(make.getNames()));
        if (make.skipSearch()) {
            c.setAttribute("skip", "true");
        }
        element.appendChild(c);
        if (make.getVersionFlags() != null || make.getVersionPattern() != null) {
            c = doc.createElement("version");
            if (make.getVersionFlags() != null) {
                c.setAttribute("flags", make.getVersionFlags());
            }
            if (make.getVersionPattern() != null) {
                c.setAttribute("pattern", make.getVersionPattern());
            }
            element.appendChild(c);
        }
        this.writeAlternativePath(doc, element, make);
        if (make.getDependencySupportCode() != null) {
            c = doc.createElement("dependency_support");
            c.setAttribute("code", make.getDependencySupportCode());
            element.appendChild(c);
        }
    }

    private void writeDebugger(Document doc, Element element, ToolchainManager.DebuggerDescriptor debugger) {
        Element c = doc.createElement("tool");
        c.setAttribute("name", this.unsplit(debugger.getNames()));
        if (debugger.skipSearch()) {
            c.setAttribute("skip", "true");
        }
        element.appendChild(c);
        if (debugger.getVersionFlags() != null || debugger.getVersionPattern() != null) {
            c = doc.createElement("version");
            if (debugger.getVersionFlags() != null) {
                c.setAttribute("flags", debugger.getVersionFlags());
            }
            if (debugger.getVersionPattern() != null) {
                c.setAttribute("pattern", debugger.getVersionPattern());
            }
            element.appendChild(c);
        }
        this.writeAlternativePath(doc, element, debugger);
    }

    private void writeQMake(Document doc, Element element, ToolchainManager.QMakeDescriptor qmake) {
        Element c = doc.createElement("tool");
        c.setAttribute("name", this.unsplit(qmake.getNames()));
        if (qmake.skipSearch()) {
            c.setAttribute("skip", "true");
        }
        element.appendChild(c);
        if (qmake.getVersionFlags() != null || qmake.getVersionPattern() != null) {
            c = doc.createElement("version");
            if (qmake.getVersionFlags() != null) {
                c.setAttribute("flags", qmake.getVersionFlags());
            }
            if (qmake.getVersionPattern() != null) {
                c.setAttribute("pattern", qmake.getVersionPattern());
            }
            element.appendChild(c);
        }
        this.writeAlternativePath(doc, element, qmake);
    }

    private void writeCMake(Document doc, Element element, ToolchainManager.CMakeDescriptor cmake) {
        Element c = doc.createElement("tool");
        c.setAttribute("name", this.unsplit(cmake.getNames()));
        if (cmake.skipSearch()) {
            c.setAttribute("skip", "true");
        }
        element.appendChild(c);
        if (cmake.getVersionFlags() != null || cmake.getVersionPattern() != null) {
            c = doc.createElement("version");
            if (cmake.getVersionFlags() != null) {
                c.setAttribute("flags", cmake.getVersionFlags());
            }
            if (cmake.getVersionPattern() != null) {
                c.setAttribute("pattern", cmake.getVersionPattern());
            }
            element.appendChild(c);
        }
        this.writeAlternativePath(doc, element, cmake);
    }

    private void writeAlternativePath(Document doc, Element element, ToolchainManager.ToolDescriptor tool) {
        ToolchainManager.AlternativePath[] paths = tool.getAlternativePath();
        if (paths != null) {
            Element c = doc.createElement("alternative_path");
            element.appendChild(c);
            block5: for (ToolchainManager.AlternativePath path : paths) {
                Element p = doc.createElement("path");
                c.appendChild(p);
                switch (path.getKind()) {
                    case PATH: {
                        p.setAttribute("directory", path.getPath());
                        continue block5;
                    }
                    case TOOL_FAMILY: {
                        p.setAttribute("toolchain_family", path.getPath());
                        continue block5;
                    }
                    case TOOL_NAME: {
                        p.setAttribute("toolchain_name", path.getPath());
                    }
                }
            }
        }
    }

    private static final class CMakeDescriptorImpl
    extends ToolDescriptorImpl<CMake>
    implements ToolchainManager.CMakeDescriptor {
        public CMakeDescriptorImpl(CMake qmake) {
            super(qmake);
        }
    }

    private static final class QMakeDescriptorImpl
    extends ToolDescriptorImpl<QMake>
    implements ToolchainManager.QMakeDescriptor {
        public QMakeDescriptorImpl(QMake qmake) {
            super(qmake);
        }
    }

    private static final class DebuggerDescriptorImpl
    extends ToolDescriptorImpl<Debugger>
    implements ToolchainManager.DebuggerDescriptor {
        private final Debugger debugger;

        public DebuggerDescriptorImpl(Debugger debugger) {
            super(debugger);
            this.debugger = debugger;
        }

        @Override
        public String getID() {
            return this.debugger.id;
        }
    }

    private static final class MakeDescriptorImpl
    extends ToolDescriptorImpl<Make>
    implements ToolchainManager.MakeDescriptor {
        private MakeDescriptorImpl(Make make) {
            super(make);
        }

        @Override
        public String getDependencySupportCode() {
            return ((Make)this.tool).dependencySupportCode;
        }
    }

    private static final class LinkerDescriptorImpl
    implements ToolchainManager.LinkerDescriptor {
        private final Linker l;

        private LinkerDescriptorImpl(Linker l) {
            this.l = l;
        }

        @Override
        public String getLibrarySearchFlag() {
            return this.l.librarySearchFlag;
        }

        @Override
        public String getDynamicLibrarySearchFlag() {
            return this.l.dynamicLibrarySearchFlag;
        }

        @Override
        public String getLibraryFlag() {
            return this.l.libraryFlag;
        }

        @Override
        public String getLibraryPrefix() {
            return this.l.library_prefix;
        }

        @Override
        public String getPICFlag() {
            return this.l.PICFlag;
        }

        @Override
        public String getStaticLibraryFlag() {
            return this.l.staticLibraryFlag;
        }

        @Override
        public String getDynamicLibraryFlag() {
            return this.l.dynamicLibraryFlag;
        }

        @Override
        public String getDynamicLibraryBasicFlag() {
            return this.l.dynamicLibraryBasicFlag;
        }

        @Override
        public String getOutputFileFlag() {
            return this.l.outputFileFlag;
        }

        @Override
        public String getStripFlag() {
            return this.l.stripFlag;
        }

        @Override
        public String getPreferredCompiler() {
            return this.l.preferredCompiler;
        }
    }

    private static final class ScannerPatternImpl
    implements ToolchainManager.ScannerPattern {
        private final ErrorPattern e;

        private ScannerPatternImpl(ErrorPattern e) {
            this.e = e;
        }

        @Override
        public String getPattern() {
            return this.e.pattern;
        }

        @Override
        public String getSeverity() {
            return this.e.severity;
        }

        @Override
        public String getLanguage() {
            return this.e.language;
        }
    }

    private static final class ScannerDescriptorImpl
    implements ToolchainManager.ScannerDescriptor {
        private final Scanner s;
        private List<ToolchainManager.ScannerPattern> patterns;
        private List<String> filterOut;

        private ScannerDescriptorImpl(Scanner s) {
            this.s = s;
        }

        @Override
        public String getID() {
            return this.s.id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<ToolchainManager.ScannerPattern> getPatterns() {
            Scanner scanner = this.s;
            synchronized (scanner) {
                if (this.patterns == null) {
                    this.patterns = new ArrayList<ToolchainManager.ScannerPattern>();
                    for (ErrorPattern p : this.s.patterns) {
                        this.patterns.add(new ScannerPatternImpl(p));
                    }
                }
            }
            return this.patterns;
        }

        @Override
        public String getChangeDirectoryPattern() {
            return this.s.changeDirectoryPattern;
        }

        @Override
        public String getEnterDirectoryPattern() {
            return this.s.enterDirectoryPattern;
        }

        @Override
        public String getLeaveDirectoryPattern() {
            return this.s.leaveDirectoryPattern;
        }

        @Override
        public String getMakeAllInDirectoryPattern() {
            return this.s.makingAllInDirectoryPattern;
        }

        @Override
        public List<String> getStackHeaderPattern() {
            return this.s.stackHeaderPattern;
        }

        @Override
        public List<String> getStackNextPattern() {
            return this.s.stackNextPattern;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<String> getFilterOutPatterns() {
            Scanner scanner = this.s;
            synchronized (scanner) {
                if (this.filterOut == null) {
                    this.filterOut = new ArrayList<String>();
                    if (this.s.filterOut != null) {
                        this.filterOut.addAll(this.s.filterOut);
                    }
                }
            }
            return this.filterOut;
        }
    }

    private static final class PredefinedMacroImpl
    implements ToolchainManager.PredefinedMacro {
        final String macro;
        final String flags;
        final boolean hidden;

        PredefinedMacroImpl(String macro, String flags, boolean hidden) {
            this.macro = macro;
            this.flags = flags;
            this.hidden = hidden;
        }

        @Override
        public String getMacro() {
            return this.macro;
        }

        @Override
        public boolean isHidden() {
            return this.hidden;
        }

        @Override
        public String getFlags() {
            return this.flags;
        }
    }

    private static final class CompilerDescriptorImpl
    extends ToolDescriptorImpl<Compiler>
    implements ToolchainManager.CompilerDescriptor {
        private CompilerDescriptorImpl(Compiler compiler) {
            super(compiler);
        }

        @Override
        public String getPathPattern() {
            return ((Compiler)this.tool).pathPattern;
        }

        @Override
        public String getExistFolder() {
            return ((Compiler)this.tool).existFolder;
        }

        @Override
        public String getIncludeFlags() {
            return ((Compiler)this.tool).includeFlags;
        }

        @Override
        public String getIncludeParser() {
            return ((Compiler)this.tool).includeOutputParser;
        }

        @Override
        public String getRemoveIncludePathPrefix() {
            return ((Compiler)this.tool).removeIncludePathPrefix;
        }

        @Override
        public String getRemoveIncludeOutputPrefix() {
            return ((Compiler)this.tool).removeIncludeOutputPrefix;
        }

        @Override
        public String getUserIncludeFlag() {
            return ((Compiler)this.tool).userIncludeFlag;
        }

        @Override
        public String getUserFileFlag() {
            return ((Compiler)this.tool).userFileFlag;
        }

        @Override
        public String getImportantFlags() {
            return ((Compiler)this.tool).importantFlags;
        }

        @Override
        public String getMacroFlags() {
            return ((Compiler)this.tool).macrosFlags;
        }

        @Override
        public String getMacroParser() {
            return ((Compiler)this.tool).macrosOutputParser;
        }

        @Override
        public List<ToolchainManager.PredefinedMacro> getPredefinedMacros() {
            return ((Compiler)this.tool).predefinedMacros;
        }

        @Override
        public String getUserMacroFlag() {
            return ((Compiler)this.tool).userMacroFlag;
        }

        @Override
        public String[] getDevelopmentModeFlags() {
            return ((Compiler)this.tool).developmentMode.values();
        }

        @Override
        public String[] getWarningLevelFlags() {
            return ((Compiler)this.tool).warningLevel.values();
        }

        @Override
        public String[] getArchitectureFlags() {
            return ((Compiler)this.tool).architecture.values();
        }

        @Override
        public String[] getCppStandardFlags() {
            return ((Compiler)this.tool).cppStandard.values();
        }

        @Override
        public String[] getCStandardFlags() {
            return ((Compiler)this.tool).cStandard.values();
        }

        @Override
        public String getStripFlag() {
            return ((Compiler)this.tool).strip;
        }

        @Override
        public String[] getMultithreadingFlags() {
            return ((Compiler)this.tool).multithreading.values();
        }

        @Override
        public String[] getStandardFlags() {
            return ((Compiler)this.tool).standard.values();
        }

        @Override
        public String[] getLanguageExtensionFlags() {
            return ((Compiler)this.tool).languageExtension.values();
        }

        @Override
        public String[] getLibraryFlags() {
            return ((Compiler)this.tool).library.values();
        }

        @Override
        public String getOutputObjectFileFlags() {
            return ((Compiler)this.tool).outputObjectFileFlags;
        }

        @Override
        public String getDependencyGenerationFlags() {
            return ((Compiler)this.tool).dependencyGenerationFlags;
        }

        @Override
        public String getPrecompiledHeaderFlags() {
            return ((Compiler)this.tool).precompiledHeaderFlags;
        }

        @Override
        public String getPrecompiledHeaderSuffix() {
            return ((Compiler)this.tool).precompiledHeaderSuffix;
        }

        @Override
        public boolean getPrecompiledHeaderSuffixAppend() {
            return ((Compiler)this.tool).precompiledHeaderSuffixAppend;
        }

        public String toString() {
            return "Path=" + this.getPathPattern() + " Folder=" + this.getExistFolder() + " Version=" + this.getVersionPattern();
        }
    }

    private static class ToolDescriptorImpl<T extends Tool>
    implements ToolchainManager.ToolDescriptor {
        protected final T tool;

        public ToolDescriptorImpl(T tool) {
            this.tool = tool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String[] getNames() {
            T t = this.tool;
            synchronized (t) {
                if (((Tool)this.tool).name != null && ((Tool)this.tool).name.length() > 0) {
                    return ((Tool)this.tool).name.split(",");
                }
            }
            return new String[0];
        }

        @Override
        public String getVersionFlags() {
            return ((Tool)this.tool).versionFlags;
        }

        @Override
        public String getVersionPattern() {
            return ((Tool)this.tool).versionPattern;
        }

        @Override
        public String getFingerPrintFlags() {
            return ((Tool)this.tool).fingerprintFlags;
        }

        @Override
        public String getFingerPrintPattern() {
            return ((Tool)this.tool).fingerprintPattern;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ToolchainManager.AlternativePath[] getAlternativePath() {
            T t = this.tool;
            synchronized (t) {
                if (((Tool)this.tool).alternativePath != null) {
                    return ((Tool)this.tool).alternativePath.toArray(new ToolchainManager.AlternativePath[((Tool)this.tool).alternativePath.size()]);
                }
            }
            return null;
        }

        @Override
        public boolean skipSearch() {
            return ((Tool)this.tool).skipSearch;
        }
    }

    private static class BaseFolderImpl
    implements ToolchainManager.BaseFolder {
        private final FolderInfo info;

        public BaseFolderImpl(FolderInfo info) {
            this.info = info;
        }

        @Override
        public String getFolderKey() {
            return this.info.folderKey;
        }

        @Override
        public String getFolderPattern() {
            return this.info.folderPattern;
        }

        @Override
        public String getFolderSuffix() {
            return this.info.folderSuffix;
        }

        @Override
        public String getFolderPathPattern() {
            return this.info.folderPathPattern;
        }

        @Override
        public String getRelativePath() {
            return this.info.relativePath;
        }
    }

    static final class ToolchainDescriptorImpl
    implements ToolchainManager.ToolchainDescriptor {
        final CompilerVendor v;
        private ToolchainManager.CompilerDescriptor c;
        private ToolchainManager.CompilerDescriptor cpp;
        private ToolchainManager.CompilerDescriptor fortran;
        private ToolchainManager.CompilerDescriptor assembler;
        private ToolchainManager.LinkerDescriptor linker;
        private ToolchainManager.ScannerDescriptor scanner;
        private ToolchainManager.MakeDescriptor make;
        private ToolchainManager.DebuggerDescriptor debugger;
        private ToolchainManager.QMakeDescriptor qmake;
        private ToolchainManager.CMakeDescriptor cmake;

        private ToolchainDescriptorImpl(CompilerVendor v) {
            this.v = v;
        }

        @Override
        public String getFileName() {
            return this.v.toolChainFileName;
        }

        @Override
        public String getName() {
            return this.v.toolChainName;
        }

        @Override
        public String getDisplayName() {
            return this.v.toolChainDisplay;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String[] getFamily() {
            CompilerVendor compilerVendor = this.v;
            synchronized (compilerVendor) {
                if (this.v.family != null && this.v.family.length() > 0) {
                    return this.v.family.split(",");
                }
            }
            return new String[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String[] getPlatforms() {
            CompilerVendor compilerVendor = this.v;
            synchronized (compilerVendor) {
                if (this.v.platforms != null && this.v.platforms.length() > 0) {
                    return this.v.platforms.split(",");
                }
            }
            return new String[0];
        }

        @Override
        public String getUpdateCenterUrl() {
            return this.v.uc;
        }

        @Override
        public String getUpdateCenterDisplayName() {
            return this.v.ucName;
        }

        @Override
        public String getUpgradeUrl() {
            return this.v.upgrage;
        }

        @Override
        public String getModuleID() {
            return this.v.module;
        }

        @Override
        public boolean isAbstract() {
            return this.v.isAbstract;
        }

        @Override
        public boolean isAutoDetected() {
            return this.v.isAutoDetected;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String[] getAliases() {
            CompilerVendor compilerVendor = this.v;
            synchronized (compilerVendor) {
                if (this.v.aliases != null && this.v.aliases.length() > 0) {
                    return this.v.aliases.split(",");
                }
            }
            return new String[0];
        }

        @Override
        public String getSubstitute() {
            return this.v.substitute;
        }

        @Override
        public String getDriveLetterPrefix() {
            return this.v.driveLetterPrefix;
        }

        @Override
        public String getMakefileWriter() {
            return this.v.makefileWriter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ToolchainManager.CompilerDescriptor getC() {
            CompilerVendor compilerVendor = this.v;
            synchronized (compilerVendor) {
                if (this.c == null && this.v.c.isValid()) {
                    this.c = new CompilerDescriptorImpl(this.v.c);
                }
            }
            return this.c;
        }

        @Override
        public List<ToolchainManager.BaseFolder> getBaseFolders() {
            if (this.v.baseFolder == null) {
                return null;
            }
            ArrayList<ToolchainManager.BaseFolder> res = new ArrayList<ToolchainManager.BaseFolder>(this.v.baseFolder.size());
            for (FolderInfo info : this.v.baseFolder) {
                res.add(new BaseFolderImpl(info));
            }
            return res;
        }

        @Override
        public List<ToolchainManager.BaseFolder> getCommandFolders() {
            if (this.v.commandFolder == null) {
                return null;
            }
            ArrayList<ToolchainManager.BaseFolder> res = new ArrayList<ToolchainManager.BaseFolder>(this.v.baseFolder.size());
            for (FolderInfo info : this.v.commandFolder) {
                res.add(new BaseFolderImpl(info));
            }
            return res;
        }

        @Override
        public String getQmakeSpec() {
            return this.v.qmakespec;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ToolchainManager.CompilerDescriptor getCpp() {
            CompilerVendor compilerVendor = this.v;
            synchronized (compilerVendor) {
                if (this.cpp == null && this.v.cpp.isValid()) {
                    this.cpp = new CompilerDescriptorImpl(this.v.cpp);
                }
            }
            return this.cpp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ToolchainManager.CompilerDescriptor getFortran() {
            CompilerVendor compilerVendor = this.v;
            synchronized (compilerVendor) {
                if (this.fortran == null && this.v.fortran.isValid()) {
                    this.fortran = new CompilerDescriptorImpl(this.v.fortran);
                }
            }
            return this.fortran;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ToolchainManager.CompilerDescriptor getAssembler() {
            CompilerVendor compilerVendor = this.v;
            synchronized (compilerVendor) {
                if (this.assembler == null && this.v.assembler.isValid()) {
                    this.assembler = new CompilerDescriptorImpl(this.v.assembler);
                }
            }
            return this.assembler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ToolchainManager.ScannerDescriptor getScanner() {
            CompilerVendor compilerVendor = this.v;
            synchronized (compilerVendor) {
                if (this.scanner == null) {
                    this.scanner = new ScannerDescriptorImpl(this.v.scanner);
                }
            }
            return this.scanner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ToolchainManager.LinkerDescriptor getLinker() {
            CompilerVendor compilerVendor = this.v;
            synchronized (compilerVendor) {
                if (this.linker == null) {
                    this.linker = new LinkerDescriptorImpl(this.v.linker);
                }
            }
            return this.linker;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ToolchainManager.MakeDescriptor getMake() {
            CompilerVendor compilerVendor = this.v;
            synchronized (compilerVendor) {
                if (this.make == null) {
                    this.make = new MakeDescriptorImpl(this.v.make);
                }
            }
            return this.make;
        }

        @Override
        public Map<String, List<String>> getDefaultLocations() {
            return this.v.default_locations;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ToolchainManager.DebuggerDescriptor getDebugger() {
            CompilerVendor compilerVendor = this.v;
            synchronized (compilerVendor) {
                if (this.debugger == null) {
                    this.debugger = new DebuggerDescriptorImpl(this.v.debugger);
                }
            }
            return this.debugger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ToolchainManager.QMakeDescriptor getQMake() {
            CompilerVendor compilerVendor = this.v;
            synchronized (compilerVendor) {
                if (this.qmake == null) {
                    this.qmake = new QMakeDescriptorImpl(this.v.qmake);
                }
            }
            return this.qmake;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ToolchainManager.CMakeDescriptor getCMake() {
            CompilerVendor compilerVendor = this.v;
            synchronized (compilerVendor) {
                if (this.cmake == null) {
                    this.cmake = new CMakeDescriptorImpl(this.v.cmake);
                }
            }
            return this.cmake;
        }

        public String toString() {
            return this.getName();
        }
    }

    private static final class SAXHandler
    extends DefaultHandler {
        private String path;
        private final CompilerVendor v;
        private boolean isScanerOverrided = false;
        private int version = 1;
        private final Map<String, String> cache;

        private SAXHandler(CompilerVendor v, Map<String, String> cache) {
            this.v = v;
            this.cache = cache;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            if (this.path != null) {
                this.path = this.path.equals(qName) ? null : this.path.substring(0, this.path.length() - qName.length() - 1);
            }
        }

        private String getValue(Attributes attributes, String key) {
            String res = attributes.getValue(key);
            if (res != null) {
                String c = this.cache.get(res);
                if (c == null) {
                    this.cache.put(res, res);
                } else {
                    res = c;
                }
            }
            return res;
        }

        private String getValue(String res) {
            String c = this.cache.get(res);
            if (c == null) {
                this.cache.put(res, res);
            } else {
                res = c;
            }
            return res;
        }

        @Override
        public void startElement(String uri, String lname, String name, Attributes attributes) throws SAXException {
            Compiler c;
            super.startElement(uri, lname, name, attributes);
            this.path = this.path == null ? name : this.path + "." + name;
            if (this.path.equals("toolchaindefinition")) {
                String xmlns = attributes.getValue("xmlns");
                if (xmlns != null) {
                    int lastSlash = xmlns.lastIndexOf(47);
                    if (lastSlash >= 0 && lastSlash + 1 < xmlns.length()) {
                        String versionStr = xmlns.substring(lastSlash + 1);
                        if (versionStr.length() > 0) {
                            try {
                                this.version = Integer.parseInt(versionStr);
                            }
                            catch (NumberFormatException ex) {
                                if (TRACE) {
                                    System.err.println("Incorrect version information:" + xmlns);
                                }
                            }
                        }
                    } else if (TRACE) {
                        System.err.println("Incorrect version information:" + xmlns);
                    }
                }
                return;
            }
            if (this.path.endsWith(".toolchain")) {
                this.v.toolChainName = this.getValue(attributes, "name");
                this.v.toolChainDisplay = this.getValue(attributes, "display");
                this.v.family = this.getValue(attributes, "family");
                this.v.qmakespec = this.getValue(attributes, "qmakespec");
                this.v.isAbstract = "true".equals(this.getValue(attributes, "abstract"));
                this.v.isAutoDetected = !"false".equals(this.getValue(attributes, "auto_detected"));
                this.v.aliases = this.getValue(attributes, "aliases");
                this.v.substitute = this.getValue(attributes, "substitute");
                return;
            }
            if (this.path.endsWith(".platforms")) {
                this.v.platforms = this.getValue(attributes, "stringvalue");
                return;
            }
            if (this.path.endsWith(".download")) {
                this.v.uc = this.getValue(attributes, "uc_url");
                this.v.ucName = this.getValue(attributes, "uc_display");
                this.v.module = this.getValue(attributes, "module_id");
                this.v.upgrage = this.getValue(attributes, "upgrade_url");
                return;
            }
            if (this.path.endsWith(".drive_letter_prefix")) {
                this.v.driveLetterPrefix = this.getValue(attributes, "stringvalue");
                return;
            }
            if (this.path.endsWith(".makefile_writer")) {
                this.v.makefileWriter = this.getValue(attributes, "class");
                return;
            }
            if (this.path.endsWith(".base_folders.base_folder")) {
                if (this.v.baseFolder == null) {
                    this.v.baseFolder = new ArrayList<FolderInfo>();
                }
                FolderInfo folder = new FolderInfo();
                this.v.baseFolder.add(folder);
                folder.folderKey = this.getValue(attributes, "regestry");
                folder.folderPattern = this.getValue(attributes, "pattern");
                folder.folderSuffix = this.getValue(attributes, "suffix");
                folder.folderPathPattern = this.getValue(attributes, "path_patern");
                return;
            }
            if (this.path.endsWith(".command_folders.command_folder")) {
                if (this.v.commandFolder == null) {
                    this.v.commandFolder = new ArrayList<FolderInfo>();
                }
                FolderInfo folder = new FolderInfo();
                this.v.commandFolder.add(folder);
                folder.folderKey = this.getValue(attributes, "regestry");
                folder.folderPattern = this.getValue(attributes, "pattern");
                folder.folderSuffix = this.getValue(attributes, "suffix");
                folder.folderPathPattern = this.getValue(attributes, "path_patern");
                folder.relativePath = this.getValue(attributes, "relative_path");
                return;
            }
            if (this.path.indexOf(".default_locations.") > 0) {
                if (this.path.endsWith(".platform")) {
                    String os_attr = this.getValue(attributes, "os");
                    String dir_attr = this.getValue(attributes, "directory");
                    if (os_attr != null && dir_attr != null) {
                        List<String> value;
                        if (this.v.default_locations == null) {
                            this.v.default_locations = new HashMap<String, List<String>>();
                        }
                        if ((value = this.v.default_locations.get(os_attr)) == null) {
                            value = new ArrayList<String>();
                        }
                        value.add(dir_attr);
                        this.v.default_locations.put(os_attr, value);
                    }
                }
                return;
            }
            if (this.path.indexOf(".linker.") > 0) {
                Linker l = this.v.linker;
                if (this.path.endsWith(".library_prefix")) {
                    l.library_prefix = this.getValue(attributes, "stringvalue");
                    return;
                }
                if (this.path.endsWith(".library_search")) {
                    l.librarySearchFlag = this.getValue(attributes, "flags");
                    return;
                }
                if (this.path.endsWith(".dynamic_library_search")) {
                    l.dynamicLibrarySearchFlag = this.getValue(attributes, "flags");
                    return;
                }
                if (this.path.endsWith(".library_flag")) {
                    l.libraryFlag = this.getValue(attributes, "flags");
                    return;
                }
                if (this.path.endsWith(".PIC")) {
                    l.PICFlag = this.getValue(attributes, "flags");
                    return;
                }
                if (this.path.endsWith(".static_library")) {
                    l.staticLibraryFlag = this.getValue(attributes, "flags");
                    return;
                }
                if (this.path.endsWith(".dynamic_library")) {
                    l.dynamicLibraryFlag = this.getValue(attributes, "flags");
                    return;
                }
                if (this.path.endsWith(".dynamic_library_basic")) {
                    l.dynamicLibraryBasicFlag = this.getValue(attributes, "flags");
                    return;
                }
                if (this.path.endsWith(".output_file")) {
                    l.outputFileFlag = this.getValue(attributes, "flags");
                    return;
                }
                if (this.path.endsWith(".strip_flag")) {
                    l.stripFlag = this.getValue(attributes, "flags");
                    return;
                }
                if (this.path.endsWith(".preferred_compiler")) {
                    l.preferredCompiler = this.getValue(attributes, "compiler");
                    return;
                }
                return;
            }
            if (this.path.indexOf(".make.") > 0) {
                Make m = this.v.make;
                if (this.path.endsWith(".tool")) {
                    m.name = this.getValue(attributes, "name");
                    m.skipSearch = "true".equals(this.getValue(attributes, "skip"));
                } else if (this.path.endsWith(".version")) {
                    m.versionFlags = this.getValue(attributes, "flags");
                    m.versionPattern = this.getValue(attributes, "pattern");
                } else if (this.path.endsWith(".alternative_path")) {
                    m.alternativePath = new ArrayList();
                } else if (this.path.endsWith(".dependency_support")) {
                    m.dependencySupportCode = this.getValue(this.getValue(attributes, "code").replace("\\n", "\n"));
                } else if (this.checkAlternativePath(attributes, m.alternativePath)) {
                    // empty if block
                }
                return;
            }
            if (this.path.endsWith(".debugger")) {
                this.v.debugger.id = this.getValue(attributes, "id");
                return;
            }
            if (this.path.indexOf(".debugger.") > 0) {
                Debugger d = this.v.debugger;
                if (this.path.endsWith(".tool")) {
                    d.name = this.getValue(attributes, "name");
                    d.skipSearch = "true".equals(this.getValue(attributes, "skip"));
                } else if (this.path.endsWith(".version")) {
                    d.versionFlags = this.getValue(attributes, "flags");
                    d.versionPattern = this.getValue(attributes, "pattern");
                } else if (this.path.endsWith(".alternative_path")) {
                    d.alternativePath = new ArrayList();
                } else if (this.checkAlternativePath(attributes, d.alternativePath)) {
                    // empty if block
                }
                return;
            }
            if (this.path.indexOf(".qmake.") > 0) {
                QMake d = this.v.qmake;
                if (this.path.endsWith(".tool")) {
                    d.name = this.getValue(attributes, "name");
                    d.skipSearch = "true".equals(this.getValue(attributes, "skip"));
                } else if (this.path.endsWith(".version")) {
                    d.versionFlags = this.getValue(attributes, "flags");
                    d.versionPattern = this.getValue(attributes, "pattern");
                } else if (this.path.endsWith(".alternative_path")) {
                    d.alternativePath = new ArrayList();
                } else if (this.checkAlternativePath(attributes, d.alternativePath)) {
                    // empty if block
                }
                return;
            }
            if (this.path.indexOf(".cmake.") > 0) {
                CMake d = this.v.cmake;
                if (this.path.endsWith(".tool")) {
                    d.name = this.getValue(attributes, "name");
                    d.skipSearch = "true".equals(this.getValue(attributes, "skip"));
                } else if (this.path.endsWith(".version")) {
                    d.versionFlags = this.getValue(attributes, "flags");
                    d.versionPattern = this.getValue(attributes, "pattern");
                } else if (this.path.endsWith(".alternative_path")) {
                    d.alternativePath = new ArrayList();
                } else if (this.checkAlternativePath(attributes, d.alternativePath)) {
                    // empty if block
                }
                return;
            }
            if (this.path.endsWith(".scanner")) {
                if (!this.isScanerOverrided) {
                    this.v.scanner = new Scanner();
                    this.isScanerOverrided = true;
                    this.v.scanner.id = this.getValue(attributes, "id");
                }
                return;
            }
            if (this.path.indexOf(".scanner.") > 0) {
                Scanner s = this.v.scanner;
                if (this.path.endsWith(".error")) {
                    String pattern = this.getValue(attributes, "pattern");
                    if (pattern != null) {
                        ErrorPattern e = new ErrorPattern();
                        s.patterns.add(e);
                        e.severity = this.getValue(attributes, "severity");
                        if (e.severity == null) {
                            e.severity = "error";
                        }
                        e.pattern = pattern;
                        e.language = this.getValue(attributes, "language");
                    }
                } else if (this.path.endsWith(".change_directory")) {
                    s.changeDirectoryPattern = this.getValue(attributes, "pattern");
                } else if (this.path.endsWith(".enter_directory")) {
                    s.enterDirectoryPattern = this.getValue(attributes, "pattern");
                } else if (this.path.endsWith(".leave_directory")) {
                    s.leaveDirectoryPattern = this.getValue(attributes, "pattern");
                } else if (this.path.endsWith(".stack_header")) {
                    s.stackHeaderPattern.add(this.getValue(attributes, "pattern"));
                } else if (this.path.endsWith(".stack_next")) {
                    s.stackNextPattern.add(this.getValue(attributes, "pattern"));
                } else if (this.path.endsWith(".filter_out")) {
                    String pattern = this.getValue(attributes, "pattern");
                    if (pattern != null) {
                        s.filterOut.add(pattern);
                    }
                } else if (this.path.endsWith(".making_all_in_directory")) {
                    s.makingAllInDirectoryPattern = this.getValue(attributes, "pattern");
                }
                return;
            }
            if (this.path.indexOf(".c.") > 0) {
                c = this.v.c;
            } else if (this.path.indexOf(".cpp.") > 0) {
                c = this.v.cpp;
            } else if (this.path.indexOf(".fortran.") > 0) {
                c = this.v.fortran;
            } else if (this.path.indexOf(".assembler.") > 0) {
                c = this.v.assembler;
            } else {
                return;
            }
            if (this.path.endsWith(".compiler")) {
                c.name = this.getValue(attributes, "name");
                c.skipSearch = "true".equals(this.getValue(attributes, "skip"));
                return;
            }
            if (this.path.endsWith(".recognizer")) {
                c.pathPattern = this.getValue(attributes, "pattern");
                c.existFolder = this.getValue(attributes, "or_exist_folder");
                return;
            }
            if (this.path.endsWith(".version")) {
                c.versionPattern = this.getValue(attributes, "pattern");
                c.versionFlags = this.getValue(attributes, "flags");
                c.fingerprintFlags = this.getValue(attributes, "fingerprint_flags");
                c.fingerprintPattern = this.getValue(attributes, "fingerprint_pattern");
                return;
            }
            if (this.path.endsWith(".alternative_path")) {
                c.alternativePath = new ArrayList();
                return;
            }
            if (this.checkAlternativePath(attributes, c.alternativePath)) {
                return;
            }
            if (this.path.endsWith(".system_macros.macro")) {
                if (c.predefinedMacros == null) {
                    c.predefinedMacros = new ArrayList<ToolchainManager.PredefinedMacro>();
                }
                PredefinedMacroImpl m = new PredefinedMacroImpl(this.getValue(attributes, "stringvalue"), this.getValue(attributes, "flags"), "true".equals(this.getValue(attributes, "hide")));
                c.predefinedMacros.add(m);
                return;
            }
            String flags = this.getValue(attributes, "flags");
            if (flags == null) {
                return;
            }
            boolean isDefault = "true".equals(this.getValue(attributes, "default"));
            if (this.path.endsWith(".system_include_paths")) {
                c.includeFlags = flags;
                c.includeOutputParser = this.getValue(attributes, "parser");
                c.removeIncludePathPrefix = this.getValue(attributes, "remove_in_path");
                c.removeIncludeOutputPrefix = this.getValue(attributes, "remove_in_output");
            } else if (this.path.endsWith(".user_include")) {
                c.userIncludeFlag = flags;
            } else if (this.path.endsWith(".user_file")) {
                c.userFileFlag = flags;
            } else if (this.path.endsWith(".important_flags")) {
                c.importantFlags = flags;
            } else if (this.path.endsWith(".system_macros")) {
                c.macrosFlags = flags;
                c.macrosOutputParser = this.getValue(attributes, "parser");
            } else if (this.path.endsWith(".user_macro")) {
                c.userMacroFlag = flags;
            } else if (this.path.indexOf(".development_mode.") > 0) {
                DevelopmentMode d = c.developmentMode;
                if (this.path.endsWith(".fast_build")) {
                    d.fast_build = flags;
                    if (isDefault) {
                        d.default_selection = 0;
                    }
                } else if (this.path.endsWith(".debug")) {
                    d.debug = flags;
                    if (isDefault) {
                        d.default_selection = 1;
                    }
                } else if (this.path.endsWith(".performance_debug")) {
                    d.performance_debug = flags;
                    if (isDefault) {
                        d.default_selection = 2;
                    }
                } else if (this.path.endsWith(".test_coverage")) {
                    d.test_coverage = flags;
                    if (isDefault) {
                        d.default_selection = 3;
                    }
                } else if (this.path.endsWith(".diagnosable_release")) {
                    d.diagnosable_release = flags;
                    if (isDefault) {
                        d.default_selection = 4;
                    }
                } else if (this.path.endsWith(".release")) {
                    d.release = flags;
                    if (isDefault) {
                        d.default_selection = 5;
                    }
                } else if (this.path.endsWith(".performance_release")) {
                    d.performance_release = flags;
                    if (isDefault) {
                        d.default_selection = 6;
                    }
                }
            } else if (this.path.indexOf(".warning_level.") > 0) {
                WarningLevel w = c.warningLevel;
                if (this.path.endsWith(".no_warnings")) {
                    w.no_warnings = flags;
                    if (isDefault) {
                        w.default_selection = 0;
                    }
                } else if (this.path.endsWith(".default")) {
                    w.default_level = flags;
                    if (isDefault) {
                        w.default_selection = 1;
                    }
                } else if (this.path.endsWith(".more_warnings")) {
                    w.more_warnings = flags;
                    if (isDefault) {
                        w.default_selection = 2;
                    }
                } else if (this.path.endsWith(".warning2error")) {
                    w.warning2error = flags;
                    if (isDefault) {
                        w.default_selection = 3;
                    }
                }
            } else if (this.path.indexOf(".architecture.") > 0) {
                Architecture a = c.architecture;
                if (this.path.endsWith(".default")) {
                    a.default_architecture = flags;
                    if (isDefault) {
                        a.default_selection = 0;
                    }
                } else if (this.path.endsWith(".bits_32")) {
                    a.bits_32 = flags;
                    if (isDefault) {
                        a.default_selection = 1;
                    }
                } else if (this.path.endsWith(".bits_64")) {
                    a.bits_64 = flags;
                    if (isDefault) {
                        a.default_selection = 2;
                    }
                }
            } else if (this.path.indexOf(".cpp_standard.") > 0) {
                CppStandard st = c.cppStandard;
                if (this.path.endsWith(".default")) {
                    st.cppDefault = flags;
                    if (isDefault) {
                        st.default_selection = 0;
                    }
                } else if (this.path.endsWith(".cpp98")) {
                    st.cpp98 = flags;
                    if (isDefault) {
                        st.default_selection = 1;
                    }
                } else if (this.path.endsWith(".cpp11")) {
                    st.cpp11 = flags;
                    if (isDefault) {
                        st.default_selection = 2;
                    }
                } else if (this.path.endsWith(".cpp14")) {
                    st.cpp14 = flags;
                    if (isDefault) {
                        st.default_selection = 3;
                    }
                }
            } else if (this.path.indexOf(".c_standard.") > 0) {
                CStandard st = c.cStandard;
                if (this.path.endsWith(".default")) {
                    st.cDefault = flags;
                    if (isDefault) {
                        st.default_selection = 0;
                    }
                } else if (this.path.endsWith(".c89")) {
                    st.c89 = flags;
                    if (isDefault) {
                        st.default_selection = 1;
                    }
                } else if (this.path.endsWith(".c99")) {
                    st.c99 = flags;
                    if (isDefault) {
                        st.default_selection = 2;
                    }
                } else if (this.path.endsWith(".c11")) {
                    st.c11 = flags;
                    if (isDefault) {
                        st.default_selection = 3;
                    }
                }
            } else if (this.path.endsWith(".strip")) {
                c.strip = flags;
            } else if (this.path.endsWith(".output_object_file")) {
                c.outputObjectFileFlags = flags;
            } else if (this.path.endsWith(".dependency_generation")) {
                c.dependencyGenerationFlags = flags;
            } else if (this.path.endsWith(".precompiled_header")) {
                c.precompiledHeaderFlags = flags;
                c.precompiledHeaderSuffix = this.getValue(attributes, "suffix");
                c.precompiledHeaderSuffixAppend = Boolean.valueOf(this.getValue(attributes, "append"));
            } else if (this.path.indexOf(".multithreading.") > 0) {
                MultiThreading m = c.multithreading;
                if (this.path.endsWith(".none")) {
                    m.none = flags;
                    if (isDefault) {
                        m.default_selection = 0;
                    }
                } else if (this.path.endsWith(".safe")) {
                    m.safe = flags;
                    if (isDefault) {
                        m.default_selection = 1;
                    }
                } else if (this.path.endsWith(".automatic")) {
                    m.automatic = flags;
                    if (isDefault) {
                        m.default_selection = 2;
                    }
                } else if (this.path.endsWith(".open_mp")) {
                    m.open_mp = flags;
                    if (isDefault) {
                        m.default_selection = 3;
                    }
                }
            } else if (this.path.indexOf(".standard.") > 0) {
                Standard s = c.standard;
                if (this.path.endsWith(".old")) {
                    s.old = flags;
                    if (isDefault) {
                        s.default_selection = 0;
                    }
                } else if (this.path.endsWith(".legacy")) {
                    s.legacy = flags;
                    if (isDefault) {
                        s.default_selection = 1;
                    }
                } else if (this.path.endsWith(".default")) {
                    s.default_standard = flags;
                    if (isDefault) {
                        s.default_selection = 2;
                    }
                } else if (this.path.endsWith(".modern")) {
                    s.modern = flags;
                    if (isDefault) {
                        s.default_selection = 3;
                    }
                }
            } else if (this.path.indexOf(".language_extension.") > 0) {
                LanguageExtension e = c.languageExtension;
                if (this.path.endsWith(".none")) {
                    e.none = flags;
                    if (isDefault) {
                        e.default_selection = 0;
                    }
                } else if (this.path.endsWith(".default")) {
                    e.default_extension = flags;
                    if (isDefault) {
                        e.default_selection = 1;
                    }
                } else if (this.path.endsWith(".all")) {
                    e.all = flags;
                    if (isDefault) {
                        e.default_selection = 2;
                    }
                }
            } else if (this.path.indexOf(".library.") > 0) {
                Library l = c.library;
                if (this.path.endsWith(".none")) {
                    l.none = flags;
                    if (isDefault) {
                        l.default_selection = 0;
                    }
                } else if (this.path.endsWith(".runtime")) {
                    l.runtime = flags;
                    if (isDefault) {
                        l.default_selection = 1;
                    }
                } else if (this.path.endsWith(".classic")) {
                    l.classic = flags;
                    if (isDefault) {
                        l.default_selection = 2;
                    }
                } else if (this.path.endsWith(".binary_standard")) {
                    l.binary_standard = flags;
                    if (isDefault) {
                        l.default_selection = 3;
                    }
                } else if (this.path.endsWith(".conforming_standard")) {
                    l.conforming_standard = flags;
                    if (isDefault) {
                        l.default_selection = 4;
                    }
                }
            }
        }

        private boolean checkAlternativePath(Attributes attributes, List<ToolchainManager.AlternativePath> alternativePath) {
            if (this.path.endsWith(".alternative_path.path") && alternativePath != null) {
                String s = this.getValue(attributes, "directory");
                if (s != null) {
                    alternativePath.add(new Alternative(s, ToolchainManager.AlternativePath.PathKind.PATH));
                    return true;
                }
                s = this.getValue(attributes, "toolchain_family");
                if (s != null) {
                    alternativePath.add(new Alternative(s, ToolchainManager.AlternativePath.PathKind.TOOL_FAMILY));
                    return true;
                }
                s = this.getValue(attributes, "toolchain_name");
                if (s != null) {
                    alternativePath.add(new Alternative(s, ToolchainManager.AlternativePath.PathKind.TOOL_NAME));
                    return true;
                }
                return true;
            }
            return false;
        }
    }

    static final class Library {
        String none;
        String runtime;
        String classic;
        String binary_standard;
        String conforming_standard;
        int default_selection = 0;

        Library() {
        }

        public boolean isValid() {
            return this.none != null && this.runtime != null && this.classic != null && this.binary_standard != null && this.conforming_standard != null;
        }

        public String[] values() {
            if (this.isValid()) {
                return new String[]{this.none, this.runtime, this.classic, this.binary_standard, this.conforming_standard};
            }
            return null;
        }
    }

    static final class LanguageExtension {
        String none;
        String default_extension;
        String all;
        int default_selection = 0;

        LanguageExtension() {
        }

        public boolean isValid() {
            return this.none != null && this.default_extension != null && this.all != null;
        }

        public String[] values() {
            if (this.isValid()) {
                return new String[]{this.none, this.default_extension, this.all};
            }
            return null;
        }
    }

    static final class CStandard {
        String cDefault;
        String c89;
        String c99;
        String c11;
        int default_selection = 0;

        CStandard() {
        }

        public boolean isValid() {
            return this.cDefault != null && this.c89 != null && this.c99 != null && this.c11 != null;
        }

        public String[] values() {
            if (this.isValid()) {
                return new String[]{this.cDefault, this.c89, this.c99, this.c11};
            }
            if (this.cDefault != null && this.c89 != null && this.c99 != null) {
                return new String[]{this.cDefault, this.c89, this.c99};
            }
            return null;
        }
    }

    static final class CppStandard {
        String cppDefault;
        String cpp98;
        String cpp11;
        String cpp14;
        int default_selection = 0;

        CppStandard() {
        }

        public boolean isValid() {
            return this.cppDefault != null && this.cpp98 != null && this.cpp11 != null && this.cpp14 != null;
        }

        public String[] values() {
            if (this.isValid()) {
                return new String[]{this.cppDefault, this.cpp98, this.cpp11, this.cpp14};
            }
            if (this.cppDefault != null && this.cpp98 != null && this.cpp11 != null) {
                return new String[]{this.cppDefault, this.cpp98, this.cpp11};
            }
            return null;
        }
    }

    static final class Standard {
        String old;
        String legacy;
        String default_standard;
        String modern;
        int default_selection = 0;

        Standard() {
        }

        public boolean isValid() {
            return this.old != null && this.legacy != null && this.default_standard != null && this.modern != null;
        }

        public String[] values() {
            if (this.isValid()) {
                return new String[]{this.old, this.legacy, this.default_standard, this.modern};
            }
            return null;
        }
    }

    static final class MultiThreading {
        String none;
        String safe;
        String automatic;
        String open_mp;
        int default_selection = 0;

        MultiThreading() {
        }

        public boolean isValid() {
            return this.none != null && this.safe != null && this.automatic != null && this.open_mp != null;
        }

        public String[] values() {
            if (this.isValid()) {
                return new String[]{this.none, this.safe, this.automatic, this.open_mp};
            }
            return null;
        }
    }

    static final class Architecture {
        String default_architecture;
        String bits_32;
        String bits_64;
        int default_selection = 0;

        Architecture() {
        }

        public boolean isValid() {
            return this.default_architecture != null && this.bits_32 != null && this.bits_64 != null;
        }

        public String[] values() {
            if (this.isValid()) {
                return new String[]{this.default_architecture, this.bits_32, this.bits_64};
            }
            return null;
        }
    }

    static final class WarningLevel {
        String no_warnings;
        String default_level;
        String more_warnings;
        String warning2error;
        int default_selection = 0;

        WarningLevel() {
        }

        public boolean isValid() {
            return this.no_warnings != null && this.default_level != null && this.more_warnings != null && this.warning2error != null;
        }

        public String[] values() {
            if (this.isValid()) {
                return new String[]{this.no_warnings, this.default_level, this.more_warnings, this.warning2error};
            }
            return null;
        }
    }

    static final class DevelopmentMode {
        String fast_build;
        String debug;
        String performance_debug;
        String test_coverage;
        String diagnosable_release;
        String release;
        String performance_release;
        int default_selection = 0;

        DevelopmentMode() {
        }

        public boolean isValid() {
            return this.fast_build != null && this.debug != null && this.performance_debug != null && this.test_coverage != null && this.diagnosable_release != null && this.release != null && this.performance_release != null;
        }

        public String[] values() {
            if (this.isValid()) {
                return new String[]{this.fast_build, this.debug, this.performance_debug, this.test_coverage, this.diagnosable_release, this.release, this.performance_release};
            }
            return null;
        }
    }

    static final class CMake
    extends Tool {
        CMake() {
        }
    }

    static final class QMake
    extends Tool {
        QMake() {
        }
    }

    static final class Debugger
    extends Tool {
        String id;

        Debugger() {
        }
    }

    static final class Make
    extends Tool {
        String dependencySupportCode;

        Make() {
        }
    }

    static final class Linker {
        String library_prefix;
        String librarySearchFlag;
        String dynamicLibrarySearchFlag;
        String libraryFlag;
        String PICFlag;
        String staticLibraryFlag;
        String dynamicLibraryFlag;
        String dynamicLibraryBasicFlag;
        String outputFileFlag;
        String stripFlag;
        String preferredCompiler;

        Linker() {
        }
    }

    static final class ErrorPattern {
        String pattern;
        String severity;
        String language;

        ErrorPattern() {
        }
    }

    static final class Scanner {
        String id;
        final List<ErrorPattern> patterns = new ArrayList<ErrorPattern>();
        String changeDirectoryPattern;
        String enterDirectoryPattern;
        String leaveDirectoryPattern;
        String makingAllInDirectoryPattern;
        List<String> stackHeaderPattern = new ArrayList<String>();
        List<String> stackNextPattern = new ArrayList<String>();
        final List<String> filterOut = new ArrayList<String>();

        Scanner() {
        }
    }

    public static final class Compiler
    extends Tool {
        String pathPattern;
        String existFolder;
        String includeFlags;
        String includeOutputParser;
        String removeIncludePathPrefix;
        String removeIncludeOutputPrefix;
        String userIncludeFlag;
        String userFileFlag;
        String importantFlags;
        String macrosFlags;
        String macrosOutputParser;
        String userMacroFlag;
        List<ToolchainManager.PredefinedMacro> predefinedMacros;
        String outputObjectFileFlags;
        String dependencyGenerationFlags;
        String precompiledHeaderFlags;
        String precompiledHeaderSuffix;
        boolean precompiledHeaderSuffixAppend;
        final DevelopmentMode developmentMode = new DevelopmentMode();
        final WarningLevel warningLevel = new WarningLevel();
        final Architecture architecture = new Architecture();
        String strip;
        final MultiThreading multithreading = new MultiThreading();
        final Standard standard = new Standard();
        final LanguageExtension languageExtension = new LanguageExtension();
        final CppStandard cppStandard = new CppStandard();
        final CStandard cStandard = new CStandard();
        final Library library = new Library();

        public boolean isValid() {
            return this.name != null && this.name.length() > 0;
        }
    }

    static class Alternative
    implements ToolchainManager.AlternativePath {
        final String path;
        final ToolchainManager.AlternativePath.PathKind kind;

        Alternative(String path, ToolchainManager.AlternativePath.PathKind kind) {
            this.path = path;
            this.kind = kind;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public ToolchainManager.AlternativePath.PathKind getKind() {
            return this.kind;
        }
    }

    public static class Tool {
        String name;
        String versionFlags;
        String versionPattern;
        String fingerprintFlags;
        String fingerprintPattern;
        boolean skipSearch;
        List<ToolchainManager.AlternativePath> alternativePath;
    }

    static final class FolderInfo {
        String folderKey;
        String folderPattern;
        String folderSuffix;
        String folderPathPattern;
        String relativePath;

        FolderInfo() {
        }
    }

    static final class CompilerVendor {
        final String toolChainFileName;
        final int position;
        String toolChainName;
        String toolChainDisplay;
        Map<String, List<String>> default_locations;
        String family;
        String platforms;
        String uc;
        String ucName;
        String upgrage;
        String module;
        String aliases;
        String substitute;
        boolean isAbstract;
        boolean isAutoDetected;
        String driveLetterPrefix;
        List<FolderInfo> baseFolder;
        List<FolderInfo> commandFolder;
        String qmakespec;
        String makefileWriter;
        final Compiler c = new Compiler();
        final Compiler cpp = new Compiler();
        final Compiler fortran = new Compiler();
        final Compiler assembler = new Compiler();
        Scanner scanner = new Scanner();
        final Linker linker = new Linker();
        final Make make = new Make();
        final Debugger debugger = new Debugger();
        final QMake qmake = new QMake();
        final CMake cmake = new CMake();

        private CompilerVendor(String fileName, int position) {
            this.toolChainFileName = fileName;
            this.position = position;
        }

        public boolean isValid() {
            return this.toolChainName != null && this.toolChainName.length() > 0 && (this.c.isValid() || this.cpp.isValid() || this.fortran.isValid());
        }
    }
}

