/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import javax.swing.JComponent;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.MissingHashCode;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ExportNonAccessibleElement
extends AbstractHint
implements ElementVisitor<Boolean, Void>,
TypeVisitor<Boolean, Void> {
    private static final Set<Tree.Kind> DECLARATION = EnumSet.of(Tree.Kind.ANNOTATION_TYPE, new Tree.Kind[]{Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.METHOD, Tree.Kind.VARIABLE});
    private volatile transient boolean stop;

    public ExportNonAccessibleElement() {
        super(true, true, AbstractHint.HintSeverity.WARNING, new String[0]);
    }

    public Set<Tree.Kind> getTreeKinds() {
        return DECLARATION;
    }

    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        this.stop = false;
        Element e = compilationInfo.getTrees().getElement(treePath);
        if (e == null) {
            return null;
        }
        Boolean b = e.accept(this, null);
        if (b.booleanValue()) {
            Element parent = e;
            while (true) {
                if (this.stop) {
                    return null;
                }
                if (parent == null || parent.getKind() == ElementKind.PACKAGE) break;
                if (!parent.getModifiers().contains((Object)Modifier.PUBLIC) && !parent.getModifiers().contains((Object)Modifier.PROTECTED)) {
                    return null;
                }
                parent = parent.getEnclosingElement();
            }
            int[] span = null;
            switch (treePath.getLeaf().getKind()) {
                case METHOD: {
                    span = compilationInfo.getTreeUtilities().findNameSpan((MethodTree)treePath.getLeaf());
                    break;
                }
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    span = compilationInfo.getTreeUtilities().findNameSpan((ClassTree)treePath.getLeaf());
                    break;
                }
                case VARIABLE: {
                    span = compilationInfo.getTreeUtilities().findNameSpan((VariableTree)treePath.getLeaf());
                }
            }
            if (span != null) {
                ErrorDescription ed = ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)NbBundle.getMessage(ExportNonAccessibleElement.class, (String)"MSG_ExportNonAccessibleElement"), (FileObject)compilationInfo.getFileObject(), (int)span[0], (int)span[1]);
                return Collections.singletonList(ed);
            }
        }
        return null;
    }

    public String getId() {
        return this.getClass().getName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(MissingHashCode.class, (String)"MSG_ExportNonAccessibleElement");
    }

    public String getDescription() {
        return NbBundle.getMessage(MissingHashCode.class, (String)"HINT_ExportNonAccessibleElement");
    }

    public void cancel() {
        this.stop = true;
    }

    public Preferences getPreferences() {
        return null;
    }

    public JComponent getCustomizer(Preferences node) {
        return null;
    }

    @Override
    public Boolean visit(Element arg0, Void arg1) {
        return false;
    }

    @Override
    public Boolean visit(Element arg0) {
        return false;
    }

    @Override
    public Boolean visitPackage(PackageElement arg0, Void arg1) {
        return false;
    }

    @Override
    public Boolean visitType(TypeElement arg0, Void arg1) {
        for (TypeParameterElement typeParameterElement : arg0.getTypeParameters()) {
            if (this.stop) {
                return false;
            }
            for (TypeMirror typeMirror : typeParameterElement.getBounds()) {
                if (this.stop) {
                    return false;
                }
                if (!typeMirror.accept(this, arg1).booleanValue()) continue;
                return true;
            }
        }
        TypeMirror superclass = arg0.getSuperclass();
        if (superclass.getKind() == TypeKind.DECLARED && !((DeclaredType)superclass).asElement().getKind().isInterface()) {
            return false;
        }
        return superclass.accept(this, arg1);
    }

    @Override
    public Boolean visitVariable(VariableElement field, Void arg1) {
        if (!this.isVisible(field)) {
            return false;
        }
        return field.asType().accept(this, arg1);
    }

    @Override
    public Boolean visitExecutable(ExecutableElement method, Void nothing) {
        if (!this.isVisible(method)) {
            return false;
        }
        for (VariableElement variableElement : method.getParameters()) {
            if (this.stop) {
                return false;
            }
            if (!variableElement.asType().accept(this, nothing).booleanValue()) continue;
            return true;
        }
        return method.getReturnType().accept(this, nothing);
    }

    @Override
    public Boolean visitTypeParameter(TypeParameterElement arg0, Void arg1) {
        return false;
    }

    @Override
    public Boolean visitUnknown(Element arg0, Void arg1) {
        return false;
    }

    @Override
    public Boolean visit(TypeMirror arg0, Void arg1) {
        return false;
    }

    @Override
    public Boolean visit(TypeMirror arg0) {
        return false;
    }

    @Override
    public Boolean visitPrimitive(PrimitiveType arg0, Void arg1) {
        return false;
    }

    @Override
    public Boolean visitNull(NullType arg0, Void arg1) {
        return false;
    }

    @Override
    public Boolean visitArray(ArrayType arg0, Void arg1) {
        return arg0.getComponentType().accept(this, arg1);
    }

    @Override
    public Boolean visitDeclared(DeclaredType arg0, Void arg1) {
        if (!this.isVisible(arg0.asElement())) {
            return true;
        }
        for (TypeMirror typeMirror : arg0.getTypeArguments()) {
            if (this.stop) {
                return false;
            }
            if (!typeMirror.accept(this, arg1).booleanValue()) continue;
            return true;
        }
        return arg0.getEnclosingType().accept(this, arg1);
    }

    @Override
    public Boolean visitError(ErrorType arg0, Void arg1) {
        return false;
    }

    @Override
    public Boolean visitTypeVariable(TypeVariable arg0, Void arg1) {
        return arg0.getLowerBound().accept(this, arg1) != false && arg0.getUpperBound().accept(this, arg1) != false;
    }

    @Override
    public Boolean visitWildcard(WildcardType wild, Void arg1) {
        TypeMirror eb = wild.getExtendsBound();
        TypeMirror sb = wild.getSuperBound();
        return eb != null && eb.accept(this, arg1) != false || sb != null && sb.accept(this, arg1) != false;
    }

    @Override
    public Boolean visitExecutable(ExecutableType arg0, Void arg1) {
        return false;
    }

    @Override
    public Boolean visitNoType(NoType arg0, Void arg1) {
        return false;
    }

    @Override
    public Boolean visitUnknown(TypeMirror arg0, Void arg1) {
        return false;
    }

    @Override
    public Boolean visitIntersection(IntersectionType t, Void p) {
        return false;
    }

    private boolean isVisible(Element ... arr) {
        return this.isVisible(Arrays.asList(arr));
    }

    private boolean isVisible(Collection<? extends Element> arr) {
        for (Element element : arr) {
            if (this.stop) {
                return false;
            }
            if (element == null || !element.getModifiers().contains((Object)Modifier.PUBLIC) && (!element.getModifiers().contains((Object)Modifier.PROTECTED) || element.getEnclosingElement() == null || !element.getEnclosingElement().getKind().isClass() && !element.getEnclosingElement().getKind().isInterface() || element.getEnclosingElement().getModifiers().contains((Object)Modifier.FINAL))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visitUnion(UnionType tm, Void p) {
        for (TypeMirror typeMirror : tm.getAlternatives()) {
            if (this.stop) {
                return false;
            }
            if (!typeMirror.accept(this, p).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static final class FixImpl
    implements Fix {
        private TreePathHandle handle;
        private FileObject file;
        private String msg;

        public FixImpl(String type, TreePathHandle handle, FileObject file) {
            this.handle = handle;
            this.file = file;
            this.msg = type;
        }

        public String getText() {
            return NbBundle.getMessage(MissingHashCode.class, (String)this.msg);
        }

        public ChangeInfo implement() throws IOException {
            ModificationResult result = JavaSource.forFileObject((FileObject)this.file).runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy wc) throws Exception {
                    wc.toPhase(JavaSource.Phase.RESOLVED);
                    Element e = FixImpl.this.handle.resolveElement((CompilationInfo)wc);
                    Tree t = wc.getTrees().getTree(e);
                    if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)t.getKind())) {
                        ClassTree ct = (ClassTree)t;
                        HashSet<Modifier> flags = new HashSet<Modifier>(ct.getModifiers().getFlags());
                        flags.remove((Object)Modifier.PUBLIC);
                        flags.remove((Object)Modifier.PROTECTED);
                        ModifiersTree mt = wc.getTreeMaker().Modifiers(flags, ct.getModifiers().getAnnotations());
                        wc.rewrite((Tree)ct.getModifiers(), (Tree)mt);
                        return;
                    }
                    if (t.getKind() == Tree.Kind.METHOD) {
                        MethodTree mt = (MethodTree)t;
                        HashSet<Modifier> flags = new HashSet<Modifier>(mt.getModifiers().getFlags());
                        flags.remove((Object)Modifier.PUBLIC);
                        flags.remove((Object)Modifier.PROTECTED);
                        ModifiersTree modt = wc.getTreeMaker().Modifiers(flags, mt.getModifiers().getAnnotations());
                        wc.rewrite((Tree)mt.getModifiers(), (Tree)modt);
                        return;
                    }
                    if (t.getKind() == Tree.Kind.VARIABLE) {
                        VariableTree vt = (VariableTree)t;
                        HashSet<Modifier> flags = new HashSet<Modifier>(vt.getModifiers().getFlags());
                        flags.remove((Object)Modifier.PUBLIC);
                        flags.remove((Object)Modifier.PROTECTED);
                        ModifiersTree modt = wc.getTreeMaker().Modifiers(flags, vt.getModifiers().getAnnotations());
                        wc.rewrite((Tree)vt.getModifiers(), (Tree)modt);
                        return;
                    }
                }
            });
            result.commit();
            return null;
        }

        public String toString() {
            return "FixExportNonAccessibleElement";
        }
    }
}

