/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.bugs.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;

public class TryCatchFinally {
    private static final Logger LOG = Logger.getLogger(TryCatchFinally.class.getName());

    public static List<ErrorDescription> finallyThrowsException(HintContext ctx) {
        ArrayList trees = new ArrayList(3);
        ExitsFromBranches efab = new ExitsFromBranches(ctx.getInfo(), true);
        Collection paths = (Collection)ctx.getMultiVariables().get("$handler$");
        for (TreePath tp : paths) {
            efab.scan(tp, trees);
        }
        if (trees.isEmpty()) {
            return null;
        }
        ArrayList<ErrorDescription> errs = new ArrayList<ErrorDescription>(trees.size());
        for (Tree stmt : trees) {
            errs.add(ErrorDescriptionFactory.forTree((HintContext)ctx, (Tree)stmt, (String)Bundle.TEXT_throwsInFinallyBlock(), (Fix[])new Fix[0]));
        }
        return errs;
    }

    public static List<ErrorDescription> finallyDiscardsException(HintContext ctx) {
        ArrayList trees = new ArrayList(3);
        ExitsFromBranches efab = new ExitsFromBranches(ctx.getInfo());
        Collection paths = (Collection)ctx.getMultiVariables().get("$handler$");
        for (TreePath tp : paths) {
            efab.scan(tp, trees);
        }
        if (trees.isEmpty()) {
            return null;
        }
        ArrayList<ErrorDescription> errs = new ArrayList<ErrorDescription>(trees.size());
        block6: for (Tree stmt : trees) {
            String stmtName;
            switch (stmt.getKind()) {
                case CONTINUE: {
                    stmtName = "continue";
                    break;
                }
                case BREAK: {
                    stmtName = "break";
                    break;
                }
                case RETURN: {
                    stmtName = "return";
                    break;
                }
                default: {
                    LOG.log(Level.WARNING, "Unexpected statement kind: {0}", (Object)stmt.getKind());
                    continue block6;
                }
            }
            errs.add(ErrorDescriptionFactory.forTree((HintContext)ctx, (Tree)stmt, (String)Bundle.TEXT_returnBreakContinueInFinallyBlock(stmtName), (Fix[])new Fix[0]));
        }
        return errs;
    }

    private static final class ExitsFromBranches
    extends TreePathScanner<Void, Collection<Tree>> {
        private final boolean analyzeThrows;
        private final CompilationInfo info;
        private final Set<Tree> seenTrees = new HashSet<Tree>();
        private final Stack<Set<TypeMirror>> caughtExceptions = new Stack();

        public ExitsFromBranches(CompilationInfo info, boolean analyzeThrows) {
            this.info = info;
            this.analyzeThrows = analyzeThrows;
        }

        public ExitsFromBranches(CompilationInfo info) {
            this.info = info;
            this.analyzeThrows = false;
        }

        @Override
        public Void scan(Tree tree, Collection<Tree> trees) {
            this.seenTrees.add(tree);
            return (Void)super.scan(tree, trees);
        }

        @Override
        public Void visitLabeledStatement(LabeledStatementTree node, Collection<Tree> p) {
            this.seenTrees.add(node);
            return (Void)super.visitLabeledStatement(node, p);
        }

        @Override
        public Void visitIf(IfTree node, Collection<Tree> trees) {
            this.scan((Tree)node.getThenStatement(), trees);
            this.scan((Tree)node.getElseStatement(), trees);
            return null;
        }

        @Override
        public Void visitReturn(ReturnTree node, Collection<Tree> trees) {
            if (!this.analyzeThrows) {
                trees.add(node);
            }
            return null;
        }

        @Override
        public Void visitBreak(BreakTree node, Collection<Tree> trees) {
            if (!this.analyzeThrows && !this.seenTrees.contains(this.info.getTreeUtilities().getBreakContinueTarget(this.getCurrentPath()))) {
                trees.add(node);
            }
            return null;
        }

        @Override
        public Void visitContinue(ContinueTree node, Collection<Tree> trees) {
            if (!this.analyzeThrows && !this.seenTrees.contains(this.info.getTreeUtilities().getBreakContinueTarget(this.getCurrentPath()))) {
                trees.add(node);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void visitTry(TryTree node, Collection<Tree> trees) {
            HashSet<TypeMirror> caught = new HashSet<TypeMirror>();
            for (CatchTree catchTree : node.getCatches()) {
                TypeMirror t = this.info.getTrees().getTypeMirror(new TreePath(new TreePath(this.getCurrentPath(), catchTree), catchTree.getParameter()));
                if (t == null) continue;
                caught.add(t);
            }
            this.caughtExceptions.push(caught);
            try {
                this.scan((Tree)node.getBlock(), trees);
                this.scan((Tree)node.getFinallyBlock(), trees);
            }
            finally {
                this.caughtExceptions.pop();
            }
            return null;
        }

        @Override
        public Void visitThrow(ThrowTree node, Collection<Tree> trees) {
            if (!this.analyzeThrows) {
                return null;
            }
            TypeMirror type = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), node.getExpression()));
            boolean isCaught = false;
            block0: for (Set set : this.caughtExceptions) {
                for (TypeMirror c : set) {
                    if (!this.info.getTypes().isSubtype(type, c)) continue;
                    isCaught = true;
                    break block0;
                }
            }
            super.visitThrow(node, trees);
            if (!isCaught) {
                trees.add(node);
            }
            return null;
        }
    }
}

