/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.java.hints.errors.Bundle;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;

public class AccessError
implements ErrorRule<Void> {
    private static final Set<String> CODES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("compiler.err.report.access")));

    public Set<String> getCodes() {
        return CODES;
    }

    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        Element outtermostClassEl;
        Element el = info.getTrees().getElement(treePath);
        if (el == null || el.asType().getKind() == TypeKind.ERROR) {
            return null;
        }
        if (el.getEnclosingElement() == null || !el.getEnclosingElement().getKind().isClass() && !el.getEnclosingElement().getKind().isInterface()) {
            return null;
        }
        TypeElement targetEnclosing = (TypeElement)el.getEnclosingElement();
        if (!Utilities.isTargetWritable(targetEnclosing, info)) {
            return null;
        }
        TreePath outtermostClassPath = null;
        for (TreePath up = treePath; up != null; up = up.getParentPath()) {
            if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)up.getLeaf().getKind())) continue;
            outtermostClassPath = up;
        }
        Element element = outtermostClassEl = outtermostClassPath != null ? info.getTrees().getElement(outtermostClassPath) : null;
        if (outtermostClassEl == null || !outtermostClassEl.getKind().isClass() && !outtermostClassEl.getKind().isInterface()) {
            return null;
        }
        TypeElement outtermostClass = (TypeElement)outtermostClassEl;
        Utilities.Visibility newVisibility = Utilities.getAccessModifiers(info, outtermostClass, targetEnclosing);
        if (newVisibility.ordinal() <= Utilities.Visibility.forElement(el).ordinal() || newVisibility == Utilities.Visibility.PRIVATE) {
            return null;
        }
        return Collections.singletonList(new FixImpl(info, el, newVisibility).toEditorFix());
    }

    public String getId() {
        return AccessError.class.getName();
    }

    public String getDisplayName() {
        return Bundle.DN_AccessError();
    }

    public void cancel() {
    }

    private static final class FixImpl
    extends JavaFix {
        private final Utilities.Visibility newVisibility;
        private final String elementDisplayName;

        public FixImpl(CompilationInfo info, Element el, Utilities.Visibility newVisibility) {
            super(TreePathHandle.create((Element)el, (CompilationInfo)info));
            this.newVisibility = newVisibility;
            this.elementDisplayName = el.getSimpleName().toString();
        }

        protected String getText() {
            String key = "FIX_AccessError_" + this.newVisibility.name();
            return NbBundle.getMessage(FixImpl.class, (String)key, (Object)this.elementDisplayName);
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            ModifiersTree mods;
            Tree el = ctx.getPath().getLeaf();
            switch (el.getKind()) {
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    mods = ((ClassTree)el).getModifiers();
                    break;
                }
                case METHOD: {
                    mods = ((MethodTree)el).getModifiers();
                    break;
                }
                case VARIABLE: {
                    mods = ((VariableTree)el).getModifiers();
                    break;
                }
                default: {
                    throw new IllegalStateException(el.getKind().name());
                }
            }
            TreeMaker make = ctx.getWorkingCopy().getTreeMaker();
            ModifiersTree result = mods;
            result = make.removeModifiersModifier(result, Modifier.PUBLIC);
            result = make.removeModifiersModifier(result, Modifier.PROTECTED);
            result = make.removeModifiersModifier(result, Modifier.PRIVATE);
            for (Modifier m : this.newVisibility.getRequiredModifiers()) {
                result = make.addModifiersModifier(result, m);
            }
            ctx.getWorkingCopy().rewrite((Tree)mods, (Tree)result);
        }
    }
}

