/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.errors.AddCastFix;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public final class AddCast
implements ErrorRule<Void> {
    private static final Set<String> ERROR_CODES = new HashSet<String>(Arrays.asList("compiler.err.prob.found.req", "compiler.err.cant.apply.symbol", "compiler.err.cant.apply.symbol.1", "compiler.err.cant.resolve.location.args", "compiler.err.cant.apply.symbols", "compiler.err.prob.found.req/compiler.misc.incompatible.ret.type.in.lambda/compiler.misc.inconvertible.types"));

    static void computeType(CompilationInfo info, int offset, List<TypeMirror> targetType, TreePath[] typeTree, ExpressionTree[] expression, Tree[] leaf) {
        TreePath path;
        int start = (int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), path.getLeaf());
        for (path = info.getTreeUtilities().pathFor(offset + 1); path != null; path = path.getParentPath()) {
            LambdaExpressionTree let;
            int[] index;
            ArrayList<TypeMirror> proposed;
            Tree scope = path.getLeaf();
            List<TypeMirror> expected = null;
            TreePath expectedTree = null;
            TypeMirror resolved = null;
            ExpressionTree found = null;
            if (scope.getKind() == Tree.Kind.VARIABLE && ((VariableTree)scope).getInitializer() != null) {
                expected = Collections.singletonList(info.getTrees().getTypeMirror(path));
                expectedTree = new TreePath(path, ((VariableTree)scope).getType());
                found = ((VariableTree)scope).getInitializer();
                resolved = info.getTrees().getTypeMirror(new TreePath(path, found));
            }
            if (scope.getKind() == Tree.Kind.ASSIGNMENT) {
                expected = Collections.singletonList(info.getTrees().getTypeMirror(path));
                found = ((AssignmentTree)scope).getExpression();
                resolved = info.getTrees().getTypeMirror(new TreePath(path, found));
            }
            if (scope.getKind() == Tree.Kind.RETURN) {
                TreePath parents;
                for (parents = path; parents != null && parents.getLeaf().getKind() != Tree.Kind.METHOD && parents.getLeaf().getKind() != Tree.Kind.LAMBDA_EXPRESSION; parents = parents.getParentPath()) {
                }
                if (parents != null) {
                    ExecutableType executableType;
                    TypeMirror lambdaType;
                    Tree p = parents.getLeaf();
                    TypeMirror returnType = null;
                    if (p.getKind() == Tree.Kind.METHOD) {
                        Tree returnTypeTree = ((MethodTree)parents.getLeaf()).getReturnType();
                        if (returnTypeTree != null) {
                            returnType = info.getTrees().getTypeMirror(new TreePath(parents, returnTypeTree));
                        }
                    } else if (p.getKind() == Tree.Kind.LAMBDA_EXPRESSION && Utilities.isValidType(lambdaType = info.getTrees().getTypeMirror(parents)) && lambdaType.getKind() == TypeKind.DECLARED && (executableType = info.getTypeUtilities().getDescriptorType((DeclaredType)lambdaType)) != null && Utilities.isValidType(executableType.getReturnType()) && executableType.getReturnType().getKind() != TypeKind.VOID) {
                        returnType = executableType.getReturnType();
                    }
                    if (returnType != null && (found = ((ReturnTree)scope).getExpression()) != null) {
                        expected = Collections.singletonList(returnType);
                        resolved = info.getTrees().getTypeMirror(new TreePath(path, found));
                    }
                }
            }
            if (!(scope.getKind() != Tree.Kind.METHOD_INVOCATION && scope.getKind() != Tree.Kind.NEW_CLASS || org.netbeans.modules.editor.java.Utilities.fuzzyResolveMethodInvocation((CompilationInfo)info, (TreePath)path, proposed = new ArrayList<TypeMirror>(), (int[])(index = new int[1])).isEmpty())) {
                expected = proposed;
                found = scope.getKind() == Tree.Kind.METHOD_INVOCATION ? ((MethodInvocationTree)scope).getArguments().get(index[0]) : ((NewClassTree)scope).getArguments().get(index[0]);
                resolved = info.getTrees().getTypeMirror(new TreePath(path, found));
            }
            if (scope.getKind() == Tree.Kind.LAMBDA_EXPRESSION && (let = (LambdaExpressionTree)scope).getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
                Element el;
                TypeMirror expIfaceType = info.getTrees().getTypeMirror(path);
                if (expIfaceType != null && expIfaceType.getKind() == TypeKind.DECLARED && (el = info.getTypes().asElement(expIfaceType)) != null && (el.getKind().isClass() || el.getKind().isInterface())) {
                    for (Element element : el.getEnclosedElements()) {
                        if (element.getKind() != ElementKind.METHOD) continue;
                        TypeMirror t = info.getTypes().asMemberOf((DeclaredType)expIfaceType, element);
                        if (t.getKind() != TypeKind.EXECUTABLE) break;
                        expected = Collections.singletonList(((ExecutableType)t).getReturnType());
                        break;
                    }
                }
                found = (ExpressionTree)let.getBody();
                resolved = info.getTrees().getTypeMirror(new TreePath(path, found));
            }
            if (expected != null && resolved != null) {
                TypeMirror foundTM = info.getTrees().getTypeMirror(new TreePath(path, found));
                if (foundTM.getKind() == TypeKind.ERROR) {
                    foundTM = info.getTrees().getOriginalType((ErrorType)foundTM);
                }
                if (resolved.getKind() == TypeKind.ERROR) {
                    resolved = info.getTrees().getOriginalType((ErrorType)resolved);
                }
                if (foundTM.getKind() != TypeKind.EXECUTABLE && foundTM.getKind() != TypeKind.PACKAGE && foundTM.getKind() != TypeKind.NONE && foundTM.getKind() != TypeKind.OTHER) {
                    targetType.clear();
                    for (TypeMirror expectedType : expected) {
                        if (!Utilities.isValidType(expectedType) || !info.getTypeUtilities().isCastable(resolved, expectedType) || info.getTypes().isAssignable(foundTM, expectedType) || foundTM.getKind() == TypeKind.ERROR || expectedType.getKind() == TypeKind.ERROR) continue;
                        targetType.add(Utilities.resolveCapturedType(info, expectedType));
                        typeTree[0] = expectedTree;
                        expression[0] = found;
                        leaf[0] = scope;
                    }
                }
            }
            if (info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), scope) < (long)start && scope.getKind() != Tree.Kind.PARENTHESIZED) break;
        }
    }

    public Set<String> getCodes() {
        return ERROR_CODES;
    }

    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        ArrayList<Fix> result = new ArrayList<Fix>();
        ArrayList<TypeMirror> targetType = new ArrayList<TypeMirror>();
        TreePath[] tmTree = new TreePath[1];
        ExpressionTree[] expression = new ExpressionTree[1];
        Tree[] leaf = new Tree[1];
        AddCast.computeType(info, offset, targetType, tmTree, expression, leaf);
        if (!targetType.isEmpty()) {
            TreePath expressionPath = TreePath.getPath(info.getCompilationUnit(), (Tree)expression[0]);
            for (TypeMirror type : targetType) {
                if (type.getKind() == TypeKind.NULL) continue;
                result.add(new AddCastFix(info, expressionPath, tmTree[0], type).toEditorFix());
            }
        }
        return result;
    }

    public void cancel() {
    }

    public String getId() {
        return AddCast.class.getName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(AddCast.class, (String)"LBL_Add_Cast");
    }

    public String getDescription() {
        return NbBundle.getMessage(AddCast.class, (String)"DSC_Add_Cast");
    }
}

