/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.infrastructure.ErrorHintsProvider;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.EnhancedFix;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public abstract class CreateClassFix
implements EnhancedFix {
    protected Set<Modifier> modifiers;
    protected List<TypeMirrorHandle> argumentTypes;
    protected List<String> argumentNames;
    private Integer prio;
    private List<TypeMirrorHandle> superTypes;
    protected ElementKind kind;
    private int numTypeParameters;
    protected List<? extends TypeMirror> argumentTypeMirrors;

    public CreateClassFix(CompilationInfo info, Set<Modifier> modifiers, List<? extends TypeMirror> argumentTypes, List<String> argumentNames, TypeMirror superType, ElementKind kind, int numTypeParameters) {
        this.modifiers = modifiers;
        if (argumentTypes != null && argumentNames != null) {
            this.argumentTypes = new ArrayList<TypeMirrorHandle>();
            this.argumentTypeMirrors = argumentTypes;
            for (TypeMirror typeMirror : argumentTypes) {
                this.argumentTypes.add(TypeMirrorHandle.create((TypeMirror)typeMirror));
            }
            this.argumentNames = argumentNames;
        }
        if (superType != null) {
            this.superTypes = new LinkedList<TypeMirrorHandle>();
            if (superType.getKind() == TypeKind.INTERSECTION) {
                for (TypeMirror typeMirror : info.getTypes().directSupertypes(superType)) {
                    this.superTypes.add(TypeMirrorHandle.create((TypeMirror)typeMirror));
                }
            } else {
                this.superTypes.add(TypeMirrorHandle.create((TypeMirror)superType));
            }
        }
        this.kind = kind;
        this.numTypeParameters = numTypeParameters;
    }

    /*
     * WARNING - void declaration
     */
    protected ClassTree createConstructor(WorkingCopy working, TreePath targetTreePath) {
        boolean removeDefaultConstructor;
        TreeMaker make = working.getTreeMaker();
        ClassTree targetTree = (ClassTree)targetTreePath.getLeaf();
        boolean bl = removeDefaultConstructor = this.kind == ElementKind.INTERFACE || this.kind == ElementKind.ANNOTATION_TYPE;
        if (this.argumentNames != null) {
            ArrayList<VariableTree> argTypes = new ArrayList<VariableTree>();
            Iterator<TypeMirrorHandle> iterator = this.argumentTypes.iterator();
            Iterator<String> nameIt = this.argumentNames.iterator();
            while (iterator.hasNext() && nameIt.hasNext()) {
                TypeMirrorHandle tmh = iterator.next();
                String argName = nameIt.next();
                argTypes.add(make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)argName, make.Type(tmh.resolve((CompilationInfo)working)), null));
            }
            MethodTree constr = make.Method(make.Modifiers(EnumSet.of(Modifier.PUBLIC)), (CharSequence)"<init>", null, Collections.emptyList(), argTypes, Collections.emptyList(), "{}", null);
            targetTree = GeneratorUtilities.get((WorkingCopy)working).insertClassMember(targetTree, (Tree)constr);
            removeDefaultConstructor = true;
        }
        if (removeDefaultConstructor) {
            for (Tree tree : targetTree.getMembers()) {
                MethodTree mt;
                if (tree.getKind() != Tree.Kind.METHOD || !"<init>".equals((mt = (MethodTree)tree).getName().toString()) || mt.getParameters().size() != 0) continue;
                targetTree = make.removeClassMember(targetTree, (Tree)mt);
                break;
            }
        }
        Tree extendsClause = null;
        List list = Collections.emptyList();
        if (this.superTypes != null) {
            DeclaredType extendsType = null;
            LinkedList<DeclaredType> implementsTypes = new LinkedList<DeclaredType>();
            for (TypeMirrorHandle h : this.superTypes) {
                TypeMirror tm = h.resolve((CompilationInfo)working);
                if (tm == null || tm.getKind() != TypeKind.DECLARED) continue;
                DeclaredType dt = (DeclaredType)tm;
                if (dt.asElement().getKind().isClass()) {
                    if (extendsType != null) {
                        // empty if block
                    }
                    extendsType = dt;
                    continue;
                }
                implementsTypes.add(dt);
            }
            if (extendsType != null && !"java.lang.Object".equals(((TypeElement)extendsType.asElement()).getQualifiedName().toString())) {
                extendsClause = make.Type((TypeMirror)extendsType);
            }
            if (!implementsTypes.isEmpty()) {
                LinkedList<Tree> linkedList = new LinkedList<Tree>();
                for (DeclaredType dt : implementsTypes) {
                    linkedList.add(make.Type((TypeMirror)dt));
                }
            }
        }
        ModifiersTree nueModifiers = make.Modifiers(this.modifiers);
        LinkedList<TypeParameterTree> typeParameters = new LinkedList<TypeParameterTree>();
        for (int cntr = 0; cntr < this.numTypeParameters; ++cntr) {
            typeParameters.add(make.TypeParameter((CharSequence)(this.numTypeParameters == 1 ? "T" : "T" + cntr), Collections.emptyList()));
        }
        switch (this.kind) {
            case CLASS: {
                void var7_12;
                return make.Class(nueModifiers, (CharSequence)targetTree.getSimpleName(), typeParameters, extendsClause, (List)var7_12, targetTree.getMembers());
            }
            case INTERFACE: {
                void var7_12;
                return make.Interface(nueModifiers, (CharSequence)targetTree.getSimpleName(), typeParameters, (List)var7_12, targetTree.getMembers());
            }
            case ANNOTATION_TYPE: {
                return make.AnnotationType(nueModifiers, (CharSequence)targetTree.getSimpleName(), targetTree.getMembers());
            }
            case ENUM: {
                void var7_12;
                return make.Enum(nueModifiers, (CharSequence)targetTree.getSimpleName(), (List)var7_12, targetTree.getMembers());
            }
        }
        assert (false) : this.kind;
        return null;
    }

    private static int valueForBundle(ElementKind kind) {
        switch (kind) {
            case CLASS: {
                return 0;
            }
            case INTERFACE: {
                return 1;
            }
            case ENUM: {
                return 2;
            }
            case ANNOTATION_TYPE: {
                return 3;
            }
        }
        assert (false) : kind;
        return 0;
    }

    public abstract String toDebugString(CompilationInfo var1);

    protected void setPriority(Integer prio) {
        this.prio = prio;
    }

    public CharSequence getSortText() {
        if (null == this.prio) {
            return this.getText();
        }
        return String.format("%04d-%s", this.prio, this.getText());
    }

    static final class CreateInnerClassFix
    extends CreateClassFix {
        private FileObject targetFile;
        private ElementHandle<TypeElement> target;
        private ClasspathInfo cpInfo;
        private String name;
        private String inFQN;

        public CreateInnerClassFix(CompilationInfo info, String name, Set<Modifier> modifiers, TypeElement target, List<? extends TypeMirror> argumentTypes, List<String> argumentNames, TypeMirror superType, ElementKind kind, int numTypeParameters, FileObject targetFile) {
            super(info, modifiers, argumentTypes, argumentNames, superType, kind, numTypeParameters);
            this.name = name;
            this.target = ElementHandle.create((Element)target);
            this.inFQN = Utilities.target2String(target);
            this.cpInfo = info.getClasspathInfo();
            this.targetFile = targetFile;
        }

        public String getText() {
            return NbBundle.getMessage(CreateClassFix.class, (String)"FIX_CreateInnerClass", (Object)this.name, (Object)this.inFQN, (Object)CreateClassFix.valueForBundle(this.kind));
        }

        public ChangeInfo implement() throws Exception {
            JavaSource js = JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[]{this.targetFile});
            ModificationResult diff = js.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy working) throws IOException {
                    working.toPhase(JavaSource.Phase.RESOLVED);
                    TypeElement targetType = (TypeElement)CreateInnerClassFix.this.target.resolve((CompilationInfo)working);
                    if (targetType == null) {
                        ErrorHintsProvider.LOG.log(Level.INFO, "Cannot resolve target.");
                        return;
                    }
                    TreePath targetTree = working.getTrees().getPath(targetType);
                    if (targetTree == null) {
                        ErrorHintsProvider.LOG.log(Level.INFO, "Cannot resolve target tree: " + targetType.getQualifiedName() + ".");
                        return;
                    }
                    TreeMaker make = working.getTreeMaker();
                    MethodTree constr = make.Method(make.Modifiers(EnumSet.of(Modifier.PUBLIC)), (CharSequence)"<init>", null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "{}", null);
                    ClassTree innerClass = make.Class(make.Modifiers(CreateInnerClassFix.this.modifiers), (CharSequence)CreateInnerClassFix.this.name, Collections.emptyList(), null, Collections.emptyList(), Collections.singletonList(constr));
                    innerClass = CreateInnerClassFix.this.createConstructor(working, new TreePath(targetTree, innerClass));
                    working.rewrite(targetTree.getLeaf(), (Tree)GeneratorUtilities.get((WorkingCopy)working).insertClassMember((ClassTree)targetTree.getLeaf(), (Tree)innerClass));
                }
            });
            return Utilities.commitAndComputeChangeInfo(this.targetFile, diff, null);
        }

        @Override
        public String toDebugString(CompilationInfo info) {
            return "CreateInnerClass:" + this.inFQN + "." + this.name + ":" + this.modifiers.toString() + ":" + (Object)((Object)this.kind);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CreateInnerClassFix other = (CreateInnerClassFix)obj;
            if (!(this.name == other.name || this.name != null && this.name.equals(other.name))) {
                return false;
            }
            if (!(this.inFQN == other.inFQN || this.inFQN != null && this.inFQN.equals(other.inFQN))) {
                return false;
            }
            if ((this.argumentTypeMirrors == null || this.argumentTypeMirrors.isEmpty()) && (other.argumentTypeMirrors == null || other.argumentTypeMirrors.isEmpty())) {
                return true;
            }
            return this.argumentTypeMirrors == other.argumentTypeMirrors || this.argumentTypeMirrors != null && this.argumentTypeMirrors.equals(other.argumentTypeMirrors);
        }

        public int hashCode() {
            int hash = 7;
            hash = 53 * hash + (this.name != null ? this.name.hashCode() : 0);
            hash = 53 * hash + (this.inFQN != null ? this.inFQN.hashCode() : 0);
            return hash;
        }
    }

    static final class CreateOuterClassFix
    extends CreateClassFix {
        private FileObject targetSourceRoot;
        private String packageName;
        private String rootName;
        private String simpleName;

        public CreateOuterClassFix(CompilationInfo info, FileObject targetSourceRoot, String packageName, String simpleName, Set<Modifier> modifiers, List<? extends TypeMirror> argumentTypes, List<String> argumentNames, TypeMirror superType, ElementKind kind, int numTypeParameters, String rootName) {
            super(info, modifiers, argumentTypes, argumentNames, superType, kind, numTypeParameters);
            this.targetSourceRoot = targetSourceRoot;
            this.packageName = packageName;
            this.simpleName = simpleName;
            this.rootName = rootName;
        }

        public String getText() {
            if (this.argumentNames == null || this.argumentNames.isEmpty()) {
                return NbBundle.getMessage(CreateClassFix.class, (String)"FIX_CreateClassInPackage", (Object)this.simpleName, (Object)this.packageName, (Object)CreateClassFix.valueForBundle(this.kind), (Object)this.rootName, (Object[])new Object[0]);
            }
            StringBuilder buf = new StringBuilder();
            for (TypeMirror tm : this.argumentTypeMirrors) {
                buf.append(tm.toString());
                buf.append(",");
            }
            String ctorParams = buf.toString();
            Object[] params = new Object[]{this.simpleName, this.packageName, CreateClassFix.valueForBundle(this.kind), ctorParams.substring(0, ctorParams.length() - 1), this.rootName};
            return NbBundle.getMessage(CreateClassFix.class, (String)"FIX_CreateClassAndCtorInPackage", (Object[])params);
        }

        private static String template(ElementKind kind) {
            switch (kind) {
                case CLASS: {
                    return "Templates/Classes/Class.java";
                }
                case INTERFACE: {
                    return "Templates/Classes/Interface.java";
                }
                case ANNOTATION_TYPE: {
                    return "Templates/Classes/AnnotationType.java";
                }
                case ENUM: {
                    return "Templates/Classes/Enum.java";
                }
            }
            throw new IllegalStateException();
        }

        public ChangeInfo implement() throws IOException {
            FileObject target;
            FileObject pack = FileUtil.createFolder((FileObject)this.targetSourceRoot, (String)this.packageName.replace('.', '/'));
            FileObject classTemplate = FileUtil.getConfigFile((String)CreateOuterClassFix.template(this.kind));
            if (classTemplate != null) {
                DataObject classTemplateDO = DataObject.find((FileObject)classTemplate);
                DataObject od = classTemplateDO.createFromTemplate(DataFolder.findFolder((FileObject)pack), this.simpleName);
                target = od.getPrimaryFile();
            } else {
                target = FileUtil.createData((FileObject)pack, (String)(this.simpleName + ".java"));
            }
            final boolean fromTemplate = classTemplate != null;
            JavaSource.forFileObject((FileObject)target).runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy parameter) throws Exception {
                    parameter.toPhase(JavaSource.Phase.RESOLVED);
                    TreeMaker make = parameter.getTreeMaker();
                    CompilationUnitTree cut = parameter.getCompilationUnit();
                    ExpressionTree pack = fromTemplate ? cut.getPackageName() : make.Identifier((CharSequence)CreateOuterClassFix.this.packageName);
                    ClassTree source = fromTemplate ? (ClassTree)cut.getTypeDecls().get(0) : make.Class(make.Modifiers(EnumSet.of(Modifier.PUBLIC)), (CharSequence)CreateOuterClassFix.this.simpleName, Collections.emptyList(), null, Collections.emptyList(), Collections.emptyList());
                    ClassTree nue = CreateOuterClassFix.this.createConstructor(parameter, new TreePath(new TreePath(cut), source));
                    parameter.rewrite((Tree)cut, (Tree)make.CompilationUnit(pack, cut.getImports(), Collections.singletonList(nue), cut.getSourceFile()));
                }
            }).commit();
            return new ChangeInfo(target, null, null);
        }

        @Override
        public String toDebugString(CompilationInfo info) {
            return "CreateClass:" + this.packageName + "." + this.simpleName + ":" + this.modifiers.toString() + ":" + (Object)((Object)this.kind);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CreateOuterClassFix other = (CreateOuterClassFix)obj;
            if (!(this.targetSourceRoot == other.targetSourceRoot || this.targetSourceRoot != null && this.targetSourceRoot.equals(other.targetSourceRoot))) {
                return false;
            }
            if (!(this.packageName == other.packageName || this.packageName != null && this.packageName.equals(other.packageName))) {
                return false;
            }
            if (!(this.simpleName == other.simpleName || this.simpleName != null && this.simpleName.equals(other.simpleName))) {
                return false;
            }
            if ((this.argumentTypeMirrors == null || this.argumentTypeMirrors.isEmpty()) && (other.argumentTypeMirrors == null || other.argumentTypeMirrors.isEmpty())) {
                return true;
            }
            return this.argumentTypeMirrors == other.argumentTypeMirrors || this.argumentTypeMirrors != null && this.argumentTypeMirrors.equals(other.argumentTypeMirrors);
        }

        public int hashCode() {
            int hash = 7;
            hash = 53 * hash + (this.targetSourceRoot != null ? this.targetSourceRoot.hashCode() : 0);
            hash = 53 * hash + (this.packageName != null ? this.packageName.hashCode() : 0);
            hash = 53 * hash + (this.simpleName != null ? this.simpleName.hashCode() : 0);
            return hash;
        }
    }
}

