/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.errors.FinalFieldsFromCtorCustomiser;
import org.netbeans.modules.java.hints.errors.ImportClassCustomizer;
import org.netbeans.modules.java.hints.errors.LocalVariableFixCustomizer;
import org.netbeans.modules.java.hints.errors.SurroundWithTryCatchLog;
import org.netbeans.modules.java.hints.providers.spi.HintMetadata;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.modules.java.hints.spiimpl.options.HintsSettings;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ErrorFixesFakeHint
extends AbstractHint {
    private FixKind kind;
    private static Map<FixKind, ErrorFixesFakeHint> kind2Hint = new EnumMap<FixKind, ErrorFixesFakeHint>(FixKind.class);
    public static final String LOCAL_VARIABLES_INPLACE = "create-local-variables-in-place";
    public static final String SURROUND_USE_EXCEPTIONS = "surround-try-catch-org-openide-util-Exceptions";
    public static final String SURROUND_RETHROW_AS_RUNTIME = "surround-try-catch-rethrow-runtime";
    public static final String SURROUND_RETHROW = "surround-try-catch-rethrow";
    public static final String SURROUND_USE_JAVA_LOGGER = "surround-try-catch-java-util-logging-Logger";
    public static final String FINAL_FIELDS_FROM_CTOR = "create-final-fields-from-ctor";
    public static final String ORGANIZE_AFTER_IMPORT_CLASS = "organize-import-class";

    private ErrorFixesFakeHint(FixKind kind) {
        super(true, false, null, new String[0]);
        this.kind = kind;
    }

    public String getDescription() {
        return NbBundle.getMessage(ErrorFixesFakeHint.class, (String)("DESC_ErrorFixesFakeHint" + this.kind.name()));
    }

    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.noneOf(Tree.Kind.class);
    }

    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        return null;
    }

    public String getId() {
        return ErrorFixesFakeHint.class.getName() + this.kind.name();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ErrorFixesFakeHint.class, (String)("DN_ErrorFixesFakeHint" + this.kind.name()));
    }

    public void cancel() {
    }

    public JComponent getCustomizer(Preferences node) {
        JComponent customizer;
        switch (this.kind) {
            case CREATE_LOCAL_VARIABLE: {
                customizer = new LocalVariableFixCustomizer(node);
                ErrorFixesFakeHint.setCreateLocalVariableInPlace(node, ErrorFixesFakeHint.isCreateLocalVariableInPlace(node));
                break;
            }
            case SURROUND_WITH_TRY_CATCH: {
                customizer = new SurroundWithTryCatchLog(node);
                ErrorFixesFakeHint.setRethrow(node, ErrorFixesFakeHint.isRethrow(node));
                ErrorFixesFakeHint.setRethrowAsRuntimeException(node, ErrorFixesFakeHint.isRethrowAsRuntimeException(node));
                ErrorFixesFakeHint.setUseExceptions(node, ErrorFixesFakeHint.isUseExceptions(node));
                ErrorFixesFakeHint.setUseLogger(node, ErrorFixesFakeHint.isUseLogger(node));
                break;
            }
            case CREATE_FINAL_FIELD_CTOR: {
                customizer = new FinalFieldsFromCtorCustomiser(node);
                ErrorFixesFakeHint.setCreateFinalFieldsForCtor(node, ErrorFixesFakeHint.isCreateFinalFieldsForCtor(node));
                break;
            }
            case IMPORT_CLASS: {
                customizer = new ImportClassCustomizer(node);
                ErrorFixesFakeHint.setOrganizeAfterImportClass(node, ErrorFixesFakeHint.isOrganizeAfterImportClass(node));
                break;
            }
            default: {
                customizer = super.getCustomizer(node);
            }
        }
        return customizer;
    }

    private static synchronized ErrorFixesFakeHint getHint(FixKind kind) {
        ErrorFixesFakeHint h = kind2Hint.get((Object)kind);
        if (h == null) {
            h = new ErrorFixesFakeHint(kind);
            kind2Hint.put(kind, h);
        }
        return h;
    }

    public static boolean enabled(FixKind kind) {
        return ErrorFixesFakeHint.getHint(kind).isEnabled();
    }

    public static Preferences getPreferences(FileObject forFile, FixKind fixKind) {
        return HintsSettings.getSettingsFor((FileObject)forFile).getHintPreferences(HintMetadata.Builder.create((String)ErrorFixesFakeHint.getHint(fixKind).getId()).build());
    }

    public static boolean isCreateFinalFieldsForCtor(Preferences p) {
        return p.getBoolean(FINAL_FIELDS_FROM_CTOR, true);
    }

    public static void setCreateFinalFieldsForCtor(Preferences p, boolean v) {
        p.putBoolean(FINAL_FIELDS_FROM_CTOR, v);
    }

    public static boolean isCreateLocalVariableInPlace(Preferences p) {
        return p.getBoolean(LOCAL_VARIABLES_INPLACE, true);
    }

    public static void setCreateLocalVariableInPlace(Preferences p, boolean v) {
        p.putBoolean(LOCAL_VARIABLES_INPLACE, v);
    }

    public static boolean isUseExceptions(Preferences p) {
        return p.getBoolean(SURROUND_USE_EXCEPTIONS, true);
    }

    public static void setUseExceptions(Preferences p, boolean v) {
        p.putBoolean(SURROUND_USE_EXCEPTIONS, v);
    }

    public static boolean isRethrowAsRuntimeException(Preferences p) {
        return p.getBoolean(SURROUND_RETHROW_AS_RUNTIME, false);
    }

    public static void setRethrowAsRuntimeException(Preferences p, boolean v) {
        p.putBoolean(SURROUND_RETHROW_AS_RUNTIME, v);
    }

    public static boolean isRethrow(Preferences p) {
        return p.getBoolean(SURROUND_RETHROW, false);
    }

    public static void setRethrow(Preferences p, boolean v) {
        p.putBoolean(SURROUND_RETHROW, v);
    }

    public static boolean isUseLogger(Preferences p) {
        return p.getBoolean(SURROUND_USE_JAVA_LOGGER, true);
    }

    public static void setUseLogger(Preferences p, boolean v) {
        p.putBoolean(SURROUND_USE_JAVA_LOGGER, v);
    }

    public static void setOrganizeAfterImportClass(Preferences p, boolean v) {
        p.putBoolean(ORGANIZE_AFTER_IMPORT_CLASS, v);
    }

    public static boolean isOrganizeAfterImportClass(Preferences p) {
        return p.getBoolean(ORGANIZE_AFTER_IMPORT_CLASS, false);
    }

    public static ErrorFixesFakeHint create(FileObject file) {
        if (file.getName().endsWith("surround")) {
            return ErrorFixesFakeHint.getHint(FixKind.SURROUND_WITH_TRY_CATCH);
        }
        if (file.getName().endsWith("local")) {
            return ErrorFixesFakeHint.getHint(FixKind.CREATE_LOCAL_VARIABLE);
        }
        if (file.getName().endsWith("finalfield")) {
            return ErrorFixesFakeHint.getHint(FixKind.CREATE_FINAL_FIELD_CTOR);
        }
        if (file.getName().endsWith("importClass")) {
            return ErrorFixesFakeHint.getHint(FixKind.IMPORT_CLASS);
        }
        throw new IllegalArgumentException();
    }

    public static enum FixKind {
        SURROUND_WITH_TRY_CATCH,
        CREATE_LOCAL_VARIABLE,
        CREATE_FINAL_FIELD_CTOR,
        IMPORT_CLASS;

    }
}

