/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.introduce;

import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.lang.model.element.Modifier;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.modules.java.hints.introduce.CommonMembersPanel;
import org.netbeans.modules.java.hints.introduce.ErrorLabel;
import org.netbeans.modules.java.hints.introduce.IntroduceFieldPanel;
import org.netbeans.modules.java.hints.introduce.TargetDescription;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

public class IntroduceMethodPanel
extends CommonMembersPanel {
    public static final int INIT_METHOD = 1;
    public static final int INIT_FIELD = 2;
    public static final int INIT_CONSTRUCTORS = 4;
    private static final int ACCESS_PUBLIC = 1;
    private static final int ACCESS_PROTECTED = 2;
    private static final int ACCESS_DEFAULT = 3;
    private static final int ACCESS_PRIVATE = 4;
    private JButton btnOk;
    private boolean targetInterface;
    private final Map<TargetDescription, Set<String>> targets2conflictingNames;
    private JRadioButton accessDefault;
    private ButtonGroup accessGroup;
    private JRadioButton accessPrivate;
    private JRadioButton accessProtected;
    private JRadioButton accessPublic;
    private JCheckBox duplicates;
    private JLabel errorLabel;
    private ButtonGroup initilizeIn;
    private JLabel jLabel1;
    private JLabel lblAccess;
    private JLabel lblName;
    private JTextField name;
    private JComboBox target;
    private String methodNameTest;
    private Set<Modifier> accessTest;
    private Boolean replaceOtherTest;

    public IntroduceMethodPanel(String name, int duplicatesCount, Map<TargetDescription, Set<String>> targets2conflictingNames, boolean targetInterface) {
        super(targets2conflictingNames.keySet());
        this.initComponents();
        this.targetInterface = targetInterface;
        this.targets2conflictingNames = targets2conflictingNames;
        this.name.setText(name);
        if (name != null && name.trim().length() > 0) {
            this.name.setCaretPosition(name.length());
            this.name.setSelectionStart(0);
            this.name.setSelectionEnd(name.length());
        }
        Preferences pref = this.getPreferences();
        if (!targetInterface) {
            int accessModifier = pref.getInt("accessModifier", 4);
            switch (accessModifier) {
                case 1: {
                    this.accessPublic.setSelected(true);
                    break;
                }
                case 2: {
                    this.accessProtected.setSelected(true);
                    break;
                }
                case 3: {
                    this.accessDefault.setSelected(true);
                    break;
                }
                case 4: {
                    this.accessPrivate.setSelected(true);
                }
            }
        } else {
            this.updateAccessVisible(false);
        }
        if (duplicatesCount == 0) {
            this.duplicates.setEnabled(false);
            this.duplicates.setSelected(false);
        } else {
            this.duplicates.setEnabled(true);
            this.duplicates.setSelected(true);
            this.duplicates.setText(this.duplicates.getText() + " (" + duplicatesCount + ")");
        }
        this.initialize(this.target, this.duplicates);
        this.target.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                IntroduceMethodPanel.this.updateTargetChange();
            }
        });
    }

    private void updateTargetChange() {
        int index = this.target.getSelectedIndex();
        if (index == -1) {
            this.updateAccessVisible(this.targetInterface);
            return;
        }
        TargetDescription desc = (TargetDescription)this.target.getModel().getSelectedItem();
        this.updateAccessVisible(!desc.iface);
    }

    private void updateAccessVisible(boolean v) {
        this.lblAccess.setVisible(v);
        this.accessPublic.setVisible(v);
        this.accessDefault.setVisible(v);
        this.accessPrivate.setVisible(v);
        this.accessProtected.setVisible(v);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(IntroduceFieldPanel.class).node("introduceField");
    }

    public void setOkButton(JButton btn) {
        this.btnOk = btn;
        this.btnOk.setEnabled(((ErrorLabel)this.errorLabel).isInputTextValid());
    }

    private JLabel createErrorLabel() {
        ErrorLabel.Validator validator = new ErrorLabel.Validator(){

            @Override
            public String validate(String text) {
                if (null == text || text.length() == 0) {
                    return "";
                }
                if (!Utilities.isJavaIdentifier((String)text)) {
                    return IntroduceMethodPanel.this.getDefaultErrorMessage(text);
                }
                Set blackList = (Set)IntroduceMethodPanel.this.targets2conflictingNames.get((TargetDescription)IntroduceMethodPanel.this.target.getModel().getSelectedItem());
                if (blackList != null && blackList.contains(text)) {
                    return IntroduceMethodPanel.this.getConflictErrorMessage(text);
                }
                return null;
            }
        };
        final ErrorLabel eLabel = new ErrorLabel(this.name.getDocument(), validator);
        eLabel.addPropertyChangeListener("isValid", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                IntroduceMethodPanel.this.btnOk.setEnabled(eLabel.isInputTextValid());
            }
        });
        return eLabel;
    }

    String getDefaultErrorMessage(String inputText) {
        return "'" + inputText + "' is not a valid identifier";
    }

    String getConflictErrorMessage(String inputText) {
        return "'" + inputText + "' method already exists";
    }

    private void initComponents() {
        this.initilizeIn = new ButtonGroup();
        this.accessGroup = new ButtonGroup();
        this.lblName = new JLabel();
        this.name = new JTextField();
        this.lblAccess = new JLabel();
        this.accessPublic = new JRadioButton();
        this.accessProtected = new JRadioButton();
        this.accessDefault = new JRadioButton();
        this.accessPrivate = new JRadioButton();
        this.errorLabel = this.createErrorLabel();
        this.duplicates = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.target = new JComboBox();
        this.lblName.setLabelFor(this.name);
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)NbBundle.getBundle(IntroduceMethodPanel.class).getString("LBL_Name"));
        this.name.setColumns(20);
        this.lblAccess.setLabelFor(this.accessPublic);
        Mnemonics.setLocalizedText((JLabel)this.lblAccess, (String)NbBundle.getMessage(IntroduceMethodPanel.class, (String)"LBL_Access"));
        this.accessGroup.add(this.accessPublic);
        Mnemonics.setLocalizedText((AbstractButton)this.accessPublic, (String)NbBundle.getMessage(IntroduceMethodPanel.class, (String)"LBL_public"));
        this.accessPublic.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.accessPublic.setMargin(new Insets(0, 0, 0, 0));
        this.accessGroup.add(this.accessProtected);
        Mnemonics.setLocalizedText((AbstractButton)this.accessProtected, (String)NbBundle.getMessage(IntroduceMethodPanel.class, (String)"LBL_protected"));
        this.accessProtected.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.accessProtected.setMargin(new Insets(0, 0, 0, 0));
        this.accessGroup.add(this.accessDefault);
        Mnemonics.setLocalizedText((AbstractButton)this.accessDefault, (String)NbBundle.getMessage(IntroduceMethodPanel.class, (String)"LBL_Default"));
        this.accessDefault.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.accessDefault.setMargin(new Insets(0, 0, 0, 0));
        this.accessGroup.add(this.accessPrivate);
        this.accessPrivate.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.accessPrivate, (String)NbBundle.getMessage(IntroduceMethodPanel.class, (String)"LBL_private"));
        this.accessPrivate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.accessPrivate.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.duplicates, (String)NbBundle.getMessage(IntroduceMethodPanel.class, (String)"IntroduceMethodPanel.duplicates.text"));
        this.jLabel1.setLabelFor(this.target);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(IntroduceMethodPanel.class, (String)"IntroduceMethodPanel.jLabel1.text"));
        this.target.setModel(new DefaultComboBoxModel());
        this.target.setRenderer(new CommonMembersPanel.TargetsRendererImpl());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblAccess).addComponent(this.lblName)).addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.name, -1, 425, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.accessPublic).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.accessProtected).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.accessDefault).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.accessPrivate)))).addComponent(this.errorLabel, -1, 491, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.duplicates).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.target, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.name, -2, -1, -2).addComponent(this.lblName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblAccess).addComponent(this.accessPublic).addComponent(this.accessProtected).addComponent(this.accessDefault).addComponent(this.accessPrivate)).addGap(18, 18, 18).addComponent(this.duplicates).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.target, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 54, Short.MAX_VALUE).addComponent(this.errorLabel).addContainerGap()));
        this.name.getAccessibleContext().setAccessibleName(NbBundle.getMessage(IntroduceMethodPanel.class, (String)"AN_IntrMethod_Name"));
        this.name.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceMethodPanel.class, (String)"AD_IntrMethod_Name"));
        this.accessPublic.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceMethodPanel.class, (String)"AD_IntrMethod_Public"));
        this.accessProtected.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceMethodPanel.class, (String)"AD_IntrMethod_Protected"));
        this.accessDefault.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceMethodPanel.class, (String)"AD_IntrMethod_Default"));
        this.accessPrivate.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceMethodPanel.class, (String)"AD_IntrMethod_Private"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceMethodPanel.class, (String)"AD_IntrMethod_Dialog"));
    }

    public String getMethodName() {
        if (this.methodNameTest != null) {
            return this.methodNameTest;
        }
        return this.name.getText();
    }

    public Set<Modifier> getAccess() {
        Set<Modifier> set;
        int val;
        if (this.accessTest != null) {
            return this.accessTest;
        }
        TargetDescription selTarget = (TargetDescription)this.target.getModel().getSelectedItem();
        if (selTarget.iface) {
            val = -1;
            set = EnumSet.of(Modifier.DEFAULT);
        } else if (this.accessPublic.isSelected()) {
            val = 1;
            set = EnumSet.of(Modifier.PUBLIC);
        } else if (this.accessProtected.isSelected()) {
            val = 2;
            set = EnumSet.of(Modifier.PROTECTED);
        } else if (this.accessDefault.isSelected()) {
            val = 3;
            set = Collections.emptySet();
        } else {
            val = 4;
            set = EnumSet.of(Modifier.PRIVATE);
        }
        if (val >= 0) {
            this.getPreferences().putInt("accessModifier", val);
        }
        return set;
    }

    public boolean getReplaceOther() {
        return this.replaceOtherTest != null ? this.replaceOtherTest.booleanValue() : this.duplicates.isSelected();
    }

    void setAccess(Set<Modifier> access) {
        this.accessTest = access;
    }

    void setMethodName(String methodName) {
        this.methodNameTest = methodName;
    }

    void setReplaceOther(boolean v) {
        this.replaceOtherTest = v;
    }
}

