/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.editor.java.Utilities;

public class ConvertToLambdaPreconditionChecker {
    private final TreePath pathToNewClassTree;
    private final NewClassTree newClassTree;
    private final MethodTree lambdaMethodTree;
    private final Scope localScope;
    private final CompilationInfo info;
    private final Types types;
    private boolean foundRefToThisOrSuper = false;
    private boolean foundShadowedVariable = false;
    private boolean foundRecursiveCall = false;
    private boolean foundOverloadWhichMakesLambdaAmbiguous = false;
    private boolean foundAssignmentToRawType = false;
    private boolean foundAssignmentToSupertype = false;
    private boolean foundErroneousTargetType = false;
    private BlockTree singleStatementLambdaMethodBody = null;
    private boolean foundMemberReferenceCandidate = false;
    private boolean havePreconditionsBeenChecked = false;
    private boolean foundRefToUninitializedVar = false;
    private final Element ownerClass;
    private final Element createdClass;

    public ConvertToLambdaPreconditionChecker(TreePath pathToNewClassTree, CompilationInfo info) {
        this.pathToNewClassTree = pathToNewClassTree;
        this.newClassTree = (NewClassTree)pathToNewClassTree.getLeaf();
        this.info = info;
        this.types = info.getTypes();
        Element el = info.getTrees().getElement(pathToNewClassTree);
        this.createdClass = el.getKind() == ElementKind.CONSTRUCTOR ? el.getEnclosingElement() : null;
        this.lambdaMethodTree = ConvertToLambdaPreconditionChecker.getMethodFromFunctionalInterface(this.newClassTree);
        this.localScope = this.getScopeFromTree(this.pathToNewClassTree);
        this.ownerClass = this.findFieldOwner();
    }

    private Element findFieldOwner() {
        for (TreePath p = this.pathToNewClassTree.getParentPath(); p != null; p = p.getParentPath()) {
            Tree t = p.getLeaf();
            if (t.getKind() == Tree.Kind.METHOD) {
                return null;
            }
            if (t.getKind() != Tree.Kind.CLASS) continue;
            return this.info.getTrees().getElement(p);
        }
        return null;
    }

    private static MethodTree getMethodFromFunctionalInterface(NewClassTree newClassTree) {
        ClassTree classTree = newClassTree.getClassBody();
        return (MethodTree)classTree.getMembers().get(1);
    }

    public boolean passesAllPreconditions() {
        this.ensurePreconditionsAreChecked();
        return !this.foundRefToThisOrSuper() && !this.foundShadowedVariable() && !this.foundRecursiveCall() && !this.foundOverloadWhichMakesLambdaAmbiguous() && !this.foundAssignmentToSupertype() && !this.foundAssignmentToRawtype() && !this.foundRefToUninitializedVar();
    }

    private void ensurePreconditionsAreChecked() {
        if (!this.havePreconditionsBeenChecked) {
            TreePath path = new TreePath(this.pathToNewClassTree, this.lambdaMethodTree);
            new PreconditionScanner().scan(path, this.info.getTrees());
            this.checkForOverload();
            this.verifyTargetType();
            this.havePreconditionsBeenChecked = true;
        }
    }

    boolean foundRefToUninitializedVar() {
        this.ensurePreconditionsAreChecked();
        return this.foundRefToUninitializedVar;
    }

    public boolean passesFatalPreconditions() {
        return !this.foundRefToThisOrSuper() && !this.foundRecursiveCall() && !this.foundErroneousTargetType() && !this.foundRefToUninitializedVar();
    }

    public boolean needsCastToExpectedType() {
        this.ensurePreconditionsAreChecked();
        return this.foundOverloadWhichMakesLambdaAmbiguous() || this.foundAssignmentToSupertype() || this.foundAssignmentToRawtype();
    }

    public boolean foundRefToThisOrSuper() {
        this.ensurePreconditionsAreChecked();
        return this.foundRefToThisOrSuper;
    }

    public boolean foundShadowedVariable() {
        this.ensurePreconditionsAreChecked();
        return this.foundShadowedVariable;
    }

    public boolean foundRecursiveCall() {
        this.ensurePreconditionsAreChecked();
        return this.foundRecursiveCall;
    }

    public boolean foundOverloadWhichMakesLambdaAmbiguous() {
        this.ensurePreconditionsAreChecked();
        return this.foundOverloadWhichMakesLambdaAmbiguous;
    }

    public boolean foundAssignmentToSupertype() {
        this.ensurePreconditionsAreChecked();
        return this.foundAssignmentToSupertype;
    }

    public boolean foundAssignmentToRawtype() {
        this.ensurePreconditionsAreChecked();
        return this.foundAssignmentToRawType;
    }

    public boolean foundErroneousTargetType() {
        this.ensurePreconditionsAreChecked();
        return this.foundErroneousTargetType;
    }

    public boolean foundMemberReferenceCandidate() {
        this.ensurePreconditionsAreChecked();
        return this.foundMemberReferenceCandidate;
    }

    private void checkForOverload() {
        this.foundOverloadWhichMakesLambdaAmbiguous = this.doesOverloadMakeLambdaAmbiguous();
    }

    private boolean shadowsVariable(CharSequence variableName) {
        return org.netbeans.modules.java.hints.errors.Utilities.isSymbolUsed(this.info, this.pathToNewClassTree, variableName, this.localScope);
    }

    private ExpressionTree getSelector(Tree tree) {
        switch (tree.getKind()) {
            case MEMBER_SELECT: {
                return ((MemberSelectTree)tree).getExpression();
            }
            case METHOD_INVOCATION: {
                return this.getSelector(((MethodInvocationTree)tree).getMethodSelect());
            }
            case NEW_CLASS: {
                return this.getSelector(((NewClassTree)tree).getIdentifier());
            }
        }
        return null;
    }

    private boolean doesOverloadMakeLambdaAmbiguous() {
        TreePath parentPath = this.pathToNewClassTree.getParentPath();
        Tree parentTree = parentPath.getLeaf();
        if (!this.isInvocationTree(parentTree)) {
            return false;
        }
        ExecutableElement invokingElement = this.getElementFromInvokingTree(parentPath);
        int indexOfLambdaInArgs = this.getLambdaIndexFromInvokingTree(parentTree);
        if (invokingElement == null || indexOfLambdaInArgs == -1) {
            return false;
        }
        return this.isLambdaAnAmbiguousArgument(invokingElement, indexOfLambdaInArgs);
    }

    private ExecutableElement getElementFromInvokingTree(TreePath treePath) {
        Element result;
        Tree invokingTree = treePath.getLeaf();
        if (invokingTree.getKind() == Tree.Kind.METHOD_INVOCATION) {
            MethodInvocationTree invokingMethTree = (MethodInvocationTree)invokingTree;
            TreePath methodTreePath = new TreePath(treePath, invokingMethTree);
            result = this.getElementFromTreePath(methodTreePath);
        } else {
            result = this.getElementFromTreePath(treePath);
        }
        if (result != null && (result.getKind() == ElementKind.CONSTRUCTOR || result.getKind() == ElementKind.METHOD)) {
            return (ExecutableElement)result;
        }
        return null;
    }

    private int getLambdaIndexFromInvokingTree(Tree invokingTree) {
        List<? extends ExpressionTree> invokingArgs;
        if (invokingTree.getKind() == Tree.Kind.METHOD_INVOCATION) {
            MethodInvocationTree invokingMethTree = (MethodInvocationTree)invokingTree;
            invokingArgs = invokingMethTree.getArguments();
        } else if (invokingTree.getKind() == Tree.Kind.NEW_CLASS) {
            NewClassTree invokingConstrTree = (NewClassTree)invokingTree;
            invokingArgs = invokingConstrTree.getArguments();
        } else {
            return -1;
        }
        return this.getIndexOfLambdaInArgs(this.newClassTree, invokingArgs);
    }

    private int getIndexOfLambdaInArgs(Tree treeToFind, List<? extends ExpressionTree> argsToSearch) {
        for (int i = 0; i < argsToSearch.size(); ++i) {
            if (argsToSearch.get(i) != treeToFind) continue;
            return i;
        }
        return -1;
    }

    private boolean isLambdaAnAmbiguousArgument(ExecutableElement invokingElement, int indexOfLambdaInArgs) {
        Element classOfInvokingElement = invokingElement.getEnclosingElement();
        for (Element possibleMatchingElement : this.info.getElementUtilities().getMembers(classOfInvokingElement.asType(), null)) {
            if (possibleMatchingElement == invokingElement || possibleMatchingElement.getKind() != invokingElement.getKind() || !this.doesInvokingElementMatchFound(invokingElement, (ExecutableElement)possibleMatchingElement, indexOfLambdaInArgs)) continue;
            return true;
        }
        return false;
    }

    private Element getElementFromTreePath(TreePath path) {
        return this.info.getTrees().getElement(path);
    }

    private boolean doesInvokingElementMatchFound(ExecutableElement invokingElement, ExecutableElement possibleMatchingElement, int indexOfLambdaInArgs) {
        return possibleMatchingElement.getSimpleName().equals(invokingElement.getSimpleName()) && this.doInvokingParamsMatchFound(invokingElement, possibleMatchingElement, indexOfLambdaInArgs);
    }

    private boolean doInvokingParamsMatchFound(ExecutableElement invokingElement, ExecutableElement possibleMatchingElement, int indexOfLambdaInArgs) {
        if (possibleMatchingElement.getParameters().size() != invokingElement.getParameters().size()) {
            return false;
        }
        if (!this.doAllParamsMatchExcludingGivenIndex(invokingElement, possibleMatchingElement, indexOfLambdaInArgs)) {
            return false;
        }
        return this.doesLambdaElementMatchFound(possibleMatchingElement, indexOfLambdaInArgs);
    }

    private boolean doAllParamsMatchExcludingGivenIndex(ExecutableElement invokingElement, ExecutableElement possibleMatchingElement, int indexToIgnore) {
        List<TypeMirror> invokingParams = this.getTypesFromElements(invokingElement.getParameters());
        List<TypeMirror> possibleMatchParams = this.getTypesFromElements(possibleMatchingElement.getParameters());
        for (int i = 0; i < possibleMatchParams.size(); ++i) {
            TypeMirror expectedType;
            TypeMirror foundType;
            if (i == indexToIgnore || this.types.isAssignable(foundType = invokingParams.get(i), expectedType = possibleMatchParams.get(i))) continue;
            return false;
        }
        return true;
    }

    private ExecutableElement getFunctionalMethodFromElement(Element element) {
        Element classType = this.types.asElement(element.asType());
        if (classType == null) {
            return null;
        }
        ExecutableElement elementToReturn = null;
        int methodCounter = 0;
        for (Element element2 : classType.getEnclosedElements()) {
            if (element2.getKind() != ElementKind.METHOD) continue;
            elementToReturn = (ExecutableElement)element2;
            ++methodCounter;
        }
        if (methodCounter != 1) {
            return null;
        }
        return elementToReturn;
    }

    private boolean doesLambdaElementMatchFound(ExecutableElement possibleMatchingElement, int indexOfLambdaInArgs) {
        TreePath pathToLambdaMethod = new TreePath(this.pathToNewClassTree, this.lambdaMethodTree);
        ExecutableElement lambdaMethodElement = (ExecutableElement)this.getElementFromTreePath(pathToLambdaMethod);
        Element paramAtIndexOfLambda = possibleMatchingElement.getParameters().get(indexOfLambdaInArgs);
        ExecutableElement possibleLambdaMatch = this.getFunctionalMethodFromElement(paramAtIndexOfLambda);
        if (possibleLambdaMatch == null) {
            return false;
        }
        return this.areLambdaMethodSignaturesAmbiguous(lambdaMethodElement, possibleLambdaMatch);
    }

    private boolean areLambdaMethodSignaturesAmbiguous(ExecutableElement found, ExecutableElement expected) {
        if (!this.areReturnTypesEquivalent(found, expected)) {
            return false;
        }
        return this.areMethodParametersEquivalent(found, expected);
    }

    private boolean areReturnTypesEquivalent(ExecutableElement found, ExecutableElement expected) {
        TypeMirror foundReturnType = this.types.erasure(found.getReturnType());
        TypeMirror expectedReturnType = this.types.erasure(expected.getReturnType());
        return this.types.isAssignable(foundReturnType, expectedReturnType);
    }

    private boolean areMethodParametersEquivalent(ExecutableElement found, ExecutableElement expected) {
        if (found.getParameters().size() != expected.getParameters().size()) {
            return false;
        }
        for (int i = 0; i < found.getParameters().size(); ++i) {
            TypeMirror expectedParamType;
            TypeMirror foundParamType = this.types.erasure(found.getParameters().get(i).asType());
            if (this.types.isAssignable(foundParamType, expectedParamType = this.types.erasure(expected.getParameters().get(i).asType()))) continue;
            return false;
        }
        return true;
    }

    private void verifyTargetType() {
        TypeElement te;
        DeclaredType tt;
        TypeMirror expectedType = this.findExpectedType(this.pathToNewClassTree);
        if (!org.netbeans.modules.java.hints.errors.Utilities.isValidType(expectedType)) {
            this.foundErroneousTargetType = true;
            return;
        }
        TypeMirror erasedExpectedType = this.info.getTypes().erasure(expectedType);
        TreePath pathForClassIdentifier = new TreePath(this.pathToNewClassTree, this.newClassTree.getIdentifier());
        TypeMirror lambdaType = this.info.getTrees().getTypeMirror(pathForClassIdentifier);
        lambdaType = this.info.getTypes().erasure(lambdaType);
        boolean bl = this.foundAssignmentToSupertype = !this.info.getTypes().isSameType(erasedExpectedType, lambdaType);
        if (erasedExpectedType.getKind() == TypeKind.DECLARED && (tt = (DeclaredType)(te = (TypeElement)((DeclaredType)erasedExpectedType).asElement()).asType()).getKind() == TypeKind.DECLARED && !tt.getTypeArguments().isEmpty()) {
            this.foundAssignmentToRawType = this.info.getTypes().isSameType(erasedExpectedType, expectedType);
        }
    }

    private TypeMirror findExpectedType(TreePath path) {
        int start = this.getSourceStartFromPath(path);
        for (path = path.getParentPath(); path != null; path = path.getParentPath()) {
            TreePath enclMethodPath;
            Tree currTree = path.getLeaf();
            if (this.isVariableTree(currTree)) {
                return this.info.getTrees().getTypeMirror(path);
            }
            if (this.isAssignmentTree(currTree)) {
                return this.info.getTrees().getTypeMirror(path);
            }
            if (this.isReturnTree(currTree) && (enclMethodPath = this.getEnclosingMethodPath(path)) != null) {
                Tree returnTypeTree = ((MethodTree)enclMethodPath.getLeaf()).getReturnType();
                return this.info.getTrees().getTypeMirror(new TreePath(enclMethodPath, returnTypeTree));
            }
            if (this.isInvocationTree(currTree)) {
                ExecutableElement invokingElement = this.getElementFromInvokingTree(path);
                if (invokingElement == null) {
                    return null;
                }
                int lambdaIndex = this.getLambdaIndexFromInvokingTree(currTree);
                if (lambdaIndex >= 0 && lambdaIndex < invokingElement.getParameters().size()) {
                    return invokingElement.getParameters().get(lambdaIndex).asType();
                }
            }
            if (this.getSourceStartFromTree(currTree) < start) break;
        }
        return null;
    }

    private boolean isVariableTree(Tree tree) {
        return tree.getKind() == Tree.Kind.VARIABLE && ((VariableTree)tree).getInitializer() != null;
    }

    private boolean isAssignmentTree(Tree tree) {
        return tree.getKind() == Tree.Kind.ASSIGNMENT;
    }

    private boolean isReturnTree(Tree tree) {
        return tree.getKind() == Tree.Kind.RETURN;
    }

    private boolean isInvocationTree(Tree tree) {
        EnumSet<Tree.Kind> acceptableKinds = EnumSet.of(Tree.Kind.NEW_CLASS, Tree.Kind.METHOD_INVOCATION);
        return acceptableKinds.contains((Object)tree.getKind());
    }

    private TreePath getEnclosingMethodPath(TreePath childPath) {
        TreePath parentPath;
        for (parentPath = childPath; parentPath != null && parentPath.getLeaf().getKind() != Tree.Kind.METHOD; parentPath = parentPath.getParentPath()) {
        }
        return parentPath;
    }

    private int getSourceStartFromPath(TreePath path) {
        return this.getSourceStartFromTree(path.getLeaf());
    }

    private int getSourceStartFromTree(Tree tree) {
        return (int)this.info.getTrees().getSourcePositions().getStartPosition(this.info.getCompilationUnit(), tree);
    }

    private List<TypeMirror> getTypesFromElements(List<? extends VariableElement> elements) {
        ArrayList<TypeMirror> elementTypes = new ArrayList<TypeMirror>();
        for (Element element : elements) {
            elementTypes.add(element.asType());
        }
        return elementTypes;
    }

    private Scope getScopeFromTree(TreePath path) {
        return this.info.getTrees().getScope(path);
    }

    private class PreconditionScanner
    extends TreePathScanner<Tree, Trees> {
        private PreconditionScanner() {
        }

        @Override
        public Tree visitClass(ClassTree node, Trees p) {
            return null;
        }

        @Override
        public Tree visitMethod(MethodTree methodTree, Trees trees) {
            TreePath path = this.getCurrentPath();
            if (ConvertToLambdaPreconditionChecker.this.info.getTreeUtilities().isSynthetic(path)) {
                return methodTree;
            }
            return (Tree)super.visitMethod(methodTree, trees);
        }

        @Override
        public Tree visitBlock(BlockTree blockTree, Trees trees) {
            TreePath path = this.getCurrentPath();
            if (path.getParentPath().getLeaf() == ConvertToLambdaPreconditionChecker.this.lambdaMethodTree && blockTree.getStatements().size() == 1) {
                ConvertToLambdaPreconditionChecker.this.singleStatementLambdaMethodBody = blockTree;
            }
            return (Tree)super.visitBlock(blockTree, trees);
        }

        @Override
        public Tree visitIdentifier(IdentifierTree identifierTree, Trees trees) {
            Element el;
            if (identifierTree.getName().contentEquals("this") || identifierTree.getName().contentEquals("super")) {
                Tree parent = this.getCurrentPath().getParentPath().getLeaf();
                if (parent.getKind() == Tree.Kind.MEMBER_SELECT) {
                    Element el2 = ConvertToLambdaPreconditionChecker.this.info.getTrees().getElement(this.getCurrentPath().getParentPath());
                    if (el2 == ConvertToLambdaPreconditionChecker.this.createdClass) {
                        ConvertToLambdaPreconditionChecker.this.foundRefToThisOrSuper = true;
                    } else {
                        TypeMirror m = ConvertToLambdaPreconditionChecker.this.info.getTrees().getTypeMirror(this.getCurrentPath());
                        if (!org.netbeans.modules.java.hints.errors.Utilities.isValidType(m)) {
                            ConvertToLambdaPreconditionChecker.this.foundRefToThisOrSuper = true;
                        } else if (m.getKind() == TypeKind.DECLARED && ConvertToLambdaPreconditionChecker.this.createdClass != null && ConvertToLambdaPreconditionChecker.this.info.getTypes().isSubtype(ConvertToLambdaPreconditionChecker.this.createdClass.asType(), m)) {
                            ConvertToLambdaPreconditionChecker.this.foundRefToThisOrSuper = true;
                        }
                    }
                } else {
                    ConvertToLambdaPreconditionChecker.this.foundRefToThisOrSuper = true;
                }
            }
            if ((el = ConvertToLambdaPreconditionChecker.this.info.getTrees().getElement(this.getCurrentPath())) != null && el.getKind() == ElementKind.FIELD && ConvertToLambdaPreconditionChecker.this.ownerClass == el.getEnclosingElement()) {
                if (!el.getModifiers().contains((Object)Modifier.FINAL)) {
                    ConvertToLambdaPreconditionChecker.this.foundRefToUninitializedVar = true;
                } else {
                    VariableTree vt = (VariableTree)ConvertToLambdaPreconditionChecker.this.info.getTrees().getTree(el);
                    ConvertToLambdaPreconditionChecker.this.foundRefToUninitializedVar = (byte)(ConvertToLambdaPreconditionChecker.this.foundRefToUninitializedVar | (vt.getInitializer() == null ? 1 : 0));
                }
            }
            return (Tree)super.visitIdentifier(identifierTree, trees);
        }

        @Override
        public Tree visitVariable(VariableTree variableDeclTree, Trees trees) {
            if (ConvertToLambdaPreconditionChecker.this.shadowsVariable(variableDeclTree.getName())) {
                ConvertToLambdaPreconditionChecker.this.foundShadowedVariable = true;
            }
            return (Tree)super.visitVariable(variableDeclTree, trees);
        }

        @Override
        public Tree visitMethodInvocation(MethodInvocationTree methodInvocationTree, Trees trees) {
            Tree parent;
            ExpressionTree selector;
            String nameSuggestion = Utilities.varNameSuggestion((Tree)methodInvocationTree.getMethodSelect());
            if (nameSuggestion != null && ConvertToLambdaPreconditionChecker.this.lambdaMethodTree.getName().contentEquals(nameSuggestion) && ((selector = ConvertToLambdaPreconditionChecker.this.getSelector(methodInvocationTree)) == null || Utilities.varNameSuggestion((Tree)selector) != null && Utilities.varNameSuggestion((Tree)selector).contentEquals("this"))) {
                ConvertToLambdaPreconditionChecker.this.foundRecursiveCall = true;
            }
            if (ConvertToLambdaPreconditionChecker.this.singleStatementLambdaMethodBody == this.getCurrentPath().getParentPath().getParentPath().getLeaf() && ((parent = this.getCurrentPath().getParentPath().getLeaf()).getKind() == Tree.Kind.EXPRESSION_STATEMENT || parent.getKind() == Tree.Kind.RETURN)) {
                ExpressionTree expr;
                boolean check = true;
                Iterator<? extends VariableTree> paramsIt = ConvertToLambdaPreconditionChecker.this.lambdaMethodTree.getParameters().iterator();
                ExpressionTree methodSelect = methodInvocationTree.getMethodSelect();
                if (paramsIt.hasNext() && methodSelect.getKind() == Tree.Kind.MEMBER_SELECT && (expr = ((MemberSelectTree)methodSelect).getExpression()).getKind() == Tree.Kind.IDENTIFIER && !((IdentifierTree)expr).getName().contentEquals(paramsIt.next().getName())) {
                    paramsIt = ConvertToLambdaPreconditionChecker.this.lambdaMethodTree.getParameters().iterator();
                }
                Iterator<? extends ExpressionTree> argsIt = methodInvocationTree.getArguments().iterator();
                while (check && argsIt.hasNext() && paramsIt.hasNext()) {
                    ExpressionTree arg = argsIt.next();
                    if (arg.getKind() == Tree.Kind.IDENTIFIER && paramsIt.next().getName().contentEquals(((IdentifierTree)arg).getName())) continue;
                    check = false;
                }
                if (check && !paramsIt.hasNext() && !argsIt.hasNext()) {
                    ConvertToLambdaPreconditionChecker.this.foundMemberReferenceCandidate = true;
                }
            }
            return (Tree)super.visitMethodInvocation(methodInvocationTree, trees);
        }
    }
}

