/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import com.sun.source.util.TreePath;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFixUtilities;
import org.netbeans.spi.java.hints.MatcherUtilities;
import org.openide.util.NbBundle;

public class ThrowableInitCause {
    public static final boolean STRICT_DEFAULT = false;
    public static final String STRICT_KEY = "strict";

    public static ErrorDescription expression(HintContext ctx) {
        return ThrowableInitCause.initCause(ctx, false);
    }

    public static ErrorDescription variable(HintContext ctx) {
        return ThrowableInitCause.initCause(ctx, true);
    }

    private static ErrorDescription initCause(HintContext ctx, boolean toThrow) {
        String target;
        TypeElement throwable = ctx.getInfo().getElements().getTypeElement("java.lang.Throwable");
        if (throwable == null) {
            return null;
        }
        TreePath exc = (TreePath)ctx.getVariables().get("$exc");
        TypeMirror excType = ctx.getInfo().getTrees().getTypeMirror(exc);
        Types t = ctx.getInfo().getTypes();
        if (!t.isSubtype(t.erasure(excType), t.erasure(throwable.asType()))) {
            return null;
        }
        Element el = t.asElement(excType);
        if (el == null || el.getKind() != ElementKind.CLASS) {
            return null;
        }
        LinkedList<TypeMirror> constrParams = new LinkedList<TypeMirror>();
        TreePath str = (TreePath)ctx.getVariables().get("$str");
        if (str != null && (MatcherUtilities.matches((HintContext)ctx, (TreePath)str, (String)"$del.toString()") || MatcherUtilities.matches((HintContext)ctx, (TreePath)str, (String)"$del.getMessage()") && !ctx.getPreferences().getBoolean(STRICT_KEY, false) || MatcherUtilities.matches((HintContext)ctx, (TreePath)str, (String)"$del.getLocalizedMessage()") && !ctx.getPreferences().getBoolean(STRICT_KEY, false)) || str == null && !ctx.getPreferences().getBoolean(STRICT_KEY, false)) {
            target = "new $exc($del)";
        } else {
            TypeElement jlString = ctx.getInfo().getElements().getTypeElement("java.lang.String");
            if (jlString == null) {
                return null;
            }
            constrParams.add(jlString.asType());
            target = str != null ? "new $exc($str, $del)" : "new $exc(null, $del)";
        }
        if (toThrow) {
            target = "throw " + target + ";";
        }
        TreePath del = (TreePath)ctx.getVariables().get("$del");
        TypeMirror delType = ctx.getInfo().getTrees().getTypeMirror(del);
        constrParams.add(delType);
        if (!ThrowableInitCause.findConstructor(el, t, constrParams)) {
            return null;
        }
        String fixDisplayName = NbBundle.getMessage(ThrowableInitCause.class, (String)"FIX_ThrowableInitCause");
        String displayName = NbBundle.getMessage(ThrowableInitCause.class, (String)"ERR_ThrowableInitCause");
        TreePath toUnderline = (TreePath)ctx.getVariables().get("$excVar");
        if (toUnderline == null) {
            toUnderline = ctx.getPath();
        }
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)toUnderline, (String)displayName, (Fix[])new Fix[]{JavaFixUtilities.rewriteFix((HintContext)ctx, (String)fixDisplayName, (TreePath)ctx.getPath(), (String)target)});
    }

    private static boolean findConstructor(Element el, Types t, List<TypeMirror> paramTypes) {
        boolean found = false;
        block0: for (ExecutableElement ee : ElementFilter.constructorsIn(el.getEnclosedElements())) {
            if (ee.isVarArgs() || ee.getParameters().size() != paramTypes.size()) continue;
            Iterator<? extends VariableElement> p = ee.getParameters().iterator();
            Iterator<TypeMirror> expectedType = paramTypes.iterator();
            while (p.hasNext() && expectedType.hasNext()) {
                if (t.isAssignable(expectedType.next(), p.next().asType())) continue;
                continue block0;
            }
            found = true;
            break;
        }
        return found;
    }
}

