/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk.mapreduce;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.jdk.mapreduce.PreconditionsChecker;
import org.netbeans.modules.java.hints.jdk.mapreduce.ProspectiveOperation;

public class Refactorer {
    private boolean untrasformable;
    private EnhancedForLoopTree loop;
    private WorkingCopy workingCopy;
    private TreeMaker treeMaker;
    private PreconditionsChecker preconditionsChecker;
    List<ProspectiveOperation> prospectives;

    private boolean isOneStatementBlock(StatementTree then) {
        return then.getKind() == Tree.Kind.BLOCK && ((BlockTree)then).getStatements().size() == 1;
    }

    private boolean isReturningIf(IfTree ifTree) {
        BlockTree block;
        StatementTree then = ifTree.getThenStatement();
        if (then.getKind() == Tree.Kind.RETURN) {
            return true;
        }
        return then.getKind() == Tree.Kind.BLOCK && (block = (BlockTree)then).getStatements().size() == 1 && block.getStatements().get(0).getKind() == Tree.Kind.RETURN;
    }

    public Refactorer(EnhancedForLoopTree loop, WorkingCopy workingCopy, PreconditionsChecker scanner) {
        this.loop = loop;
        this.workingCopy = workingCopy;
        this.treeMaker = workingCopy.getTreeMaker();
        this.preconditionsChecker = scanner;
    }

    public Boolean isRefactorable() {
        this.prospectives = this.getListRepresentation(this.loop.getStatement());
        if (this.prospectives != null && !this.prospectives.isEmpty()) {
            this.prospectives.get(this.prospectives.size() - 1).eagerize();
            if (this.untrasformable) {
                return false;
            }
            for (int i = 0; i < this.prospectives.size() - 1; ++i) {
                if (this.prospectives.get(i).isLazy().booleanValue()) continue;
                return false;
            }
            this.prospectives = ProspectiveOperation.mergeIntoComposableOperations(this.prospectives);
            return this.prospectives != null;
        }
        return false;
    }

    public StatementTree refactor(TreeMaker treeMaker) {
        StatementTree loopBody = this.loop.getStatement();
        VariableTree var = this.loop.getVariable();
        ExpressionTree expr = this.loop.getExpression();
        MethodInvocationTree mi = this.chainAllProspectives(treeMaker, expr);
        ProspectiveOperation lastOperation = this.prospectives.get(this.prospectives.size() - 1);
        StatementTree returnValue = this.propagateSideEffects(lastOperation, mi, treeMaker);
        return returnValue;
    }

    private Boolean isIfWithContinue(IfTree ifTree) {
        List<? extends StatementTree> statements;
        StatementTree then = ifTree.getThenStatement();
        if (then.getKind() == Tree.Kind.CONTINUE) {
            return true;
        }
        if (then.getKind() == Tree.Kind.BLOCK && (statements = ((BlockTree)then).getStatements()).size() == 1 && statements.get(0).getKind() == Tree.Kind.CONTINUE) {
            return true;
        }
        return false;
    }

    private List<ProspectiveOperation> getListRepresentation(StatementTree tree) {
        ArrayList<ProspectiveOperation> ls = new ArrayList<ProspectiveOperation>();
        if (tree.getKind() == Tree.Kind.BLOCK) {
            ls.addAll(this.getBlockListRepresentation(tree));
        } else if (tree.getKind() == Tree.Kind.IF) {
            ls.addAll(this.getIfListRepresentation(tree));
        } else {
            ls.addAll(this.getSingleStatementListRepresentation(tree));
        }
        return ls;
    }

    private IfTree refactorContinuingIf(IfTree ifTree, List<? extends StatementTree> newStatements) {
        UnaryTree newPredicate = this.treeMaker.Unary(Tree.Kind.LOGICAL_COMPLEMENT, ifTree.getCondition());
        BlockTree newThen = this.treeMaker.Block(newStatements, false);
        return this.treeMaker.If((ExpressionTree)newPredicate, (StatementTree)newThen, null);
    }

    private MethodInvocationTree chainAllProspectives(TreeMaker treeMaker, ExpressionTree expr) {
        MethodInvocationTree mi = treeMaker.MethodInvocation(new ArrayList(), (ExpressionTree)treeMaker.MemberSelect(expr, (CharSequence)"stream"), new ArrayList());
        for (ProspectiveOperation prospective : this.prospectives) {
            mi = treeMaker.MethodInvocation(new ArrayList(), (ExpressionTree)treeMaker.MemberSelect((ExpressionTree)mi, (CharSequence)prospective.getSuitableMethod()), prospective.getArguments());
        }
        return mi;
    }

    private StatementTree propagateSideEffects(ProspectiveOperation lastOperation, MethodInvocationTree mi, TreeMaker treeMaker) {
        StatementTree returnValue = lastOperation.shouldReturn() ? this.propagateReturn(lastOperation, mi, treeMaker) : (lastOperation.shouldAssign() ? treeMaker.ExpressionStatement((ExpressionTree)treeMaker.Assignment((ExpressionTree)this.preconditionsChecker.getVariableToAssign(), (ExpressionTree)mi)) : treeMaker.ExpressionStatement((ExpressionTree)mi));
        return returnValue;
    }

    private StatementTree propagateReturn(ProspectiveOperation lastOperation, MethodInvocationTree mi, TreeMaker treeMaker) {
        ReturnTree returnExpre = null;
        ExpressionTree pred = null;
        if ("anyMatch".equals(lastOperation.getSuitableMethod())) {
            pred = mi;
            returnExpre = treeMaker.Return((ExpressionTree)treeMaker.Literal((Object)true));
        } else if ("noneMatch".equals(lastOperation.getSuitableMethod())) {
            pred = treeMaker.Unary(Tree.Kind.LOGICAL_COMPLEMENT, (ExpressionTree)mi);
            returnExpre = treeMaker.Return((ExpressionTree)treeMaker.Literal((Object)false));
        }
        return treeMaker.If(pred, (StatementTree)returnExpre, null);
    }

    private List<ProspectiveOperation> getBlockListRepresentation(StatementTree tree) {
        ArrayList<ProspectiveOperation> ls = new ArrayList<ProspectiveOperation>();
        BlockTree blockTree = (BlockTree)tree;
        List<? extends StatementTree> statements = blockTree.getStatements();
        for (int i = 0; i < statements.size(); ++i) {
            StatementTree statement = statements.get(i);
            if (statement.getKind() == Tree.Kind.IF) {
                IfTree ifTree = (IfTree)statement;
                if (this.isIfWithContinue(ifTree).booleanValue()) {
                    ifTree = this.refactorContinuingIf(ifTree, statements.subList(i + 1, statements.size()));
                    ls.addAll(this.getListRepresentation(ifTree));
                    break;
                }
                if (i == statements.size() - 1) {
                    ls.addAll(this.getListRepresentation(ifTree));
                    continue;
                }
                if (this.isReturningIf(ifTree)) {
                    this.untrasformable = true;
                }
                ls.addAll(ProspectiveOperation.createOperator(ifTree, ProspectiveOperation.OperationType.MAP, this.preconditionsChecker, this.workingCopy));
                continue;
            }
            ls.addAll(this.getListRepresentation(statement));
        }
        return ls;
    }

    private List<ProspectiveOperation> getIfListRepresentation(StatementTree tree) {
        IfTree ifTree = (IfTree)tree;
        ArrayList<ProspectiveOperation> ls = new ArrayList<ProspectiveOperation>();
        if (ifTree.getElseStatement() == null) {
            StatementTree then = ifTree.getThenStatement();
            if (this.isOneStatementBlock(then)) {
                then = ((BlockTree)then).getStatements().get(0);
            }
            if (then.getKind() == Tree.Kind.RETURN) {
                ReturnTree returnTree = (ReturnTree)then;
                ExpressionTree returnExpression = returnTree.getExpression();
                if (returnExpression.getKind() == Tree.Kind.BOOLEAN_LITERAL && ((LiteralTree)returnExpression).getValue().equals(true)) {
                    ls.addAll(ProspectiveOperation.createOperator(ifTree, ProspectiveOperation.OperationType.ANYMATCH, this.preconditionsChecker, this.workingCopy));
                } else if (returnExpression.getKind() == Tree.Kind.BOOLEAN_LITERAL && ((LiteralTree)returnExpression).getValue().equals(false)) {
                    ls.addAll(ProspectiveOperation.createOperator(ifTree, ProspectiveOperation.OperationType.NONEMATCH, this.preconditionsChecker, this.workingCopy));
                }
            } else {
                ls.addAll(ProspectiveOperation.createOperator(ifTree, ProspectiveOperation.OperationType.FILTER, this.preconditionsChecker, this.workingCopy));
                ls.addAll(this.getListRepresentation(ifTree.getThenStatement()));
            }
        } else {
            ls.addAll(ProspectiveOperation.createOperator(ifTree, ProspectiveOperation.OperationType.MAP, this.preconditionsChecker, this.workingCopy));
        }
        return ls;
    }

    private List<ProspectiveOperation> getSingleStatementListRepresentation(StatementTree tree) {
        ArrayList<ProspectiveOperation> ls = new ArrayList<ProspectiveOperation>();
        if (this.preconditionsChecker.isReducer().booleanValue() && this.preconditionsChecker.getReducer().equals(tree)) {
            ls.addAll(ProspectiveOperation.createOperator(tree, ProspectiveOperation.OperationType.REDUCE, this.preconditionsChecker, this.workingCopy));
        } else {
            ls.addAll(ProspectiveOperation.createOperator(tree, ProspectiveOperation.OperationType.MAP, this.preconditionsChecker, this.workingCopy));
        }
        return ls;
    }
}

