/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.NBPluginParameterExpressionEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class PluginPropertyUtils {
    private static final String CONTEXT_EXPRESSION_EVALUATOR = "NB_EVALUATOR";
    private static final List<String> LIFECYCLE_PLUGINS = Arrays.asList("maven-compiler-plugin", "maven-surefire-plugin", "maven-ear-plugin", "maven-jar-plugin", "maven-war-plugin", "maven-resources-plugin");
    private static ExpressionEvaluator DUMMY_EVALUATOR = new ExpressionEvaluator(){

        public Object evaluate(String string) throws ExpressionEvaluationException {
            return string;
        }

        public File alignToBaseDirectory(File file) {
            return file;
        }
    };

    private PluginPropertyUtils() {
    }

    @Deprecated
    @CheckForNull
    public static String getPluginProperty(@NonNull Project prj, @NonNull String groupId, @NonNull String artifactId, @NonNull String parameter, @NullAllowed String goal) {
        return PluginPropertyUtils.getPluginProperty(prj, groupId, artifactId, parameter, goal, null);
    }

    @CheckForNull
    public static String getPluginProperty(@NonNull Project prj, @NonNull String groupId, @NonNull String artifactId, @NonNull String parameter, @NullAllowed String goal, @NullAllowed String expressionProperty) {
        NbMavenProjectImpl project;
        NbMavenProjectImpl nbMavenProjectImpl = project = prj instanceof NbMavenProjectImpl ? (NbMavenProjectImpl)prj : (NbMavenProjectImpl)prj.getLookup().lookup(NbMavenProjectImpl.class);
        assert (project != null) : "Requires a maven project instance";
        return PluginPropertyUtils.getPluginPropertyImpl(project.getOriginalMavenProject(), groupId, artifactId, PluginPropertyUtils.simpleProperty(parameter), goal, PluginPropertyUtils.simpleDefaultProperty(expressionProperty));
    }

    @Deprecated
    @CheckForNull
    public static String getPluginProperty(@NonNull MavenProject prj, @NonNull String groupId, @NonNull String artifactId, @NonNull String parameter, @NullAllowed String goal) {
        return PluginPropertyUtils.getPluginProperty(prj, groupId, artifactId, parameter, goal, null);
    }

    @CheckForNull
    public static String getPluginProperty(@NonNull MavenProject prj, @NonNull String groupId, @NonNull String artifactId, @NonNull String parameter, @NullAllowed String goal, @NullAllowed String expressionProperty) {
        return PluginPropertyUtils.getPluginPropertyImpl(prj, groupId, artifactId, PluginPropertyUtils.simpleProperty(parameter), goal, PluginPropertyUtils.simpleDefaultProperty(expressionProperty));
    }

    @CheckForNull
    private static <T> T getPluginPropertyImpl(@NonNull MavenProject prj, @NonNull String groupId, @NonNull String artifactId, @NonNull ConfigurationBuilder<T> builder, @NullAllowed String goal, @NullAllowed ExternalDefaultBuilder<T> external) {
        T toRet = null;
        if (prj.getBuildPlugins() == null) {
            return toRet;
        }
        for (Plugin plug : prj.getBuildPlugins()) {
            PluginExecution exe;
            if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
            Iterator<PluginExecution> i$ = PluginPropertyUtils.getPluginExecutions(plug, goal).iterator();
            while (i$.hasNext() && (toRet = (T)builder.build((Xpp3Dom)(exe = i$.next()).getConfiguration(), DUMMY_EVALUATOR)) == null) {
            }
            if (toRet != null) continue;
            toRet = builder.build((Xpp3Dom)plug.getConfiguration(), DUMMY_EVALUATOR);
        }
        if (toRet == null && LIFECYCLE_PLUGINS.contains(artifactId) && prj.getPluginManagement() != null) {
            for (Plugin plug : prj.getPluginManagement().getPlugins()) {
                if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
                toRet = builder.build((Xpp3Dom)plug.getConfiguration(), DUMMY_EVALUATOR);
                break;
            }
        }
        if (toRet == null && external != null) {
            toRet = external.externalValue(prj);
        }
        return toRet;
    }

    public static <T> T getPluginPropertyBuildable(@NonNull Project prj, @NonNull String groupId, @NonNull String artifactId, @NullAllowed String goal, @NonNull ConfigurationBuilder<T> builder) {
        NbMavenProjectImpl project;
        NbMavenProjectImpl nbMavenProjectImpl = project = prj instanceof NbMavenProjectImpl ? (NbMavenProjectImpl)prj : (NbMavenProjectImpl)prj.getLookup().lookup(NbMavenProjectImpl.class);
        assert (project != null) : "Requires a maven project instance";
        return PluginPropertyUtils.getPluginPropertyImpl(project.getOriginalMavenProject(), groupId, artifactId, builder, goal, null);
    }

    public static <T> T getPluginPropertyBuildable(@NonNull MavenProject prj, @NonNull String groupId, @NonNull String artifactId, @NullAllowed String goal, @NonNull ConfigurationBuilder<T> builder) {
        return PluginPropertyUtils.getPluginPropertyImpl(prj, groupId, artifactId, builder, goal, null);
    }

    @CheckForNull
    public static String getReportPluginProperty(@NonNull Project prj, @NonNull String groupId, @NonNull String artifactId, @NonNull String property, @NullAllowed String report) {
        NbMavenProjectImpl project;
        NbMavenProjectImpl nbMavenProjectImpl = project = prj instanceof NbMavenProjectImpl ? (NbMavenProjectImpl)prj : (NbMavenProjectImpl)prj.getLookup().lookup(NbMavenProjectImpl.class);
        assert (project != null) : "Requires a maven project instance";
        return PluginPropertyUtils.getReportPluginPropertyImpl(project.getOriginalMavenProject(), groupId, artifactId, PluginPropertyUtils.simpleProperty(property), report);
    }

    @CheckForNull
    public static String getReportPluginProperty(@NonNull MavenProject prj, @NonNull String groupId, @NonNull String artifactId, @NonNull String property, @NullAllowed String report) {
        return PluginPropertyUtils.getReportPluginPropertyImpl(prj, groupId, artifactId, PluginPropertyUtils.simpleProperty(property), report);
    }

    @CheckForNull
    private static <T> T getReportPluginPropertyImpl(@NonNull MavenProject prj, @NonNull String groupId, @NonNull String artifactId, @NonNull ConfigurationBuilder<T> builder, @NullAllowed String report) {
        T toRet = null;
        for (ReportPlugin plug : PluginPropertyUtils.getEffectiveReportPlugins(prj)) {
            if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
            if (plug.getReportSets() != null) {
                ReportSet exe;
                Iterator i$ = plug.getReportSets().iterator();
                while (i$.hasNext() && (!(exe = (ReportSet)i$.next()).getReports().contains(report) || (toRet = (T)builder.build((Xpp3Dom)exe.getConfiguration(), DUMMY_EVALUATOR)) == null)) {
                }
            }
            if (toRet != null) continue;
            toRet = builder.build((Xpp3Dom)plug.getConfiguration(), DUMMY_EVALUATOR);
        }
        return toRet;
    }

    @CheckForNull
    public static String getPluginVersion(@NonNull MavenProject prj, @NonNull String groupId, @NonNull String artifactId) {
        String toRet = null;
        if (prj.getBuildPlugins() == null) {
            return toRet;
        }
        for (Plugin plug : prj.getBuildPlugins()) {
            if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
            toRet = plug.getVersion();
        }
        if (toRet == null && LIFECYCLE_PLUGINS.contains(artifactId) && prj.getPluginManagement() != null) {
            for (Plugin plug : prj.getPluginManagement().getPlugins()) {
                if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
                toRet = plug.getVersion();
                break;
            }
        }
        return toRet;
    }

    @CheckForNull
    public static String getReportPluginVersion(@NonNull MavenProject prj, @NonNull String groupId, @NonNull String artifactId) {
        for (ReportPlugin plug : PluginPropertyUtils.getEffectiveReportPlugins(prj)) {
            if (!groupId.equals(plug.getGroupId()) || !artifactId.equals(plug.getArtifactId())) continue;
            return plug.getVersion();
        }
        return null;
    }

    @NonNull
    static ConfigurationBuilder<String> simpleProperty(final @NonNull String property) {
        return new ConfigurationBuilder<String>(){

            @Override
            public String build(Xpp3Dom configRoot, ExpressionEvaluator eval) {
                Xpp3Dom source;
                if (configRoot != null && (source = configRoot.getChild(property)) != null) {
                    String value = source.getValue();
                    if (value == null) {
                        return null;
                    }
                    return value.trim();
                }
                return null;
            }
        };
    }

    @NonNull
    static ExternalDefaultBuilder<String> simpleDefaultProperty(final @NullAllowed String expressionProperty) {
        return new ExternalDefaultBuilder<String>(){

            @Override
            public String externalValue(MavenProject prj) {
                if (expressionProperty == null) {
                    return null;
                }
                Properties prop = prj.getProperties();
                if (prop != null) {
                    return prop.getProperty(expressionProperty);
                }
                return null;
            }
        };
    }

    @NonNull
    static ConfigurationBuilder<String[]> listProperty(final @NonNull String multiProperty, final @NonNull String singleProperty) {
        return new ConfigurationBuilder<String[]>(){

            @Override
            public String[] build(Xpp3Dom conf, ExpressionEvaluator eval) {
                Xpp3Dom dom;
                Xpp3Dom source;
                if (conf != null && (source = (dom = conf).getChild(multiProperty)) != null) {
                    Xpp3Dom[] childs;
                    ArrayList<String> toRet = new ArrayList<String>();
                    for (Xpp3Dom ch : childs = source.getChildren(singleProperty)) {
                        String chvalue = ch.getValue() == null ? "" : ch.getValue().trim();
                        toRet.add(chvalue);
                    }
                    return toRet.toArray(new String[toRet.size()]);
                }
                return null;
            }
        };
    }

    @NonNull
    static ConfigurationBuilder<Properties> propertiesBuilder(final @NonNull String propertyParameter) {
        return new ConfigurationBuilder<Properties>(){

            @Override
            public Properties build(Xpp3Dom conf, ExpressionEvaluator eval) {
                Xpp3Dom source;
                if (conf != null && (source = conf.getChild(propertyParameter)) != null) {
                    Xpp3Dom[] childs;
                    Properties toRet = new Properties();
                    for (Xpp3Dom ch : childs = source.getChildren()) {
                        String val = ch.getValue();
                        if (val == null) {
                            if (ch.getChildCount() == 2) {
                                Xpp3Dom nameDom = ch.getChild("name");
                                Xpp3Dom valueDom = ch.getChild("value");
                                if (nameDom != null && valueDom != null) {
                                    String name = nameDom.getValue();
                                    String value = valueDom.getValue();
                                    if (name != null && value != null) {
                                        toRet.put(name, value);
                                    }
                                }
                            }
                            toRet.put(ch.getName(), "");
                            continue;
                        }
                        toRet.put(ch.getName(), val.trim());
                    }
                    return toRet;
                }
                return null;
            }
        };
    }

    @CheckForNull
    public static String[] getPluginPropertyList(@NonNull Project prj, @NonNull String groupId, @NonNull String artifactId, @NonNull String multiproperty, @NonNull String singleproperty, @NullAllowed String goal) {
        NbMavenProjectImpl project;
        NbMavenProjectImpl nbMavenProjectImpl = project = prj instanceof NbMavenProjectImpl ? (NbMavenProjectImpl)prj : (NbMavenProjectImpl)prj.getLookup().lookup(NbMavenProjectImpl.class);
        assert (project != null) : "Requires a maven project instance";
        return PluginPropertyUtils.getPluginPropertyImpl(project.getOriginalMavenProject(), groupId, artifactId, PluginPropertyUtils.listProperty(multiproperty, singleproperty), goal, null);
    }

    @CheckForNull
    public static String[] getPluginPropertyList(@NonNull MavenProject prj, @NonNull String groupId, @NonNull String artifactId, @NonNull String multiproperty, @NonNull String singleproperty, @NullAllowed String goal) {
        return PluginPropertyUtils.getPluginPropertyImpl(prj, groupId, artifactId, PluginPropertyUtils.listProperty(multiproperty, singleproperty), goal, null);
    }

    @CheckForNull
    public static String[] getReportPluginPropertyList(@NonNull Project prj, @NonNull String groupId, @NonNull String artifactId, @NonNull String multiproperty, @NonNull String singleproperty, @NullAllowed String goal) {
        NbMavenProjectImpl project;
        NbMavenProjectImpl nbMavenProjectImpl = project = prj instanceof NbMavenProjectImpl ? (NbMavenProjectImpl)prj : (NbMavenProjectImpl)prj.getLookup().lookup(NbMavenProjectImpl.class);
        assert (project != null) : "Requires a maven project instance";
        return PluginPropertyUtils.getReportPluginPropertyImpl(project.getOriginalMavenProject(), groupId, artifactId, PluginPropertyUtils.listProperty(multiproperty, singleproperty), goal);
    }

    @CheckForNull
    public static String[] getReportPluginPropertyList(@NonNull MavenProject prj, @NonNull String groupId, @NonNull String artifactId, @NonNull String multiproperty, @NonNull String singleproperty, @NullAllowed String goal) {
        return PluginPropertyUtils.getReportPluginPropertyImpl(prj, groupId, artifactId, PluginPropertyUtils.listProperty(multiproperty, singleproperty), goal);
    }

    @CheckForNull
    public static Properties getPluginPropertyParameter(@NonNull Project prj, @NonNull String groupId, @NonNull String artifactId, @NonNull String propertyParameter, @NullAllowed String goal) {
        NbMavenProjectImpl project;
        NbMavenProjectImpl nbMavenProjectImpl = project = prj instanceof NbMavenProjectImpl ? (NbMavenProjectImpl)prj : (NbMavenProjectImpl)prj.getLookup().lookup(NbMavenProjectImpl.class);
        assert (project != null) : "Requires a maven project instance";
        return PluginPropertyUtils.getPluginPropertyImpl(project.getOriginalMavenProject(), groupId, artifactId, PluginPropertyUtils.propertiesBuilder(propertyParameter), goal, null);
    }

    @CheckForNull
    public static Properties getPluginPropertyParameter(@NonNull MavenProject prj, @NonNull String groupId, @NonNull String artifactId, @NonNull String propertyParameter, @NullAllowed String goal) {
        return PluginPropertyUtils.getPluginPropertyImpl(prj, groupId, artifactId, PluginPropertyUtils.propertiesBuilder(propertyParameter), goal, null);
    }

    @NonNull
    private static Iterable<ReportPlugin> getEffectiveReportPlugins(@NonNull MavenProject prj) {
        ArrayList<ReportPlugin> plugins = new ArrayList<ReportPlugin>();
        for (Plugin plug : prj.getBuildPlugins()) {
            Xpp3Dom reportPlugins;
            Xpp3Dom cfg;
            if (!"org.apache.maven.plugins".equals(plug.getGroupId()) || !"maven-site-plugin".equals(plug.getArtifactId()) || (cfg = (Xpp3Dom)plug.getConfiguration()) == null || (reportPlugins = cfg.getChild("reportPlugins")) == null) continue;
            for (Xpp3Dom plugin : reportPlugins.getChildren("plugin")) {
                Xpp3Dom version;
                Xpp3Dom artifactId;
                ReportPlugin p = new ReportPlugin();
                Xpp3Dom groupId = plugin.getChild("groupId");
                if (groupId != null) {
                    p.setGroupId(groupId.getValue());
                }
                if ((artifactId = plugin.getChild("artifactId")) != null) {
                    p.setArtifactId(artifactId.getValue());
                }
                if ((version = plugin.getChild("version")) != null) {
                    p.setVersion(version.getValue());
                }
                p.setConfiguration((Object)plugin.getChild("configuration"));
                plugins.add(p);
            }
        }
        List m2Plugins = prj.getReportPlugins();
        plugins.addAll(m2Plugins);
        return plugins;
    }

    @NonNull
    public static ExpressionEvaluator createEvaluator(@NonNull Project project) {
        NbMavenProjectImpl prj;
        NbMavenProjectImpl nbMavenProjectImpl = prj = project instanceof NbMavenProjectImpl ? (NbMavenProjectImpl)project : (NbMavenProjectImpl)project.getLookup().lookup(NbMavenProjectImpl.class);
        assert (prj != null);
        MavenProject mvnprj = prj.getOriginalMavenProject();
        ExpressionEvaluator eval = (ExpressionEvaluator)mvnprj.getContextValue(CONTEXT_EXPRESSION_EVALUATOR);
        if (eval == null) {
            Settings ss = EmbedderFactory.getProjectEmbedder().getSettings();
            ss.setLocalRepository(EmbedderFactory.getProjectEmbedder().getLocalRepository().getBasedir());
            eval = new NBPluginParameterExpressionEvaluator(mvnprj, ss, prj.createSystemPropsForPropertyExpressions(), prj.createUserPropsForPropertyExpressions());
            mvnprj.setContextValue(CONTEXT_EXPRESSION_EVALUATOR, (Object)eval);
        }
        return eval;
    }

    @NonNull
    public static ExpressionEvaluator createEvaluator(@NonNull MavenProject prj) {
        NbMavenProjectImpl project;
        Project p;
        FileObject bsd;
        ExpressionEvaluator eval = (ExpressionEvaluator)prj.getContextValue(CONTEXT_EXPRESSION_EVALUATOR);
        if (eval != null) {
            return eval;
        }
        Map<Object, Object> sysprops = Collections.emptyMap();
        Map<Object, Object> userprops = Collections.emptyMap();
        File basedir = prj.getBasedir();
        if (basedir != null && (bsd = FileUtil.toFileObject((File)basedir)) != null && (p = FileOwnerQuery.getOwner((FileObject)bsd)) != null && (project = (NbMavenProjectImpl)p.getLookup().lookup(NbMavenProjectImpl.class)) != null) {
            sysprops = project.createSystemPropsForPropertyExpressions();
            userprops = project.createUserPropsForPropertyExpressions();
        }
        Settings ss = EmbedderFactory.getProjectEmbedder().getSettings();
        ss.setLocalRepository(EmbedderFactory.getProjectEmbedder().getLocalRepository().getBasedir());
        eval = new NBPluginParameterExpressionEvaluator(prj, ss, sysprops, userprops);
        prj.setContextValue(CONTEXT_EXPRESSION_EVALUATOR, (Object)eval);
        return eval;
    }

    @NonNull
    private static List<PluginExecution> getPluginExecutions(@NonNull Plugin plug, @NullAllowed String goal) {
        if (goal == null) {
            return Collections.emptyList();
        }
        ArrayList<PluginExecution> exes = new ArrayList<PluginExecution>();
        for (PluginExecution exe : plug.getExecutions()) {
            if (!exe.getGoals().contains(goal) && !("default-" + goal).equals(exe.getId())) continue;
            exes.add(exe);
        }
        Collections.sort(exes, new Comparator<PluginExecution>(){

            @Override
            public int compare(PluginExecution e1, PluginExecution e2) {
                return e2.getPriority() - e1.getPriority();
            }
        });
        return exes;
    }

    private static interface ExternalDefaultBuilder<T> {
        public T externalValue(MavenProject var1);
    }

    public static interface ConfigurationBuilder<T> {
        public T build(Xpp3Dom var1, ExpressionEvaluator var2);
    }
}

