/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute.cmd;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.maven.execute.cmd.Constructor;
import org.netbeans.modules.maven.options.MavenSettings;
import org.openide.util.Utilities;

public class ShellConstructor
implements Constructor {
    @NonNull
    private final File mavenHome;

    public ShellConstructor(@NonNull File mavenHome) {
        this.mavenHome = mavenHome;
    }

    @Override
    public List<String> construct() {
        String quote = "\"";
        ArrayList<String> toRet = new ArrayList<String>();
        String ex = "mvn";
        if (Utilities.isWindows()) {
            String version = MavenSettings.getCommandLineMavenVersion(this.mavenHome);
            if (null == version) {
                ex = "mvn.bat";
            } else {
                String[] v = version.split("\\.");
                int major = Integer.parseInt(v[0]);
                int minor = Integer.parseInt(v[1]);
                ex = major < 3 || major == 3 && minor < 3 ? "mvn.bat" : "mvn.cmd";
            }
        }
        File bin = new File(this.mavenHome, "bin" + File.separator + ex);
        toRet.add(ShellConstructor.quoteSpaces(bin.getAbsolutePath(), quote));
        if (Utilities.isWindows()) {
            toRet.add(0, "/c");
            toRet.add(0, "cmd");
        }
        return toRet;
    }

    private static String quoteSpaces(String val, String quote) {
        if (Utilities.isWindows()) {
            return quote + val + quote;
        }
        return val;
    }
}

