/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.problems;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbArtifactFixer;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.actions.OpenPOMAction;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.modelcache.MavenProjectCache;
import org.netbeans.modules.maven.problems.Bundle;
import org.netbeans.modules.maven.problems.ProblemReporterImpl;
import org.netbeans.modules.maven.problems.SanityBuildAction;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class MavenModelProblemsProvider
implements ProjectProblemsProvider {
    static final RequestProcessor RP = new RequestProcessor(MavenModelProblemsProvider.class);
    private static final Logger LOG = Logger.getLogger(MavenModelProblemsProvider.class.getName());
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final Project project;
    private final AtomicBoolean projectListenerSet = new AtomicBoolean(false);
    private final AtomicReference<Collection<ProjectProblemsProvider.ProjectProblem>> problemsCache = new AtomicReference();
    private ProblemReporterImpl problemReporter;
    private final PropertyChangeListener projectListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("MavenProject".equals(evt.getPropertyName())) {
                MavenModelProblemsProvider.this.firePropertyChange();
            }
        }
    };

    public MavenModelProblemsProvider(Project project) {
        this.project = project;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends ProjectProblemsProvider.ProjectProblem> getProblems() {
        final MavenProject prj = ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).getMavenProject();
        MavenModelProblemsProvider mavenModelProblemsProvider = this;
        synchronized (mavenModelProblemsProvider) {
            Collection<ProjectProblemsProvider.ProjectProblem> cached;
            Object wasprocessed;
            if (this.projectListenerSet.compareAndSet(false, true)) {
                this.problemReporter = ((NbMavenProjectImpl)this.project.getLookup().lookup(NbMavenProjectImpl.class)).getProblemReporter();
                assert (this.problemReporter != null);
                ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).addPropertyChangeListener(this.projectListener);
            }
            if ((wasprocessed = prj.getContextValue(MavenModelProblemsProvider.class.getName())) != null && (cached = this.problemsCache.get()) != null) {
                return cached;
            }
            Callable<Collection<? extends ProjectProblemsProvider.ProjectProblem>> c = new Callable<Collection<? extends ProjectProblemsProvider.ProjectProblem>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Collection<? extends ProjectProblemsProvider.ProjectProblem> call() throws Exception {
                    Collection cached;
                    Object wasprocessed = prj.getContextValue(MavenModelProblemsProvider.class.getName());
                    if (wasprocessed != null && (cached = (Collection)MavenModelProblemsProvider.this.problemsCache.get()) != null) {
                        return Collections.EMPTY_LIST;
                    }
                    ArrayList<ProjectProblemsProvider.ProjectProblem> toRet = new ArrayList<ProjectProblemsProvider.ProjectProblem>();
                    MavenExecutionResult res = MavenProjectCache.getExecutionResult(prj);
                    if (res != null && res.hasExceptions()) {
                        toRet.addAll(MavenModelProblemsProvider.this.reportExceptions(res));
                    }
                    toRet.addAll(MavenModelProblemsProvider.this.doArtifactChecks(prj));
                    prj.setContextValue(MavenModelProblemsProvider.class.getName(), new Object());
                    MavenModelProblemsProvider mavenModelProblemsProvider = MavenModelProblemsProvider.this;
                    synchronized (mavenModelProblemsProvider) {
                        MavenModelProblemsProvider.this.problemsCache.set(toRet);
                    }
                    MavenModelProblemsProvider.this.firePropertyChange();
                    return toRet;
                }
            };
            if (Boolean.getBoolean("test.reload.sync")) {
                try {
                    return (Collection)c.call();
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                RP.submit((Callable)c);
            }
        }
        return Collections.emptyList();
    }

    private void firePropertyChange() {
        this.support.firePropertyChange("problems", null, null);
    }

    public Collection<ProjectProblemsProvider.ProjectProblem> doArtifactChecks(@NonNull MavenProject project) {
        ArrayList<ProjectProblemsProvider.ProjectProblem> toRet = new ArrayList<ProjectProblemsProvider.ProjectProblem>();
        if (MavenProjectCache.unknownBuildParticipantObserved(project)) {
            StringBuilder sb = new StringBuilder();
            for (String s : MavenProjectCache.getUnknownBuildParticipantsClassNames(project)) {
                sb.append(s).append("\n");
            }
            toRet.add(ProjectProblemsProvider.ProjectProblem.createWarning((String)Bundle.ERR_Participant(), (String)Bundle.MSG_Participant(sb.toString())));
        }
        toRet.addAll(this.checkParents(project));
        boolean missingNonSibling = false;
        ArrayList<Artifact> missingJars = new ArrayList<Artifact>();
        for (Artifact art : project.getArtifacts()) {
            File file = art.getFile();
            if (file == null || !file.exists()) {
                if ("system".equals(art.getScope())) {
                    toRet.add(ProjectProblemsProvider.ProjectProblem.createWarning((String)Bundle.ERR_SystemScope(), (String)Bundle.MSG_SystemScope(), (ProjectProblemResolver)new ProblemReporterImpl.MavenProblemResolver(OpenPOMAction.instance().createContextAwareInstance(Lookups.fixed((Object[])new Object[]{project})), "SCOPE_DEPENDENCY")));
                    continue;
                }
                this.problemReporter.addMissingArtifact(art);
                if (file == null) {
                    missingNonSibling = true;
                } else {
                    SourceForBinaryQuery.Result2 result;
                    URL archiveUrl = FileUtil.urlForArchiveOrDir((File)file);
                    if (!(archiveUrl == null || (result = SourceForBinaryQuery.findSourceRoots2((URL)archiveUrl)).preferSources() && result.getRoots().length != 0)) {
                        missingNonSibling = true;
                    }
                }
                missingJars.add(art);
                continue;
            }
            if (!NbArtifactFixer.isFallbackFile(file)) continue;
            this.problemReporter.addMissingArtifact(art);
            missingJars.add(art);
            missingNonSibling = true;
        }
        if (!missingJars.isEmpty()) {
            StringBuilder mess = new StringBuilder();
            for (Artifact art : missingJars) {
                mess.append(art.getId()).append('\n');
            }
            if (missingNonSibling) {
                toRet.add(ProjectProblemsProvider.ProjectProblem.createWarning((String)Bundle.ERR_NonLocal(), (String)Bundle.MSG_NonLocal(mess), (ProjectProblemResolver)new SanityBuildAction(this.project)));
            }
        }
        return toRet;
    }

    private Collection<ProjectProblemsProvider.ProjectProblem> checkParents(@NonNull MavenProject project) {
        List mdls = MavenEmbedder.getModelDescriptors((MavenProject)project);
        boolean first = true;
        if (mdls == null) {
            return Collections.emptyList();
        }
        ArrayList<ProjectProblemsProvider.ProjectProblem> toRet = new ArrayList<ProjectProblemsProvider.ProjectProblem>();
        for (MavenEmbedder.ModelDescription m : mdls) {
            if (first) {
                first = false;
                continue;
            }
            if (!"F@LLB@CK".equals(m.getName())) continue;
            toRet.add(ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.ERR_NoParent(), (String)Bundle.MSG_NoParent(m.getId()), (ProjectProblemResolver)new SanityBuildAction(this.project)));
            this.problemReporter.addMissingArtifact(EmbedderFactory.getProjectEmbedder().createArtifact(m.getGroupId(), m.getArtifactId(), m.getVersion(), "pom"));
        }
        return toRet;
    }

    private Collection<ProjectProblemsProvider.ProjectProblem> reportExceptions(MavenExecutionResult res) {
        ArrayList<ProjectProblemsProvider.ProjectProblem> toRet = new ArrayList<ProjectProblemsProvider.ProjectProblem>();
        for (Throwable e : res.getExceptions()) {
            LOG.log(Level.FINE, "Error on loading project " + this.project.getProjectDirectory(), e);
            String msg = e.getMessage();
            if (e instanceof ArtifactResolutionException) {
                toRet.add(ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.TXT_Artifact_Resolution_problem(), (String)msg));
                this.problemReporter.addMissingArtifact(((ArtifactResolutionException)e).getArtifact());
                continue;
            }
            if (e instanceof ArtifactNotFoundException) {
                toRet.add(ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.TXT_Artifact_Not_Found(), (String)msg));
                this.problemReporter.addMissingArtifact(((ArtifactNotFoundException)e).getArtifact());
                continue;
            }
            if (e instanceof ProjectBuildingException) {
                toRet.add(ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.TXT_Cannot_Load_Project(), (String)msg, (ProjectProblemResolver)new SanityBuildAction(this.project)));
                if (!(e.getCause() instanceof ModelBuildingException)) continue;
                ModelBuildingException mbe = (ModelBuildingException)e.getCause();
                for (ModelProblem mp : mbe.getProblems()) {
                    LOG.log(Level.FINE, mp.toString(), mp.getException());
                    if (mp.getException() instanceof UnresolvableModelException) {
                        UnresolvableModelException ume = (UnresolvableModelException)mp.getException();
                        this.problemReporter.addMissingArtifact(EmbedderFactory.getProjectEmbedder().createProjectArtifact(ume.getGroupId(), ume.getArtifactId(), ume.getVersion()));
                        continue;
                    }
                    if (!(mp.getException() instanceof PluginResolutionException)) continue;
                    Plugin plugin = ((PluginResolutionException)mp.getException()).getPlugin();
                    this.problemReporter.addMissingArtifact(EmbedderFactory.getProjectEmbedder().createArtifact(plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion(), "jar"));
                }
                continue;
            }
            if (msg != null) {
                LOG.log(Level.INFO, "Exception thrown while loading maven project at " + this.project.getProjectDirectory(), e);
                toRet.add(ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.TXT_Cannot_read_model(), (String)msg));
                continue;
            }
            String path = this.project.getProjectDirectory().getPath();
            toRet.add(ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.TXT_Cannot_read_model(), (String)Bundle.TXT_NoMsg(path)));
            LOG.log(Level.WARNING, "Exception thrown while loading maven project at " + path, e);
        }
        return toRet;
    }
}

