/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.EventListener;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.queries.Bundle;
import org.netbeans.modules.maven.spi.nodes.SpecialIcon;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public final class Info
implements ProjectInformation,
PropertyChangeListener {
    private static final RequestProcessor RP = new RequestProcessor(Info.class.getName(), 10);
    private static final Logger LOG = Logger.getLogger(Info.class.getName());
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final Project project;
    private final PreferenceChangeListener preferenceChangeListener = new PreferenceChangeListener(){

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            if ("project.displayName".equals(evt.getKey())) {
                Info.this.pcs.firePropertyChange("name", null, null);
                Info.this.pcs.firePropertyChange("displayName", null, null);
            }
        }
    };
    private final AtomicBoolean prefChangeListenerSet = new AtomicBoolean(false);
    private boolean displayNameRunning = false;
    private String displayName;
    private final Runnable displayNameTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String s;
                NbMavenProject nb = (NbMavenProject)Info.this.project.getLookup().lookup(NbMavenProject.class);
                if (!nb.isMavenProjectLoaded()) {
                    nb.getMavenProject();
                }
                if (!(s = Info.this.getDisplayName(nb)).equals(Info.this.displayName)) {
                    Info.this.displayName = s;
                    Info.this.pcs.firePropertyChange("displayName", null, null);
                }
            }
            finally {
                Info.this.displayNameRunning = false;
            }
        }
    };

    public Info(Project project) {
        this.project = project;
    }

    public String getName() {
        NbMavenProject nb = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        return nb.getMavenProject().getId().replace(':', '_');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public String getDisplayName() {
        Runnable runnable = this.displayNameTask;
        synchronized (runnable) {
            if (this.displayName == null) {
                this.displayName = FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory());
            }
            if (!this.displayNameRunning) {
                this.displayNameRunning = true;
                if (Boolean.getBoolean("test.load.sync")) {
                    this.displayNameTask.run();
                } else {
                    RP.schedule(this.displayNameTask, 100L, TimeUnit.MILLISECONDS);
                }
            }
            return this.displayName;
        }
    }

    private String getDisplayName(NbMavenProject nb) {
        String toReturn;
        MavenProject pr = nb.getMavenProject();
        if (NbMavenProject.isErrorPlaceholder(pr)) {
            return Bundle.LBL_misconfigured_project(this.project.getProjectDirectory().getNameExt());
        }
        String custom = ((AuxiliaryProperties)this.project.getLookup().lookup(AuxiliaryProperties.class)).get("netbeans.hint.displayName", true);
        if (custom == null) {
            custom = NbPreferences.forModule(Info.class).get("project.displayName", null);
        }
        if (custom != null) {
            ExpressionEvaluator evaluator = PluginPropertyUtils.createEvaluator(this.project);
            try {
                Object s = evaluator.evaluate(custom);
                if (s != null) {
                    String ss = s.toString().replace("${project.name)", "" + pr.getGroupId() + ":" + pr.getArtifactId());
                    return ss;
                }
            }
            catch (ExpressionEvaluationException ex) {
                LOG.log(Level.INFO, "bad display name expression:" + custom, ex);
            }
        }
        if ((toReturn = pr.getName()) == null) {
            String grId = pr.getGroupId();
            String artId = pr.getArtifactId();
            toReturn = grId != null && artId != null ? grId + ":" + artId : Bundle.TXT_Maven_project_at(FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory()));
        }
        return toReturn;
    }

    public Icon getIcon() {
        final NbMavenProject nb = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        if (SwingUtilities.isEventDispatchThread() && !nb.isMavenProjectLoaded()) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    nb.getMavenProject();
                    Info.this.pcs.firePropertyChange("icon", null, null);
                }
            });
            return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/resources/Maven2Icon.gif", (boolean)true);
        }
        SpecialIcon special = (SpecialIcon)this.project.getLookup().lookup(SpecialIcon.class);
        return special != null ? special.getIcon() : ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/resources/Maven2Icon.gif", (boolean)true);
    }

    public Project getProject() {
        return this.project;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.prefChangeListenerSet.compareAndSet(false, true)) {
            NbPreferences.forModule(Info.class).addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.preferenceChangeListener, (Object)NbPreferences.forModule(Info.class)));
        }
        if (!this.pcs.hasListeners(null)) {
            ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).addPropertyChangeListener(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        boolean had = this.pcs.hasListeners(null);
        this.pcs.removePropertyChangeListener(listener);
        if (had && !this.pcs.hasListeners(null)) {
            ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).removePropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("MavenProject".equals(evt.getPropertyName())) {
            this.pcs.firePropertyChange("name", null, null);
            this.pcs.firePropertyChange("displayName", null, null);
            this.pcs.firePropertyChange("icon", null, null);
        }
    }
}

