/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.progress.aggregate.AggregateProgressFactory;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.embedder.exec.ProgressTransferListener;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.queries.Bundle;
import org.netbeans.modules.maven.queries.MavenFileOwnerQueryImpl;
import org.netbeans.modules.maven.queries.RepositoryForBinaryQueryImpl;
import org.netbeans.spi.java.project.support.JavadocAndSourceRootDetection;
import org.netbeans.spi.java.queries.SourceJavadocAttacherImplementation;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;

public class MavenSourceJavadocAttacher
implements SourceJavadocAttacherImplementation.Definer {
    private static final Logger LOG = Logger.getLogger(MavenSourceJavadocAttacher.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<? extends URL> attach(@NonNull URL root, @NonNull Callable<Boolean> cancel, boolean javadoc) throws Exception {
        File file = FileUtil.archiveOrDirForURL((URL)root);
        if (file == null) {
            return Collections.emptyList();
        }
        String[] coordinates = MavenFileOwnerQueryImpl.findCoordinates(file);
        boolean byHash = coordinates == null;
        NBVersionInfo defined = null;
        StatusDisplayer.Message message = null;
        if (Boolean.TRUE.equals(cancel.call())) {
            return Collections.emptyList();
        }
        if (!byHash) {
            defined = new NBVersionInfo(null, coordinates[0], coordinates[1], coordinates[2], null, null, null, null, null);
            message = StatusDisplayer.getDefault().setStatusText(Bundle.LBL_DOWNLOAD_REPO(), 700);
        } else if (file.isFile() && file.exists()) {
            List<RepositoryForBinaryQueryImpl.Coordinates> coordinates2 = RepositoryForBinaryQueryImpl.getJarMetadataCoordinates(file);
            if (coordinates != null && coordinates2.size() == 1) {
                RepositoryForBinaryQueryImpl.Coordinates coord = coordinates2.get(0);
                defined = new NBVersionInfo(null, coord.groupId, coord.artifactId, coord.version, null, null, null, null, null);
            }
            if (defined == null) {
                RepositoryQueries.Result res = RepositoryQueries.findBySHA1Result((File)file, null);
                List candidates = res.getResults();
                for (NBVersionInfo nbvi : candidates) {
                    if (!(javadoc ? nbvi.isJavadocExists() : nbvi.isSourcesExists())) continue;
                    defined = nbvi;
                    message = StatusDisplayer.getDefault().setStatusText(Bundle.LBL_DOWNLOAD_SHA1(), 700);
                    break;
                }
                if (defined != null || res.isPartial()) {
                    // empty if block
                }
            }
        }
        if (defined == null) {
            return Collections.emptyList();
        }
        if (Boolean.TRUE.equals(cancel.call())) {
            return Collections.emptyList();
        }
        MavenEmbedder online = EmbedderFactory.getOnlineEmbedder();
        Artifact art = online.createArtifactWithClassifier(defined.getGroupId(), defined.getArtifactId(), defined.getVersion(), "jar", javadoc ? "javadoc" : "sources");
        if (Boolean.TRUE.equals(cancel.call())) {
            return Collections.emptyList();
        }
        AggregateProgressHandle hndl = AggregateProgressFactory.createHandle((String)Bundle.attaching(art.getId()), (ProgressContributor[])new ProgressContributor[]{AggregateProgressFactory.createProgressContributor((String)"attach")}, (Cancellable)ProgressTransferListener.cancellable(), null);
        ProgressTransferListener.setAggregateHandle((AggregateProgressHandle)hndl);
        try {
            hndl.start();
            List repos = RepositoryPreferences.getInstance().remoteRepositories(online);
            online.resolve(art, repos, online.getLocalRepository());
            File result = art.getFile();
            if (result.isFile()) {
                URL rootUrl = this.findRoot(result, javadoc);
                if (rootUrl != null) {
                    List<URL> list = Collections.singletonList(rootUrl);
                    return list;
                }
            } else {
                if (Boolean.TRUE.equals(cancel.call())) {
                    List rootUrl = Collections.emptyList();
                    return rootUrl;
                }
                if (file.isFile()) {
                    List<RepositoryForBinaryQueryImpl.Coordinates> coordinates2 = RepositoryForBinaryQueryImpl.getJarMetadataCoordinates(result);
                    ArrayList<URL> res = new ArrayList<URL>();
                    if (coordinates2 != null) {
                        for (RepositoryForBinaryQueryImpl.Coordinates coordinate : coordinates2) {
                            if (Boolean.TRUE.equals(cancel.call())) {
                                List list = Collections.emptyList();
                                return list;
                            }
                            Artifact sources = EmbedderFactory.getOnlineEmbedder().createArtifactWithClassifier(coordinate.groupId, coordinate.artifactId, coordinate.version, "jar", javadoc ? "javadoc" : "sources");
                            online.resolve(sources, repos, online.getLocalRepository());
                            URL rootUrl = this.findRoot(sources.getFile(), javadoc);
                            if (rootUrl == null) continue;
                            res.add(rootUrl);
                        }
                        if (!res.isEmpty()) {
                            ArrayList<URL> arrayList = res;
                            return arrayList;
                        }
                    }
                }
            }
        }
        catch (ThreadDeath d) {
        }
        catch (IllegalStateException ise) {
            if (!(ise.getCause() instanceof ThreadDeath)) {
                throw ise;
            }
        }
        catch (AbstractArtifactResolutionException x) {
        }
        finally {
            hndl.finish();
            ProgressTransferListener.clearAggregateHandle();
        }
        return Collections.emptyList();
    }

    private URL findRoot(File jarFile, boolean javadoc) {
        FileObject fo;
        if (jarFile != null && jarFile.isFile() && (fo = FileUtil.toFileObject((File)jarFile)) != null && FileUtil.isArchiveFile((FileObject)fo)) {
            FileObject foRoot = FileUtil.getArchiveRoot((FileObject)fo);
            FileObject fileObject = foRoot = javadoc ? JavadocAndSourceRootDetection.findJavadocRoot((FileObject)foRoot) : JavadocAndSourceRootDetection.findSourceRoot((FileObject)foRoot);
            if (foRoot != null) {
                return foRoot.toURL();
            }
        }
        return null;
    }

    public String getDisplayName() {
        return Bundle.NAME_SourceJavadocAttacher();
    }

    public String getDescription() {
        return Bundle.DESC_SourceJavadocAttacher();
    }

    public List<? extends URL> getSources(URL root, Callable<Boolean> cancel) {
        try {
            return this.attach(root, cancel, false);
        }
        catch (IOException io) {
            LOG.log(Level.INFO, "IO error while retrieving the source for " + root, io);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return Collections.emptyList();
    }

    public List<? extends URL> getJavadoc(URL root, Callable<Boolean> cancel) {
        try {
            return this.attach(root, cancel, true);
        }
        catch (IOException io) {
            LOG.log(Level.INFO, "IO error while retrieving the javadoc for " + root, io);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return Collections.emptyList();
    }
}

