/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.debug;

import java.awt.EventQueue;
import java.lang.reflect.Field;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.DialogBinding;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;

public final class EditorContextSetter {
    private static final RequestProcessor RP = new RequestProcessor(EditorContextSetter.class);

    private EditorContextSetter() {
    }

    public static void setContext(final JEditorPane editorPane, final EditorContextProvider ecp, final Runnable setUpCallback) {
        if (EventQueue.isDispatchThread()) {
            if (ecp != null) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        final Pair context = EditorContextSetter.getContext(ecp);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                EditorContextSetter.setupContext(editorPane, (Pair<Line.Part, FileObject>)context);
                                if (setUpCallback != null) {
                                    setUpCallback.run();
                                }
                            }
                        });
                    }
                });
            } else {
                EditorContextSetter.setupContext(editorPane, null);
                Line line = EditorContextDispatcher.getDefault().getMostRecentLine();
                line.createPart(0, 0);
            }
        } else {
            final Pair<Line.Part, FileObject> context = EditorContextSetter.getContext(ecp);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditorContextSetter.setupContext(editorPane, (Pair<Line.Part, FileObject>)context);
                    if (setUpCallback != null) {
                        setUpCallback.run();
                    }
                }
            });
        }
    }

    private static Pair<Line.Part, FileObject> getContext(EditorContextProvider ecp) {
        Line line;
        Line.Part lp = ecp.getContext();
        if (lp == null && (line = EditorContextDispatcher.getDefault().getMostRecentLine()) != null) {
            lp = line.createPart(0, 0);
        }
        FileObject file = lp != null ? (FileObject)lp.getLine().getLookup().lookup(FileObject.class) : null;
        return Pair.of((Object)lp, file);
    }

    private static void setupContext(JEditorPane editorPane, Pair<Line.Part, FileObject> context) {
        assert (SwingUtilities.isEventDispatchThread());
        if (context != null) {
            Line.Part lp = (Line.Part)context.first();
            FileObject file = (FileObject)context.second();
            if (file != null && file.getMIMEType().startsWith("text/")) {
                String origText = editorPane.getText();
                DialogBinding.bindComponentToFile((FileObject)file, (int)lp.getLine().getLineNumber(), (int)lp.getColumn(), (int)lp.getLength(), (JTextComponent)editorPane);
                Document editPaneDoc = editorPane.getDocument();
                editorPane.setText(origText);
            }
        }
        EditorContextSetter.setupUI(editorPane);
    }

    private static void setupUI(JEditorPane editorPane) {
        assert (SwingUtilities.isEventDispatchThread());
        EditorUI eui = Utilities.getEditorUI((JTextComponent)editorPane);
        if (eui == null) {
            return;
        }
        editorPane.putClientProperty("HighlightsLayerExcludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.CaretRowHighlighting$");
        try {
            Field textLimitLineField = EditorUI.class.getDeclaredField("textLimitLineVisible");
            textLimitLineField.setAccessible(true);
            textLimitLineField.set(eui, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        editorPane.repaint();
    }

    public static interface EditorContextProvider {
        public Line.Part getContext();
    }
}

