/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.debug.breakpoints.models;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import org.netbeans.modules.javascript2.debug.breakpoints.JSLineBreakpoint;
import org.netbeans.modules.javascript2.debug.breakpoints.models.Bundle;
import org.netbeans.modules.javascript2.debug.breakpoints.ui.ControllerProvider;
import org.netbeans.modules.javascript2.debug.breakpoints.ui.JSLineBreakpointCustomizer;
import org.netbeans.modules.javascript2.debug.breakpoints.ui.JSLineBreakpointCustomizerPanel;
import org.netbeans.spi.debugger.ui.Controller;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.text.Line;
import org.openide.util.HelpCtx;

public class BreakpointNodeActionProvider
implements NodeActionsProviderFilter {
    private static final Action GO_TO_SOURCE_ACTION = Models.createAction((String)Bundle.CTL_Breakpoint_GoToSource_Label(), (Models.ActionPerformer)new GoToSourcePerformer(), (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    private static final Action CUSTOMIZE_ACTION = Models.createAction((String)Bundle.CTL_Breakpoint_Customize_Label(), (Models.ActionPerformer)new CustomizePerformer(), (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);

    public Action[] getActions(NodeActionsProvider original, Object node) throws UnknownTypeException {
        Action[] actions = original.getActions(node);
        if (node instanceof JSLineBreakpoint) {
            Action[] newActions = new Action[actions.length + 4];
            newActions[0] = GO_TO_SOURCE_ACTION;
            newActions[1] = null;
            System.arraycopy(actions, 0, newActions, 2, actions.length);
            newActions[newActions.length - 2] = null;
            newActions[newActions.length - 1] = CUSTOMIZE_ACTION;
            actions = newActions;
        }
        return actions;
    }

    public void performDefaultAction(NodeActionsProvider original, Object node) throws UnknownTypeException {
        if (node instanceof JSLineBreakpoint) {
            BreakpointNodeActionProvider.goToSource((JSLineBreakpoint)((Object)node));
        } else {
            original.performDefaultAction(node);
        }
    }

    private static void goToSource(JSLineBreakpoint breakpoint) {
        Line line = breakpoint.getLine();
        if (line != null) {
            line.show(Line.ShowOpenType.REUSE, Line.ShowVisibilityType.FOCUS);
        }
    }

    private static void customize(JSLineBreakpoint lb) {
        JSLineBreakpointCustomizerPanel c = JSLineBreakpointCustomizer.getCustomizerComponent(lb);
        HelpCtx helpCtx = HelpCtx.findHelp((Component)c);
        if (helpCtx == null) {
            helpCtx = new HelpCtx("debug.add.breakpoint");
        }
        Controller cc = c instanceof ControllerProvider ? ((ControllerProvider)c).getController() : (Controller)c;
        final Controller[] cPtr = new Controller[]{cc};
        final DialogDescriptor[] descriptorPtr = new DialogDescriptor[1];
        final Dialog[] dialogPtr = new Dialog[1];
        ActionListener buttonsActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (descriptorPtr[0].getValue() == DialogDescriptor.OK_OPTION) {
                    boolean ok = cPtr[0].ok();
                    if (ok) {
                        dialogPtr[0].setVisible(false);
                    }
                } else {
                    dialogPtr[0].setVisible(false);
                }
            }
        };
        DialogDescriptor descriptor = new DialogDescriptor((Object)c, Bundle.CTL_Breakpoint_Customizer_Title(), true, 2, DialogDescriptor.OK_OPTION, 0, helpCtx, buttonsActionListener);
        descriptor.setClosingOptions(new Object[0]);
        Dialog d = DialogDisplayer.getDefault().createDialog(descriptor);
        d.pack();
        descriptorPtr[0] = descriptor;
        dialogPtr[0] = d;
        d.setVisible(true);
    }

    private static class CustomizePerformer
    implements Models.ActionPerformer {
        private CustomizePerformer() {
        }

        public boolean isEnabled(Object node) {
            return true;
        }

        public void perform(Object[] nodes) {
            BreakpointNodeActionProvider.customize((JSLineBreakpoint)((Object)nodes[0]));
        }
    }

    private static class GoToSourcePerformer
    implements Models.ActionPerformer {
        private GoToSourcePerformer() {
        }

        public boolean isEnabled(Object arg) {
            return true;
        }

        public void perform(Object[] nodes) {
            BreakpointNodeActionProvider.goToSource((JSLineBreakpoint)((Object)nodes[0]));
        }
    }
}

