/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.debug.models;

import java.awt.Color;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JTable;
import javax.swing.UIManager;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;

public abstract class ViewModelSupport {
    protected static final Object[] EMPTY_CHILDREN = new Object[0];
    private CopyOnWriteArrayList<ModelListener> myListeners = new CopyOnWriteArrayList();

    protected ViewModelSupport() {
    }

    public final void addModelListener(ModelListener l) {
        this.myListeners.add(l);
    }

    public final void removeModelListener(ModelListener l) {
        this.myListeners.remove(l);
    }

    protected final void refresh() {
        this.fireChangeEvent((ModelEvent)new ModelEvent.TreeChanged((Object)this));
    }

    protected final void fireChangeEvent(ModelEvent modelEvent) {
        for (ModelListener listener : this.myListeners) {
            listener.modelChanged(modelEvent);
        }
    }

    protected final void fireChangeEvents(ModelEvent[] events) {
        for (ModelEvent event : events) {
            this.fireChangeEvent(event);
        }
    }

    protected final void fireChangeEvents(Collection<ModelEvent> events) {
        for (ModelEvent event : events) {
            this.fireChangeEvent(event);
        }
    }

    public static String toHTML(String text) {
        return ViewModelSupport.toHTML(text, false, false, null);
    }

    public static String toHTML(String text, boolean bold, boolean italics, Color color) {
        if (text == null) {
            return null;
        }
        if (text.length() > 6 && text.substring(0, 6).equalsIgnoreCase("<html>")) {
            return text;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        if (bold) {
            sb.append("<b>");
        }
        if (italics) {
            sb.append("<i>");
        }
        if (color == null && (color = UIManager.getColor("Table.foreground")) == null) {
            color = new JTable().getForeground();
        }
        sb.append("<font color=");
        sb.append(Integer.toHexString(color.getRGB() & 0xFFFFFF));
        sb.append(">");
        text = text.replaceAll("&", "&amp;");
        text = text.replaceAll("<", "&lt;");
        text = text.replaceAll(">", "&gt;");
        sb.append(text);
        sb.append("</font>");
        if (italics) {
            sb.append("</i>");
        }
        if (bold) {
            sb.append("</b>");
        }
        sb.append("</html>");
        return sb.toString();
    }
}

