/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote;

import java.awt.Color;
import org.netbeans.modules.git.remote.Bundle;
import org.netbeans.modules.git.remote.FileInformation;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.GitModuleConfig;
import org.netbeans.modules.git.remote.cli.GitRevisionInfo;
import org.netbeans.modules.git.remote.options.AnnotationColorProvider;
import org.netbeans.modules.remotefs.versioning.util.common.VCSFileInformation;
import org.netbeans.modules.remotefs.versioning.util.common.VCSFileNode;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.util.OptionsPanelColorProvider;
import org.netbeans.modules.versioning.util.common.VCSCommitOptions;

public abstract class GitFileNode<T extends FileNodeInformation>
extends VCSFileNode {
    protected GitFileNode(VCSFileProxy root, VCSFileProxy file) {
        super(root, file);
    }

    public abstract T getInformation();

    public static class HistoryFileInformation
    extends FileNodeInformation {
        private final GitRevisionInfo.GitFileInfo info;

        public HistoryFileInformation(GitRevisionInfo.GitFileInfo info) {
            this.info = info;
        }

        @Override
        public boolean isCopied() {
            return this.info.getStatus() == GitRevisionInfo.GitFileInfo.Status.COPIED;
        }

        @Override
        public boolean isRenamed() {
            return this.info.getStatus() == GitRevisionInfo.GitFileInfo.Status.RENAMED;
        }

        @Override
        public VCSFileProxy getOldFile() {
            return this.info.getOriginalFile();
        }

        public String getOldPath() {
            return this.info.getOriginalPath();
        }

        public String getStatusText() {
            switch (this.info.getStatus()) {
                case ADDED: {
                    return Bundle.CTL_HistoryFileInfo_Status_Added();
                }
                case COPIED: {
                    return Bundle.CTL_HistoryFileInfo_Status_Copied();
                }
                case MODIFIED: {
                    return Bundle.CTL_HistoryFileInfo_Status_Modified();
                }
                case REMOVED: {
                    return Bundle.CTL_HistoryFileInfo_Status_Removed();
                }
                case RENAMED: {
                    return Bundle.CTL_HistoryFileInfo_Status_Renamed();
                }
            }
            return Bundle.CTL_HistoryFileInfo_Status_Unknown();
        }

        public int getComparableStatus() {
            return GitRevisionInfo.GitFileInfo.Status.values().length - this.info.getStatus().ordinal();
        }

        public String annotateNameHtml(String name) {
            OptionsPanelColorProvider.AnnotationFormat format;
            switch (this.info.getStatus()) {
                case ADDED: 
                case COPIED: 
                case RENAMED: {
                    format = AnnotationColorProvider.getInstance().ADDED_FILE;
                    break;
                }
                case MODIFIED: {
                    format = AnnotationColorProvider.getInstance().MODIFIED_FILE;
                    break;
                }
                case REMOVED: {
                    format = AnnotationColorProvider.getInstance().REMOVED_FILE;
                    break;
                }
                default: {
                    format = AnnotationColorProvider.getInstance().EXCLUDED_FILE;
                }
            }
            return format.getFormat().format(new Object[]{name, ""});
        }

        public Color getAnnotatedColor() {
            switch (this.info.getStatus()) {
                case ADDED: 
                case COPIED: 
                case RENAMED: {
                    return AnnotationColorProvider.getInstance().ADDED_FILE.getActualColor();
                }
                case MODIFIED: {
                    return AnnotationColorProvider.getInstance().MODIFIED_FILE.getActualColor();
                }
                case REMOVED: {
                    return AnnotationColorProvider.getInstance().REMOVED_FILE.getActualColor();
                }
            }
            return AnnotationColorProvider.getInstance().EXCLUDED_FILE.getActualColor();
        }
    }

    public static class GitHistoryFileNode
    extends GitFileNode<HistoryFileInformation> {
        private final HistoryFileInformation fi;

        public GitHistoryFileNode(VCSFileProxy root, VCSFileProxy file, HistoryFileInformation info) {
            super(root, file);
            this.fi = info;
        }

        @Override
        public HistoryFileInformation getInformation() {
            return this.fi;
        }

        public VCSCommitOptions getDefaultCommitOption(boolean withExclusions) {
            return VCSCommitOptions.EXCLUDE;
        }
    }

    public static class GitLocalFileNode
    extends GitFileNode<FileInformation> {
        private FileInformation.Mode mode;

        public GitLocalFileNode(VCSFileProxy root, VCSFileProxy file) {
            super(root, file);
        }

        public GitLocalFileNode(VCSFileProxy root, VCSFileProxy file, FileInformation.Mode mode) {
            super(root, file);
            this.mode = mode;
        }

        @Override
        public FileInformation getInformation() {
            return Git.getInstance().getFileStatusCache().getStatus(this.getFile());
        }

        public String getStatusText() {
            return this.mode == null ? this.getInformation().getStatusText() : this.getInformation().getStatusText(this.mode);
        }

        public VCSCommitOptions getDefaultCommitOption(boolean withExclusions) {
            if (withExclusions && GitModuleConfig.getDefault().isExcludedFromCommit(this.getFile().getPath())) {
                return VCSCommitOptions.EXCLUDE;
            }
            if (this.getInformation().containsStatus(FileInformation.STATUS_REMOVED)) {
                return VCSCommitOptions.COMMIT_REMOVE;
            }
            if (this.getInformation().containsStatus(FileInformation.Status.NEW_INDEX_WORKING_TREE)) {
                return withExclusions && GitModuleConfig.getDefault().getExludeNewFiles() ? VCSCommitOptions.EXCLUDE : VCSCommitOptions.COMMIT;
            }
            return VCSCommitOptions.COMMIT;
        }
    }

    public static abstract class FileNodeInformation
    extends VCSFileInformation {
        public abstract boolean isCopied();

        public abstract boolean isRenamed();

        public abstract VCSFileProxy getOldFile();
    }
}

