/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.ignore;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.netbeans.modules.git.remote.FileInformation;
import org.netbeans.modules.git.remote.FileStatusCache;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.progress.FileListener;
import org.netbeans.modules.git.remote.cli.progress.NotificationListener;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.git.remote.client.GitClientExceptionHandler;
import org.netbeans.modules.git.remote.client.GitProgressSupport;
import org.netbeans.modules.git.remote.ui.actions.GitAction;
import org.netbeans.modules.git.remote.ui.actions.MultipleRepositoryAction;
import org.netbeans.modules.git.remote.ui.ignore.IgnoreAction;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.api.VersioningSupport;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class UnignoreAction
extends MultipleRepositoryAction {
    @Override
    protected RequestProcessor.Task performAction(VCSFileProxy repository, VCSFileProxy[] roots, VCSContext context) {
        return this.unignore(repository, roots);
    }

    @Override
    protected boolean enable(Node[] activatedNodes) {
        boolean enabled = super.enable(activatedNodes);
        if (enabled) {
            enabled = false;
            FileStatusCache cache = Git.getInstance().getFileStatusCache();
            for (VCSFileProxy root : this.getCurrentContext(activatedNodes).getRootFiles()) {
                if (!cache.getStatus(root).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) continue;
                VCSFileProxy parent = root.getParentFile();
                enabled = parent == null || !cache.getStatus(parent).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED);
                break;
            }
        }
        return enabled;
    }

    public RequestProcessor.Task unignore(VCSFileProxy repository, VCSFileProxy[] roots) {
        final VCSFileProxy[] toUnignore = UnignoreAction.filterRoots(roots);
        if (toUnignore.length == 0) {
            return null;
        }
        GitProgressSupport supp = new GitProgressSupport(){
            private final Set<VCSFileProxy> notifiedFiles = new HashSet<VCSFileProxy>();
            private VCSFileProxy[] modifiedIgnores = new VCSFileProxy[0];

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void perform() {
                try {
                    GitClient client = this.getClient();
                    client.addNotificationListener((NotificationListener)new GitProgressSupport.DefaultFileListener(toUnignore));
                    client.addNotificationListener((NotificationListener)new FileListener(){

                        public void notifyFile(VCSFileProxy file, String relativePathToRoot) {
                            notifiedFiles.add(file);
                        }
                    });
                    this.modifiedIgnores = client.unignore(toUnignore, this.getProgressMonitor());
                    ((IgnoreAction)SystemAction.get(IgnoreAction.class)).setEnabled(false);
                    ((UnignoreAction)SystemAction.get(UnignoreAction.class)).setEnabled(false);
                }
                catch (GitException ex) {
                    GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                }
                finally {
                    if (this.modifiedIgnores.length > 0) {
                        VersioningSupport.refreshFor((VCSFileProxy[])this.modifiedIgnores);
                        this.notifiedFiles.addAll(Arrays.asList(this.modifiedIgnores));
                    }
                    if (!this.notifiedFiles.isEmpty()) {
                        this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                        Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(this.getRepositoryRoot(), this.notifiedFiles));
                    }
                }
            }
        };
        supp.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(UnignoreAction.class, (String)"LBL_UnignoreAction.progressName"));
        return supp.getTask();
    }

    private static VCSFileProxy[] filterRoots(VCSFileProxy[] roots) {
        LinkedList<VCSFileProxy> toUnignore = new LinkedList<VCSFileProxy>();
        FileStatusCache cache = Git.getInstance().getFileStatusCache();
        for (VCSFileProxy root : roots) {
            FileInformation info = cache.getStatus(root);
            if (!info.containsStatus(EnumSet.of(FileInformation.Status.NOTVERSIONED_EXCLUDED))) continue;
            toUnignore.add(root);
        }
        return toUnignore.toArray(new VCSFileProxy[toUnignore.size()]);
    }
}

