/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.repository;

import java.awt.Dialog;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.modules.git.remote.GitModuleConfig;
import org.netbeans.modules.git.remote.ui.repository.RepositoryBrowserPanel;
import org.netbeans.modules.git.remote.ui.repository.Revision;
import org.netbeans.modules.git.remote.ui.repository.RevisionInfoPanelController;
import org.netbeans.modules.git.remote.ui.repository.RevisionPickerDialog;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.util.DialogBoundsPreserver;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class RevisionPicker
implements PropertyChangeListener {
    private final RevisionPickerDialog panel;
    private final JButton okButton;
    private final RevisionInfoPanelController infoPanelController;
    private Revision revision;
    private DialogDescriptor dd;
    private final RepositoryBrowserPanel browserPanel;
    private static final String PROP_PANEL_SLIDER_POSITION = "RevisionPicker.slider.pos";
    private static final String PROP_BROWSER_SLIDER_POSITION = "RevisionPicker.browser.slider.pos";

    public RevisionPicker(VCSFileProxy repository, VCSFileProxy[] roots) {
        this.infoPanelController = new RevisionInfoPanelController(repository);
        this.browserPanel = new RepositoryBrowserPanel(RepositoryBrowserPanel.OPTIONS_INSIDE_PANEL, repository, roots, null);
        this.panel = new RevisionPickerDialog(this.infoPanelController.getPanel(), this.browserPanel);
        this.okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)NbBundle.getMessage(RevisionPicker.class, (String)"LBL_RevisionPickerDialog.okButton.title"));
    }

    public boolean open() {
        this.dd = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(RevisionPicker.class, (String)"LBL_RevisionPickerDialog.title"), true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, new HelpCtx("org.netbeans.modules.git.remote.ui.repository.RevisionPickerDialog"), null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.dd);
        this.updateDialogState();
        this.browserPanel.addPropertyChangeListener(this);
        Preferences prefs = GitModuleConfig.getDefault().getPreferences();
        DialogBoundsPreserver windowListener = new DialogBoundsPreserver(prefs, this.getClass().getName());
        dialog.addWindowListener((WindowListener)windowListener);
        windowListener.windowOpened(new WindowEvent(dialog, 200));
        dialog.pack();
        this.updateSliders(prefs);
        dialog.setVisible(true);
        this.persistSliders(prefs);
        this.browserPanel.removePropertyChangeListener(this);
        return this.dd.getValue() == this.okButton;
    }

    public Revision getRevision() {
        return this.revision;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "RepositoryBrowserPanel.revision") {
            this.revision = (Revision)evt.getNewValue();
            this.updateDialogState();
        } else if (evt.getPropertyName() == "RepositoryBrowserPanel.acceptedRevision" && this.revision != null && this.revision.equals(evt.getNewValue())) {
            this.okButton.doClick();
        }
    }

    private void updateSliders(Preferences prefs) {
        int pos = prefs.getInt(PROP_PANEL_SLIDER_POSITION, 0);
        if (pos > 0) {
            this.panel.setSliderPosition(pos);
        }
        if ((pos = prefs.getInt(PROP_BROWSER_SLIDER_POSITION, 0)) > 0) {
            this.browserPanel.setSliderPosition(pos);
        }
    }

    private void persistSliders(Preferences prefs) {
        prefs.putInt(PROP_PANEL_SLIDER_POSITION, this.panel.getSliderPosition());
        prefs.putInt(PROP_BROWSER_SLIDER_POSITION, this.browserPanel.getSliderPosition());
    }

    void displayMergedStatus(String revision) {
        this.browserPanel.displayBrancheMergedStatus(revision);
        this.infoPanelController.displayMergedStatus(revision);
    }

    private void updateDialogState() {
        boolean enabled = this.revision != null;
        this.dd.setValid(enabled);
        this.okButton.setEnabled(enabled);
        this.infoPanelController.loadInfo(this.revision == null ? null : this.revision.getRevision());
    }
}

