/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tax.beans.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.xml.tax.beans.editor.Util;
import org.netbeans.modules.xml.tax.util.TAXUtil;
import org.netbeans.tax.TreeAttlistDecl;
import org.netbeans.tax.TreeAttribute;
import org.netbeans.tax.TreeCDATASection;
import org.netbeans.tax.TreeCharacterData;
import org.netbeans.tax.TreeComment;
import org.netbeans.tax.TreeConditionalSection;
import org.netbeans.tax.TreeDocumentType;
import org.netbeans.tax.TreeElement;
import org.netbeans.tax.TreeElementDecl;
import org.netbeans.tax.TreeEntityDecl;
import org.netbeans.tax.TreeGeneralEntityReference;
import org.netbeans.tax.TreeNode;
import org.netbeans.tax.TreeNodeDecl;
import org.netbeans.tax.TreeNotationDecl;
import org.netbeans.tax.TreeParameterEntityReference;
import org.netbeans.tax.TreeParentNode;
import org.netbeans.tax.TreeProcessingInstruction;
import org.netbeans.tax.TreeReference;
import org.netbeans.tax.TreeText;
import org.netbeans.tax.traversal.TreeNodeFilter;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.HelpCtx;

public class TreeNodeFilterCustomEditor
extends JPanel
implements EnhancedCustomPropertyEditor {
    private static final long serialVersionUID = 1767193347881681541L;
    private static final Map publicNodeTypeNamesMap = new HashMap();
    private final TreeNodeFilter filter;
    private final List nodeTypesList;
    private NodeTypesTableModel tableModel;
    private JRadioButton rejectRadioButton;
    private JPanel rbPanel;
    private JPanel acceptPolicyPanel;
    private JButton addButton;
    private JLabel acceptRejectLabel;
    private JScrollPane tableScrollPane;
    private JTable nodeTypesTable;
    private JRadioButton acceptRadioButton;
    private JPanel tablePanel;
    private ButtonGroup acceptPolicyGroup;
    private JButton removeButton;
    private static Vector publicNodeTypesInheritanceTree;

    public TreeNodeFilterCustomEditor(TreeNodeFilter filter) {
        this.filter = filter;
        this.nodeTypesList = new LinkedList<Class>(Arrays.asList(filter.getNodeTypes()));
        this.initComponents();
        this.ownInitComponents();
        this.initAccessibility();
        HelpCtx.setHelpIDString((JComponent)this, (String)this.getClass().getName());
    }

    private void ownInitComponents() {
        this.tableModel = (NodeTypesTableModel)this.nodeTypesTable.getModel();
        ListSelectionModel selModel = this.nodeTypesTable.getSelectionModel();
        selModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    TreeNodeFilterCustomEditor.this.removeButton.setEnabled(false);
                } else {
                    TreeNodeFilterCustomEditor.this.removeButton.setEnabled(true);
                }
            }
        });
        JComboBox cb = new JComboBox(TreeNodeFilterCustomEditor.getPublicNodeTypesInheritanceTree());
        cb.setEditable(false);
        DefaultCellEditor dce = new DefaultCellEditor(cb);
        this.nodeTypesTable.getColumnModel().getColumn(0).setCellEditor(dce);
    }

    public Object getPropertyValue() throws IllegalStateException {
        short acceptPolicy = this.acceptRadioButton.isSelected() ? (short)10 : 11;
        Class[] nodeTypes = this.nodeTypesList.toArray(new Class[0]);
        return new TreeNodeFilter(nodeTypes, acceptPolicy);
    }

    private void initComponents() {
        this.acceptPolicyGroup = new ButtonGroup();
        this.acceptPolicyPanel = new JPanel();
        this.acceptRejectLabel = new JLabel();
        this.rbPanel = new JPanel();
        this.acceptRadioButton = new JRadioButton();
        this.acceptRadioButton.setSelected(this.filter.getAcceptPolicy() == 10);
        this.rejectRadioButton = new JRadioButton();
        this.rejectRadioButton.setSelected(this.filter.getAcceptPolicy() == 11);
        this.tablePanel = new JPanel();
        this.tableScrollPane = new JScrollPane();
        this.nodeTypesTable = new JTable();
        this.nodeTypesTable.setSelectionMode(0);
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.setLayout(new BorderLayout());
        this.acceptPolicyPanel.setLayout(new GridBagLayout());
        this.acceptRejectLabel.setText(Util.THIS.getString("LBL_acceptReject"));
        this.acceptRejectLabel.setLabelFor(this.rbPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.acceptPolicyPanel.add((Component)this.acceptRejectLabel, gridBagConstraints);
        this.rbPanel.setLayout(new GridBagLayout());
        this.acceptRadioButton.setText(Util.THIS.getString("LBL_showItRadioButton"));
        this.acceptPolicyGroup.add(this.acceptRadioButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.rbPanel.add((Component)this.acceptRadioButton, gridBagConstraints);
        this.rejectRadioButton.setText(Util.THIS.getString("LBL_hideItRadioButton"));
        this.acceptPolicyGroup.add(this.rejectRadioButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.rbPanel.add((Component)this.rejectRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 11);
        this.acceptPolicyPanel.add((Component)this.rbPanel, gridBagConstraints);
        this.add((Component)this.acceptPolicyPanel, "North");
        this.tablePanel.setLayout(new GridBagLayout());
        this.nodeTypesTable.setModel(new NodeTypesTableModel());
        this.nodeTypesTable.setPreferredScrollableViewportSize(new Dimension(300, 200));
        this.tableScrollPane.setViewportView(this.nodeTypesTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.tablePanel.add((Component)this.tableScrollPane, gridBagConstraints);
        this.addButton.setText(Util.THIS.getString("LBL_addButton"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeNodeFilterCustomEditor.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.tablePanel.add((Component)this.addButton, gridBagConstraints);
        this.removeButton.setText(Util.THIS.getString("LBL_removeButton"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeNodeFilterCustomEditor.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 11, 11, 11);
        this.tablePanel.add((Component)this.removeButton, gridBagConstraints);
        this.add((Component)this.tablePanel, "Center");
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int sel = this.nodeTypesTable.getSelectedRow();
        if (sel != -1) {
            this.tableModel.removeRow(sel);
            int numRows = this.nodeTypesTable.getModel().getRowCount();
            if (numRows > 0) {
                sel = Math.min(sel, numRows - 1);
                this.nodeTypesTable.getSelectionModel().setSelectionInterval(sel, sel);
            }
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.nodeTypesList.add(TreeNode.class);
        this.tableModel.fireTableDataChanged();
    }

    private static Vector getPublicNodeTypesInheritanceTree() {
        if (publicNodeTypesInheritanceTree == null) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("Init Set");
            }
            Item rootItem = new Item();
            Object[] array = publicNodeTypeNamesMap.keySet().toArray();
            for (int i = 0; i < array.length; ++i) {
                Class clazz = (Class)array[i];
                Item.insertItemIntoLayer(rootItem.layer, Item.getItem(clazz));
                if (!clazz.isInterface()) continue;
                for (int j = 0; j < i; ++j) {
                    Item.insertItemIntoLayer(rootItem.layer, Item.getItem((Class)array[j]));
                }
            }
            publicNodeTypesInheritanceTree = new Vector();
            TreeNodeFilterCustomEditor.fillPublicNodeTypesInheritanceTree(rootItem.layer, "");
            Item.itemMap.clear();
            Item.itemMap = null;
            Object var0 = null;
        }
        return publicNodeTypesInheritanceTree;
    }

    private static void fillPublicNodeTypesInheritanceTree(Set layer, String prefix) {
        Iterator it = layer.iterator();
        while (it.hasNext()) {
            Item item = (Item)it.next();
            String itemPrefix = "";
            if (prefix.length() != 0) {
                itemPrefix = it.hasNext() ? prefix + "|- " : prefix + "`- ";
            }
            Item newItem = new Item(item, itemPrefix);
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug(">>" + newItem.toString() + "<<");
            }
            publicNodeTypesInheritanceTree.add(newItem);
            String newPrefix = prefix.length() == 0 ? "   " : (it.hasNext() ? prefix + "|   " : prefix + "    ");
            TreeNodeFilterCustomEditor.fillPublicNodeTypesInheritanceTree(item.layer, newPrefix);
        }
    }

    public void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_TreeNodeFilterCustomEditor"));
        this.acceptRadioButton.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_acceptRejectLabel"));
        this.acceptRadioButton.setMnemonic(Util.THIS.getString("LBL_showItRadioButton_Mnem").charAt(0));
        this.rejectRadioButton.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_rejectRadioButton"));
        this.rejectRadioButton.setMnemonic(Util.THIS.getString("LBL_hideItRadioButton_Mnem").charAt(0));
        this.addButton.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_addButton1"));
        this.addButton.setMnemonic(Util.THIS.getString("LBL_addButton_Mnem").charAt(0));
        this.removeButton.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_removeButton1"));
        this.removeButton.setMnemonic(Util.THIS.getString("LBL_removeButton_Mnem").charAt(0));
        this.nodeTypesTable.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_nodeTypesTable"));
        this.nodeTypesTable.getAccessibleContext().setAccessibleName(Util.THIS.getString("ACSN_nodeTypesTable"));
    }

    public static final void main(String[] args) throws Exception {
        Vector vector = TreeNodeFilterCustomEditor.getPublicNodeTypesInheritanceTree();
    }

    static {
        publicNodeTypeNamesMap.put(TreeNode.class, Util.THIS.getString("NAME_Any_Node_Type"));
        publicNodeTypeNamesMap.put(TreeParentNode.class, Util.THIS.getString("NAME_Any_Parent_Node_Type"));
        publicNodeTypeNamesMap.put(TreeCharacterData.class, Util.THIS.getString("NAME_Any_Character_Data_Node_Type"));
        publicNodeTypeNamesMap.put(TreeReference.class, Util.THIS.getString("NAME_Any_Reference_Node_Type"));
        publicNodeTypeNamesMap.put(TreeNodeDecl.class, Util.THIS.getString("NAME_Any_Declaration_Node_Type"));
        publicNodeTypeNamesMap.put(TreeComment.class, Util.THIS.getString("NAME_Comment_Node_Type"));
        publicNodeTypeNamesMap.put(TreeProcessingInstruction.class, Util.THIS.getString("NAME_Processing_Instruction_Node_Type"));
        publicNodeTypeNamesMap.put(TreeText.class, Util.THIS.getString("NAME_Text_Node_Type"));
        publicNodeTypeNamesMap.put(TreeCDATASection.class, Util.THIS.getString("NAME_CDATA_Section_Node_Type"));
        publicNodeTypeNamesMap.put(TreeElement.class, Util.THIS.getString("NAME_Element_Node_Type"));
        publicNodeTypeNamesMap.put(TreeAttribute.class, Util.THIS.getString("NAME_Attribute_Node_Type"));
        publicNodeTypeNamesMap.put(TreeConditionalSection.class, Util.THIS.getString("NAME_Conditional_Section_Node_Type"));
        publicNodeTypeNamesMap.put(TreeDocumentType.class, Util.THIS.getString("NAME_Document_Type_Node_Type"));
        publicNodeTypeNamesMap.put(TreeGeneralEntityReference.class, Util.THIS.getString("NAME_General_Entity_Reference_Node_Type"));
        publicNodeTypeNamesMap.put(TreeParameterEntityReference.class, Util.THIS.getString("NAME_Parameter_Entity_Reference_Node_Type"));
        publicNodeTypeNamesMap.put(TreeElementDecl.class, Util.THIS.getString("NAME_Element_Declaration_Node_Type"));
        publicNodeTypeNamesMap.put(TreeEntityDecl.class, Util.THIS.getString("NAME_Entity_Declaration_Node_Type"));
        publicNodeTypeNamesMap.put(TreeAttlistDecl.class, Util.THIS.getString("NAME_Attlist_Declaration_Node_Type"));
        publicNodeTypeNamesMap.put(TreeNotationDecl.class, Util.THIS.getString("NAME_Notation_Declaration_Node_Type"));
    }

    private static class Item {
        private static Map itemMap;
        private final NamedClass clazz;
        private final Set layer;
        private final String prefix;

        private Item(NamedClass clazz, Set layer, String prefix) {
            this.clazz = clazz;
            this.layer = layer;
            this.prefix = prefix;
        }

        private Item(Item item, String prefix) {
            this(item.clazz, null, prefix);
        }

        private Item(NamedClass clazz) {
            this(clazz, new TreeSet(new NamedClassComparator()), new String());
        }

        private Item() {
            this(new NamedClass(null));
        }

        public String toString() {
            return this.prefix + this.clazz.toString();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Item)) {
                return false;
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("___ Item::equals: this = " + this);
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("___     ::equals: obj  = " + obj);
            }
            Item peer = (Item)obj;
            return this.clazz.equals(peer.clazz);
        }

        private static Item getItem(Class clazz) {
            Item item;
            if (itemMap == null) {
                itemMap = new HashMap();
            }
            if ((item = (Item)itemMap.get(clazz)) == null) {
                item = new Item(new NamedClass(clazz));
                itemMap.put(clazz, item);
            }
            return item;
        }

        private static void insertItemIntoLayer(Set layer, Item newItem) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("\n\nInsert newItem : " + newItem);
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("       Item : set = " + layer);
            }
            boolean inserted = false;
            Object[] array = layer.toArray();
            for (int i = 0; i < array.length; ++i) {
                Item item = (Item)array[i];
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("       Item : item [" + i + "] = " + item);
                }
                if (item.clazz.clazz == newItem.clazz.clazz) {
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug("       Item : #1 -= [ ITEM.clazz.clazz == NEW_ITEM.clazz.clazz   => IGNORE insert ]=-");
                    }
                    inserted = true;
                    continue;
                }
                if (item.clazz.clazz.isAssignableFrom(newItem.clazz.clazz)) {
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug("       Item : #2 -= [ NEW_ITEM is subclass of actual ITEM   => insert to ITEM.LAYER ]=-");
                    }
                    Item.insertItemIntoLayer(item.layer, newItem);
                    inserted = true;
                    continue;
                }
                if (!newItem.clazz.clazz.isAssignableFrom(item.clazz.clazz)) continue;
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("       Item : #3 -= [ actual ITEM '" + item + "' is subclass of NEW_ITEM   => item REMOVED & insert to NEW_ITEM.LAYER ]=-");
                }
                if (newItem.clazz.clazz.isInterface()) continue;
                layer.remove(item);
                Item.insertItemIntoLayer(newItem.layer, item);
            }
            if (!inserted) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("       Item : #4 -= [ item '" + newItem + "' INSERTED into " + layer + " ] =-");
                }
                layer.add(newItem);
            }
        }
    }

    private static class NamedClassComparator
    implements Comparator {
        private NamedClassComparator() {
        }

        public int compare(Object obj1, Object obj2) throws ClassCastException {
            return obj1.toString().compareTo(obj2.toString());
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof NamedClassComparator;
        }
    }

    private static class NamedClass {
        private final Class clazz;

        public NamedClass(Class clazz) {
            this.clazz = clazz;
        }

        public String toString() {
            String name = (String)publicNodeTypeNamesMap.get(this.clazz);
            if (name == null) {
                name = this.clazz.getName();
            }
            return name;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof NamedClass)) {
                return false;
            }
            NamedClass peer = (NamedClass)obj;
            return this.clazz.equals(peer.clazz);
        }
    }

    private class NodeTypesTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -1438087942670592779L;

        private NodeTypesTableModel() {
        }

        public void removeRow(int row) {
            TreeNodeFilterCustomEditor.this.nodeTypesList.remove(row);
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return TreeNodeFilterCustomEditor.this.nodeTypesList.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        public Class getColumnClass(int index) {
            return Class.class;
        }

        @Override
        public Object getValueAt(int row, int column) {
            Item retVal = new Item(new NamedClass((Class)TreeNodeFilterCustomEditor.this.nodeTypesList.get(row)));
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("<-- getValue: row    = " + row);
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("<-- getValue: column = " + column);
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("<-- getValue: " + retVal.getClass().getName() + " -- '" + retVal + "'");
            }
            return retVal;
        }

        @Override
        public void setValueAt(Object val, int row, int column) {
            if (row >= TreeNodeFilterCustomEditor.this.nodeTypesList.size()) {
                return;
            }
            Class type = null;
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("--> setValue: " + val.getClass().getName() + " -- '" + val + "'");
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("--> setValue: row    = " + row);
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("--> setValue: column = " + column);
            }
            if (val instanceof String) {
                try {
                    type = Class.forName(val.toString());
                }
                catch (ClassNotFoundException exc) {}
            } else if (val instanceof Item) {
                type = ((Item)val).clazz.clazz;
            } else if (val instanceof NamedClass) {
                type = ((NamedClass)val).clazz;
            }
            if (type == null || !TreeNodeFilter.isValidNodeType(type)) {
                TAXUtil.notifyWarning(Util.THIS.getString("MSG_invalidNodeType", val.toString()));
                return;
            }
            TreeNodeFilterCustomEditor.this.nodeTypesList.set(row, type);
        }

        @Override
        public String getColumnName(int column) {
            return Util.THIS.getString("LBL_nodeType");
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }
    }

    private class RowKeyListener
    extends KeyAdapter {
        private JTable table;

        public RowKeyListener(JTable table) {
            this.table = table;
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 127) {
                TreeNodeFilterCustomEditor.this.tableModel.removeRow(this.table.getSelectedRow());
            }
        }
    }
}

