/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openide.util.NbBundle;

public class CertificationPanel
extends JPanel {
    private X509Certificate cert;
    private Map issuedToMap;
    private Map issuedByMap;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JTextField jTextField1;
    private JTextField jTextField10;
    private JTextField jTextField11;
    private JTextField jTextField12;
    private JTextField jTextField13;
    private JTextField jTextField14;
    private JTextField jTextField15;
    private JTextField jTextField16;
    private JTextField jTextField17;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private JTextField jTextField4;
    private JTextField jTextField5;
    private JTextField jTextField6;
    private JTextField jTextField7;
    private JTextField jTextField8;
    private JTextField jTextField9;

    public CertificationPanel(X509Certificate cert) {
        this.cert = cert;
        this.issuedToMap = new HashMap();
        this.issuedByMap = new HashMap();
        String issuedTo = cert.getSubjectX500Principal().getName();
        StringTokenizer issuedToTokens = new StringTokenizer(issuedTo, ",");
        while (issuedToTokens.hasMoreTokens()) {
            String token = issuedToTokens.nextToken();
            int index = token.indexOf(61);
            if (index <= 0) continue;
            this.issuedToMap.put(token.substring(0, index), token.substring(index + 1));
        }
        String issuedBy = cert.getIssuerX500Principal().getName();
        StringTokenizer issuedByTokens = new StringTokenizer(issuedBy, ",");
        while (issuedByTokens.hasMoreTokens()) {
            String token = issuedByTokens.nextToken();
            int index = token.indexOf(61);
            if (index <= 0) continue;
            this.issuedByMap.put(token.substring(0, index), token.substring(index + 1));
        }
        String fingerPrint = NbBundle.getMessage(CertificationPanel.class, (String)"TXT_CannotCompute");
        try {
            fingerPrint = CertificationPanel.getThumbPrint(cert);
        }
        catch (NoSuchAlgorithmException ex) {
        }
        catch (CertificateEncodingException ex) {
            // empty catch block
        }
        this.initComponents();
        this.jTextField1.setText(this.getInfo(this.issuedToMap.get("CN")));
        this.jTextField2.setText(this.getInfo(this.issuedToMap.get("O")));
        this.jTextField3.setText(this.getInfo(this.issuedToMap.get("OU")));
        this.jTextField4.setText(this.getInfo(this.issuedToMap.get("L")));
        this.jTextField5.setText(this.getInfo(this.issuedToMap.get("ST")));
        this.jTextField6.setText(this.getInfo(this.issuedToMap.get("C")));
        this.jTextField7.setText(this.getSerialNoInfo(cert.getSerialNumber()));
        this.jTextField8.setText(this.getPublicKeyInfo(cert.getPublicKey()));
        this.jTextField9.setText(this.getInfo(this.issuedByMap.get("CN")));
        this.jTextField10.setText(this.getInfo(this.issuedByMap.get("O")));
        this.jTextField11.setText(this.getInfo(this.issuedByMap.get("OU")));
        this.jTextField12.setText(this.getInfo(this.issuedByMap.get("L")));
        this.jTextField13.setText(this.getInfo(this.issuedByMap.get("ST")));
        this.jTextField14.setText(this.getInfo(this.issuedByMap.get("C")));
        this.jTextField15.setText(this.getDateInfo(cert.getNotBefore()));
        this.jTextField16.setText(this.getDateInfo(cert.getNotAfter()));
        this.jTextField17.setText(fingerPrint);
    }

    public static String getThumbPrint(X509Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] der = cert.getEncoded();
        md.update(der);
        byte[] digest = md.digest();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < digest.length; ++i) {
            sb.append(":").append(Integer.toHexString(digest[i] & 0xFF));
        }
        return sb.substring(1);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel13 = new JLabel();
        this.jTextField9 = new JTextField();
        this.jLabel14 = new JLabel();
        this.jTextField10 = new JTextField();
        this.jLabel15 = new JLabel();
        this.jTextField11 = new JTextField();
        this.jLabel16 = new JLabel();
        this.jTextField12 = new JTextField();
        this.jLabel17 = new JLabel();
        this.jTextField13 = new JTextField();
        this.jLabel18 = new JLabel();
        this.jTextField14 = new JTextField();
        this.jLabel19 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel20 = new JLabel();
        this.jTextField15 = new JTextField();
        this.jLabel21 = new JLabel();
        this.jTextField16 = new JTextField();
        this.jLabel4 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jLabel6 = new JLabel();
        this.jTextField2 = new JTextField();
        this.jLabel7 = new JLabel();
        this.jTextField3 = new JTextField();
        this.jLabel8 = new JLabel();
        this.jTextField4 = new JTextField();
        this.jLabel9 = new JLabel();
        this.jTextField5 = new JTextField();
        this.jLabel10 = new JLabel();
        this.jTextField6 = new JTextField();
        this.jLabel11 = new JLabel();
        this.jTextField7 = new JTextField();
        this.jLabel12 = new JLabel();
        this.jTextField8 = new JTextField();
        this.jLabel22 = new JLabel();
        this.jTextField17 = new JTextField();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new GridBagLayout());
        this.jLabel1.setText(NbBundle.getMessage(CertificationPanel.class, (String)"LBL_unableToVerify", (Object[])new Object[]{this.issuedToMap.get("CN")}));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText(NbBundle.getMessage(CertificationPanel.class, (String)"LBL_issuedTo"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText(NbBundle.getMessage(CertificationPanel.class, (String)"LBL_issuedBy"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel13.setText(NbBundle.getMessage(CertificationPanel.class, (String)"LBL_CommonName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.jPanel2.add((Component)this.jLabel13, gridBagConstraints);
        this.jTextField9.setEditable(false);
        this.jTextField9.setBorder(null);
        this.jTextField9.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jTextField9, gridBagConstraints);
        this.jLabel14.setText(NbBundle.getMessage(CertificationPanel.class, (String)"LBL_Organization"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.jPanel2.add((Component)this.jLabel14, gridBagConstraints);
        this.jTextField10.setEditable(false);
        this.jTextField10.setBorder(null);
        this.jTextField10.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jTextField10, gridBagConstraints);
        this.jLabel15.setText(NbBundle.getMessage(CertificationPanel.class, (String)"LBL_OrganizationalUnit"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.jPanel2.add((Component)this.jLabel15, gridBagConstraints);
        this.jTextField11.setEditable(false);
        this.jTextField11.setBorder(null);
        this.jTextField11.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jTextField11, gridBagConstraints);
        this.jLabel16.setText(NbBundle.getMessage(CertificationPanel.class, (String)"LBL_Location"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.jPanel2.add((Component)this.jLabel16, gridBagConstraints);
        this.jTextField12.setEditable(false);
        this.jTextField12.setBorder(null);
        this.jTextField12.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jTextField12, gridBagConstraints);
        this.jLabel17.setText(NbBundle.getMessage(CertificationPanel.class, (String)"LBL_State"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.jPanel2.add((Component)this.jLabel17, gridBagConstraints);
        this.jTextField13.setEditable(false);
        this.jTextField13.setBorder(null);
        this.jTextField13.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jTextField13, gridBagConstraints);
        this.jLabel18.setText(NbBundle.getMessage(CertificationPanel.class, (String)"LBL_Country"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.jPanel2.add((Component)this.jLabel18, gridBagConstraints);
        this.jTextField14.setEditable(false);
        this.jTextField14.setBorder(null);
        this.jTextField14.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jTextField14, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jLabel19.setText(NbBundle.getMessage(CertificationPanel.class, (String)"LBL_Validity"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel19, gridBagConstraints);
        this.jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabel20.setText(NbBundle.getMessage(CertificationPanel.class, (String)"LBL_IssuedOn"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.jPanel3.add((Component)this.jLabel20, gridBagConstraints);
        this.jTextField15.setEditable(false);
        this.jTextField15.setBorder(null);
        this.jTextField15.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jTextField15, gridBagConstraints);
        this.jLabel21.setText(NbBundle.getMessage(CertificationPanel.class, (String)"LBL_ExpiresOn"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.jPanel3.add((Component)this.jLabel21, gridBagConstraints);
        this.jTextField16.setEditable(false);
        this.jTextField16.setBorder(null);
        this.jTextField16.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jTextField16, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.jPanel3, gridBagConstraints);
        this.jLabel4.setText(NbBundle.getMessage(CertificationPanel.class, (String)"LBL_acceptCertificate"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel5.setText(NbBundle.getMessage(CertificationPanel.class, (String)"LBL_CommonName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.jPanel1.add((Component)this.jLabel5, gridBagConstraints);
        this.jTextField1.setEditable(false);
        this.jTextField1.setBorder(null);
        this.jTextField1.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jTextField1, gridBagConstraints);
        this.jLabel6.setText(NbBundle.getMessage(CertificationPanel.class, (String)"LBL_Organization"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.jPanel1.add((Component)this.jLabel6, gridBagConstraints);
        this.jTextField2.setEditable(false);
        this.jTextField2.setBorder(null);
        this.jTextField2.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.jTextField2, gridBagConstraints);
        this.jLabel7.setText(NbBundle.getMessage(CertificationPanel.class, (String)"LBL_OrganizationalUnit"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.jPanel1.add((Component)this.jLabel7, gridBagConstraints);
        this.jTextField3.setEditable(false);
        this.jTextField3.setBorder(null);
        this.jTextField3.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jTextField3, gridBagConstraints);
        this.jLabel8.setText(NbBundle.getMessage(CertificationPanel.class, (String)"LBL_Location"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.jPanel1.add((Component)this.jLabel8, gridBagConstraints);
        this.jTextField4.setEditable(false);
        this.jTextField4.setBorder(null);
        this.jTextField4.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jTextField4, gridBagConstraints);
        this.jLabel9.setText(NbBundle.getMessage(CertificationPanel.class, (String)"LBL_State"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.jPanel1.add((Component)this.jLabel9, gridBagConstraints);
        this.jTextField5.setEditable(false);
        this.jTextField5.setBorder(null);
        this.jTextField5.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jTextField5, gridBagConstraints);
        this.jLabel10.setText(NbBundle.getMessage(CertificationPanel.class, (String)"LBL_Country"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.jPanel1.add((Component)this.jLabel10, gridBagConstraints);
        this.jTextField6.setEditable(false);
        this.jTextField6.setBorder(null);
        this.jTextField6.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jTextField6, gridBagConstraints);
        this.jLabel11.setText(NbBundle.getMessage(CertificationPanel.class, (String)"LBL_SerialNo"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.jPanel1.add((Component)this.jLabel11, gridBagConstraints);
        this.jTextField7.setEditable(false);
        this.jTextField7.setBorder(null);
        this.jTextField7.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jTextField7, gridBagConstraints);
        this.jLabel12.setText(NbBundle.getMessage(CertificationPanel.class, (String)"LBL_PublicKeyAlg"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.jPanel1.add((Component)this.jLabel12, gridBagConstraints);
        this.jTextField8.setEditable(false);
        this.jTextField8.setBorder(null);
        this.jTextField8.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jTextField8, gridBagConstraints);
        this.jLabel22.setText(NbBundle.getMessage(CertificationPanel.class, (String)"LBL_FIngerprint"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel22, gridBagConstraints);
        this.jTextField17.setEditable(false);
        this.jTextField17.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jTextField17, gridBagConstraints);
        this.jPanel4.add((Component)this.jPanel1, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel4, gridBagConstraints);
    }

    private String getInfo(Object entry) {
        return entry == null ? NbBundle.getMessage(CertificationPanel.class, (String)"TXT_NotSpecified") : (String)entry;
    }

    private String getDateInfo(Date date) {
        return date == null ? NbBundle.getMessage(CertificationPanel.class, (String)"TXT_NotSpecified") : date.toString();
    }

    private String getSerialNoInfo(BigInteger sn) {
        return sn == null ? NbBundle.getMessage(CertificationPanel.class, (String)"TXT_NotSpecified") : sn.toString();
    }

    private String getPublicKeyInfo(PublicKey pk) {
        if (pk == null) {
            return NbBundle.getMessage(CertificationPanel.class, (String)"TXT_NotSpecified");
        }
        String algorithm = pk.getAlgorithm();
        return algorithm == null ? NbBundle.getMessage(CertificationPanel.class, (String)"TXT_NotSpecified") : algorithm;
    }
}

