/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javacard.common.Utils;
import org.netbeans.modules.javacard.spi.JavacardPlatform;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public final class JCUtil {
    private JCUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataObject createFakeJavacardPlatform(String name) {
        FileSystem fs = FileUtil.createMemoryFileSystem();
        try {
            MultiFileSystem mfs = new MultiFileSystem(new FileSystem[]{fs, FileUtil.getConfigRoot().getFileSystem()});
            FileObject fo = FileUtil.createData((FileObject)fs.getRoot(), (String)("Services/Platforms/org-netbeans-api-java-Platform/" + name + '.' + "jcplatform"));
            Properties props = new Properties();
            props.setProperty("javacard.instance.id", name);
            props.setProperty("javacard.displayName", name);
            BufferedOutputStream out = new BufferedOutputStream(fo.getOutputStream());
            try {
                props.store(out, "Dummy Platform");
            }
            catch (IOException ioe) {
            }
            finally {
                ((OutputStream)out).close();
            }
            fo = mfs.getRoot().getFileObject(fo.getPath());
            return DataObject.find((FileObject)fo);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public static JavacardPlatform findPlatformNamed(String name) {
        DataObject dob = JCUtil.findPlatformDataObjectNamed(name);
        JavacardPlatform result = null;
        if (dob != null) {
            result = (JavacardPlatform)dob.getLookup().lookup(JavacardPlatform.class);
        }
        if (result == null) {
            result = JavacardPlatform.createBrokenJavacardPlatform((String)name);
        }
        return result;
    }

    public static File eepromFileForDevice(JavacardPlatform platform, String deviceName, boolean create) {
        String realName = platform.getSystemName();
        if (realName == null) {
            for (FileObject fo : Utils.sfsFolderForRegisteredJavaPlatforms().getChildren()) {
                try {
                    DataObject dob = DataObject.find((FileObject)fo);
                    JavacardPlatform impl = (JavacardPlatform)dob.getLookup().lookup(JavacardPlatform.class);
                    if (impl == null || !impl.equals(platform)) continue;
                    realName = dob.getName();
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
        }
        if (realName == null) {
            realName = platform.getDisplayName();
        }
        return Utils.eepromFileForDevice((String)realName, (String)deviceName, (boolean)create);
    }

    public static DataObject findPlatformDataObjectNamed(String name) {
        if (name == null || "".equals(name)) {
            return null;
        }
        for (FileObject fo : Utils.sfsFolderForRegisteredJavaPlatforms().getChildren()) {
            if (!name.equals(fo.getName())) continue;
            try {
                return DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return JCUtil.createFakeJavacardPlatform(name);
    }

    public static FileObject findBuildXml(Project project) {
        return project.getProjectDirectory().getFileObject("build.xml");
    }

    public static URL getBuildXslTemplate() {
        FileObject file = FileUtil.getConfigFile((String)"org-netbeans-modules-javacard/stylesheets/build.xsl");
        Parameters.notNull((CharSequence)"org-netbeans-modules-javacard/stylesheets/build.xsl missing from system filesystem", (Object)file);
        return URLMapper.findURL((FileObject)file, (int)0);
    }

    public static URL getBuildImplXslTemplate() {
        FileObject file = FileUtil.getConfigFile((String)"org-netbeans-modules-javacard/stylesheets/build-impl.xsl");
        Parameters.notNull((CharSequence)"org-netbeans-modules-javacard/stylesheets/build-impl.xsl missing from system filesystem", (Object)file);
        return URLMapper.findURL((FileObject)file, (int)0);
    }
}

